float4x4 WorldViewProjection : WORLDVIEWPROJECTION;
float4x4 World : WORLD;

float4x4 PrzeksztalceniaSwiata;

float4 Color : COLOR = float4(1.0,1.0,0.0,1.0);

//teksturowanie
bool TeksturowanieWlaczone = true;
texture2D Tekstura;
sampler ProbnikTekstury : TEXTURE2D = sampler_state
{
	texture = <Tekstura>;
	magfilter = LINEAR;
	minfilter = LINEAR;
	mipfilter = LINEAR;
	addressU = WRAP;
	addressV = WRAP;
};

texture2D Tekstura2;
sampler ProbnikTekstury2 : TEXTURE2D = sampler_state
{
	texture = <Tekstura2>;
	magfilter = LINEAR;
	minfilter = LINEAR;
	mipfilter = LINEAR;
	addressU = WRAP;
	addressV = WRAP;
};


//oswietlenie

//zrodlo swiatla
float4 Ca : COLOR = float4(0.1,0.1,0.1,1);
float4 Cd : COLOR = float4(0.5,0.5,0.5,1);
float4 Cs : COLOR = float4(1,1,1,1);

//material
float4 Wa = float4(1,1,1,1);
float4 Wd = float4(1,1,1,1);
float4 Ws = float4(1,1,1,1);
float ns = 10;

float3 PozycjaZrodlaSwiatla : LIGHTPOSITION = float3(1,1,1);
float3 PozycjaKamery : CAMERAPOSITION = float3(0,0,1);

struct Dane_PozycjaKolorNormalnaTekstura
{
	float4 Pozycja : POSITION0;
	float4 Kolor : COLOR0;
	float4 Normalna : NORMAL0;
	float2 WspTeksturowania : TEXCOORD0;
};

struct Dane_PozycjaKolorNRTekstura
{
	float4 Pozycja : POSITION0;
	float4 Kolor : COLOR0;
	float2 WspTeksturowania : TEXCOORD0;

	float4 PozycjaSwiat : TEXCOORD1;	
	float4 NormalnaSwiat : TEXCOORD2;
};

float4 ObliczKolor(Dane_PozycjaKolorNRTekstura input) : COLOR
{
	//return float4(1,1,0,1);

	//Phong
	float3 wektorRL = PozycjaZrodlaSwiatla - input.PozycjaSwiat;
	float3 L = normalize(wektorRL);
	float dotLN = dot(L,input.NormalnaSwiat);

	float3 R = 2*dotLN*input.NormalnaSwiat.xyz-L;
	float dotRK = pow(saturate(dot(R,PozycjaKamery)),ns);

	float4 _Wa,_Wd;
	if(TeksturowanieWlaczone)
	{
		_Wa=tex2D(ProbnikTekstury,input.WspTeksturowania);
		//_Wa=tex2D(ProbnikTekstury,input.WspTeksturowania)*tex2D(ProbnikTekstury2,input.WspTeksturowania);
		//_Wa=input.WspTeksturowania.y*tex2D(ProbnikTekstury,input.WspTeksturowania)+(1-input.WspTeksturowania.y)*tex2D(ProbnikTekstury2,input.WspTeksturowania);
		_Wd=_Wa;
		
	}
	else
	{
		_Wa=Wa;
		_Wd=Wd;
	}

	float4 kolor=float4(0,0,0,0);
	kolor+=saturate(Ca*_Wa); //amb
	kolor+=saturate(Cd*_Wd*dotLN); //dif
	kolor+=saturate(Cs*Ws*dotRK); //spec
	return kolor;
}

Dane_PozycjaKolorNRTekstura VS(Dane_PozycjaKolorNormalnaTekstura input)
{
	Dane_PozycjaKolorNRTekstura output;

	output.WspTeksturowania=input.WspTeksturowania;

	output.PozycjaSwiat=mul(input.Pozycja,World);

	//output.NormalnaSwiat=input.Normalna;
	output.NormalnaSwiat=mul(input.Normalna,PrzeksztalceniaSwiata); //bez skalowania i przesuniecia

	output.Kolor=Color;
	
	output.Pozycja=mul(input.Pozycja,WorldViewProjection);
	return output;
}

float4 PS(Dane_PozycjaKolorNRTekstura input) : COLOR0
{
	//return abs(input.NormalnaSwiat);

	return ObliczKolor(input);	
}

Technique technika
{
	Pass przebieg0
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
		AlphaBlendEnable = True;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;
	}
}