float4x4 WorldViewProjection : WORLDVIEWPROJECTION;
float4x4 World : WORLD;

float4 Color : COLOR = float4(1.0,1.0,0.0,1.0);

bool OswietleniePerPixel = true;

//zrodlo swiatla
float4 Ca : COLOR = float4(0.1,0.1,0.1,1);
float4 Cd : COLOR = float4(0.5,0.5,0.5,1);
float4 Cs : COLOR = float4(1,1,0,1);

//material
float4 Wa = float4(1,1,1,1);
float4 Wd = float4(1,1,1,1);
float4 Ws = float4(1,1,1,1);
float ns = 10;

float3 PozycjaZrodlaSwiatla : LIGHTPOSITION = float3(1,1,1);
float3 PozycjaKamery : CAMERAPOSITION = float3(0,0,1);

struct Dane_PozycjaKolorNormalna
{
	float4 Pozycja : POSITION0;
	float4 Kolor : COLOR0;
	float4 Normalna : NORMAL0;
};

struct Dane_PozycjaKolorNR
{
	float4 Pozycja : POSITION0;
	float4 Kolor : COLOR0;

	float4 PozycjaSwiat : TEXCOORD1;	
	float4 NormalnaSwiat : TEXCOORD0;
};

float4 ObliczKolor(Dane_PozycjaKolorNR input) : COLOR
{
	//return float4(1,1,0,1);

	//Phong
	float3 wektorRL = PozycjaZrodlaSwiatla - input.PozycjaSwiat;
	float3 L = normalize(wektorRL);
	float dotLN = dot(L,input.NormalnaSwiat);

	float3 R = 2*dotLN*input.NormalnaSwiat.xyz-L;
	float dotRK = pow(saturate(dot(R,PozycjaKamery)),ns);

	float4 kolor=float4(0,0,0,0);
	kolor+=saturate(Ca*Wa); //amb
	kolor+=saturate(Cd*Wd*dotLN); //dif
	kolor+=saturate(Cs*Ws*dotRK); //spec
	return kolor;
}

Dane_PozycjaKolorNR VS(Dane_PozycjaKolorNormalna input)
{
	Dane_PozycjaKolorNR output;

	output.PozycjaSwiat=mul(input.Pozycja,World);
	output.NormalnaSwiat=mul(input.Normalna,World);	
	if(!OswietleniePerPixel) output.Kolor=ObliczKolor(output);
	else output.Kolor=Color;
	
	output.Pozycja=mul(input.Pozycja,WorldViewProjection);
	return output;
}

float4 PS(Dane_PozycjaKolorNR input) : COLOR0
{
	//return abs(input.NormalnaSwiat);

	if(!OswietleniePerPixel) return input.Kolor;
	else return ObliczKolor(input);	
}

Technique technika
{
	Pass przebieg0
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
	}
}