float4x4 WorldViewProjection : WORLDVIEWPROJECTION;
float4 Color : COLOR = float4(1.0,1.0,0.0,1.0);

float4x4 World : WORLD;
float Czas : TIME;

struct Dane_Pozycja
{
	float4 Pozycja : POSITION0;
};

struct Dane_PozycjaKolor
{
	float4 Pozycja : POSITION0;
	float4 Kolor : COLOR0;

	float4 PozycjaDodatkowa : TEXCOORD0;
};

Dane_PozycjaKolor VS(Dane_PozycjaKolor input)
{
	Dane_PozycjaKolor output;
	output.Kolor=Color;

	float4 pozycjaSwiat = mul(input.Pozycja,WorldViewProjection);
	output.PozycjaDodatkowa=pozycjaSwiat;

	//if(pozycjaSwiat.x<0) output.Kolor=float4(1,1,0,1);
	//else output.Kolor=float4(0,1,1,1);

	output.Pozycja=mul(input.Pozycja,WorldViewProjection);
	return output;
}

float4 PS(Dane_PozycjaKolor input) : COLOR0
{
	float a=0.1;
	float k=10;
	float w=0.005;

	//return input.Kolor;
	if(input.PozycjaDodatkowa.y<a*sin(k*input.PozycjaDodatkowa.x+w*Czas)) return float4(1,1,0,1);
	//if(input.PozycjaDodatkowa.y<0) return float4(1,1,0,1);
	else return float4(0,1,1,1);
}

Technique technika
{
	Pass przebieg0
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
	}
}