using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace WczytywanieModelu
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        Matrix World, View, Projection;
        Effect efekt;
        Model model;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";

            this.IsMouseVisible = true;
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            Projection = Matrix.CreatePerspective(
                2f * graphics.GraphicsDevice.Viewport.AspectRatio,
                2f,
                1f,
                100f);
            View = Matrix.CreateLookAt(
                new Vector3(0, 0, 2.5f),
                Vector3.Zero,
                Vector3.Up);
            //efekt.World = Matrix.Identity;
            World = Matrix.CreateScale(0.025f)*Matrix.CreateTranslation(0,-0.6f,0);

            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            efekt = Content.Load<Effect>("Efekt");
            efekt.Parameters["Color"].SetValue(Color.CornflowerBlue.ToVector4());
            efekt.Parameters["WorldViewProjection"].SetValue(World * View * Projection);
            efekt.Parameters["World"].SetValue(World);

            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            model = Content.Load<Model>("teapot_LR");
            foreach (ModelMesh siatka in model.Meshes)
            {
                foreach (ModelMeshPart czescSiatki in siatka.MeshParts)
                {
                    czescSiatki.Effect = efekt;
                }
            }
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        KeyboardState poprzedniStanKlawiatury = Keyboard.GetState();

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();


            KeyboardState stanKlawiatury = Keyboard.GetState();
            if (stanKlawiatury.IsKeyDown(Keys.Left)) World *= Matrix.CreateRotationY(-0.01f);
            if (stanKlawiatury.IsKeyDown(Keys.Right)) World *= Matrix.CreateRotationY(0.01f);
            if (stanKlawiatury.IsKeyDown(Keys.Up)) World *= Matrix.CreateRotationX(-0.01f);
            if (stanKlawiatury.IsKeyDown(Keys.Down)) World *= Matrix.CreateRotationX(0.01f);

            if(stanKlawiatury.GetPressedKeys().Count()>0) View *= Matrix.CreateTranslation(0, 0, 2.5f);
            if (stanKlawiatury.IsKeyDown(Keys.A)) View *= Matrix.CreateRotationY(-0.01f);
            if (stanKlawiatury.IsKeyDown(Keys.D)) View *= Matrix.CreateRotationY(0.01f);
            if (stanKlawiatury.IsKeyDown(Keys.W)) View *= Matrix.CreateRotationX(-0.01f);
            if (stanKlawiatury.IsKeyDown(Keys.S)) View *= Matrix.CreateRotationX(0.01f);
            if (stanKlawiatury.GetPressedKeys().Count() > 0) View *= Matrix.CreateTranslation(0, 0, -2.5f);

            if(stanKlawiatury.IsKeyDown(Keys.PageUp)) World *= Matrix.CreateScale(1.01f);
            if(stanKlawiatury.IsKeyDown(Keys.PageDown)) World *= Matrix.CreateScale(0.99f);

            if(stanKlawiatury.IsKeyDown(Keys.Insert)) View *= Matrix.CreateTranslation(0,0,0.1f);
            if(stanKlawiatury.IsKeyDown(Keys.Delete)) View *= Matrix.CreateTranslation(0,0,-0.1f);

            efekt.Parameters["WorldViewProjection"].SetValue(World * View * Projection);
            efekt.Parameters["World"].SetValue(World * View);

            efekt.Parameters["Czas"].SetValue((float)gameTime.TotalGameTime.TotalMilliseconds);

            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            //GraphicsDevice.Clear(Color.CornflowerBlue);
            GraphicsDevice gd = GraphicsDevice;
            gd.Clear(Color.Black);

            //gd.RasterizerState = RasterizerState.CullNone;
            //gd.RasterizerState = RasterizerState.CullCounterClockwise;

            gd.RasterizerState = new RasterizerState()
            {
                CullMode=CullMode.CullCounterClockwiseFace,
                FillMode=FillMode.Solid
            };

            gd.BlendState = BlendState.Opaque;
            //gd.BlendState = BlendState.AlphaBlend;

            foreach (ModelMesh siatka in model.Meshes)
            {
                siatka.Draw();
            }

            base.Draw(gameTime);
        }
    }
}
