using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace WczytywanieModelu
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        BasicEffect efekt;
        Model model;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            efekt = new BasicEffect(this.GraphicsDevice);
            efekt.Projection = Matrix.CreatePerspective(
                2f * graphics.GraphicsDevice.Viewport.AspectRatio,
                2f,
                1f,
                100f);
            efekt.View = Matrix.CreateLookAt(
                new Vector3(0, 0, 2.5f),
                Vector3.Zero,
                Vector3.Up);
            //efekt.World = Matrix.Identity;
            efekt.World = Matrix.CreateScale(0.025f)*Matrix.CreateTranslation(0,-0.6f,0);

            efekt.VertexColorEnabled = false;
            efekt.EnableDefaultLighting();
            //efekt.LightingEnabled = true;
            efekt.PreferPerPixelLighting = true;

            efekt.AmbientLightColor = Color.Black.ToVector3();
            efekt.DiffuseColor = Color.White.ToVector3();
            efekt.SpecularColor = Color.Black.ToVector3();

            efekt.DirectionalLight0.DiffuseColor = Color.White.ToVector3();
            efekt.DirectionalLight1.DiffuseColor = Color.White.ToVector3();
            efekt.DirectionalLight2.DiffuseColor = Color.White.ToVector3();            

            //efekt.DirectionalLight0.DiffuseColor = Color.Red.ToVector3();
            //efekt.DirectionalLight0.SpecularColor = Color.Red.ToVector3();
            //efekt.DirectionalLight1.DiffuseColor = Color.Green.ToVector3();
            //efekt.DirectionalLight1.SpecularColor = Color.Green.ToVector3();
            //efekt.DirectionalLight2.DiffuseColor = Color.Blue.ToVector3();
            //efekt.DirectionalLight2.SpecularColor = Color.Blue.ToVector3();            

            //efekt.Alpha = 0.5f; //+ wlaczenie AlphaBlendingu

            //efekt.EmissiveColor = Color.White.ToVector3();

            efekt.FogColor = Color.Yellow.ToVector3();
            efekt.FogStart = 3f;
            efekt.FogEnd = 10f;
            efekt.FogEnabled = true;

            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            model = Content.Load<Model>("teapot_LR");
            foreach (ModelMesh siatka in model.Meshes)
            {
                foreach (ModelMeshPart czescSiatki in siatka.MeshParts)
                {
                    czescSiatki.Effect = efekt;
                }
            }

            efekt.Texture = Content.Load<Texture2D>("tekstura");
            //efekt.Texture = Content.Load<Texture2D>("nefryt");
            efekt.TextureEnabled = true;
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        KeyboardState poprzedniStanKlawiatury = Keyboard.GetState();

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();


            KeyboardState stanKlawiatury = Keyboard.GetState();
            if (stanKlawiatury.IsKeyDown(Keys.Left)) efekt.World *= Matrix.CreateRotationY(-0.01f);
            if (stanKlawiatury.IsKeyDown(Keys.Right)) efekt.World *= Matrix.CreateRotationY(0.01f);
            if (stanKlawiatury.IsKeyDown(Keys.Up)) efekt.World *= Matrix.CreateRotationX(-0.01f);
            if (stanKlawiatury.IsKeyDown(Keys.Down)) efekt.World *= Matrix.CreateRotationX(0.01f);

            if(stanKlawiatury.IsKeyDown(Keys.PageUp)) efekt.World *= Matrix.CreateScale(1.01f);
            if(stanKlawiatury.IsKeyDown(Keys.PageDown)) efekt.World *= Matrix.CreateScale(0.99f);

            if(stanKlawiatury.IsKeyDown(Keys.Insert)) efekt.View *= Matrix.CreateTranslation(0,0,0.1f);
            if(stanKlawiatury.IsKeyDown(Keys.Delete)) efekt.View *= Matrix.CreateTranslation(0,0,-0.1f);

            // TODO: Add your update logic here

            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            //GraphicsDevice.Clear(Color.CornflowerBlue);
            GraphicsDevice gd = GraphicsDevice;
            gd.Clear(Color.Black);

            gd.RasterizerState = RasterizerState.CullNone;
            //gd.RasterizerState = RasterizerState.CullCounterClockwise;

            gd.BlendState = BlendState.Opaque;
            //gd.BlendState = BlendState.AlphaBlend;

            foreach (ModelMesh siatka in model.Meshes)
            {
                siatka.Draw();
            }

            base.Draw(gameTime);
        }
    }
}
