#version 330 core

//GLSL = GL Shader Language
//Cg 

layout(location=0) in vec3 polozenie_in;
layout(location=1) in vec3 normalna_in;
//layout(location=2) in vec2 wspTeksturowania_in;
layout(location=3) in vec4 kolor_in;

uniform bool UwzglednijKolorWerteksu = true;
uniform vec4 Kolor = vec4(1.0,1.0,0.0,1.0);

const mat4 macierzJednostkowa = mat4(1.0,0.0,0.0,0.0,
                                     0.0,1.0,0.0,0.0,
							         0.0,0.0,1.0,0.0,
							         0.0,0.0,0.0,1.0);
uniform mat4 macierzSwiata = macierzJednostkowa;
uniform mat4 macierzWidoku = macierzJednostkowa;
uniform mat4 macierzRzutowania = macierzJednostkowa;
mat4 macierzMVP = macierzRzutowania*macierzWidoku*macierzSwiata;

mat3 macierzNormalnych = mat3(1.0);

out vec4 polozenie;
out vec4 kolor;
out vec3 polozenie_scena;
out vec3 normalna_scena;

void main(void)
{
	polozenie = vec4(polozenie_in,1.0);
	gl_Position = macierzMVP*polozenie;
	polozenie = macierzSwiata*polozenie;
	
	polozenie_scena = mat3(macierzSwiata)*polozenie_in;
	macierzNormalnych = transpose(inverse(mat3(macierzSwiata))); //!!!!!!udowodnic, ze tak powinno byc
	normalna_scena = macierzNormalnych*normalna_in; 

	kolor = UwzglednijKolorWerteksu?kolor_in:Kolor;
	
	//if(UwzglednijKolorWerteksu) kolor = kolor_in;
	//else kolor = Kolor;		

	//if(gl_Position.y < 0) kolor = vec4(1,1,1,1);
	//else kolor = vec4(1,0,0,1);
	//kolor = vec4(1,1,0,1);	
}