#include <math.h>
#include "Aktor.h"
#include "Werteks.h"
#include "Wektor.h"

class Kwadryka : public Aktor
{
private:
	int liczbaPasm, liczbaSekcji, liczbaWertekswWPamie;
	float promieDolny, promieGrny, pooeniePodstawy, wysoko;

	static unsigned int TwrzTablicWertekswcitegoStoka(CWerteks*& tablicaWerteksw, float promieDolny, float promieGrny, float pooeniePodstawy, float wysoko, int liczbaSekcji);

	//ukryty konstruktor
	Kwadryka(
		GLuint atrybutPooenie, GLuint atrybutNormalna, GLuint atrybutKolor,
		float promieDolny, float promieGrny, float pooeniePodstawy, float wysoko, int liczbaSekcji, int liczbaPasm = 1)
		:Aktor(),
		liczbaPasm(liczbaPasm), liczbaSekcji(liczbaSekcji), liczbaWertekswWPamie(2 * (liczbaSekcji + 1)),
		promieDolny(promieDolny), promieGrny(promieGrny), pooeniePodstawy(pooeniePodstawy), wysoko(wysoko)
	{
		Inicjuj(atrybutPooenie, atrybutNormalna, atrybutKolor);
	}

	unsigned int TwrzTablicWerteksw(CWerteks*& werteksy);

public:
	void Rysuj();

	//pseudokonstruktory 
	static Kwadryka* StwrzcityStoek(
		GLuint atrybutPooenie, GLuint atrybutNormalna, GLuint atrybutKolor,
		float promieDolny, float promieGrny, float wysoko, int liczbaSekcji = 20)
	{
		return new Kwadryka(
			atrybutPooenie, atrybutNormalna, atrybutKolor,
			promieDolny, promieGrny, 0.0f, wysoko, liczbaSekcji, 1);
	}

	static Kwadryka* StwrzWalec(
		GLuint atrybutPooenie, GLuint atrybutNormalna, GLuint atrybutKolor,
		float promie, float wysoko, int liczbaSekcji = 20)
	{
		return new Kwadryka(
			atrybutPooenie, atrybutNormalna, atrybutKolor,
			promie, promie, 0.0f, wysoko, liczbaSekcji, 1);
	}

	static Kwadryka* StwrzStoek(
		GLuint atrybutPooenie, GLuint atrybutNormalna, GLuint atrybutKolor,
		float promieDolny, float wysoko, int liczbaSekcji = 20)
	{
		return new Kwadryka(
			atrybutPooenie, atrybutNormalna, atrybutKolor,
			promieDolny, 0.0f, 0.0f, wysoko, liczbaSekcji, 1);
	}

	static Kwadryka* StwrzDysk(
		GLuint atrybutPooenie, GLuint atrybutNormalna, GLuint atrybutKolor,
		float promieWewntrzny, float promieZewntrzny, int liczbaSekcji = 20)
	{
		return new Kwadryka(
			atrybutPooenie, atrybutNormalna, atrybutKolor,
			promieZewntrzny, promieWewntrzny, 0.0f, 0.0f, liczbaSekcji, 1);
	}
		
	static Kwadryka* StwrzKoo(
		GLuint atrybutPooenie, GLuint atrybutNormalna, GLuint atrybutKolor,
		float promie, int liczbaSekcji = 20)
	{
		return new Kwadryka(
			atrybutPooenie, atrybutNormalna, atrybutKolor,
			promie, 0.0f, 0.0f, 0.0f, liczbaSekcji, 1);
	}

	static Kwadryka* StwrzSfer(
		GLuint atrybutPooenie, GLuint atrybutNormalna, GLuint atrybutKolor,
		float promie, int liczbaSekcjiNaRwnolenikach = 20, int liczbaSekcjiNaPoudnikach = 20)
	{
		return new Kwadryka(
			atrybutPooenie, atrybutNormalna, atrybutKolor,
			promie, 0.0f, 0.0f, 0.0f, liczbaSekcjiNaRwnolenikach, liczbaSekcjiNaPoudnikach);
	}
};

//-------------------------------------------------------------------

class SferaZBuforemIndeksw : public AktorZBuforemIndeksw
{
private:
	float promie;
	unsigned int liczbaSekcjiNaRwnolenikach, liczbaSekcjiNaPoudnikach;
	unsigned int TwrzTablicWerteksw(CWerteks*& werteksy);
	unsigned int TwrzTablicIndeksw(GLuint*& indeksy);
	int indeks(int i, int j);

public:
	SferaZBuforemIndeksw(
		GLuint atrybutPooenie, GLuint atrybutNormalna, GLuint atrybutKolor,
		float promie,
		unsigned int liczbaSekcjiNaRwnolenikach = 20, unsigned int liczbaSekcjiNaPoudnikach = 20)
		:AktorZBuforemIndeksw(), promie(promie), liczbaSekcjiNaRwnolenikach(liczbaSekcjiNaRwnolenikach), liczbaSekcjiNaPoudnikach(liczbaSekcjiNaPoudnikach)
	{
		Inicjuj(atrybutPooenie, atrybutNormalna, atrybutKolor);
	}
};
