#include "Kwadryka.h"

unsigned int Kwadryka::TwrzTablicWertekswcitegoStoka(CWerteks*& tablicaWerteksw, float promieDolny, float promieGrny, float pooeniePodstawy, float wysoko, int liczbaSekcji)
{
	const int liczbaWerteksw = 2 * (liczbaSekcji + 1);
	const double przyrostKta = 2 * M_PI / liczbaSekcji;
	const float r = 1, g = 1, b = 1, a = 1;

	tablicaWerteksw = new CWerteks[liczbaWerteksw];	

	for (int i = 0; i <= liczbaSekcji; i++) //ilo par musi by wiksza o 1 ni ilo sekcji, przy penym obrocie pierwsza i ostatnia s takie same
	{		
		double kt = i * przyrostKta;

		tablicaWerteksw[2 * i].x = promieGrny*(float)cos(kt);
		tablicaWerteksw[2 * i].y = promieGrny*(float)sin(kt);
		tablicaWerteksw[2 * i].z = pooeniePodstawy + wysoko;
		tablicaWerteksw[2 * i].r = r;
		tablicaWerteksw[2 * i].g = g;
		tablicaWerteksw[2 * i].b = b;
		tablicaWerteksw[2 * i].a = a;

		tablicaWerteksw[2 * i + 1].x = promieDolny*(float)cos(kt);
		tablicaWerteksw[2 * i + 1].y = promieDolny*(float)sin(kt);
		tablicaWerteksw[2 * i + 1].z = pooeniePodstawy;
		tablicaWerteksw[2 * i + 1].r = r;
		tablicaWerteksw[2 * i + 1].g = g;
		tablicaWerteksw[2 * i + 1].b = b;
		tablicaWerteksw[2 * i + 1].a = a;

		//obliczanie normalnej
		float a = promieDolny - promieGrny;
		float c = sqrt(a * a + wysoko * wysoko);
		float sinTheta = a / c;
		float cosTheta = wysoko / c;
		tablicaWerteksw[2 * i].nx = (float)(cos(kt)*cosTheta);
		tablicaWerteksw[2 * i].ny = (float)(sin(kt)*cosTheta);
		tablicaWerteksw[2 * i].nz = sinTheta;
		tablicaWerteksw[2 * i + 1].nx = tablicaWerteksw[2 * i].nx;
		tablicaWerteksw[2 * i + 1].ny = tablicaWerteksw[2 * i].ny;
		tablicaWerteksw[2 * i + 1].nz = tablicaWerteksw[2 * i].nz;
	}

	return liczbaWerteksw;
}

unsigned int Kwadryka::TwrzTablicWerteksw(CWerteks*& werteksy)
{
	if (liczbaPasm == 1)
	{
		return TwrzTablicWertekswcitegoStoka(werteksy, promieDolny, promieGrny, pooeniePodstawy, wysoko, liczbaSekcji);
	}
	else //tylko sfera ma wicej ni jedno pasmo; tu lepiej byoby uy bufora indeksw
	{
		unsigned int cakowitaLiczbaWerteksw = liczbaWertekswWPamie * liczbaPasm;
		const float promie = promieDolny;
		werteksy = new CWerteks[cakowitaLiczbaWerteksw];

		double przyrostKtaTheta = M_PI / liczbaPasm;
		for (int i = 0; i < liczbaPasm; i++)
		{
			double ktThetaGrny = i * przyrostKtaTheta;
			double ktThetaDolny = (i + 1) * przyrostKtaTheta;
			float wysokoGrna = (float)(promie * cos(ktThetaGrny));
			float wysokoDolna = (float)(promie * cos(ktThetaDolny));
			float _promieGrny = (float)(promie * sin(ktThetaGrny));
			float _promieDolny = (float)(promie * sin(ktThetaDolny));

			CWerteks* tablicaWertekswPasma;
			unsigned int liczbaWertekswWPamie = TwrzTablicWertekswcitegoStoka(
				tablicaWertekswPasma, _promieDolny, _promieGrny, wysokoDolna, wysokoGrna - wysokoDolna, liczbaSekcji);
			CWerteks* pocztekWertekswPasma = werteksy + liczbaWertekswWPamie * i;
			std::copy(tablicaWertekswPasma, tablicaWertekswPasma + liczbaWertekswWPamie, pocztekWertekswPasma);
			delete[] tablicaWertekswPasma;
		}

		return cakowitaLiczbaWerteksw;
	}
}

void Kwadryka::Rysuj()
{
	glBindVertexArray(vao);
	glBindBuffer(GL_ARRAY_BUFFER, vbo);
	for (int i = 0; i < liczbaPasm; ++i)
	{
		glDrawArrays(GL_TRIANGLE_STRIP, i*liczbaWertekswWPamie, liczbaWertekswWPamie);
	}
	//glBindBuffer(GL_ARRAY_BUFFER, NULL);
	//glBindVertexArray(NULL);
}

//-------------------------------------------------------------------

unsigned int SferaZBuforemIndeksw::TwrzTablicWerteksw(CWerteks*& werteksy)
{
	const unsigned int cakowitaLiczbaWerteksw = liczbaSekcjiNaRwnolenikach * (liczbaSekcjiNaPoudnikach - 1) + 2;
	werteksy = new CWerteks[cakowitaLiczbaWerteksw];

	const double przyrostKtaTheta = M_PI / liczbaSekcjiNaPoudnikach;
	const double przyrostKtaPhi = 2 * M_PI / liczbaSekcjiNaRwnolenikach;

	const float r = 1, g = 1, b = 1, a = 1;

	for (unsigned int i = 1; i < liczbaSekcjiNaPoudnikach; i++) //tu zmiany
	{
		double ktTheta = i * przyrostKtaTheta;
		float _wysoko = (float)(promie * cos(ktTheta));
		float _promie = (float)(promie * sin(ktTheta));

		for (unsigned int j = 0; j < liczbaSekcjiNaRwnolenikach; j++)
		{
			double ktPhi = j*przyrostKtaPhi;
			unsigned int indeks = 1 + j + (i - 1)*liczbaSekcjiNaRwnolenikach;

			werteksy[indeks].x = _promie*(float)cos(ktPhi);
			werteksy[indeks].y = _promie*(float)sin(ktPhi);
			werteksy[indeks].z = _wysoko;
			werteksy[indeks].nx = werteksy[indeks].x / _promie;
			werteksy[indeks].ny = werteksy[indeks].y / _promie;
			werteksy[indeks].nz = werteksy[indeks].z / _promie;
			werteksy[indeks].r = r;
			werteksy[indeks].g = g;
			werteksy[indeks].b = b;
			werteksy[indeks].a = 1;
		}
	}
	//biegun =z
	werteksy[0].x = 0;
	werteksy[0].y = 0;
	werteksy[0].z = promie;
	werteksy[0].nx = 0;
	werteksy[0].ny = 0;
	werteksy[0].nz = 1;
	werteksy[0].r = r;
	werteksy[0].g = g;
	werteksy[0].b = b;
	//biegun =z
	unsigned int _indeks = 1 + (liczbaSekcjiNaPoudnikach - 1)*liczbaSekcjiNaRwnolenikach;
	werteksy[_indeks].x = 0;
	werteksy[_indeks].y = 0;
	werteksy[_indeks].z = -promie;
	werteksy[_indeks].nx = 0;
	werteksy[_indeks].ny = 0;
	werteksy[_indeks].nz = -1;
	werteksy[_indeks].r = r;
	werteksy[_indeks].g = g;
	werteksy[_indeks].b = b;

	return cakowitaLiczbaWerteksw;
}

unsigned int SferaZBuforemIndeksw::TwrzTablicIndeksw(GLuint*& indeksy)
{
	const unsigned int liczbaIndekswWPamie = 2 * (liczbaSekcjiNaRwnolenikach + 1);
	const unsigned int cakowitaLiczbaIndeksw = liczbaIndekswWPamie * liczbaSekcjiNaPoudnikach;
	indeksy = new GLuint[cakowitaLiczbaIndeksw];

	for (unsigned int i = 0; i < liczbaSekcjiNaPoudnikach; i++)
	{
		for (unsigned int j = 0; j < liczbaSekcjiNaRwnolenikach; j++)
		{
			unsigned int _indeks = j + i*(liczbaSekcjiNaRwnolenikach + 1);
			indeksy[2 * _indeks] = (i == 0) ? 0 : (1 + j + (i - 1)*liczbaSekcjiNaRwnolenikach);
			indeksy[2 * _indeks + 1] = (i == liczbaSekcjiNaPoudnikach - 1) ? (liczbaWerteksw - 1) : (1 + j + i*liczbaSekcjiNaRwnolenikach);
		}
		unsigned int _indeks = liczbaSekcjiNaRwnolenikach + i*(liczbaSekcjiNaRwnolenikach + 1);
		indeksy[2 * _indeks] = (i == 0) ? 0 : (i*liczbaSekcjiNaRwnolenikach);
		indeksy[2 * _indeks + 1] = (i == liczbaSekcjiNaPoudnikach - 1) ? (liczbaWerteksw - 1) : (indeksy[2 * _indeks] + liczbaSekcjiNaRwnolenikach);
	}

	return cakowitaLiczbaIndeksw;
}