#include "Aktor.h"

Aktor::Aktor()
:liczbaWerteksw(-1), Macierzwiata(Macierz4::Jednostkowa)
{
}

Aktor::~Aktor()
{
	UsuBuforWerteksw();
}

void Aktor::Inicjuj(GLuint atrybutPooenie, GLuint atrybutNormalna, GLuint atrybutKolor)
{
	InicjujBuforWerteksw();

	glVertexAttribPointer(atrybutPooenie, CWerteks::liczbaWsprzdnychPooenia, GL_FLOAT, GL_FALSE, CWerteks::rozmiarWerteksu, 0);
	glEnableVertexAttribArray(atrybutPooenie);
	glVertexAttribPointer(atrybutNormalna, CWerteks::liczbaWsprzdnychNormalnej, GL_FLOAT, GL_FALSE, CWerteks::rozmiarWerteksu, (const GLvoid*)CWerteks::rozmiarWektoraPooenia);
	glEnableVertexAttribArray(atrybutNormalna);
	glVertexAttribPointer(atrybutKolor, CWerteks::liczbaSkadowychKoloru, GL_FLOAT, GL_FALSE, CWerteks::rozmiarWerteksu, (const GLvoid*)(CWerteks::rozmiarWektoraPooenia + CWerteks::rozmiarNormalnej));
	glEnableVertexAttribArray(atrybutKolor);
}

void Aktor::InicjujBuforWerteksw()
{
	//Vertex Array Object (VAO)
	glGenVertexArrays(1, &vao);
	glBindVertexArray(vao);

	//Vertex Buffer Object (VBO)
	glGenBuffers(1, &vbo); //tworzy bufory
	glBindBuffer(GL_ARRAY_BUFFER, vbo);

	CWerteks* werteksy = NULL;
	liczbaWerteksw = TwrzTablicWerteksw(werteksy);
	glBufferData(GL_ARRAY_BUFFER, liczbaWerteksw*sizeof(CWerteks), werteksy, GL_STATIC_DRAW);
	delete[] werteksy;
}

void Aktor::UsuBuforWerteksw()
{
	glDeleteBuffers(1, &vbo);
	glDeleteVertexArrays(1, &vao);
}

void Aktor::Rysuj() //default implementation for triangle strip
{
	assert(liczbaWerteksw > 0);

	//bez bufora indeksw
	glBindVertexArray(vao);
	glBindBuffer(GL_ARRAY_BUFFER, vbo);
	glDrawArrays(GL_TRIANGLE_STRIP, 0, liczbaWerteksw);
	//glBindBuffer(GL_ARRAY_BUFFER, NULL);
	//glBindVertexArray(NULL);
}

//--------------------------------------------

AktorZBuforemIndeksw::AktorZBuforemIndeksw()
:Aktor(), liczbaIndeksw(-1)
{
}

AktorZBuforemIndeksw::~AktorZBuforemIndeksw()
{
	//UsuBuforWerteksw();
	Aktor::~Aktor();
	UsuBuforIndeksw();
}

void AktorZBuforemIndeksw::Inicjuj(GLuint atrybutPooenie, GLuint atrybutNormalna, GLuint atrybutKolor)
{
	Aktor::Inicjuj(atrybutPooenie, atrybutNormalna, atrybutKolor);
	InicjujBuforIndeksw();
}

void AktorZBuforemIndeksw::InicjujBuforIndeksw()
{
	glGenBuffers(1, &vbo_indeksy);
	glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, vbo_indeksy);

	GLuint* indeksy = NULL;
	liczbaIndeksw = TwrzTablicIndeksw(indeksy);
	glBufferData(GL_ELEMENT_ARRAY_BUFFER, liczbaIndeksw*sizeof(GLuint), indeksy, GL_STATIC_DRAW);
	delete[] indeksy;
}

void AktorZBuforemIndeksw::UsuBuforIndeksw()
{
	glDeleteBuffers(1, &vbo_indeksy);
}

void AktorZBuforemIndeksw::Rysuj()
{
	assert(liczbaIndeksw > 0);

	//z buforem indeksw
	glBindVertexArray(vao);
	glBindBuffer(GL_ARRAY_BUFFER, vbo_indeksy);
	glDrawElements(GL_TRIANGLE_STRIP, liczbaIndeksw, GL_UNSIGNED_INT, 0);
	//glBindBuffer(GL_ARRAY_BUFFER, NULL);
	//glBindVertexArray(NULL);
}

//--------------------------------------------

Kwadrat::Kwadrat(GLuint atrybutPooenie, GLuint atrybutNormalna, GLuint atrybutKolor, float dugoKrawdzi)
:Aktor(), dugoKrawdzi(dugoKrawdzi)
{
	Inicjuj(atrybutPooenie, atrybutNormalna, atrybutKolor);
}

unsigned int Kwadrat::TwrzTablicWerteksw(CWerteks*& werteksy)
{
	const float x0 = dugoKrawdzi/2.0f;
	const float y0 = dugoKrawdzi/2.0f;

	werteksy = new CWerteks[4];
	werteksy[0] = CWerteks(-x0, -y0, 0.0f, 0, 0, 1, 1, 1, 0, 1); //dolny lewy
	werteksy[1] = CWerteks(x0, -y0, 0.0f, 0, 0, 1, 1, 0, 1, 1); //dolny prawy
	werteksy[2] = CWerteks(-x0, y0, 0.0f, 0, 0, 1, 0, 1, 1, 1); //grny lewy
	werteksy[3] = CWerteks(x0, y0, 0.0f, 0, 0, 1, 1, 1, 1, 1);  //grny prawy

	return 4;
}

//--------------------------------------------

Trjkt::Trjkt(GLuint atrybutPooenie, GLuint atrybutNormalna, GLuint atrybutKolor, float dugoPodstawy, float wysoko)
:Aktor(), dugoPodstawy(dugoPodstawy), wysoko(wysoko)
{
	Inicjuj(atrybutPooenie, atrybutNormalna, atrybutKolor);
}

unsigned int Trjkt::TwrzTablicWerteksw(CWerteks*& werteksy)
{
	const float x0 = dugoPodstawy / 2.0f;
	const float y0 = wysoko / 2.0f;

	werteksy = new CWerteks[3];
	werteksy[0] = CWerteks(-x0, -y0, 0.0f, 0, 0, 1, 1, 0, 0, 1); //dolny lewy
	werteksy[1] = CWerteks(x0, -y0, 0.0f, 0, 0, 1, 0, 1, 0, 1); //dolny prawy
	werteksy[2] = CWerteks(0, y0, 0.0f, 0, 0, 1, 0, 0, 1, 1); //grny lewy

	return 3;
}

//--------------------------------------------

KwadratZBuforemIndeksw::KwadratZBuforemIndeksw(GLuint atrybutPooenie, GLuint atrybutNormalna, GLuint atrybutKolor, float dugoKrawdzi)
:AktorZBuforemIndeksw(), dugoKrawdzi(dugoKrawdzi)
{
	Inicjuj(atrybutPooenie, atrybutNormalna, atrybutKolor);
}

unsigned int KwadratZBuforemIndeksw::TwrzTablicWerteksw(CWerteks*& werteksy)
{
	const float x0 = dugoKrawdzi / 2.0f;
	const float y0 = dugoKrawdzi / 2.0f;

	werteksy = new CWerteks[5];
	werteksy[0] = CWerteks(-x0, -y0, 0.0f, 0, 0, 1, 1, 0, 0, 1); //dolny lewy
	werteksy[1] = CWerteks(x0, -y0, 0.0f, 0, 0, 1, 0, 1, 0, 1); //dolny prawy
	werteksy[2] = CWerteks(0, y0, 0.0f, 0, 0, 1, 0, 0, 1, 1); //grny
	werteksy[3] = CWerteks(-x0, y0, 0.0f, 0, 0, 1, 0, 0, 1, 1); //grny lewy
	werteksy[4] = CWerteks(x0, y0, 0.0f, 0, 0, 1, 0, 0, 1, 1);  //grny prawy

	return 5;
}

unsigned int KwadratZBuforemIndeksw::TwrzTablicIndeksw(GLubyte*& indeksy)
{
	indeksy = new GLubyte[4];
	indeksy[0] = 0;
	indeksy[1] = 1;
	indeksy[2] = 3;
	indeksy[3] = 4;

	return 4;
}

//--------------------------------------------

Prostopadocian::Prostopadocian(GLuint atrybutPooenie, GLuint atrybutNormalna, GLuint atrybutKolor, float dugoKrawdziX, float dugoKrawdziY, float dugoKrawdziZ, bool koloruj)
:Aktor(), dugoKrawdziX(dugoKrawdziX), dugoKrawdziY(dugoKrawdziY), dugoKrawdziZ(dugoKrawdziZ), koloruj(koloruj)
{
	Inicjuj(atrybutPooenie, atrybutNormalna, atrybutKolor);
}

unsigned int Prostopadocian::TwrzTablicWerteksw(CWerteks*& werteksy)
{
	const float x0 = dugoKrawdziX / 2.0f;
	const float y0 = dugoKrawdziY / 2.0f;
	const float z0 = dugoKrawdziZ / 2.0f;


	werteksy = new CWerteks[24];

	float r = 1.0f;
	float g = 1.0f;
	float b = 1.0f;

	if (koloruj) { r = 1.0f; g = 0.0f; b = 0.0f; }
	//tylnia
	werteksy[0] = CWerteks(x0, -y0, -z0, 0, 0, -1, r, g, b);
	werteksy[1] = CWerteks(-x0, -y0, -z0, 0, 0, -1, r, g, b);
	werteksy[2] = CWerteks(x0, y0, -z0, 0, 0, -1, r, g, b);
	werteksy[3] = CWerteks(-x0, y0, -z0, 0, 0, -1, r, g, b);
	//przednia
	werteksy[4] = CWerteks(-x0, -y0, z0, 0, 0, 1, r, g, b);
	werteksy[5] = CWerteks(x0, -y0, z0, 0, 0, 1, r, g, b);
	werteksy[6] = CWerteks(-x0, y0, z0, 0, 0, 1, r, g, b);
	werteksy[7] = CWerteks(x0, y0, z0, 0, 0, 1, r, g, b);

	if (koloruj) { r = 0.0f; g = 1.0f; b = 0.0f; }
	//prawa
	werteksy[8] = CWerteks(x0, -y0, z0, 1, 0, 0, r, g, b);
	werteksy[9] = CWerteks(x0, -y0, -z0, 1, 0, 0, r, g, b);
	werteksy[10] = CWerteks(x0, y0, z0, 1, 0, 0, r, g, b);
	werteksy[11] = CWerteks(x0, y0, -z0, 1, 0, 0, r, g, b);
	//lewa
	werteksy[12] = CWerteks(-x0, -y0, -z0, -1, 0, 0, r, g, b);
	werteksy[13] = CWerteks(-x0, -y0, z0, -1, 0, 0, r, g, b);
	werteksy[14] = CWerteks(-x0, y0, -z0, -1, 0, 0, r, g, b);
	werteksy[15] = CWerteks(-x0, y0, z0, -1, 0, 0, r, g, b);

	if (koloruj) { r = 0.0f; g = 0.0f; b = 1.0f; }
	//grna
	werteksy[16] = CWerteks(-x0, y0, z0, 0, 1, 0, r, g, b);
	werteksy[17] = CWerteks(x0, y0, z0, 0, 1, 0, r, g, b);
	werteksy[18] = CWerteks(-x0, y0, -z0, 0, 1, 0, r, g, b);
	werteksy[19] = CWerteks(x0, y0, -z0, 0, 1, 0, r, g, b);
	//dolna
	werteksy[20] = CWerteks(-x0, -y0, -z0, 0, -1, 0, r, g, b);
	werteksy[21] = CWerteks(x0, -y0, -z0, 0, -1, 0, r, g, b);
	werteksy[22] = CWerteks(-x0, -y0, z0, 0, -1, 0, r, g, b);
	werteksy[23] = CWerteks(x0, -y0, z0, 0, -1, 0, r, g, b);

	return 24;
}

void Prostopadocian::Rysuj()
{
	//bez bufora indeksw
	glBindVertexArray(vao);
	glBindBuffer(GL_ARRAY_BUFFER, vbo);
	for (int i = 0; i < 6; ++i)
	{
		glDrawArrays(GL_TRIANGLE_STRIP, i * 4, 4);
	}
	//glBindBuffer(GL_ARRAY_BUFFER, NULL);
	//glBindVertexArray(NULL);
}
