#include "Okno.h"

//#include <gl\GL.h>
//#include <gl\GLU.h>
#include "glew.h"
#include "wglew.h"

#include "Werteks.h"

//#include "Rozszerzenia.h"

int WINAPI WinMain(HINSTANCE hInstance, 
				   HINSTANCE hPrevInstance,
				   LPSTR lpCmdLine, int nCmdShow)
{
	POINT polozenieOkna = {100,100};
	POINT rozmiarOkna = {800,600};
	if(!okno.Inicjuj(hInstance,polozenieOkna,rozmiarOkna,false,false))
	{
		MessageBox(NULL,"Inicjacja okna nie powioda si",
			"Aplikacja OpenGL", MB_OK | MB_ICONERROR);
		return EXIT_FAILURE;
	}
	else return okno.Uruchom();

	return 0;
}

LRESULT Okno::WndProc(HWND hWnd, UINT message,
					  WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
	case WM_DESTROY: //zamykanie okna -> koczenie aplikacji
		 PostQuitMessage(EXIT_SUCCESS);
		 break;
	case WM_SIZE: //zmiana rozmiaru okna
		RECT rect;
		GetClientRect(hWnd, &rect);
		szerokoscObszaruUzytkownika = rect.right - rect.left;
		wysokoscObszaruUzytkownika = rect.bottom - rect.top;
		break;
	default: //automatyczne przetwarzanie komunikatw
		return DefWindowProc(hWnd, message, wParam, lParam);
	}

	return 0L;
}

bool Okno::Inicjuj(HINSTANCE uchwytAplikacji, 
				   POINT polozenieOkna, POINT rozmiarOkna, 
				   bool trybPelnoekranowy, bool zmianaRozdzielczosci)
{
	char nazwaOkna[] = "Aplikacja OpenGL";

	WNDCLASSEX wc;
	wc.cbSize=sizeof(wc);
	wc.style = CS_HREDRAW | CS_VREDRAW | CS_OWNDC; //styl okna
	wc.lpfnWndProc = (WNDPROC)::WndProc; //procedura okna
	wc.cbClsExtra = 0; //dodatkowe bajty zarezrwowane za klas okna
	wc.cbWndExtra = 0; //dodatkowe bajty zarezerwowane za instancj okna
	wc.hInstance = uchwytAplikacji; //instancja aplikacji
	wc.hIcon = NULL; //uchwyt ikony
	wc.hIconSm = NULL; //uchwyt ikony
	wc.hCursor = LoadCursor(NULL, IDC_ARROW); //uchwyt kursora
	wc.hbrBackground = NULL; //uchwyt pdzla ta
	wc.lpszMenuName = NULL; //nazwa menu
	wc.lpszClassName = nazwaOkna; //nazwa klasy okna

	//Rejestracja klasy okna
	if(RegisterClassEx(&wc)==0) return false;

	DWORD stylOkna = WS_OVERLAPPEDWINDOW;

	if(trybPelnoekranowy)
	{
		stylOkna = WS_POPUP;
		polozenieOkna.x = 0;
		polozenieOkna.y = 0;
		if(zmianaRozdzielczosci)
		{
			rozmiarOkna.x = 1024;
			rozmiarOkna.y = 768;
			if(!ZmianaRozdzielczosci(rozmiarOkna.x, rozmiarOkna.y)) return false;
		}
		else
		{
			RECT rozmiarEkranu;
			GetWindowRect(GetDesktopWindow(), &rozmiarEkranu);
			rozmiarOkna.x = rozmiarEkranu.right - rozmiarEkranu.left;
			rozmiarOkna.y = rozmiarEkranu.bottom - rozmiarEkranu.top;
		}
	}

	//Tworzenie okna
	uchwytOkna = CreateWindow(
		nazwaOkna, //nazwa klasy okna
		nazwaOkna, //nazwa okna
		stylOkna, //styl okna
		polozenieOkna.x, polozenieOkna.y, //pooenie okna (x,y)
		rozmiarOkna.x, rozmiarOkna.y, //rozmiar okna (szeroko, wysoko)
		NULL, //uchwyt okna nadrzdnego
		NULL, //uchwyt menu
		uchwytAplikacji, //uchwyt instancji aplikacji
		NULL); //parametr komunikatu WM_CREATE informujcego o utworzeniu okna

	if(uchwytOkna==NULL) return false;

	//Pokazanie i aktualizacja okna
	ShowWindow(uchwytOkna,SW_SHOW);
	UpdateWindow(uchwytOkna);

	return true;
}

bool Okno::ZmianaRozdzielczosci(long szerokosc, long wysokosc,
								long glebiaKolorow) const
{
	DEVMODE dmScreenSettings; //struktura trybu wywietlania 
	memset(&dmScreenSettings, 0, sizeof(dmScreenSettings)); //czyszczenie pamici
	dmScreenSettings.dmSize = sizeof(dmScreenSettings);
	dmScreenSettings.dmPelsWidth = szerokosc; //nowa szerokosc ekranu
	dmScreenSettings.dmPelsHeight = wysokosc; //nowa wysokosc ekranu
	dmScreenSettings.dmBitsPerPel = glebiaKolorow; //liczba bitw na piksel
	dmScreenSettings.dmFields = DM_BITSPERPEL |  DM_PELSWIDTH | DM_PELSHEIGHT;
	return ChangeDisplaySettings(&dmScreenSettings, CDS_FULLSCREEN) == DISP_CHANGE_SUCCESSFUL;
}

WPARAM Okno::Uruchom()
{
	//Ptla gwna - obsuga komunikatw
	MSG msg;
	while(GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return msg.wParam;
}

//---------------------------------------

bool OknoGL::UstalFormatPikseli(HDC uchwytDC) const
{
	PIXELFORMATDESCRIPTOR opisFormatuPikseli;
	ZeroMemory(&opisFormatuPikseli, sizeof(opisFormatuPikseli));
	opisFormatuPikseli.nVersion = 1;
	opisFormatuPikseli.dwFlags = PFD_SUPPORT_OPENGL | 
		PFD_DRAW_TO_WINDOW | PFD_DOUBLEBUFFER; //w oknie, podwjne buforowanie
	opisFormatuPikseli.iPixelType = PFD_TYPE_RGBA; //tyo koloru RGB z kanaa alfa
	opisFormatuPikseli.cColorBits = 32; //jako kolorw, 4 bajty (po bajcie na kady kana)
	opisFormatuPikseli.cDepthBits = 32; //gboko bufora gbi (z-buffer)
	opisFormatuPikseli.iLayerType = PFD_MAIN_PLANE;
	int formatPikseli = ChoosePixelFormat(uchwytDC, &opisFormatuPikseli);
	if(formatPikseli == 0) return false;
	if(!SetPixelFormat(uchwytDC,formatPikseli,&opisFormatuPikseli)) return false;
	return true;
}

/*
bool OknoGL::InicjujWGL(HWND uchwytOkna)
{
	uchwytDC = ::GetDC(uchwytOkna);
	if (!UstalFormatPikseli(uchwytDC)) return false;

	uchwytRC = wglCreateContext(uchwytDC);
	if(uchwytRC == NULL) return false;
	if(!wglMakeCurrent(uchwytDC, uchwytRC)) return false;
	return true;
}
*/

bool OknoGL::InicjujWGL(HWND uchwytOkna)
{
	uchwytDC = ::GetDC(uchwytOkna);
	if (!UstalFormatPikseli(uchwytDC)) return false;

	HGLRC uchwytTymczasowegoRC = wglCreateContext(uchwytDC);
	if(uchwytTymczasowegoRC == NULL) return false;
	if(!wglMakeCurrent(uchwytDC, uchwytTymczasowegoRC)) return false;

	/*
	if(!InicjujRozszerzenia())
	{
		MessageBox(NULL, 
			"Pobranie adresw funkcji rozszerze ARB nie powiodo si", 
			"Aplikacja OpenGL",
			MB_OK | MB_ICONERROR);
		return false;
	}
	*/
	GLenum err = glewInit();
	if(err != GLEW_OK)
	{
		MessageBox(NULL, "Inicjacja biblioteki GLEW nie powioda si", "Aplikacja OpenGL", MB_OK | MB_ICONERROR);
		return false;
	}

	const int major_min = 3; const int minor_min = 3;
	int major, minor;
	glGetIntegerv(GL_MAJOR_VERSION, &major);
	glGetIntegerv(GL_MINOR_VERSION, &minor);
	if(major<major_min || (major==major_min && minor<minor_min))
	{
		MessageBox(NULL, 
			"Wersja OpenGL jest niewystarczajca", 
			"Aplikacja OpenGL",
			MB_OK | MB_ICONERROR);
		return false;
	}

	int atrybuty[] =
	{
		WGL_CONTEXT_MAJOR_VERSION_ARB, major_min,
		WGL_CONTEXT_MINOR_VERSION_ARB, minor_min,
		WGL_CONTEXT_FLAGS_ARB, WGL_CONTEXT_FORWARD_COMPATIBLE_BIT_ARB,
		//WGL_CONTEXT_PROFILE_MASK_ARB, WGL_CONTEXT_COMPATIBILITY_PROFILE_BIT_ARB,
		WGL_CONTEXT_PROFILE_MASK_ARB, WGL_CONTEXT_CORE_PROFILE_BIT_ARB,
		0
	};

	uchwytRC = wglCreateContextAttribsARB(uchwytDC, 0, atrybuty);
	if(uchwytRC == NULL) return false;
	if(!wglMakeCurrent(uchwytDC, uchwytRC)) return false;

	wglDeleteContext(uchwytTymczasowegoRC);

	return true;
}


void OknoGL::UsuWGL()
{
	wglMakeCurrent(NULL, NULL);
	wglDeleteContext(uchwytRC);
	::ReleaseDC(uchwytOkna, uchwytDC);
}

#include <cstdlib>

LRESULT OknoGL::WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	long wynik = Okno::WndProc(hWnd, message, wParam, lParam);

	static POINT poprzedniaPozycjaKursoraMyszyLMB = { -1, -1 };
	static POINT poprzedniaPozycjaKursoraMyszyRMB = { -1, -1 };

	const bool swobodneObrotyKameryMoliwe = true; //gwny wycznik swobodnych obrotw kamery
	const int identyfikatorTimeraSwobodnychObrotwKamery = 1;
	const int okresTimeraSwobodnychObrotwKamery = 50; //50ms

	switch(message)
	{
		case WM_CREATE: //Utworzenie okna
			//zmienna uchwytOkna nie jest jeszcze zainicjowana
			if(!InicjujWGL(hWnd))
			{
				MessageBox(NULL, "Pobranie kontekstu renderowania nie powiodo si", "Aplikacja OpenGL", MB_OK | MB_ICONERROR);
				return EXIT_FAILURE;
			}
			idProgramuShaderow = PrzygotujShadery("basic.vsh", "basic.fsh", false);
			if(idProgramuShaderow==NULL)
			{
				MessageBox(NULL, "Przygotowanie shaderw nie powiodo si", "Aplikacja OpenGL", MB_OK | MB_ICONERROR);
				exit(EXIT_FAILURE);
			}
			UmieInformacjeNaPaskuTytuu(hWnd);
			InicjujBuforWerteksw();
			UstawienieSceny();
			if (swobodneObrotyKameryMoliwe)
			{
				if (SetTimer(hWnd, identyfikatorTimeraSwobodnychObrotwKamery, okresTimeraSwobodnychObrotwKamery, NULL) == 0)
					MessageBox(hWnd, "Nie udao si ustawi timera swobodnych obrotw kamery", "Bd", MB_OK | MB_ICONERROR);			
			}
			break;
		case WM_DESTROY: //Zamknicie okna
			UsuBuforWerteksw();
			UsuWGL();
			break;
		case WM_SIZE: //Zmiana rozmiaru okna
			UstawienieSceny();
			break;
		case WM_PAINT: //Okno wymaga odwieenia
			RysujScen();
			ValidateRect(hWnd, NULL);
			break;
		case WM_KEYDOWN:
			ObsugaKlawiszy(wParam);
			break;

		case WM_MOUSEMOVE:
			if (wParam & MK_LBUTTON) ObliczaniePrzesuniciaMyszy(lParam, 3.0f, poprzedniaPozycjaKursoraMyszyLMB, &OknoGL::ObsugaMyszyZWcinitymLewymKlawiszem);
			if (wParam & MK_RBUTTON) ObliczaniePrzesuniciaMyszy(lParam, 3.0f, poprzedniaPozycjaKursoraMyszyRMB, &OknoGL::ObsugaMyszyZWcinitymPrawymKlawiszem);
			break;	
		case WM_LBUTTONUP:
			//poprzedniaPozycjaKursoraMyszyLMB = { -1, -1 };
			poprzedniaPozycjaKursoraMyszyLMB.x = -1;
			poprzedniaPozycjaKursoraMyszyLMB.y = -1;
			break;
		case WM_RBUTTONUP:
			//poprzedniaPozycjaKursoraMyszyRMB = { -1, -1 };
			poprzedniaPozycjaKursoraMyszyRMB.x = -1;
			poprzedniaPozycjaKursoraMyszyRMB.y = -1;
			break;
		case WM_MOUSEWHEEL:
			ObsugaRolkiMyszy(wParam);
			break;

		case WM_TIMER:
			switch (wParam)
			{
			case identyfikatorTimeraSwobodnychObrotwKamery:
				if (swobodneObrotyKameryAktywne) SwobodneObrotyKamery(false);
				break;
			}
			wynik = 0;
			break;
		case WM_LBUTTONDOWN:
			swobodneObrotyKameryAktywne = false;
			break;
	}

	return wynik;
}

void OknoGL::UmieInformacjeNaPaskuTytuu(HWND uchwytOkna)
{
	char bufor[256];
	GetWindowText(uchwytOkna, bufor, 256);
	const GLubyte* wersja = glGetString(GL_VERSION);
	strcat_s(bufor, " | OpenGL "); strcat_s(bufor, (char*)wersja);
	const GLubyte* dostawca = glGetString(GL_VENDOR);
	strcat_s(bufor, " | "); strcat_s(bufor, (char*)dostawca);
	const GLubyte* kartaGraficzna = glGetString(GL_RENDERER);
	strcat_s(bufor, " | "); strcat_s(bufor, (char*)kartaGraficzna);
	const GLubyte* wersjaGLSL = glGetString(GL_SHADING_LANGUAGE_VERSION);
	strcat_s(bufor, " | GLSL "); strcat_s(bufor, (char*)wersjaGLSL);
	SetWindowText(uchwytOkna, bufor);
}

void OknoGL::UstawienieSceny(bool rzutowanieIzometryczne) //warto domylna = false
{
	glViewport(0,0, szerokoscObszaruUzytkownika, wysokoscObszaruUzytkownika); //okno OpenGL = wntrze formy (domylnie)

	/*
	//ustawienie puntu projekcji
	glMatrixMode(GL_PROJECTION); //przeczenie na macierz rzutowania
	glLoadIdentity();
	float wsp = wysokoscObszaruUzytkownika / (float)szerokoscObszaruUzytkownika;
	if(!rzutowanieIzometryczne)
		//left, right, bottom, top, znear, zfar (clipping)
		//mnoenie macierzy rzutowania przez macierz perspektywy - ustalanie frustum
		glFrustum(-1.0f, 1.0f, wsp*-1.0f, wsp*1.0f, 1.0f, 10.0f);
	else
		glOrtho(-1.0f, 1.0f, wsp*-1.0f, wsp*1.0f, 1.0f, 10.0f);
	glMatrixMode(GL_MODELVIEW);
	*/

	glEnable(GL_DEPTH_TEST); //z-buffer aktywny = ukrywanie przesonitych powierzchni

	//odtworzenie domylnych ustawie
	glFrontFace(GL_CW);
	glPolygonMode(GL_FRONT, GL_FILL);
	glPolygonMode(GL_BACK, GL_LINE);
	glCullFace(GL_BACK); 
	//glEnable(GL_CULL_FACE);

	//Parametry shadera 
	GLint parametrUwzglednijKolorWerteksu = glGetUniformLocation(idProgramuShaderow, "UwzglednijKolorWerteksu");
	glUniform1i(parametrUwzglednijKolorWerteksu, true);

	GLint parametrKolor = glGetUniformLocation(idProgramuShaderow, "Kolor");
	float kolor[4] = { 1, 0, 1, 1 };
	glUniform4fv(parametrKolor, 1, kolor);

	//Macierze - DODANE/ZMIENIONE
	GLint parametrMacierzywiata = glGetUniformLocation(idProgramuShaderow, "macierzSwiata");
	macierzwiata.ZwiZIdentyfikatorem(parametrMacierzywiata, true);

	GLint parametrMacierzyWidoku = glGetUniformLocation(idProgramuShaderow, "macierzWidoku");
	macierzWidoku.UstawJednostkow();
	macierzWidoku*=Macierz4::Przesunicie(0,0,-2.5);
	macierzWidoku.ZwiZIdentyfikatorem(parametrMacierzyWidoku, true);

	GLint parametrMacierzyRzutowania = glGetUniformLocation(idProgramuShaderow, "macierzRzutowania");
	macierzRzutowania.ZwiZIdentyfikatorem(parametrMacierzyRzutowania, false);
	float wsp = wysokoscObszaruUzytkownika / (float) szerokoscObszaruUzytkownika;
	if (!rzutowanieIzometryczne)
		//left,right,bottom,top,znear,zfar (clipping) - ustalanie frustum 
		macierzRzutowania.UstawRzutPerspektywiczny(-1.0f, 1.0f, wsp*-1.0f, wsp*1.0f, 1.0f, 10.0f);
	else
		macierzRzutowania.UstawRzutIzometryczny(-1.0f, 1.0f, wsp*-1.0f, wsp*1.0f, 1.0f, 10.0f);
	macierzRzutowania.PrzelijWarto();
}

void OknoGL::RysujScen()
{
	//Przygotowanie buforw
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT); //czyci bufory

	/*
	glLoadIdentity(); // macierz model-widok = macierz jednostkowa
	glTranslatef(0.0f, 0.0f, -3.0f); //odsunicie kamery od sceny o 3
	*/

	glDrawElements(GL_TRIANGLE_STRIP, 4, GL_UNSIGNED_BYTE, 0);

	//Z bufora na ekran
	SwapBuffers(uchwytDC);
}

void OknoGL::InicjujBuforWerteksw()
{
	const float x0 = 1.0f;
	const float y0 = 1.0f;
	const float z0 = 1.0f;

	Werteks werteksy[] =
	{
		Werteks(-x0, -y0, 0.0f, 1, 1, 0, 1), //dolny lewy
		Werteks( x0, -y0, 0.0f, 1, 0, 1, 1), //dolny prawy
		Werteks(  0,  y0, 0.0f, 0, 1, 1, 1), //grny
		Werteks(-x0,  y0, 0.0f, 0, 1, 1, 1), //grny lewy
		Werteks( x0,  y0, 0.0f, 1, 1, 1, 1)  //grny prawy
	};

	//------------------

	//Vertex Array Object (VAO)
	glGenVertexArrays(1, &vao);
	glBindVertexArray(vao);

	//Vertex Buffer Object (VBO)
	glGenBuffers(3, vbo); //tworzy bufory

	GLuint atrybutPooenia = glGetAttribLocation(idProgramuShaderow, "polozenie_in");
	if(atrybutPooenia == (GLuint)-1) atrybutPooenia = 0;
	GLuint atrybutKolor = glGetAttribLocation(idProgramuShaderow, "kolor_in");;
	if(atrybutKolor == (GLuint)-1) atrybutKolor = 3;

	//jeden bufor, z przeplataniem, klasa werteksu
	glBindBuffer(GL_ARRAY_BUFFER, vbo[0]);
	glBufferData(GL_ARRAY_BUFFER, sizeof(werteksy), werteksy, GL_STATIC_DRAW);

	glVertexAttribPointer(atrybutPooenia, Werteks::liczbaWsprzdnychPooenia, GL_FLOAT, GL_FALSE, Werteks::rozmiarWerteksu, 0);
	glEnableVertexAttribArray(atrybutPooenia);
	glVertexAttribPointer(atrybutKolor, Werteks::liczbaSkadowychKoloru, GL_FLOAT, GL_FALSE, Werteks::rozmiarWerteksu, (const GLvoid*)Werteks::rozmiarWektoraPooenia);
	glEnableVertexAttribArray(atrybutKolor);

	glBindBuffer(GL_ARRAY_BUFFER, NULL);

	//------------------------------

	GLubyte indeksy[] = { 0, 3, 1, 4 };
	glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, vbo[2]);
	glBufferData(GL_ELEMENT_ARRAY_BUFFER, sizeof(indeksy), indeksy, GL_STATIC_DRAW);
}

void OknoGL::UsuBuforWerteksw()
{
	glDeleteBuffers(3, vbo);
	glDeleteVertexArrays(1, &vao);
}

void PokaKomunikat(char* tekst, UINT typ = 0)
{
	MessageBox(NULL, tekst, "Aplikacja OpenGL - KompilacjaShaderw", MB_OK | typ);
}

#include <fstream>
char* CzytajPlikTxt(const char* nazwaPliku, int rozmiarBufora, char* bufor)
{
	std::ifstream plik_we(nazwaPliku);
	if(plik_we.fail()) return NULL;
	plik_we.read(bufor, rozmiarBufora);
	if(plik_we.eof())
	{
		std::streamsize odczytane = plik_we.gcount();
		plik_we.close();
		bufor[odczytane] = '\0';
		return bufor;
	}
	else
	{
		plik_we.close();
		return NULL;
	}
}

GLuint OknoGL::KompilujShader(const char* nazwaPliku, unsigned int typ, bool trybDebugowania)
{
	const int maksymalaWielkoKodu = 65535;

	//Wczytywanie kodu z pliku
	char kodShadera[maksymalaWielkoKodu] = "";
	if(CzytajPlikTxt(nazwaPliku, maksymalaWielkoKodu, kodShadera)==NULL)
	{
		PokaKomunikat("Brak lub niemoliwe odczytanie pliku shadera", MB_ICONERROR);
		return NULL;
	}
	else if(trybDebugowania) PokaKomunikat(kodShadera);

	//Tworzenie obiektu shadera
	GLuint idShadera = glCreateShader(typ);
	if(idShadera==NULL) return NULL;

	//Dostarczanie kodu zrodlowego do obiektu shadera
	const GLchar* zrodlo[1];
	zrodlo[0] = kodShadera;
	glShaderSource(idShadera, 1, zrodlo, NULL);

	//Kompilacja shadera
	glCompileShader(idShadera);

	//Weryfikacja kompilacji
	GLint powodzenie;
	glGetShaderiv(idShadera, GL_COMPILE_STATUS, &powodzenie);
	if(!powodzenie)
	{
		const int maxInfoLogSize = 2048;
		GLchar infoLog[maxInfoLogSize];
		glGetShaderInfoLog(idShadera, maxInfoLogSize, NULL, infoLog);
		char komunikat[maxInfoLogSize + 64] =
			"Uwaga! Kompilacja shadera nie powioda si:\n";
		strcat_s(komunikat, (char*)infoLog);
		PokaKomunikat(komunikat, MB_ICONERROR);
		return NULL;
	}
	else if(trybDebugowania) PokaKomunikat("Kompilacja shadera zakoczya si powodzeniem", MB_ICONINFORMATION);

	return idShadera;
}

unsigned int OknoGL::PrzygotujShadery(const char* vsNazwaPliku, const char* fsNazwaPliku, bool trybDebugowania)
{
	//Kompilacja shadera werteksw
	GLuint idShaderaWerteksw = KompilujShader(vsNazwaPliku, GL_VERTEX_SHADER, trybDebugowania);
	if(idShaderaWerteksw==NULL) 
	{
		PokaKomunikat("Kompilacja shadera werteksw nie powioda si", MB_ICONERROR);
		return NULL;
	}
	else if(trybDebugowania) 
		PokaKomunikat("Kompilacja shadera werteksw zakoczya si sukcesem", MB_ICONINFORMATION);

	//Kompilacja shadera fragmentw
	GLuint idShaderaFragmentw = KompilujShader(fsNazwaPliku, GL_FRAGMENT_SHADER, trybDebugowania);
	if(idShaderaFragmentw==NULL) 
	{
		PokaKomunikat("Kompilacja shadera fragmentw nie powioda si", MB_ICONERROR);
		return NULL;
	}
	else if(trybDebugowania) 
		PokaKomunikat("Kompilacja shadera fragmentw zakoczya si sukcesem", MB_ICONINFORMATION);

	//Tworzenie obiektu programu
	GLuint idProgramu = glCreateProgram();


	//Przyczanie shaderw
	glAttachShader(idProgramu, idShaderaWerteksw);
	glAttachShader(idProgramu, idShaderaFragmentw);

	//Linkowanie
	glLinkProgram(idProgramu);

	//Weryfikacja linkowania
	GLint powodzenie;
	glGetProgramiv(idProgramu, GL_LINK_STATUS, &powodzenie);
	if(!powodzenie)
	{
		const int maxInfoLogSize = 2048;
		GLchar infoLog[maxInfoLogSize];
		glGetProgramInfoLog(idProgramu, maxInfoLogSize, NULL, infoLog);
		char komunikat[maxInfoLogSize + 64] =
			"Uwaga! Kompilacja linkowanie programu shaderw nie powiodo si:\n";
		strcat_s(komunikat, (char*)infoLog);
		PokaKomunikat(komunikat, MB_ICONERROR);
		return NULL;
	}
	else if(trybDebugowania) PokaKomunikat("Linkowanie programu shaderw zakoczyo si powodzeniem", MB_ICONINFORMATION);

	//Walidacja programu
	glGetProgramiv(idProgramu, GL_VALIDATE_STATUS, &powodzenie);
	if(!powodzenie)
	{
		const int maxInfoLogSize = 2048;
		GLchar infoLog[maxInfoLogSize];
		glGetProgramInfoLog(idProgramu, maxInfoLogSize, NULL, infoLog);
		char komunikat[maxInfoLogSize + 64] =
			"Uwaga! Walidacja programu shaderw nie powiodo si:\n";
		strcat_s(komunikat, (char*)infoLog);
		PokaKomunikat(komunikat, MB_ICONERROR);
		return NULL;
	}
	else if(trybDebugowania) PokaKomunikat("Walidacja programu shaderw zakoczyo si powodzeniem", MB_ICONINFORMATION);

	//Uycia programu
	glUseProgram(idProgramu);
	
	//Usuwanie niepotrzebnych obiektw shadera
	glDeleteShader(idShaderaWerteksw);
	glDeleteShader(idShaderaFragmentw);

	return idProgramu;
}

void OknoGL::ObsugaKlawiszy(WPARAM wParam)
{
	const float kt = 5.0f;
	Macierz4 m = Macierz4::Jednostkowa;
	switch(wParam)
	{
	case 27:
		SendMessage(uchwytOkna, WM_CLOSE, 0, 0);
		break;
	case 'A':
	case VK_LEFT:
		m=Macierz4::ObrtY(kt);
		break;
	case 'D':
	case VK_RIGHT:
		m=Macierz4::ObrtY(-kt);
		break;
	case 'W':
	case VK_UP:
		m=Macierz4::ObrtX(kt);
		break;
	case 'S':
	case VK_DOWN:
		m=Macierz4::ObrtX(-kt);
		break;
	case VK_OEM_COMMA:
		m=Macierz4::ObrtZ(kt);
		break;
	case VK_OEM_PERIOD:
		m=Macierz4::ObrtZ(-kt);
		break;
	case VK_OEM_MINUS:
		m=Macierz4::Przesunicie(0,0,0.1f);
		break;
	case VK_OEM_PLUS:
		m=Macierz4::Przesunicie(0,0,-0.1f);
		break;
	case VK_F5: //DODANE
	{
		bool komunikatNaPaskuTytuu = true;
		switch (trybKontroliKamery)
		{
		case tkkFPP:
			trybKontroliKamery = tkkTPP;
			if (komunikatNaPaskuTytuu) SetWindowText(uchwytOkna, "Tryb kontroli kamery: TPP");
			break;
		case tkkTPP:
			trybKontroliKamery = tkkArcBall;
			if (komunikatNaPaskuTytuu) SetWindowText(uchwytOkna, "Tryb kontroli kamery: ArcBall");
			break;
		case tkkArcBall:
			trybKontroliKamery = tkkModel;
			if (komunikatNaPaskuTytuu) SetWindowText(uchwytOkna, "Tryb kontroli kamery: Model");
			break;
		case tkkModel:
			trybKontroliKamery = tkkFPP;
			if (komunikatNaPaskuTytuu) SetWindowText(uchwytOkna, "Tryb kontroli kamery: FPP");
			break;
		}
	}
		MessageBeep(MB_OK);
		break;
	};
	ModyfikujPooenieKamery(m);
	RysujScen();
}

#pragma region Obsuga klawiatury i myszy
Wektor3 OknoGL::PobierzPooenieKamery(bool pomiObroty) const
//zwraca pooenie kamery w ukadzie odniesienia sceny
{
	Wektor3 w3;
	if(pomiObroty)
	{
		Wektor4 w4 = macierzWidoku.KopiaKolumny(3);
		for(int i=0; i<3; ++i) w3[i] = -w4[i];
	}
	else
	{
		Wektor4 w4 = macierzWidoku.Odwrotna().KopiaKolumny(3);
		for(int i=0; i<3; ++i) w3[i] = w4[i];
	}
	return w3;
}

float OknoGL::OdlegoKamery() const
{
	return PobierzPooenieKamery().Dugo();
}

void OknoGL::ModyfikujPooenieKamery(Macierz4 macierzPrzeksztacenia)
{
	switch(trybKontroliKamery)
	{
	case tkkFPP:
		macierzWidoku.PomnZLewej(macierzPrzeksztacenia);
		break;
	case tkkTPP:
		{
			const float odlegoCentrumOdKamery = 3.0f;
			macierzWidoku.PomnZLewej(
				Macierz4::Przesunicie(0,0,-odlegoCentrumOdKamery)*
				macierzPrzeksztacenia*
				Macierz4::Przesunicie(0,0,odlegoCentrumOdKamery));
		}
		break;
	case tkkArcBall:
		{
			Wektor3 pooenieKamery = PobierzPooenieKamery(true);
			macierzWidoku.PomnZLewej(
				Macierz4::Przesunicie(-pooenieKamery)*
				macierzPrzeksztacenia*
				Macierz4::Przesunicie(pooenieKamery));
		}
		break;
	case tkkModel:
		macierzWidoku.PomnZPrawej(macierzPrzeksztacenia);
		break;
	}
	macierzWidoku.PrzelijWarto();
}

void OknoGL::ObliczaniePrzesuniciaMyszy(
	const LPARAM lParam, const float prg, 
	POINT& poprzedniaPozycjaKursoraMyszy, 
	TypMetodyObsugujcejPrzesunicieMyszy MetodaObsugujcaPrzesunicieMyszy)
{
	if (poprzedniaPozycjaKursoraMyszy.x == -1 && 
		poprzedniaPozycjaKursoraMyszy.y == -1)
	{
		//poprzedniaPozycjaKursoraMyszy = { LOWORD(lParam), HIWORD(lParam) };
		poprzedniaPozycjaKursoraMyszy.x = LOWORD(lParam);
		poprzedniaPozycjaKursoraMyszy.y = HIWORD(lParam);
		return;
	}
	POINT biecaPozycjaKursoraMyszy = { LOWORD(lParam), HIWORD(lParam) };
	POINT przesunicie;
	przesunicie.x = biecaPozycjaKursoraMyszy.x - poprzedniaPozycjaKursoraMyszy.x;
	przesunicie.y = biecaPozycjaKursoraMyszy.y - poprzedniaPozycjaKursoraMyszy.y;
	float przesunicieKursoraMyszy = (float)sqrt(przesunicie.x*przesunicie.x + przesunicie.y*przesunicie.y);
	
	if (przesunicieKursoraMyszy > prg) 
	//prg w pikselach
	//zapobiega zbyt czstym zmianom - utrata dokadnoci
	{
		(this->*MetodaObsugujcaPrzesunicieMyszy)(biecaPozycjaKursoraMyszy, przesunicie);
		poprzedniaPozycjaKursoraMyszy = biecaPozycjaKursoraMyszy;
	}
}

void OknoGL::ObsugaMyszyZWcinitymLewymKlawiszem(POINT biecaPozycjaKursoraMyszy, POINT przesunicieKursoraMyszy)
{
	//skalowanie
	const float wspX = 360.0f / szerokoscObszaruUzytkownika;
	const float wspY = 360.0f / wysokoscObszaruUzytkownika;
	float dx = przesunicieKursoraMyszy.x * wspX;
	float dy = przesunicieKursoraMyszy.y * wspY;

	//Macierz4 m = Macierz4::ObrtY(dx)*Macierz4::ObrtX(dy);
	Macierz4 m = Macierz4::ObrtXYZ(dy, dx, 0);

	ModyfikujPooenieKamery(m);
	RysujScen();

	SwobodneObrotyKamery(true, dx, dy, 0.95f); //inicjacja swobodnych obrotw kamery
}

void OknoGL::ObsugaMyszyZWcinitymPrawymKlawiszem(POINT biecaPozycjaKursoraMyszy, POINT przesunicieKursoraMyszy)
{
	//skalowanie
	const float wspX = 5.0f / szerokoscObszaruUzytkownika;
	const float wspY = 5.0f / wysokoscObszaruUzytkownika;
	float dx = przesunicieKursoraMyszy.x * wspX;
	float dy = przesunicieKursoraMyszy.y * wspY;

	Macierz4 m = Macierz4::Przesunicie(dx, -dy, 0);

	ModyfikujPooenieKamery(m);
	RysujScen();
}

void OknoGL::ObsugaRolkiMyszy(WPARAM wParam)
{
	const float czuo = 10.0f;
	short zmianaPozycjiRolki = (short)HIWORD(wParam);
	float przesuniecie = zmianaPozycjiRolki / abs(zmianaPozycjiRolki) / czuo;
	ModyfikujPooenieKamery(Macierz4::Przesunicie(0, 0, przesuniecie)); //tu w niektrych trybach w kierunku pooenia kamery
	RysujScen();
}

void OknoGL::SwobodneObrotyKamery(const bool inicjacja, const float pocztkowe_dx, const float pocztkowe_dy, const float wspczynnikWygaszania)
{
	static float dx = 0;
	static float dy = 0;
	static float wsp = 0;
	if (inicjacja)
	{
		swobodneObrotyKameryAktywne = true;
		dx = pocztkowe_dx;
		dy = pocztkowe_dy;
		wsp = wspczynnikWygaszania; if (wsp < 0) wsp = 0; if (wsp>1) wsp = 1;
		return;
	}
	else
	{
		dx *= wsp;
		dy *= wsp;
		if (fabs(dx) < 0.001f && fabs(dy) < 0.001f) swobodneObrotyKameryAktywne = false;
		Macierz4 m = Macierz4::ObrtXYZ(dy, dx, 0);
		ModyfikujPooenieKamery(m);
		RysujScen();
	}
}
#pragma endregion