#include "Okno.h"

#include <gl\GL.h>
#include <gl\GLU.h>

int WINAPI WinMain(HINSTANCE hInstance, 
				   HINSTANCE hPrevInstance,
				   LPSTR lpCmdLine, int nCmdShow)
{
	POINT polozenieOkna = {100,100};
	POINT rozmiarOkna = {800,600};
	if(!okno.Inicjuj(hInstance,polozenieOkna,rozmiarOkna))
	{
		MessageBox(NULL,"Inicjacja okna nie powioda si",
			"Aplikacja OpenGL", MB_OK | MB_ICONERROR);
		return EXIT_FAILURE;
	}
	else return okno.Uruchom();

	return 0;
}

LRESULT Okno::WndProc(HWND hWnd, UINT message,
					  WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
	case WM_DESTROY: //zamykanie okna -> koczenie aplikacji
		 PostQuitMessage(EXIT_SUCCESS);
		 break;
	case WM_SIZE: //zmiana rozmiaru okna
		RECT rect;
		GetClientRect(hWnd, &rect);
		szerokoscObszaruUzytkownika = rect.right - rect.left;
		wysokoscObszaruUzytkownika = rect.bottom - rect.top;
		break;
	default: //automatyczne przetwarzanie komunikatw
		return DefWindowProc(hWnd, message, wParam, lParam);
	}

	return 0L;
}

bool Okno::Inicjuj(HINSTANCE uchwytAplikacji, POINT polozenieOkna, POINT rozmiarOkna)
{
	char nazwaOkna[] = "Aplikacja OpenGL";

	WNDCLASSEX wc;
	wc.cbSize=sizeof(wc);
	wc.style = CS_HREDRAW | CS_VREDRAW | CS_OWNDC; //styl okna
	wc.lpfnWndProc = (WNDPROC)::WndProc; //procedura okna
	wc.cbClsExtra = 0; //dodatkowe bajty zarezrwowane za klas okna
	wc.cbWndExtra = 0; //dodatkowe bajty zarezerwowane za instancj okna
	wc.hInstance = uchwytAplikacji; //instancja aplikacji
	wc.hIcon = NULL; //uchwyt ikony
	wc.hIconSm = NULL; //uchwyt ikony
	wc.hCursor = LoadCursor(NULL, IDC_ARROW); //uchwyt kursora
	wc.hbrBackground = NULL; //uchwyt pdzla ta
	wc.lpszMenuName = NULL; //nazwa menu
	wc.lpszClassName = nazwaOkna; //nazwa klasy okna

	//Rejestracja klasy okna
	if(RegisterClassEx(&wc)==0) return false;

	//Tworzenie okna
	uchwytOkna = CreateWindow(
		nazwaOkna, //nazwa klasy okna
		nazwaOkna, //nazwa okna
		WS_OVERLAPPEDWINDOW, //styl okna
		polozenieOkna.x, polozenieOkna.y, //pooenie okna (x,y)
		rozmiarOkna.x, rozmiarOkna.y, //rozmiar okna (szeroko, wysoko)
		NULL, //uchwyt okna nadrzdnego
		NULL, //uchwyt menu
		uchwytAplikacji, //uchwyt instancji aplikacji
		NULL); //parametr komunikatu WM_CREATE informujcego o utworzeniu okna

	if(uchwytOkna==NULL) return false;

	//Pokazanie i aktualizacja okna
	ShowWindow(uchwytOkna,SW_SHOW);
	UpdateWindow(uchwytOkna);

	return true;
}

WPARAM Okno::Uruchom()
{
	//Ptla gwna - obsuga komunikatw
	MSG msg;
	while(GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return msg.wParam;
}

//---------------------------------------

bool OknoGL::UstalFormatPikseli(HDC uchwytDC) const
{
	PIXELFORMATDESCRIPTOR opisFormatuPikseli;
	ZeroMemory(&opisFormatuPikseli, sizeof(opisFormatuPikseli));
	opisFormatuPikseli.nVersion = 1;
	opisFormatuPikseli.dwFlags = PFD_SUPPORT_OPENGL | 
		PFD_DRAW_TO_WINDOW | PFD_DOUBLEBUFFER; //w oknie, podwjne buforowanie
	opisFormatuPikseli.iPixelType = PFD_TYPE_RGBA; //tyo koloru RGB z kanaa alfa
	opisFormatuPikseli.cColorBits = 32; //jako kolorw, 4 bajty (po bajcie na kady kana)
	opisFormatuPikseli.cDepthBits = 32; //gboko bufora gbi (z-buffer)
	opisFormatuPikseli.iLayerType = PFD_MAIN_PLANE;
	int formatPikseli = ChoosePixelFormat(uchwytDC, &opisFormatuPikseli);
	if(formatPikseli == 0) return false;
	if(!SetPixelFormat(uchwytDC,formatPikseli,&opisFormatuPikseli)) return false;
	return true;
}

bool OknoGL::InicjujWGL(HWND uchwytOkna)
{
	uchwytDC = ::GetDC(uchwytOkna);
	if (!UstalFormatPikseli(uchwytDC)) return false;

	uchwytRC = wglCreateContext(uchwytDC);
	if(uchwytRC == NULL) return false;
	if(!wglMakeCurrent(uchwytDC, uchwytRC)) return false;
	return true;
}

void OknoGL::UsuWGL()
{
	wglMakeCurrent(NULL, NULL);
	wglDeleteContext(uchwytRC);
	::ReleaseDC(uchwytOkna, uchwytDC);
}

LRESULT OknoGL::WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	long wynik = Okno::WndProc(hWnd, message, wParam, lParam);

	switch(message)
	{
		case WM_CREATE: //Utworzenie okna
			//zmienna uchwytOkna nie jest jeszcze zainicjowana
			if(!InicjujWGL(hWnd))
			{
				MessageBox(NULL, "Pobranie kontekstu renderowania nie powiodo si", "Aplikacja OpenGL", MB_OK | MB_ICONERROR);
				return EXIT_FAILURE;
			}
			UmieInformacjeNaPaskuTytuu(hWnd);
			UstawienieSceny();
			break;
		case WM_DESTROY: //Zamknicie okna
			UsuWGL();
			break;
		case WM_SIZE: //Zmiana rozmiaru okna
			UstawienieSceny();
			break;
		case WM_PAINT: //Okno wymaga odwieenia
			RysujScen();
			ValidateRect(hWnd, NULL);
			break;
	}

	return wynik;
}

void OknoGL::UmieInformacjeNaPaskuTytuu(HWND uchwytOkna)
{
	char bufor[256];
	GetWindowText(uchwytOkna, bufor, 256);
	const GLubyte* wersja = glGetString(GL_VERSION);
	strcat_s(bufor, " | OpenGL "); strcat_s(bufor, (char*)wersja);
	const GLubyte* dostawca = glGetString(GL_VENDOR);
	strcat_s(bufor, " | "); strcat_s(bufor, (char*)dostawca);
	const GLubyte* kartaGraficzna = glGetString(GL_RENDERER);
	strcat_s(bufor, " | "); strcat_s(bufor, (char*)kartaGraficzna);
	SetWindowText(uchwytOkna, bufor);
}

void OknoGL::UstawienieSceny(bool rzutowanieIzometryczne) //warto domylna = false
{
	glViewport(0,0, szerokoscObszaruUzytkownika, wysokoscObszaruUzytkownika); //okno OpenGL = wntrze formy (domylnie)

	//ustawienie puntu projekcji
	glMatrixMode(GL_PROJECTION); //przeczenie na macierz rzutowania
	glLoadIdentity();
	float wsp = wysokoscObszaruUzytkownika / (float)szerokoscObszaruUzytkownika;
	if(!rzutowanieIzometryczne)
		//left, right, bottom, top, znear, zfar (clipping)
		//mnoenie macierzy rzutowania przez macierz perspektywy - ustalanie frustum
		glFrustum(-1.0f, 1.0f, wsp*-1.0f, wsp*1.0f, 1.0f, 10.0f);
	else
		glOrtho(-1.0f, 1.0f, wsp*-1.0f, wsp*1.0f, 1.0f, 10.0f);
	glMatrixMode(GL_MODELVIEW);

	glEnable(GL_DEPTH_TEST); //z-buffer aktywny = ukrywanie przesonitych powierzchni
}

void OknoGL::RysujScen()
{
	const float x0 = 1.0f;
	const float y0 = 1.0f;
	const float z0 = 1.0f;

	//Przygotowanie buforw
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT); //czyci bufory

	glLoadIdentity(); // macierz model-widok = macierz jednostkowa
	glTranslatef(0.0f, 0.0f, -3.0f); //odsunicie kamery od sceny o 3

	//ty kolor werteksw
	//glColor4f(1.0f, 1.0f, 0.0f, 1.0f);

	//Rysowanie trjkta
	glBegin(GL_TRIANGLES);
	//ustalenie trzech wierzchokw trjkta (werteksw (x,y,z))
	//(0,0,z) jest mniej wicej w rodku ekranu
	//dolny lewy
	glColor4f(1.0f, 1.0f, 0.0f, 1.0f);
	glVertex3f(-x0, -y0, 0.0f);
	//dolny prawy
	glColor4f(1.0f, 0.0f, 1.0f, 1.0f);
	glVertex3f(x0, -y0, 0.0f); 
	//grny
	glColor4f(0.0f, 1.0f, 1.0f, 1.0f);
	glVertex3f(0, y0, 0.0f); 
	//koniec rysowania figury
	glEnd();

	//Z bufora na ekran
	SwapBuffers(uchwytDC);
}