#ifndef OPENGL_H
#define OPENGL_H

#define WIN32_LEAN_AND_MEAN
#define EXIT_SUCCESS 0
#define EXIT_FAILURE 1
#include <Windows.h>

#include "Wektor.h"
#include "MacierzGL.h"
#include "Aktor.h"

class Okno
{
protected:
	HWND uchwytOkna;
	int szerokoscObszaruUzytkownika, 
		wysokoscObszaruUzytkownika;

public:
	LRESULT WndProc(
		HWND hWnd, UINT message,
		WPARAM wParam, LPARAM lParam);
	bool Inicjuj(
		HINSTANCE uchwytAplikacji, 
		POINT polozenieOkna, POINT rozmiarOkna,
		bool trybPelnoekranowy, bool zmianaRozdzielczosci);
	bool ZmianaRozdzielczosci(
		long szerokosc, long wysokosc, 
		long glebiaKolorow = 32) const;
	WPARAM Uruchom();
};

enum TrybKontroliKamery { tkkFPP, tkkTPP, tkkArcBall, tkkModel };

class OknoGL : public Okno
{
private:
	HGLRC uchwytRC; //uchwyt kontekstu renderowania
	HDC uchwytDC; //uchwyt prywatnego kontekstu urzdzenia GDI

	bool UstalFormatPikseli(HDC uchwytDC) const;
	bool InicjujWGL(HWND uchwytOkna);	
	void UsuWGL();

	void UmieInformacjeNaPaskuTytuu(HWND uchwytOkna);
	void UstawienieSceny(bool rzutowanieIzometryczne = false);
	void RysujScen();

	Macierz4 macierzwiata, macierzWidoku, macierzRzutowania;
	void ObsugaKlawiszy(WPARAM wParam);
	Wektor3 PobierzPooenieKamery(bool pomiObroty = false) const;
	float OdlegoKamery() const;
	TrybKontroliKamery trybKontroliKamery;// = tkkArcBall;
	void ModyfikujPooenieKamery(Macierz4 macierzPrzeksztacenia);

	//Obsuga myszy
	typedef void (OknoGL::*TypMetodyObsugujcejPrzesunicieMyszy)(const POINT biecaPozycjaKursoraMyszy, const POINT przesunicieKursoraMyszy);
	void ObliczaniePrzesuniciaMyszy(const LPARAM lParam, const float prg, POINT& poprzedniaPozycjaKursoraMyszy, TypMetodyObsugujcejPrzesunicieMyszy MetodaObsugujcaPrzesunicieMyszy);
	virtual void ObsugaMyszyZWcinitymLewymKlawiszem(const POINT biecaPozycjaKursoraMyszy, const POINT przesunicieKursoraMyszy);
	virtual void ObsugaMyszyZWcinitymPrawymKlawiszem(const POINT biecaPozycjaKursoraMyszy, const POINT przesunicieKursoraMyszy);
	virtual void ObsugaRolkiMyszy(WPARAM wParam);

	bool swobodneObrotyKameryAktywne;
	virtual void SwobodneObrotyKamery(const bool inicjacja, const float pocztkowe_dx = 0, const float pocztkowe_dy = 0, const float wspczynnikWygaszania = 0);

	/*
	unsigned int vao;
	unsigned int vbo[3];
	void InicjujBuforWerteksw();
	void UsuBuforWerteksw();
	*/

	//shadery
	unsigned int idProgramuShaderow;
	static unsigned int KompilujShader(
		const char* nazwaPliku, unsigned int typ,
		bool trybDebugowania = false);
	static unsigned int PrzygotujShadery(
		const char* vsNazwaPliku,
		const char* fsNazwaPliku,
		bool trybDebugowania = false);


public:
	OknoGL() 
		: Okno(), uchwytRC(NULL), uchwytDC(NULL),
		trybKontroliKamery(tkkArcBall),
		macierzwiata(Macierz4::Jednostkowa),
		macierzWidoku(Macierz4::Jednostkowa),
		macierzRzutowania(Macierz4::Jednostkowa),
		swobodneObrotyKameryAktywne(false)
	{};
	LRESULT WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

protected:
	Aktor** aktorzy;
	unsigned int liczbaAktorw;
	virtual unsigned int PrzygotujAktorw();
	virtual void RysujAktorw();
	virtual void UsuAktorw();
} okno;

LRESULT CALLBACK WndProc(
		HWND hWnd, UINT message,
		WPARAM wParam, LPARAM lParam)
{
	return okno.WndProc(hWnd, message, wParam, lParam);
}

#endif