#ifndef AKTOR_H
#define AKTOR_H

#include "MacierzGL.h"
#include "Werteks.h"

class Aktor
{
protected:
	unsigned int vao, vbo;
	unsigned int liczbaWerteksw;

private:
	void InicjujBuforWerteksw();
	void UsuBuforIndeksw();

protected:
	virtual unsigned int TwrzTablicWerteksw(Werteks*& werteksy) = 0;

public:
	Macierz4 Macierzwiata;
	virtual void Inicjuj(GLuint atrybutPooenia, GLuint atrybutNormalnej, GLuint atrybutKolor);

	virtual void Rysuj();

	Aktor();
	virtual ~Aktor();
};

//--------------------------------------------

class Kwadrat : public Aktor
{
private:
	float dugoKrawdzi;
	unsigned int TwrzTablicWerteksw(Werteks*& werteksy);

public:
	Kwadrat(GLuint atrybutPooenia, GLuint atrybutNormalnej, GLuint atrybutKoloru,
		float dugoKrawdzi = 2.0f);
};

//--------------------------------------------------

class Prostopadocian : public Aktor
{
private:
	float dugoKrawdziX, dugoKrawdziY, dugoKrawdziZ;
	bool koloruj;
	unsigned int TwrzTablicWerteksw(Werteks*& werteksy);

public:
	void Rysuj();

	Prostopadocian(GLuint atrybutPooenia,
		GLuint atrybutNormalnej, GLuint atrybutKoloru, 
		float dugoKrawdziX, float dugoKrawdziY, float dugoKrawdziZ,
		bool koloruj);
};

static Prostopadocian* StwrzSzecian(
	GLuint atrybutPooenia, GLuint atrybutNormalnej, GLuint atrybutKolor,
	float dugoKrawdzi, bool koloruj)
{
	return new Prostopadocian(atrybutPooenia, atrybutNormalnej, atrybutKolor,
		dugoKrawdzi, dugoKrawdzi, dugoKrawdzi, koloruj);
}

#endif
