#include "Aktor.h"

void Aktor::InicjujBuforWerteksw()
{
	//VAO
	glGenVertexArrays(1, &vao);
	glBindVertexArray(vao);

	//VBO
	glGenBuffers(1, &vbo);
	glBindBuffer(GL_ARRAY_BUFFER, vbo);

	Werteks* werteksy = NULL;
	liczbaWerteksw = TwrzTablicWerteksw(werteksy);
	glBufferData(GL_ARRAY_BUFFER, liczbaWerteksw * sizeof(Werteks), werteksy, GL_STATIC_DRAW);
	delete [] werteksy;
}

void Aktor::Inicjuj(GLuint atrybutPooenia, GLuint atrybutNormalnej, GLuint atrybutKolor)
{
	InicjujBuforWerteksw();

	glVertexAttribPointer(
		atrybutPooenia, Werteks::liczbaWsprzdnychPooenia, 
		GL_FLOAT, GL_FALSE, 
		Werteks::rozmiarWerteksu, 0);
	glEnableVertexAttribArray(atrybutPooenia);

	glVertexAttribPointer(
		atrybutNormalnej, Werteks::liczbaWsprzdnychNormalnej,
		GL_FLOAT, GL_FALSE,
		Werteks::rozmiarWerteksu,
		(const GLvoid*)Werteks::rozmiarWektoraPooenia);
	glEnableVertexAttribArray(atrybutNormalnej);

	glVertexAttribPointer(
		atrybutKolor, Werteks::liczbaSkadowychKoloru, 
		GL_FLOAT, GL_FALSE, 
		Werteks::rozmiarWerteksu, 
		(const GLvoid*)(Werteks::rozmiarWektoraPooenia + Werteks::rozmiarNormalnej));
	glEnableVertexAttribArray(atrybutKolor);
}

Aktor::Aktor()
	:liczbaWerteksw(-1), Macierzwiata(Macierz4::Jednostkowa)
{}

void Aktor::UsuBuforIndeksw()
{
	glDeleteBuffers(1, &vbo);
	glDeleteVertexArrays(1, &vao);
}

Aktor::~Aktor()
{
	UsuBuforIndeksw();
}

void Aktor::Rysuj()
{
	assert(liczbaWerteksw>0);

	glBindVertexArray(vao);
	glBindBuffer(GL_ARRAY_BUFFER, vbo);
	glDrawArrays(GL_TRIANGLE_STRIP, 0, liczbaWerteksw);	
}

//--------------------------------------------

Kwadrat::Kwadrat(GLuint atrybutPooenia, GLuint atrybutNormalnej, 
				 GLuint atrybutKoloru, float dugoKrawdzi)
	:Aktor(), dugoKrawdzi(dugoKrawdzi)
{
	Inicjuj(atrybutPooenia, atrybutNormalnej, atrybutKoloru);
}

unsigned int Kwadrat::TwrzTablicWerteksw(Werteks*& werteksy)
{
	const float x0 = dugoKrawdzi / 2.0f;
	const float y0 = dugoKrawdzi / 2.0f;

	werteksy= new Werteks[4];
	werteksy[0] = Werteks(-x0, -y0, 0.0f, 0, 0, 1, 1, 1, 0, 1); //dolny lewy
	werteksy[1] = Werteks(x0, -y0, 0.0f, 0, 0, 1, 1, 0, 1, 1); //dolny prawy
	werteksy[2] = Werteks(-x0, y0, 0.0f, 0, 0, 1, 0, 1, 1, 1); //grny lewy
	werteksy[3] = Werteks(x0, y0, 0.0f, 0, 0, 1, 1, 1, 1, 1); //grny prawy
	
	return 4;
}

//--------------------------------------------------

Prostopadocian::Prostopadocian(
		GLuint atrybutPooenia, GLuint atrybutNormalnej,
		GLuint atrybutKoloru, float dugoKrawdziX, 
		float dugoKrawdziY, float dugoKrawdziZ,
		bool koloruj)
	:Aktor(), dugoKrawdziX(dugoKrawdziX),
	dugoKrawdziY(dugoKrawdziY), dugoKrawdziZ(dugoKrawdziZ),
	koloruj(koloruj)

{
	Inicjuj(atrybutPooenia, atrybutNormalnej, atrybutKoloru);
}


unsigned int Prostopadocian::TwrzTablicWerteksw(Werteks*& werteksy)
{
	const float x0 = dugoKrawdziX / 2.0f;
	const float y0 = dugoKrawdziY / 2.0f;
	const float z0 = dugoKrawdziZ / 2.0f;

	werteksy = new Werteks[24];

	float r = 1.0f;
	float g = 1.0f;
	float b = 1.0f;

	if(koloruj) { r = 1.0f; g = 0.0f; b= 0.0f; }
	//tylna
	werteksy[0] = Werteks(x0, -y0, -z0, 0, 0, -1, r, g, b);
	werteksy[1] = Werteks(-x0, -y0, -z0, 0, 0, -1, r, g, b);
	werteksy[2] = Werteks(x0, y0, -z0, 0, 0, -1, r, g, b);
	werteksy[3] = Werteks(-x0, y0, -z0, 0, 0, -1, r, g, b);
	//przednia
	werteksy[4] = Werteks(x0, -y0, z0, 0, 0, 1, r, g, b);
	werteksy[5] = Werteks(-x0, -y0, z0, 0, 0, 1, r, g, b);
	werteksy[6] = Werteks(x0, y0, z0, 0, 0, 1, r, g, b);
	werteksy[7] = Werteks(-x0, y0, z0, 0, 0, 1, r, g, b);

	if(koloruj) { r = 0.0f; g = 1.0f; b= 0.0f; }
	//prawa
	werteksy[8] = Werteks(x0, -y0, z0, 1, 0, 0, r, g, b);
	werteksy[9] = Werteks(x0, -y0, -z0, 1, 0, 0, r, g, b);
	werteksy[10] = Werteks(x0, y0, z0, 1, 0, 0, r, g, b);
	werteksy[11] = Werteks(x0, y0, -z0, 1, 0, 0, r, g, b);
	//lewa
	werteksy[12] = Werteks(-x0, -y0, z0, -1, 0, 0, r, g, b);
	werteksy[13] = Werteks(-x0, -y0, -z0, -1, 0, 0, r, g, b);
	werteksy[14] = Werteks(-x0, y0, z0, -1, 0, 0, r, g, b);
	werteksy[15] = Werteks(-x0, y0, -z0, -1, 0, 0, r, g, b);

	if(koloruj) { r = 0.0f; g = 0.0f; b= 1.0f; }
	//grna
	werteksy[16] = Werteks(-x0, y0, z0, 0, 1, 0, r, g, b);
	werteksy[17] = Werteks(x0, y0, z0, 0, 1, 0, r, g, b);
	werteksy[18] = Werteks(-x0, y0, -z0, 0, 1, 0, r, g, b);
	werteksy[19] = Werteks(x0, y0, -z0, 0, 1, 0, r, g, b);
	//dolna
	werteksy[20] = Werteks(-x0, -y0, z0, 0, -1, 0, r, g, b);
	werteksy[21] = Werteks(x0, -y0, z0, 0, -1, 0, r, g, b);
	werteksy[22] = Werteks(-x0, -y0, -z0, 0, -1, 0, r, g, b);
	werteksy[23] = Werteks(x0, -y0, -z0, 0, -1, 0, r, g, b);

	return 24;
}

void Prostopadocian::Rysuj()
{
	//bez bufora indeksw
	glBindVertexArray(vao);
	glBindBuffer(GL_ARRAY_BUFFER, vbo);
	for(int i = 0; i < 6; ++i)
	{
		glDrawArrays(GL_TRIANGLE_STRIP, i*4, 4);
	}
}


