#include "shader_loader.h"

using namespace std;

void framebuffer_size_callback(GLFWwindow* window, int width, int height)
{
    glViewport(0,0,width,height);
}

int main()
{
	//GLFW - inicjacja okna
	if(!glfwInit()) return -1;
	glfwWindowHint(GLFW_CONTEXT_VERSION_MAJOR, 3);
	glfwWindowHint(GLFW_CONTEXT_VERSION_MINOR, 3);
	glfwWindowHint(GLFW_SAMPLES, 8);
	GLFWwindow* window = glfwCreateWindow(640, 480, "Tytu okna", NULL, NULL);
	if(!window)
	{
		glfwTerminate();
		return -1;
	}

	glfwMakeContextCurrent(window); //kontekst
	glfwSetFramebufferSizeCallback(window, framebuffer_size_callback);

	//GLEW - zarzdzanie rozszerzeniami OpenGL
	glewExperimental = true;
	if(glewInit() != GLEW_OK) return -1;

    //---------------------------------
	/* a do nastpnego ---- - kod gotowy */

    GLuint programID = LoadShaders("shader.vsh", "shader.fsh");
    glUseProgram(programID);

    GLuint VertexArrayID;
    glGenVertexArrays(1, &VertexArrayID);
    glBindVertexArray(VertexArrayID);

    //wierzcholki
    static const GLfloat g_vertex_buffer_data[] = {
    -1.0f,-1.0f,-1.0f, // triangle 1 : begin
    -1.0f,-1.0f, 1.0f,
    -1.0f, 1.0f, 1.0f, // triangle 1 : end
    1.0f, 1.0f,-1.0f, // triangle 2 : begin
    -1.0f,-1.0f,-1.0f,
    -1.0f, 1.0f,-1.0f, // triangle 2 : end
    1.0f,-1.0f, 1.0f,
    -1.0f,-1.0f,-1.0f,
    1.0f,-1.0f,-1.0f,
    1.0f, 1.0f,-1.0f,
    1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,
    -1.0f,-1.0f,-1.0f,
    -1.0f, 1.0f, 1.0f,
    -1.0f, 1.0f,-1.0f,
    1.0f,-1.0f, 1.0f,
    -1.0f,-1.0f, 1.0f,
    -1.0f,-1.0f,-1.0f,
    -1.0f, 1.0f, 1.0f,
    -1.0f,-1.0f, 1.0f,
    1.0f,-1.0f, 1.0f,
    1.0f, 1.0f, 1.0f,
    1.0f,-1.0f,-1.0f,
    1.0f, 1.0f,-1.0f,
    1.0f,-1.0f,-1.0f,
    1.0f, 1.0f, 1.0f,
    1.0f,-1.0f, 1.0f,
    1.0f, 1.0f, 1.0f,
    1.0f, 1.0f,-1.0f,
    -1.0f, 1.0f,-1.0f,
    1.0f, 1.0f, 1.0f,
    -1.0f, 1.0f,-1.0f,
    -1.0f, 1.0f, 1.0f,
    1.0f, 1.0f, 1.0f,
    -1.0f, 1.0f, 1.0f,
    1.0f,-1.0f, 1.0f
    };

    GLuint vertexbuffer;
    glGenBuffers(1, &vertexbuffer);
    glBindBuffer(GL_ARRAY_BUFFER, vertexbuffer);

    glBufferData(GL_ARRAY_BUFFER, sizeof(g_vertex_buffer_data), g_vertex_buffer_data, GL_STATIC_DRAW);

    glEnableVertexAttribArray(0);
    glBindBuffer(GL_ARRAY_BUFFER, vertexbuffer);
    glVertexAttribPointer(
	0,
	3,
	GL_FLOAT,
	GL_FALSE,
	0,
	(void*)0);

    //kolory
    static const GLfloat g_color_buffer_data[] = {
    0.0f,  0.0f,  1.0f,
    0.0f,  0.0f,  1.0f,
    0.0f,  0.0f,  1.0f,
    1.0f,  0.0f,  0.0f,
    1.0f,  0.0f,  0.0f,
    1.0f,  0.0f,  0.0f,
    0.0f,  1.0f,  0.0f,
    0.0f,  1.0f,  0.0f,
    0.0f,  1.0f,  0.0f,
    1.0f,  0.0f,  0.0f,
    1.0f,  0.0f,  0.0f,
    1.0f,  0.0f,  0.0f,
    0.0f,  0.0f,  1.0f,
    0.0f,  0.0f,  1.0f,
    0.0f,  0.0f,  1.0f,
    0.0f,  1.0f,  0.0f,
    0.0f,  1.0f,  0.0f,
    0.0f,  1.0f,  0.0f,
    0.0f,  1.0f,  1.0f,
    0.0f,  1.0f,  1.0f,
    0.0f,  1.0f,  1.0f,
    1.0f,  0.0f,  1.0f,
    1.0f,  0.0f,  1.0f,
    1.0f,  0.0f,  1.0f,
    1.0f,  0.0f,  1.0f,
    1.0f,  0.0f,  1.0f,
    1.0f,  0.0f,  1.0f,
    1.0f,  1.0f,  0.0f,
    1.0f,  1.0f,  0.0f,
    1.0f,  1.0f,  0.0f,
    1.0f,  1.0f,  0.0f,
    1.0f,  1.0f,  0.0f,
    1.0f,  1.0f,  0.0f,
    0.0f,  1.0f,  1.0f,
    0.0f,  1.0f,  1.0f,
    0.0f,  1.0f,  1.0f
    };

    GLuint colorbuffer;
    glGenBuffers(1, &colorbuffer);
    glBindBuffer(GL_ARRAY_BUFFER, colorbuffer);

    glBufferData(GL_ARRAY_BUFFER, sizeof(g_color_buffer_data), g_color_buffer_data, GL_STATIC_DRAW);

    glEnableVertexAttribArray(1);
    glBindBuffer(GL_ARRAY_BUFFER, colorbuffer);
    glVertexAttribPointer(
	1,
	3,
	GL_FLOAT,
	GL_FALSE,
	0,
	(void*)0);
    //-------------------------------------------

	//dodane po uzyciu GLFW
	glEnable(GL_DEPTH_TEST);
	glDepthFunc(GL_LESS);

	//Uycie GLM
	glm::mat4 projection = glm::perspective(90.0f, 4.0f / 3.0f, 0.1f, 100.0f);
	glm::mat4 view = glm::lookAt(glm::vec3(0,0,3), glm::vec3(0,0,0), glm::vec3(0,1,0));
	glm::mat4 model = glm::mat4(1.0f); //jednostkowa
	glm::mat4 macierzMVP = projection * view * model;
	GLuint macierzID = glGetUniformLocation(programID, "MVP");
	glUniformMatrix4fv(macierzID, 1, GL_FALSE, &macierzMVP[0][0]); //nie da si po prostu macierzMVP, bo ona jest typu mat4, a my chcemy si dobra do jej wewntrzej tablicy float[]

	//Uycie GLFW
	/*	
	//przed dodaniem GLM
	while(!glfwWindowShouldClose(window))
	{
		glfwPollEvents();
	}
	*/
	while(!glfwWindowShouldClose(window))
	{
		glClear(GL_DEPTH_BUFFER_BIT | GL_COLOR_BUFFER_BIT);

		if(glfwGetKey(window, GLFW_KEY_RIGHT) == GLFW_PRESS) model = glm::rotate(model, 1.0f, glm::vec3(0,1,0));
		if(glfwGetKey(window, GLFW_KEY_LEFT) == GLFW_PRESS) model = glm::rotate(model, -1.0f, glm::vec3(0,1,0));
		if(glfwGetKey(window, GLFW_KEY_UP) == GLFW_PRESS) model = glm::rotate(model, -1.0f, glm::vec3(1,0,0));
		if(glfwGetKey(window, GLFW_KEY_DOWN) == GLFW_PRESS) model = glm::rotate(model, 1.0f, glm::vec3(1,0,0));		
		
		//skopiowane; mozna sprawdzic, czy cos jest wcisniete
		glm::mat4 macierzMVP = projection * view * model; 
		glUniformMatrix4fv(macierzID, 1, GL_FALSE, &macierzMVP[0][0]);

		glDrawArrays(GL_TRIANGLES, 0, 36);
		glfwSwapBuffers(window);

		glfwPollEvents();
	}


    return 0;
}