#version 330 core

uniform mat4 macierzModelu;
uniform mat4 macierzWidoku;
uniform mat4 macierzRzutowania;

in vec3 pozycja_in;
in vec3 kolor_in;
in vec3 normalna_in;
in vec2 wspTeksturowania_in;

out vec4 kolor;
out vec3 pozycja; //scena
out vec3 normalna; //scena
out vec2 wspTeksturowania;

void main(void)
{
	mat4 macierzMVP = macierzRzutowania * macierzWidoku * macierzModelu;
	gl_Position = macierzMVP*vec4(pozycja_in,1.0);

	mat3 macierzMV = mat3(macierzWidoku*macierzModelu); //do zoptymalizowania
	mat3 macierzN = transpose(macierzMV);
	pozycja = macierzMV*pozycja_in;
	normalna = normalna_in*macierzN; //kolejnosc!!!!!!!
	
	kolor.rgb = kolor_in;	
	kolor.a = 1.0;
	//kolor = vec4(kolor_in,1.0);

	wspTeksturowania = wspTeksturowania_in;
}