#include "OpenGL4.h"
#include "resource.h"

#include <cstdlib>

int CALLBACK WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow)
{
	POINT polozenieOkna = {100,100};
	POINT rozmiarOkna = {800,600};
	if(!okno.Init(hInstance,polozenieOkna,rozmiarOkna))
	{
		MessageBox(NULL,"Inicjacja okna nie powioda si","Aplikacja OpenGL 3.3+",MB_OK|MB_ICONERROR);
		return EXIT_FAILURE;
	}
	else return okno.Run();
}

LRESULT CALLBACK WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
	return okno.WndProc(hWnd,message,wParam,lParam);
}

//---------------

bool COkno::Init(HINSTANCE uchwytAplikacji,POINT polozenieOkna,POINT rozmiarOkna)
{
	char nazwaOkna[]="Aplikacja OpenGL";

	WNDCLASSEX wc;
	wc.cbSize=sizeof(wc);
	wc.style=CS_HREDRAW|CS_VREDRAW|CS_OWNDC; //styl okna
	wc.lpfnWndProc=(WNDPROC)::WndProc; //procedura okna
	wc.cbClsExtra=0; //dodatkowe bajty zarezerwowane za klas okna
	wc.cbWndExtra=0; //dodatkowe bajty zarezerwowane za instancj okna
	wc.hInstance=uchwytAplikacji; //instancja aplikacji
	wc.hIcon=LoadIcon(uchwytAplikacji,MAKEINTRESOURCE(IDI_OPENGL4)); //uchwyt ikony
	wc.hIconSm=LoadIcon(uchwytAplikacji,MAKEINTRESOURCE(IDI_OPENGL4)); //uchwyt ikony
	wc.hCursor=LoadCursor(NULL,IDC_ARROW); //uchwyt kursora
	wc.hbrBackground=NULL; //uchwyt pdzla ta
	wc.lpszMenuName=NULL; //nazwa menu
	wc.lpszClassName=nazwaOkna; //nazwa klasy okna	

	if(RegisterClassEx(&wc)==0) return false; //rejestracja klasy okna

	bool trybPelnoekranowy=false;

	//ustawienia okna
	DWORD stylOkna = WS_OVERLAPPEDWINDOW;
	if(trybPelnoekranowy)
	{
		polozenieOkna.x=0;
		polozenieOkna.y=0;
		RECT rozmiarEkranu;
		GetWindowRect(GetDesktopWindow(),&rozmiarEkranu);
		rozmiarOkna.x=rozmiarEkranu.right-rozmiarEkranu.left;
		rozmiarOkna.y=rozmiarEkranu.bottom-rozmiarEkranu.top; //zamiast pobiera, mona wymusi okreslon rozdzielczo
		//rozmiarOkna.x=1024;
		//rozmiarOkna.y=768;
		stylOkna=WS_POPUP;
		if(!ZmianaRozdzielczosciEkranu(rozmiarOkna.x,rozmiarOkna.y)) return false; //w takiej konstrukcji to tylko wymusza glebi kolorw w trybie penoekranowym
	}

	//tworzenie okna
	uchwytOkna=CreateWindow(
		nazwaOkna, //nazwa klasy okna
		nazwaOkna, //nazwa okna
		stylOkna,
		polozenieOkna.x,polozenieOkna.y, //pooenie okna (x, y)
		rozmiarOkna.x,rozmiarOkna.y, //rozmiar okna (szeroko, wysoko)
		NULL, //uchwyt okna nadrzdnego (parent)
		NULL, //uchwyt menu
		uchwytAplikacji, //uchwyt instancji aplikacji
		NULL); //parametr komunikatu informujacego o utworzeniu okna

	if(uchwytOkna==NULL) return false;

	ShowWindow(uchwytOkna,SW_SHOW); //pokazanie i aktualizacja okna
	UpdateWindow(uchwytOkna);

	return true;
}

WPARAM COkno::Run()
{
	//petla glowna - obsluga komunikatow
	MSG msg;
	while(GetMessage(&msg,0,0,0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return msg.wParam;
}

LRESULT COkno::WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
	switch(message)
	{
	case WM_DESTROY: //zamykanie okna => konczenie aplikacji
		//ChangeDisplaySettings(NULL,0); //przywrocenie domyslnej rozdzielczosci ekranu
		PostQuitMessage(0);
		break;
	case WM_SIZE: //zmiana rozmiaru okna
		RECT rect;
		GetClientRect(uchwytOkna,&rect);
		szerokoscObszaruUzytkownika=rect.right-rect.left;
		wysokoscObszaruUzytkownika=rect.bottom-rect.top;
		break;
	default: //automatyczne przetwarzanie komunikatow
		return DefWindowProc(hWnd,message,wParam,lParam);
	}
	return 0L;
}

bool COkno::ZmianaRozdzielczosciEkranu(long szerokosc,long wysokosc,long glebiaKolorow) const
{
	DEVMODE dmScreenSettings; //struktura trybu wyswietlania
	ZeroMemory(&dmScreenSettings,sizeof(dmScreenSettings)); //czyszczenie pamieci
	dmScreenSettings.dmSize=sizeof(dmScreenSettings); //rozmiar struktury
	dmScreenSettings.dmPelsWidth=szerokosc; //nowa szerokosc ekranu
	dmScreenSettings.dmPelsHeight=wysokosc; //nowa wysokosc ekranu
	dmScreenSettings.dmBitsPerPel=glebiaKolorow; //ilosc bitow opisujacych kolor piksela
	dmScreenSettings.dmFields=DM_BITSPERPEL|DM_PELSWIDTH|DM_PELSHEIGHT; //elementy podlegajace zmianom
	return ChangeDisplaySettings(&dmScreenSettings,CDS_FULLSCREEN)==DISP_CHANGE_SUCCESSFUL;
}

//-----------------------------

#include "InitApi.h"

LRESULT COknoGL::WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
	long wynik=COkno::WndProc(hWnd,message,wParam,lParam);

	switch(message)
	{
	case WM_CREATE: //utworzenie okna
		InitWGL(hWnd,true); //Uwaga! Tu zmienna uchwytOkna nie jest jeszcze zainicjowana.
		UstawienieSceny();
		break;
	case WM_DESTROY: //zamkniecie okna
		UsunWGL();
		break;
	case WM_SIZE: //zmiana rozmiaru okna
		UstawienieSceny();
		break;
	case WM_PAINT: //okno wymaga odswiezenia
		RysujScene();
		ValidateRect(hWnd,NULL);
		break;
	}

	return wynik;
}

//WGL

bool COknoGL::InitWGL(HWND uchwytOkna,bool uzupelnijTytulOkna)
{
	uchwytDC=GetDC(uchwytOkna);
	if(!UstalFormatPikseli(uchwytDC)) return false; 
	HGLRC tymczasowyUchwytRC=wglCreateContext(uchwytDC); //tworzenie tymczasowego kontekstu renderowania (met. tradycyjna)
	if(tymczasowyUchwytRC==NULL) return false;
	if(!wglMakeCurrent(uchwytDC,tymczasowyUchwytRC)) return false;

	//uzupelnienie tytulu
	if(uzupelnijTytulOkna)
	{
		char bufor[256]; GetWindowText(uchwytOkna,bufor,256);
		const GLubyte* wersja=glGetString(GL_VERSION);
		strcat(bufor," "); strcat(bufor,(char*)wersja);
		const GLubyte* dostawca=glGetString(GL_VENDOR);
		strcat(bufor," / "); strcat(bufor,(char*)dostawca);
		const GLubyte* kartaGraficzna=glGetString(GL_RENDERER);
		strcat(bufor," / "); strcat(bufor,(char*)kartaGraficzna);
		SetWindowText(uchwytOkna,bufor);
	}

	//przygotowanie RC dla OpenGL 3.3+

	int major, minor; 
	glGetIntegerv(GL_MAJOR_VERSION,&major);
	glGetIntegerv(GL_MINOR_VERSION,&minor);
	if(major<3 && minor<3) 
	{
		MessageBox(NULL,"Wersja OpenGL mniejsza ni 3.3","",MB_OK | MB_ICONERROR);
		return false;
	}

	int atrybuty[]=
	{
		WGL_CONTEXT_MAJOR_VERSION_ARB, 3,
		WGL_CONTEXT_MINOR_VERSION_ARB, 3,
		WGL_CONTEXT_FLAGS_ARB, WGL_CONTEXT_FORWARD_COMPATIBLE_BIT_ARB,
		//WGL_CONTEXT_PROFILE_MASK_ARB,WGL_CONTEXT_CORE_PROFILE_BIT_ARB,
		WGL_CONTEXT_PROFILE_MASK_ARB,WGL_CONTEXT_COMPATIBILITY_PROFILE_BIT_ARB,
		0
	};

	InitApi();
	uchwytRC = wglCreateContextAttribsARB(uchwytDC,0,atrybuty); //tworzenie zasadniczego kontekstu dla OpenGL 3.3+
	if(uchwytRC==NULL) return false;
	if(!wglMakeCurrent(uchwytDC,uchwytRC)) return false;

	wglDeleteContext(tymczasowyUchwytRC); //usuniecie niepotrzebnego juz tymczasowego uchwytu kontekstu renderowania

	return true;
}

void COknoGL::UsunWGL()
{
	wglMakeCurrent(0,0);
	wglDeleteContext(uchwytRC);
	ReleaseDC(uchwytOkna,uchwytDC);
}

bool COknoGL::UstalFormatPikseli(HDC uchwytDC) const
{
	PIXELFORMATDESCRIPTOR opisFormatuPikseli;
	ZeroMemory(&opisFormatuPikseli,sizeof(opisFormatuPikseli));
	opisFormatuPikseli.nVersion=1;
	opisFormatuPikseli.dwFlags=PFD_SUPPORT_OPENGL|PFD_DRAW_TO_WINDOW|PFD_DOUBLEBUFFER; //w oknie, podwojne buforowanie 
	opisFormatuPikseli.iPixelType=PFD_TYPE_RGBA; //typ koloru RGB z kanalem alfa
	opisFormatuPikseli.cColorBits=32; //jakosc kolorw 4 bajty (po bajcie na kazdy kanal)
	opisFormatuPikseli.cDepthBits=32; //glebokosc bufora Z (z-buffer) 
	opisFormatuPikseli.iLayerType=PFD_MAIN_PLANE;
	
	int formatPikseli=ChoosePixelFormat(uchwytDC,&opisFormatuPikseli);
	if(formatPikseli==0) return false;

	if(!SetPixelFormat(uchwytDC,formatPikseli,&opisFormatuPikseli)) return false;
	return true;
}

//OpenGL

void COknoGL::UstawienieSceny()
{
	glViewport(0,0,szerokoscObszaruUzytkownika,wysokoscObszaruUzytkownika);

	//ustalenie macierzy projekcji 
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	float aspectRatio=szerokoscObszaruUzytkownika/(float)wysokoscObszaruUzytkownika;
	glFrustum(-1*aspectRatio,1*aspectRatio,-1,1,1,100); //left,right,bottom,top,znear,zfar (clipping); mnozenie macierzy rzutowania przez macierz perspektywy - ustalanie frustum
	
	glMatrixMode(GL_MODELVIEW); //powrt do macierzy widoku modelu 
	glLoadIdentity();
	
	glEnable(GL_DEPTH_TEST); //bufor glebii aktywny 
}

void COknoGL::RysujScene()
{
	const float x0=1.0f;
	const float y0=1.0f;
	const float z0=1.0f;

	glClearColor(0.0f,0.0f,0.0f,1.0f); //kolor czyszczenia bufora ramki
	glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT); //czysci bufory ramki i glebii

	glLoadIdentity();
	glTranslatef(0,0,-2); //odsuniecie calosci o 2

	//rysowanie trojkata, ustalanie trzech wierzcholkow trojkata (werteksow (x,y,z))
	glBegin(GL_TRIANGLES);
	glVertex3f(-x0,-y0,0); //dolny lewy
	glVertex3f(x0,-y0,0); //dolny prawy
	glVertex3f(0,y0,0); //gorny
	glEnd(); //koniec rysowania ciagu figur

	SwapBuffers(uchwytDC); //z bufora na ekran
}