#ifndef __gxframework_nativewindow_h__
	#define __gxframework_nativewindow_h__

#include "shared.h"
#include <string> // metody setCaption i getCaption

namespace Gx
{
	typedef RECT Bounds;

	namespace Win32
	{
		/*
		 *	Klasa tworzy okno na jak najniszym poziomie WinApi.
		 *	Udostpnia kilka metod do bardzo obkrojonej obsugi okna.
		 */
		class GXFRAMEWORK_DECLSPEC NativeWindow
		{
		public:
			typedef HWND Handle;

			explicit NativeWindow(const char* className = ::WindowClassName);
			virtual ~NativeWindow();

			bool isValid() const;
			bool isActive() const;
			bool isVisible() const;

			void show();
			void hide();
			void update();
			void close();

			void setForeground();
			void setFocus();

			std::string getCaption() const;
			void setCaption(const std::string& caption);

			Bounds getBounds() const;
			void setBounds(const Bounds& bounds);

			unsigned int getLeft() const;
			void setLeft(unsigned int left);

			unsigned int getRight() const;
			void setRight(unsigned int right);

			unsigned int getWidth() const;
			void setWidth(unsigned int width);

			unsigned int getHeight() const;
			void setHeight(unsigned int height);

			void setDimensions(unsigned int width, unsigned int height);

			Bounds getClientBounds() const;
			Bounds getAbsoluteClientBounds() const;

			unsigned int getClientWidth() const;
			unsigned int getClientHeight() const;

			Handle getHandle() {
				return m_handle;
			}

			virtual bool handleMessage(UINT msg, WPARAM wparam, LPARAM lparam);

		protected:
			void destroy();

		private:
			NativeWindow(const NativeWindow&);
			NativeWindow& operator=(const NativeWindow&);

			Handle			m_handle;
			bool			m_active;
		};
	}
}

#endif // ~__gxframework_nativewindow_h__
