#version 330 core

in vec4 color;
in vec4 gltexcoord;
out vec4 fragColor;

//1
uniform sampler2D texture;

//2
const bool filter=true;
const float dx=1/800.0;
const float dy=1/600.0;
const vec2 offsets[9]=vec2[9](vec2(-dx,-dy),vec2(0,-dy),vec2(dx,-dy),
                              vec2(-dx,0),vec2(0,0),vec2(dx,0),
                              vec2(-dx,dy),vec2(0,dy),vec2(dx,dy));

void main(void)
{
    //2
    //blur
    const float kernel[9]=float[9](0.075625,0.12375,0.075625,
                                   0.12375,0.2025,0.12375,
                                   0.075625,0.12375,0.075625);
    //wykrywanie krawedzi
    const float kernel2[9]=float[9](-1,-1,-1,
                                    -1, 9,-1,
                                    -1,-1,-1);
    //wykrywanie krawedzi wzdluz x
    const float kernel4[9]=float[9](0,0,0,
                                    -1,1,0,
                                    0,0,0);
    //wyostrzenie
    const float kernel3[9]=float[9](0,-1,0,
                                    -1,5,-1,
                                    0,-1,0);

    if(filter)
    {
        vec4 averagedColor=vec4(0.0);
        for(int i=0;i<9;i++)
        {
            //usredniam po 9 elementow z rozkladem Gaussa
            averagedColor+=texture2D(texture,gltexcoord.st+offsets[i])*kernel[i];
            //averagedColor+=texture2D(texture,gltexcoord.st+offsets[i])*0.1111111111;
        }
        fragColor=averagedColor;
    }
    else
    {
        //1
        fragColor=vec4(texture2D(texture,gltexcoord.st).rgb,1.0);
    }
}