#ifndef __gxframework_ipixelformat_h__
	#define __gxframework_ipixelformat_h__

#include "shared.h"

namespace Gx
{
	namespace AccelerationTypes
	{
		enum Enum
		{
			/*
			 * Rendering programowy, brak akceleracji sprztowej.
			 */
			Software = 0,

			/*
			 * Rendering sprztowy dziki sterownikowi MCD.
			 */
			Generic = 1,

			/*
			 * Rendering sprztowy dziki sterownikowi ICD.
			 */
			Full = 2
		};
	}

	namespace SwapMethodTypes
	{
		enum Enum
		{
			/*
			 * Podmiana bufora przedniego i tylnego
			 */
			Exchange = 0,

			/*
			 * Bufor tylny jest kopiowany do przedniego.
			 */
			Copy = 1,

			/*
			 * Bufor tylny jest kopiowany do przedniego, 
			 * ale zawarto bufora tylnego pozostaje po zmianie niezdefiniowana.
			 */
			Undefined = 2
		};
	}

	class DeviceContext;

	/*
	 * Klasa bazowa dla formatw pixeli, biblioteka tworzy podstawowy format pikseli.
	 * Uytkownik bdzie mg stworzy rozszerzony format pixeli.
	 * Klasa zawiera tylko wybrane pola.
	 */
	class GXFRAMEWORK_DECLSPEC IPixelFormat
	{
	public:
		IPixelFormat();
		virtual ~IPixelFormat();

		virtual int getIndex(const DeviceContext& dc) = 0;
		
		//TODO: supportComposition, supportDirectDraw

		bool			drawToWindow;		// default: true
		bool			drawToBitmap;		// default: false
		bool			supportOpenGl;		// default: true
		bool			doubleBuffered;		// default: true
		bool			antiAliasing;		// default: false
		unsigned char	aliasingSamples;	// default: 0
		unsigned char	depthBits;			// default: 24
		unsigned char	stencilBits;		// default: 8
		unsigned char	colorBits;			// default: 32
		unsigned char	redBits;			// default: 8
		unsigned char	greenBits;			// default: 8
		unsigned char	blueBits;			// default: 8
		unsigned char	alphaBits;			// default: 8

		AccelerationTypes::Enum		acceleration;	// default: Full
		SwapMethodTypes::Enum		swapMethod;		// default: Exchange

	protected:
		int				m_index;

	private:
		IPixelFormat(const IPixelFormat&);
		IPixelFormat& operator=(const IPixelFormat&);
	};
}

#endif // ~__gxframework_ipixelformat_h__
