#version 330 core

in vec4 color;
in vec4 gltexcoord;
out vec4 fragColor;

uniform sampler2D colorTexture;
uniform sampler2D normalTexture;

void main(void)
{
	vec3 normal=normalize(texture2D(normalTexture,gltexcoord.st).rgb*2.0-1.0);
    vec3 lightPos=normalize(vec3(1.0,1.0,1.5));
    float diffuse=max(dot(normal,lightPos),0.0);
    vec3 lightColor=diffuse*texture2D(colorTexture,gltexcoord.st).rgb;
    //vec3 lightColor=texture2D(normalTexture,gltexcoord.st).rgb; //wyswietlanie tekstury normalnych
    fragColor=vec4(lightColor,1.0);
}