#ifndef __gxframework_gxmath_h__
	#define __gxframework_gxmath_h__

#include <algorithm>

namespace Gx
{
	namespace Math
	{
		static const float Pi		= 3.141592653589793f;
		static const float HalfPi	= 1.57079632679489661923f;			// Pi / 2
		static const float TwoPi	= 6.28318530717958647692f;			// 2 * Pi
		static const float InvPi	= 0.31830988618379067154f;			// 1 / Pi

		static const float PiDiv180	= 0.017453292519943296f;
		static const float InvPiDiv180 = 57.2957795130823229f;
	}

	static bool isFinite(float a)
	{
		return (0 == ((_FPCLASS_SNAN | _FPCLASS_QNAN | _FPCLASS_NINF | _FPCLASS_PINF) & _fpclass(a) ));
	}
}


#endif // ~__gxframework_gxmath_h__
