#ifndef __gxframework_game_h__
	#define __gxframework_game_h__

#include "shared.h"
#include "graphicsdevice.h"
#include "stopwatch.h"
#include "stepper.h"
#include "keyboard.h"
#include "mouse.h"

namespace Gx
{
	class GXFRAMEWORK_DECLSPEC Game
	{
	public:
		Game();
		virtual ~Game();

		void run();

		virtual void initialize() = 0;
		virtual void release() = 0;

		virtual void reshape(const Viewport& viewport) = 0;
		virtual void input(float elapsedTime) = 0;
		virtual void update(float elapsedTime) = 0;
		virtual void render(float elapsedTime) = 0;

		Keyboard& getKeyboard() const {
			return Keyboard::getInstance();
		}

		Mouse& getMouse() const {
			return Mouse::getInstance();
		}

		GraphicsDevice& getGraphicsDevice() {
			return m_graphicsDevice;
		}

		Window& getWindow() {
			return m_graphicsDevice.getWindow();
		}

		Stopwatch& getStopwatch() {
			return m_stopwatch;
		}

		Stepper& getStepper() {
			return m_stepper;
		}

	private:
		Game(const Game&);
		Game& operator=(const Game&);

		GraphicsDevice	m_graphicsDevice;
		Stopwatch		m_stopwatch;
		Stepper			m_stepper;
	};
}

#endif // ~__gxframework_game_h__
