#ifndef __mygame_h__
	#define __mygame_h__

#include <gxframework/gxframework.h>
#include <gxframework/gxfoundation.h>
#include "shaderprogram.h"
#include "camera.h"

class MyGame : public Gx::Game
{
public:
	MyGame();

	void initialize();
	void release();

	void reshape(const Gx::Viewport& viewport);
	void input(float elapsedTime);
	void update(float elapsedTime);
	void render(float elapsedTime);

protected:
	void initShaders();
	void initBuffers();
	void initVertexPositionBuffer();

private:
	static const unsigned int buffersCount = 1;

	GLuint			m_buffers[buffersCount];
	GLuint			m_vertexPositionBuffer;

	GLuint			m_positionLocation;
	GLuint			m_mvpLocation;

	ShaderProgram	m_identityProgram;

	Camera			m_camera;

	Gx::Matrix4		m_projection;
	Gx::Matrix4		m_view;
	Gx::Matrix4		m_model;
	Gx::Matrix4		m_mvp;
};

#endif // ~__mygame_h__
