#ifndef __camera_h__
	#define __camera_h__

#include <gxframework/gxfoundation.h>

using namespace Gx;


/* Tymczasowo, na szybko pisane... */
#define CAMERA_SPEED 10.0f
class Camera
{
public:
	Camera() : position(0.0f, 0.5f, 1.0f) {
		forward = Vector3::Forward;
		right = Vector3::Right;
		up = Vector3::Up;
	}

	void move(const Vector3& direction, float deltaTime) {
		position += direction * CAMERA_SPEED * deltaTime;
	}

	void walk(float distance, float dt) {
		position += forward * (distance * CAMERA_SPEED * dt);
	}

	void strafe(float distance, float dt) {
		position += right * (distance * CAMERA_SPEED * dt);
	}

	void fly(float distance, float dt) {
		position += up * (distance * CAMERA_SPEED * dt);
	}

	// mocno testowe... pisane ok 22:00
	// looking up and down
	void pitch(float angle) {
		angle /= 10.0f;
		forward = forward * cos(angle * Math::PiDiv180) + up * sin(angle * Math::PiDiv180);

		// Najprawdopodobniej zbugowana metoda rotate
		/*Quaternion q = Quaternion::createFromAngleAxis(angle * Math::PiDiv180, right);
		q.rotate(forward);*/

		forward.normalize();
		//up = cross(right, forward); // blokuje os up
	}

	// looking left and right
	void yaw(float angle) {
		angle /= 10.0f;
		forward = forward * cos(angle * Math::PiDiv180) - right * sin(angle * Math::PiDiv180);

		/*Quaternion q = Quaternion::createFromAngleAxis(angle * 10.0f * Math::PiDiv180, up);
		q.rotate(forward);*/

		forward.normalize();
		right = cross(forward, up);
	}

	void roll(float angle) {
		right = right * cos(angle * Math::PiDiv180) + up * sin(angle * Math::PiDiv180);
		/*Quaternion q = Quaternion::createFromAngleAxis(angle * 10.0f * Math::PiDiv180, forward);
		q.rotate(right);*/

		right.normalize();
		//up.cross(m_right, m_forward);
	}

	const Matrix4& getViewMatrix() {
		Vector3 view = position + forward;
		return Matrix4::createLookAt(position, view, up);
	}

	Vector3 position;
	Vector3 forward;
	Vector3 right;
	Vector3 up;
};

#endif // ~__camera_h__
