#ifndef __gxframework_igraphicscontext_h__
	#define __gxframework_igraphicscontext_h__

#include "shared.h"

namespace Gx
{
	class DeviceContext;

	class GXFRAMEWORK_DECLSPEC IGraphicsContext
	{
	public:
		typedef HGLRC Handle;

		IGraphicsContext();
		virtual ~IGraphicsContext();

		virtual Handle createHandle(const DeviceContext& dc) = 0;

		void setVersion(int major, int minor) {
			majorVersion = major; minorVersion = minor;
		}

		Handle getHandle() const {
			return m_handle;
		}

		bool	coreProfile;			// default: true
		bool	forwardCompatible;		// default: true
		int		majorVersion;			// default: 3
		int		minorVersion;			// default: 3

	protected:
		Handle					m_handle;

	private:
		IGraphicsContext(const IGraphicsContext&);
		IGraphicsContext& operator=(const IGraphicsContext&);
	};
}

#endif // ~__gxframework_graphicscontext_h__
