#ifndef MATRIX_H
#define MATRIX_H
#include <exception>
#include <cmath>
#include <cstring>
#include <string>
#include <sstream>
#include <cstdlib>
#include <assert.h>
#include <iostream>
#include <GL/gl.h>

#define DEG2RAD 0.017453292519943295

class MatNonInvErr: public std::exception
{ virtual const char* what() const throw() { return "Error: attempt to invert a singular matrix."; }
};
class MatUniNotBound: public std::exception
{ virtual const char* what() const throw() { return "Error: attempt to use uniform location not bound to matrix."; }
};
class MatStaOv: public std::exception
{ virtual const char* what() const throw() { return "Error: matrix stack overflow."; }
};

typedef void (*MATGLUNIMATPTR)(GLint, GLsizei, GLboolean, const GLfloat *);
//typedef GLint (*MATGLGETUNILOCPTR)(GLuint,  const GLchar *);

class Matrix4rf {
    protected:
    float coeff[4][4];
    int uni_loc, nor_uni_loc;
    bool uni_ena, nor_uni_ena;
    static MATGLUNIMATPTR UniformMatrix3fv;
    static MATGLUNIMATPTR UniformMatrix4fv;
    void Init();
    public:
    static void SetFunPtrs(MATGLUNIMATPTR UM3, MATGLUNIMATPTR UM4);
    Matrix4rf();
    Matrix4rf(float* c);
    Matrix4rf(float M11, float M12, float M13, float M14,
             float M21, float M22, float M23, float M24,
             float M31, float M32, float M33, float M34,
             float M41, float M42, float M43, float M44);
    Matrix4rf(const Matrix4rf& M); 
    Matrix4rf& operator=(const Matrix4rf& M); // to check
    std::string ToString();
    void Transpose();
    Matrix4rf Transposed();
    float Invert();
    Matrix4rf Inverted();
    float Det();
    void Multiply(Matrix4rf& R);
    void PreMultiply(Matrix4rf& L);
    void SetToIdentity();
    void SetToRotation(float angle, float x, float y, float z);
    void AppendRotation(float angle, float x, float y, float z);
    void PrependRotation(float angle, float x, float y, float z);
    void SetToTranslation(float x, float y, float z);
    void AppendTranslation(float x, float y, float z);
    void PrependTranslation(float x, float y, float z);
    void SetToScale(float x, float y, float z);
    void AppendScale(float x, float y, float z);
    void PrependScale(float x, float y, float z);
    void SetToOrtho(float left, float right, float bottom, float top, float near, float far);// to check
    void AppendOrtho(float left, float right, float bottom, float top, float near, float far);
    void PrependOrtho(float left, float right, float bottom, float top, float near, float far);
    void SetToFrustum(float left, float right, float bottom, float top, float near, float far);// to check
    void AppendFrustum(float left, float right, float bottom, float top, float near, float far);
    void PrependFrustum(float left, float right, float bottom, float top, float near, float far);
    void SetToPerspective(float fovy, float aspect, float near, float far);// to check
    void AppendPerspective(float fovy, float aspect, float near, float far);
    void PrependPerspective(float fovy, float aspect, float near, float far);
    void BindUniform(int location);
    void BindNorUniform(int location);
    void UpdateUniforms();// to check
    /*
    operator*=()
    operator*()
    operator+=()
    operator+()
    operator-=()
    operator-()
    operator-()
    operator[]()
    operator string()
    operator const char*()
    */
};

class Matrix4rfStack: public Matrix4rf {
    private:
    float* stack;
    unsigned size, pos;
    public:
    Matrix4rfStack(unsigned size);
    Matrix4rfStack(unsigned size, const Matrix4rf& M);
    Matrix4rfStack(const Matrix4rfStack& MS);
    Matrix4rfStack& operator=(const Matrix4rfStack& MS);// to check
    ~Matrix4rfStack();
    void Resize(unsigned size);
    void Pop();
    void Push();
};

#endif
