
#ifndef gridparmH
#define gridparmH

#include <fstream.h>
#include "defaulttd.h"


class GridParam
{
    private:
    	//minimal and maximum range of x
        ftyp xmin, xmax;

        //minimal and maximum range of y
        ftyp ymin, ymax;

        //minimal and maximum range of z
        ftyp zmin, zmax;

        //knots of the grid
        ntyp nx, ny, nz;

        //dimension
        ntyp dim;

        //sets dimension
        void SetDim();

        ntyp Round(const ftyp &) const;
    public:
        /* The non-argument constructor.
    	   This constructors sets default parameter values:
        		xmin = -1; ymin = 1;
    			zmin = 0;  xmax = 0;
    			ymax = 0;  zmax = 0;
    			nx=10;	   ny=0;
    			nz=0;
    			dim=1; */
        GridParam();

        /* 	This constructor reads parameters from file.
    		The file have to fillowing form:

    			xmin xmax nx
        		ymin ymax ny
        		zmin zmax nz */
        GridParam(ifstream &);

        /* 	If ymin=ymax=0 then dim=1,
        	if zmin=zmax=0 then dim=2
        	else dim=3 */
        GridParam(const ftyp &xmin, const ftyp &xmax, const ntyp &nx,
                  const ftyp &ymin=0, const ftyp &ymax=0, const ntyp &ny=0,
                  const ftyp &zmin=0, const ftyp &zmax=0, const ntyp &nz=0);

        //reads parameters from file
        void FromFile(ifstream &);

        //sets xmin, xmax , nx
        void SetXRange(const ftyp &, const ftyp &, const ntyp &);
        //sets ymin, ymax , ny
        void SetYRange(const ftyp &, const ftyp &, const ntyp &);
        //sets zmin, zmax , nz
        void SetZRange(const ftyp &, const ftyp &, const ntyp &);

        //gets xmin, xmax, nx
        void GetXRange(ftyp &, ftyp &, ntyp &) const;
        //gets ymin, ymax, ny
        void GetYRange(ftyp &, ftyp &, ntyp &) const;
        //gets zmin, zmax, nz
        void GetZRange(ftyp &, ftyp &, ntyp &) const;

        //get increase dx, dy or dz
        ftyp GetDx() const;
        ftyp GetDy() const;
        ftyp GetDz() const;

        //gets knots of the grid
        ntyp GetNx() const;
        ntyp GetNy() const;
        ntyp GetNz() const;

        //gets spatial dimension
        ntyp GetDim() const;
        
        //returns:
        //nx 	   - in case of 1D
        //nx*ny    - in case of 2D
        //nx*ny*nz - in case of 3D
        ntyp GetNmax() const;

        //gets minimal and maximum of spatial range
        ftyp GetXmin() const;
        ftyp GetYmin() const;
        ftyp GetZmin() const;
        ftyp GetXmax() const;
        ftyp GetYmax() const;
        ftyp GetZmax() const;

        //operator =
        GridParam &operator=(const GridParam &);

        ntyp GetIndexX(const ftyp &);
        ntyp GetIndexY(const ftyp &);
        ntyp GetIndexZ(const ftyp &);
};

#endif

