
#include "gridparam.h"


GridParam::GridParam()
{
    GridParam::xmin = -1;
    GridParam::ymin = 1;
    GridParam::zmin = 0;
    GridParam::xmax = 0;
    GridParam::ymax = 0;
    GridParam::zmax = 0;
    GridParam::nx=10;
    GridParam::ny=0;
    GridParam::nz=0;

    dim=1;
}

GridParam::GridParam(const ftyp &xmin, const ftyp &xmax, const ntyp &nx,
                     const ftyp &ymin, const ftyp &ymax, const ntyp &ny,
                     const ftyp &zmin, const ftyp &zmax, const ntyp &nz)
{
    GridParam::xmin = xmin;
    GridParam::ymin = ymin;
    GridParam::zmin = zmin;
    GridParam::xmax = xmax;
    GridParam::ymax = ymax;
    GridParam::zmax = zmax;
    GridParam::nx=nx;
    GridParam::ny=ny;
    GridParam::nz=nz;

    SetDim();
}


GridParam::GridParam(ifstream &inputGP)
{
    try {
        FromFile(inputGP);
    } catch (...) {
        throw "No data in file";
    }
}

void GridParam::FromFile(ifstream &inputGP)
{
    if (!inputGP.eof()) inputGP>>xmin>>xmax>>nx;
    else throw "No data in file";
    if (!inputGP.eof()) inputGP>>ymin>>ymax>>ny;
    else ymin=ymax=ny=0;
    if (!inputGP.eof()) inputGP>>zmin>>zmax>>nz;
    else zmin=zmax=nz=0;

    if (!ny) dim=1;
    else if (!nz) dim=2;
    else dim=3;
}

void GridParam::SetXRange(const ftyp &xmin, const ftyp &xmax, const ntyp &nx)
{
    GridParam::xmin = xmin;
    GridParam::xmax = xmax;
    GridParam::nx=nx;
    try {
        SetDim();
    } catch (...) {
        throw "Xmin must be different from xmax";
    }
    return;
}

void GridParam::SetYRange(const ftyp &ymin, const ftyp &ymax, const ntyp &ny)
{
    GridParam::ymin = ymin;
    GridParam::ymax = ymax;
    GridParam::ny=ny;
    try {
        SetDim();
    } catch (...) {
        throw "Xmin must be different from xmax";
    }
    return;
}

void GridParam::SetZRange(const ftyp &zmin, const ftyp &zmax, const ntyp &nz)
{
    GridParam::zmin = zmin;
    GridParam::zmax = zmax;
    GridParam::nz=nz;
    try {
        SetDim();
    } catch (...) {
        throw "Xmin must be different from xmax";
    }
    return;
}

void GridParam::GetXRange(ftyp &xmin, ftyp &xmax, ntyp &nx) const
{
    xmin = GridParam::xmin;
    xmax = GridParam::xmax;
    nx = GridParam::nx;

    return;
}

void GridParam::GetYRange(ftyp &ymin, ftyp &ymax, ntyp &ny) const
{
    ymin = GridParam::ymin;
    ymax = GridParam::ymax;
    ny = GridParam::ny;

    return;
}

void GridParam::GetZRange(ftyp &zmin, ftyp &zmax, ntyp &nz) const
{
    zmin = GridParam::zmin;
    zmax = GridParam::zmax;
    nz = GridParam::nz;

    return;
}

void GridParam::SetDim()
{
    if (xmin==xmax) throw "Xmin must be different from xmax";
    else if (ymin==ymax) dim=1;
    else if (zmin==zmax) dim=2;
    else dim=3;
}

ftyp GridParam::GetDx() const
{
    if (dim>=1) return (xmax-xmin)/(nx-1);
    return 0.0;
}

ftyp GridParam::GetDy() const
{
    if (dim>=2) return (ymax-ymin)/(ny-1);
    return 0.0;
}

ftyp GridParam::GetDz() const
{
    if (dim>=3) return (zmax-zmin)/(nz-1);
    return 0.0;
}

ntyp GridParam::GetDim() const
{
    return dim;
}

ntyp GridParam::GetNmax() const
{
    switch (dim) {
        case 1  : return nx;
        case 2  : return nx*ny;
        default : return nx*ny*nz;
    }
}

ntyp GridParam::GetNx() const
{
    return nx;
}

ntyp GridParam::GetNy() const
{
    return ny;
}

ntyp GridParam::GetNz() const
{
    return nz;
}

ftyp GridParam::GetXmin() const
{
    return xmin;
}

ftyp GridParam::GetYmin() const
{
    return ymin;
}

ftyp GridParam::GetZmin() const
{
    return zmin;
}

ftyp GridParam::GetXmax() const
{
    return xmax;
}

ftyp GridParam::GetYmax() const
{
    return ymax;
}

ftyp GridParam::GetZmax() const
{
    return zmax;
}

GridParam &GridParam::operator=(const GridParam &gp)
{
    xmin = gp.xmin;
    ymin = gp.ymin;
    zmin = gp.zmin;
    xmax = gp.xmax;
    ymax = gp.ymax;
    zmax = gp.zmax;
    nx = gp.nx;
    ny = gp.ny;
    nz = gp.nz;
    dim = gp.dim;

    return *this;
}

ntyp GridParam::Round(const ftyp &l) const
{
    ftyp tmpl=(ntyp)l;
    tmpl+=0.5;
    tmpl=tmpl>l?tmpl-0.5:tmpl+0.5;
    return (ntyp)tmpl;
}

ntyp GridParam::GetIndexZ(const ftyp &z)
{
	return Round((z-GetZmin())/GetDz());
}

ntyp GridParam::GetIndexY(const ftyp &y)
{
    return Round((y-GetYmin())/GetDy());
}

ntyp GridParam::GetIndexX(const ftyp &x)
{
    return Round((x-GetXmin())/GetDx());
}
