//---------------------------------------------------------------------------

#ifndef Unit1H
#define Unit1H
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>

#include <gl.h>
#include <glu.h>
#include "GLForm.h"
#include "CSPIN.h"
#include <vector.h>
#include <Dialogs.hpp>
#include <Menus.hpp>

#include "gridparam.h"
#include "okcancel2.h"
#include "settings.h"

#include "colormaps.h"
     /*
typedef unsigned char cm_byte;
struct rgb_triplet //RGB_709
	{
	cm_byte r;
    cm_byte g;
    cm_byte b;
    }; */

typedef struct {
    float psi_value;
    rgb_triplet kolor;
} fpsi;

typedef struct {
    int ilosc_haszy_w_naglowku;
    int ilosc_kolumn;
    bool zawiera_param_sieci;
    vector<AnsiString> naglowek;
} FileInfo;

//---------------------------------------------------------------------------
typedef fpsi* pfpsi;
class TForm1 : public TGLForm
{
    friend class TOKRightDlg;
    friend class TFormSettings;
__published:	// IDE-managed Components
    TOpenDialog *OpenDialog;
    TPopupMenu *PopupMenu1;
    TMenuItem *Wczytaj1;
    TMenuItem *Zakres1;
    TMenuItem *Wywietlaj1;
    TMenuItem *Psi1;
    TMenuItem *Psi21;
    TMenuItem *Typ1;
    TMenuItem *Punkty1;
    TMenuItem *Linie1;
    TMenuItem *Powierzchnia1;
    TMenuItem *Impulsy1;
    TMenuItem *Paleta1;
    TMenuItem *Skalszaroci1;
    TMenuItem *N51;
    TMenuItem *N71;
    TMenuItem *wlength1;
    TMenuItem *temp1;
    TMenuItem *Jednolity1;
    TMenuItem *Ustawienia1;
    void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
    void __fastcall Wczytaj1Click(TObject *Sender);
    void __fastcall Zakres1Click(TObject *Sender);
    void __fastcall Psi1Click(TObject *Sender);
    void __fastcall Psi21Click(TObject *Sender);
    void __fastcall Jednolity1Click(TObject *Sender);
    void __fastcall N51Click(TObject *Sender);
    void __fastcall Punkty1Click(TObject *Sender);
    void __fastcall Impulsy1Click(TObject *Sender);
    void __fastcall Linie1Click(TObject *Sender);
    void __fastcall Powierzchnia1Click(TObject *Sender);
    void __fastcall Ustawienia1Click(TObject *Sender);
    void __fastcall Skalszaroci1Click(TObject *Sender);
    void __fastcall N71Click(TObject *Sender);
    void __fastcall wlength1Click(TObject *Sender);
    void __fastcall temp1Click(TObject *Sender);
private:	// User declarations
	virtual void __fastcall RysujScene();
	virtual void __fastcall Oswietlenie();
	void __fastcall MlecznaZarowka();
	void __fastcall Reflektor();
    void __fastcall Swiatlo3();

    void __fastcall CzytajPsi();

    fpsi **psi;
    GridParam *gp;

    void __fastcall MinMax2D();
    double minpsi, //warto minimalna
           maxpsi, //warto maksymalna
           _min,   //minimalny kwadrat wartoci
           _max,   //maksymalny kwadrat wartoci
           min_value, //warto minimalna uwzgldniajaca zmienne skala i mod_psi
           max_value; //warto maksymalna uwzgldniajaca zmienne skala i mod_psi
    bool mod_psi;

    short int paleta;
    short int typ;
    int every;

    void __fastcall SetSkala();
    double skala, wsp;

    void __fastcall SetPsi(int mode);
    void __fastcall SetTyp(int wybrany_typ);

    void __fastcall SetColor();
    rgb_triplet __fastcall Kolor(double minpsi, double maxpsi, double psi);

    rgb_triplet __fastcall SetColorJednolity();
    rgb_triplet __fastcall SetColorN5(ftyp min, ftyp max, ftyp psi);
    rgb_triplet __fastcall SetColorN7(double min, double max, double psi);
    rgb_triplet __fastcall SetColorSzary(ftyp min, ftyp max, ftyp psi);
    rgb_triplet __fastcall SetColorTemp(ftyp min, ftyp max, ftyp psi);
    rgb_triplet __fastcall SetColorWLength(ftyp min, ftyp max, ftyp psi);
    void __fastcall SetPaleta(short int nr_palety);

    void __fastcall RysujPsiPunkty();
    void __fastcall RysujPsiImpulsy();
    void __fastcall RysujPsiLinie();
    void __fastcall RysujPsiPowierzchnia();

    void __fastcall RysujLegende();
    void __fastcall RysujOsie();

    void __fastcall OpisLegendy();

    void __fastcall CzytajGrid(char *filename);
    void __fastcall UstawParametrySieci();
    void __fastcall GetSetup(char *out);
    bool __fastcall Info();
    int __fastcall ile_kolumn(char *linia);

    FileInfo InfoPliku;

    int imin, imax, jmin, jmax;
    double Xmin, Xmax, Ymin, Ymax;
    double x_sr, y_sr;

public:		// User declarations
	__fastcall TForm1(TComponent* Owner);

    void __fastcall SetRange(double X_min, double X_max, double Y_min, double Y_max);
};
//---------------------------------------------------------------------------
extern PACKAGE TForm1 *Form1;
//---------------------------------------------------------------------------
#endif
