//---------------------------------------------------------------------------

#include <vcl.h>
#include <math.h>
#pragma hdrstop

#include "Unit1.h"
#include "okcancel2.h"
#include "glwektory.h"
#include "GLNapisy.h"
#include "colormaps.cpp"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "CSPIN"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TGLForm(Owner)
{
	debug_mode=true;
	NatezenieSwiatlaOtoczenia=0.5f;

    Xmin = -12.0f;
    Xmax =  12.0f;
    Ymin = -12.0f;
    Ymax =  12.0f;

    every = 1;
    skala = 6;

    OKRightDlg = new TOKRightDlg(this);
    FormSettings = new TFormSettings(this);
    gp=NULL;
    psi=0;

    paleta=5;
    typ=0;

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Oswietlenie()
{
	//definiowanie swiatel
   	//MlecznaZarowka();
	//Reflektor();
    Swiatlo3();
}

void __fastcall TForm1::MlecznaZarowka()
{
	const float kolor_rozproszone[4]={0.7f,0.7f,0.7f,1.0f};
	const float pozycja[4]={2.0f,2.0f,-2.0f,1.0f};

	glLightfv(GL_LIGHT1,GL_POSITION,pozycja);
	glLightfv(GL_LIGHT1,GL_DIFFUSE,kolor_rozproszone);
	glEnable(GL_LIGHT1);
}

void __fastcall TForm1::Reflektor()
{
	const float kolor_rozproszone[4]={0.3,0.3,0.3,1.0};
	const float kolor_reflektora[4]={1.0,1.0,1.0,1.0};
	const float pozycja[4]={0.0,-10.0,0.0,1.0};
	const szerokosc_wiazki=60.0; //w stopniach

	glLightfv(GL_LIGHT2,GL_POSITION,pozycja);
	glLightfv(GL_LIGHT2,GL_DIFFUSE,kolor_rozproszone);
	glLightfv(GL_LIGHT2,GL_SPECULAR,kolor_reflektora);
	glLightf(GL_LIGHT2,GL_SPOT_CUTOFF,szerokosc_wiazki);
	glEnable(GL_LIGHT2);
}
void __fastcall TForm1::Swiatlo3()
{
    const float kolor3_rozproszone[]={0.5,0.5,0.5,1.0};

    glLightfv(GL_LIGHT3,GL_DIFFUSE,kolor3_rozproszone);
    glEnable(GL_LIGHT3);
}
void __fastcall TForm1::RysujScene()
{
	//przeksztalcenia macierzy model-widok i rysowanie figur

    //jeeli udao si wczyta parametry sieci
    //wywietl dane na monitorze
    if (gp) {
        switch (typ) {
            case 0 : RysujPsiPunkty();       break;
            case 1 : RysujPsiLinie();        break;
            case 2 : RysujPsiPowierzchnia(); break;
            case 3 : RysujPsiImpulsy ();     break;
        }
        RysujOsie();
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::CzytajGrid(char *filename)
{
    ifstream input(filename);
    double tmp;
    input>>tmp;
    double nx,xmin,xmax;
    double ny,ymin,ymax;
    input>>nx>>xmin>>xmax;
    input>>ny>>ymin>>ymax;

    gp = new GridParam(xmin, xmax, nx, ymin, ymax, ny, 0, 0, 0);
}
//---------------------------------------------------------------------------
bool __fastcall TForm1::Info()
{
    int ilosc=0;
    char linia[255];
    ifstream in(OpenDialog->FileName.c_str());
    if (in.eof()) return 0; //brak danych w pliku: BAD

    //czycimy struktur przechowujaca linie nagwka pliku
    InfoPliku.naglowek.clear();
    //wykonujemy ptle dopki na poczatku lini znajduje si znak #
    for (;;) {
        if (!in.eof()) in.getline(linia,255);
            else break;
        if (linia[0]=='#') {
            ++ilosc;
            InfoPliku.naglowek.push_back(linia);
        } else break;

        //po wczytaniu drugiej linii sprawdzamy czy sa w niej parametry sieci
        if (ilosc==2) {
            if (strstr(linia,"nx = "))
                InfoPliku.zawiera_param_sieci = 1;
            else
                InfoPliku.zawiera_param_sieci = 0;
        }
    }
    //okrelamy ilo kolumn w pliku
    InfoPliku.ilosc_kolumn = ile_kolumn(linia);
    //ustawiamy warto MaxValue komponentu OKRightDlg->CSpinEdit1 na
    //ilo kolumn w pliku
    OKRightDlg->CSpinEdit1->MaxValue = InfoPliku.ilosc_kolumn;
    if (InfoPliku.ilosc_kolumn<=2)
        //jeeli w pliku sa dwie lub jedna kolumna to
        //ustawiamy warto Value komponentu OKRightDlg->CSpinEdit1 na 1
        OKRightDlg->CSpinEdit1->Value = 1;
    else
        //w przeciwnym razie ustawiamy na OKRightDlg->CSpinEdit1->MaxValue
        OKRightDlg->CSpinEdit1->Value = OKRightDlg->CSpinEdit1->MaxValue;
    in.close(); //zamykamy plik

    InfoPliku.ilosc_haszy_w_naglowku = ilosc;
    return 1;   //OK
}
//---------------------------------------------------------------------------
int __fastcall TForm1::ile_kolumn(char *linia)
{
    //ustawienie zmiennej okrelajacej liczb kolumn na 0
    int ile_kolumn=0;

    //wyznaczenie pierwszej pozycji w tablicy "linia" na ktrej wystpuje
    //jaki kolwiek znak z "1234567890-+" oraz przypisanie wskanika do tej pozycji do tp
    char *tp=strpbrk(linia,"1234567890-+");

    //dopki tp jest rne NULL
    while (tp) {
        ++ile_kolumn; //zwikzamy liczb kolumn o jeden

        //dopki pod tp wystpuje jakikolwiek znak rny od spacji, tabulatora lub
        //znaku koca tablicy wykonujemy ptl wstawiajac za warto spod tp znak spacji ' '
        for (;*tp!=' ' && *tp!='\t' && *tp!='\0'; tp++)
            *tp=' ';
        //strpbrk zwraca NULL jeli w linia nie wystpuje cho jeden znak z "1234567890-+"
        //w przeciwnym razie zwraca wskanik na ten znak
        tp=strpbrk(linia,"1234567890-+");
    }

    return ile_kolumn;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
    delete OKRightDlg;
    delete FormSettings;
    delete gp;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SetRange(double X_min, double X_max, double Y_min, double Y_max)
{
    Xmin = X_min; Xmax = X_max;
    Ymin = Y_min; Ymax = Y_max;

    //jeli Xmin jest mniejsze od minimalnej wartoci
    //sieci przestrzennej na osi OX przypisz Xmin  najmniejsza moliwa warto
    if (Xmin<gp->GetXmin()) Xmin=gp->GetXmin();
    imin = gp->GetIndexX(Xmin); //wyznaczamy indeks odpowiadajcy wartoci Xmin

    //jeli Xmax jest wiksze od najwikszej wartoci
    //sieci przestrzennej na osi OX przypisz Xmax  najwiksza moliwa warto
    if (Xmax>gp->GetXmax()) Xmax=gp->GetXmax();
    imax = gp->GetIndexX(Xmax); //wyznaczamy indeks odpowiadajcy wartoci Xmax

    //jeli Ymin jest mniejsze od minimalnej wartoci
    //sieci przestrzennej na osi OY przypisz Ymin  najmniejsza moliwa warto
    if (Ymin<gp->GetYmin()) Ymin=gp->GetYmin();
    jmin = gp->GetIndexY(Ymin); //wyznaczamy indeks odpowiadajcy wartoci Ymin

    //jeli Ymax jest wiksze od najwikszej wartoci
    //sieci przestrzennej na osi OY przypisz Ymax  najwiksza moliwa warto
    if (Ymax>gp->GetYmax()) Ymax=gp->GetYmax();
    jmax = gp->GetIndexY(Ymax); //wyznaczamy indeks odpowiadajcy wartoci Ymax

    //wyznaczamy rodek przedziau na osi OX
    x_sr = (Xmax+Xmin)/2.0;
    //wyznaczamy rodek przedziau na osi OY
    y_sr = (Ymax+Ymin)/2.0;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::CzytajPsi()
{
    Screen->Cursor=crAppStart; //ustawiamy typ kursora na klepsydr

    //przygotowujemy pami dla tablicy 2D
    psi = new pfpsi[gp->GetNx()];
    for(int i=0; i<gp->GetNx(); i++) psi[i]=new fpsi[gp->GetNy()];

    //otwieramy plik o nazwie wskazanej przez OpenDialog->FileName
    ifstream input(OpenDialog->FileName.c_str());

    char line[255];

    //pobieramy pierwsze linie w pliku zawierajace #
    for (int i=0; i<InfoPliku.ilosc_haszy_w_naglowku; i++)
        input.getline(line,255);

    //wczytujemy dane do tablicy
    for (int j=0; j<gp->GetNy(); j++)
        for (int i=0; i<gp->GetNx(); i++){
            double tmp;
            //przechodzimy przez dane ktrych nie mamy wywietla
            for (int k=1; k<OKRightDlg->CSpinEdit1->Value; k++)
                input>>tmp;
            //wczytujemy warto z poadanej kolumny
            input>>(psi[i][j].psi_value);
            //przechodzimy przez reszt kolumn
            for (int k=OKRightDlg->CSpinEdit1->Value+1; k<=OKRightDlg->CSpinEdit1->MaxValue; k++)
                input>>tmp;
        }
    input.close();  //zamykamy plik
    //SetRange();
    //MinMax2D();
    //SetColor();
    Screen->Cursor=crDefault;  //ustawiamy kursor na domylny
}       
//---------------------------------------------------------------------------
void __fastcall TForm1::Wczytaj1Click(TObject *Sender)
{
    //jeeli wybrano plik
	if (OpenDialog->Execute()){
        //Timer1->Enabled=0;
        if (psi) { //jeeli wczytano ju wczeniej jakie dane
            for(int i=0; i<gp->GetNx(); i++) { //zwolnij pami zajmowana przez
                delete[] psi[i];               //te dane
                psi[i]=0;
            }
            delete[] psi;
            psi=0;
            delete gp; //zwolnij pami zajmowana przez paramtery sieci
            gp=0;
        }
        //wyznaczamy format pliku z danymi
        Info();
        
        //wczytujemy parametry sieci
        UstawParametrySieci();

        //ustawiamy imin, imax, jmin oraz jmax
        SetRange(Xmin, Xmax, Ymin, Ymax);

        if (gp) {
            //czytamy dane z pliku jeeli zostay wczytane parametry sieci ()
            CzytajPsi();

            //wyznaczamy wartoci minimalna i maksymalna
            MinMax2D();

            //wyznaczamy kolory dla wartoci z wczeniej wyznaczonego
            //przedziau tablicy psi
            SetColor();

            //Timer1->Enabled=tmp;
        }
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::UstawParametrySieci()
{
    if (InfoPliku.zawiera_param_sieci) //jeeli plik z funkcja falowa zawiera parametry sieci
        //czytaj parametry sieci bezporednio z pliku z funkcja falowa
        GetSetup(OpenDialog->FileName.c_str());
    //jeeli istnieje plik parametrw sieci (2d-grid.par)
    else if (FileExists(ExtractFilePath(OpenDialog->FileName)+"2d-grid.par")) {
        //czytaj parametry sieci z pliku 2d-grid.par
        CzytajGrid((ExtractFilePath(OpenDialog->FileName)+"2d-grid.par").c_str());
    } else {
        //wywietl komunikat jeeli brak parametrw sieci
        ShowMessage("Brak parametrow sieci w pliku "+ ExtractFileName(OpenDialog->FileName) +
                    ". Podaj parametry sieci lub plik z parametrami sieci.");
        //poka form OKRightDlg w celu podania parametrw sieci przez uytkownika
        OKRightDlg->ShowModal();
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::GetSetup(char *out)
{
    ntyp dim=1;
    char temp[201];
    for(int i=0; i<201; i++) temp[i]='\0';
    ifstream plik(out);
    plik.getline(temp,200); //pobierz pierwsz lini komentarza
    plik.getline(temp,200); //pobierz drug lini komentarza

    if (strstr(temp,"ny")) { //jeeli w drugiej linii komentarza wystpuje "ny" 
    	++dim; //zwiksz wymiar przestrzenny o jeden
    	if (strstr(temp,"nz")) //jeeli w drugiej lini komentarza wystpuje "nz"
            ++dim; //zwiksz wymiar przestrzenny o jeden
    }
    char *tp, 
          l[10]; //przechwuje liczb w postaci znakowej (char)
    ntyp n[6];  //przechowuje odczytane parametry sieci
    n[0]=n[1]=n[2]=n[3]=n[4]=n[5]=0;
    for(int i=0; i<dim*2; i++){
    	int j=0;
    	tp=strpbrk(temp,"1234567890"); //znajd pierwsze wystpienie jednego ze 
     //znakw "1234567890"
	  //umie pierwsz napotkan liczb w tablicy o nazwie "l" typu char
        while ((*tp!=' ') && (*tp!=',') && (*tp!=']')) {
        	l[j]=*tp;
            *tp=' ';
            ++j;
            ++tp;
        }
        l[j]='\0';
        n[i]=StrToInt(l); //zamie liczb przechowywana w tablicy typu char na int 
    }
    delete gp;
    switch (dim) {
    	case 1 : gp= new GridParam(-n[1],n[1],n[0],0,0,0,0,0,0); break;
    	case 2 : gp= new GridParam(-n[2],n[2],n[0],-n[3],n[3],n[1],0,0,0);break;
    	case 3 : gp= new GridParam(-n[3],n[3],n[0],-n[4],n[4],n[1],-n[5],n[5],n[2]);
                break;
    }
    plik.close();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Zakres1Click(TObject *Sender)
{
    OKRightDlg->ShowModal();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::MinMax2D()
{
    minpsi=maxpsi=psi[imin][jmin].psi_value;
    _min=_max=minpsi*minpsi;
    //szukamy w wierszach tablicy psi poczawszy od imin a do imax
    for (int i=imin; i<=imax; i++)
        //szukamy w kolumnach tablicy psi poczawszy od jmin a do jmax
        for (int j=jmin; j<=jmax; j++){
        	if (psi[i][j].psi_value<minpsi) minpsi=psi[i][j].psi_value;
        	else if (psi[i][j].psi_value>maxpsi) maxpsi=psi[i][j].psi_value;

            if (psi[i][j].psi_value*psi[i][j].psi_value<_min) _min=psi[i][j].psi_value*psi[i][j].psi_value;
            else if (psi[i][j].psi_value*psi[i][j].psi_value>_max)_max=psi[i][j].psi_value*psi[i][j].psi_value;
    }

    SetSkala();
}
//---------------------------------------------------------------------------
rgb_triplet __fastcall TForm1::SetColorJednolity()
{
    rgb_triplet rgb={255,0,0};
    return rgb;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RysujPsiPunkty()
{
    //kady vertex ma by traktowany jako punkt
    glBegin(GL_POINTS);
    for (int j=jmin; j<=jmax; j+=every) {
        float pkt1[3]; //tablica przechowujaca wsprzdne x, y, z
        pkt1[1]=gp->GetYmin()+j*gp->GetDy()-y_sr; //wyznaczenie wsp. y
        for (int i=imin; i<=imax; i+=every){
            pkt1[0]=gp->GetXmin()+i*gp->GetDx()-x_sr;  //wyznaczenie wsp. x
            //wyznaczenie wsp. z, z uwzgldnieniem wartoci zmiennej mod_psi
            pkt1[2]=mod_psi?psi[i][j].psi_value*psi[i][j].psi_value:psi[i][j].psi_value;
            pkt1[2]*=wsp;

            //ustawienie odpowiedniego koloru rysowania
            glColor3ub(psi[i][j].kolor.r,psi[i][j].kolor.g,psi[i][j].kolor.b);
            //wyrysowanie punktu
            glVertex3fv(pkt1);
        }
    }
    glEnd();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Psi1Click(TObject *Sender)
{
    SetPsi(0);
    SetColor();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Psi21Click(TObject *Sender)
{
    SetPsi(1);
    SetColor();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SetPsi(int mode)
{
    //przeacz wasno Checked poprzednio wybranej opcji na false
    switch (mod_psi) {
        case 0 : Psi1->Checked = 0; break;
        case 1 : Psi21->Checked = 0; break;
    }
    mod_psi = mode; //przypisz zmiennej mod_psi warto mode
    //przeacz wasno Checked wybranej opcji na true
    switch (mod_psi) {
        case 0 : Psi1->Checked = 1; break;
        case 1 : Psi21->Checked = 1; break;
    }
    SetSkala();
    return;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SetTyp(int wybrany_typ)
{
    //przeacz wasno Checked poprzednio wybranej opcji na false
    switch (typ) {
        case 0 : Punkty1->Checked = 0; break;
        case 1 : Linie1->Checked = 0; break;
        case 2 : Powierzchnia1->Checked = 0; break;
        case 3 : Impulsy1->Checked = 0; break;
    }
    typ = wybrany_typ; //przypisz zmiennej mod_psi warto mode
    //przeacz wasno Checked wybranej opcji na true
    switch (typ) {
        case 0 : Punkty1->Checked = 1; break;
        case 1 : Linie1->Checked = 1; break;
        case 2 : Powierzchnia1->Checked = 1; break;
        case 3 : Impulsy1->Checked = 1; break;
    }
    return;
}
//---------------------------------------------------------------------------
rgb_triplet __fastcall TForm1::Kolor(double minpsi, double maxpsi, double psi)
{
    switch (paleta) {
        case 0 : return SetColorSzary(minpsi, maxpsi, psi);
        case 1 : return SetColorN5(minpsi, maxpsi, psi);  //wybrano palet N5
        case 2 : return SetColorN7(minpsi, maxpsi, psi);
        case 3 : return SetColorWLength(minpsi, maxpsi, psi);
        case 4 : return SetColorTemp(minpsi, maxpsi, psi); 
        case 5 : return SetColorJednolity(); //wybrano palet jednobarwna
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SetColor()
{
    //dla wszystkich wartoci w kolumnach z zakresu jmin:jmax
    for (int j=jmin; j<=jmax; j+=every)
        //dla wszystkich wartoci w wierszach z zakresu imin:imax
        for (int i=imin; i<=imax; i+=every){
            //przypisz psi_value warto spod psi[i][j].psi_value lub kwadrat
            //tej wartoci jeli mod_psi = true
            float psi_value = mod_psi?psi[i][j].psi_value*psi[i][j].psi_value:psi[i][j].psi_value; //wsp. z
            psi_value*=wsp;
            //wyznacz kolor odpowiadajacy wartoci psi_value
            psi[i][j].kolor = Kolor(min_value, max_value, psi_value);
        }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SetSkala()
{
    //jeeli mod_psi = false
    if (!mod_psi) {
        //jeeli minpsi!=0 i |minpis| jest wiksza od |maxpsi|
        if (minpsi && (fabs(minpsi)>fabs(maxpsi))) wsp=skala/fabs(minpsi);
        //jeeli maxpsi!=0 i |maxpis| jest wiksza bad rwna |minpsi|
        else if (maxpsi && (fabs(minpsi)<=fabs(maxpsi))) wsp=skala/fabs(maxpsi);
        //jeeli minpsi i maxpsi sa rwne 0
        else wsp=0.0;
    } else { //jeeli mod_psi  = true
        //jeeli _max jest rne od zera
        if (_max)
            wsp=skala/_max;
        //w przeciwnym razie
        else wsp=0.0;
    }
    //wyznaczamy wartoci minimalna oraz maksymalna uwzgldniajac
    //zmienne mod_psi oraz wsp (skala)
    min_value=(mod_psi?_min:minpsi)*wsp;
    max_value=(mod_psi?_max:maxpsi)*wsp;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SetPaleta(short int nr_palety)
{
    //usu ptaszek dla wybranej wczeniej palety
    switch (paleta) {
        case 0 : Skalszaroci1->Checked=0; break;
        case 1 : N51->Checked=0; break;        //opcja N5
        case 2 : N71->Checked=0; break;
        case 3 : wlength1->Checked=0; break;
        case 4 : temp1->Checked=0; break;
        case 5 : Jednolity1->Checked=0; break; //opcja jednolity
    }
    paleta=nr_palety;
    //ustaw ptaszek dla obecnie wybranej palety
    switch (paleta) {
        case 0 : Skalszaroci1->Checked=1; break;
        case 1 : N51->Checked=1; break;         //opcja N5
        case 2 : N71->Checked=1; break;
        case 3 : wlength1->Checked=1; break;
        case 4 : temp1->Checked=1; break;
        case 5 : Jednolity1->Checked=1; break;  //opcja jednolity
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Skalszaroci1Click(TObject *Sender)
{
    SetPaleta(0);
    SetColor();
    GL_RysujScene();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::N51Click(TObject *Sender)
{
    SetPaleta(1);
    SetColor();
    GL_RysujScene();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::N71Click(TObject *Sender)
{
    SetPaleta(2);
    SetColor();
    GL_RysujScene();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::wlength1Click(TObject *Sender)
{
    SetPaleta(3);
    SetColor();
    GL_RysujScene();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::temp1Click(TObject *Sender)
{
    SetPaleta(4);
    SetColor();
    GL_RysujScene();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Jednolity1Click(TObject *Sender)
{
    SetPaleta(5);
    SetColor();
    GL_RysujScene();
}
//---------------------------------------------------------------------------
rgb_triplet __fastcall TForm1::SetColorN5(ftyp min, ftyp max, ftyp psi)
{
	unsigned char przedzial; //numer podprzedziau
    rgb_triplet Kolor;       //przechowuje skadowe koloru
    ftyp delta=max-min,      //rnica pomidzy maksymalna a minimalna
                             //wartocia danych
         dr=delta/5.0,dp;    //szeroko podprzedziau

    Kolor.r=Kolor.g=Kolor.b=0; //wyzerowanie skadowych
    //wyznaczenie podprzedziau, do ktrego zalicza sie warto psi
  	if ((psi>=min) && (psi<(min+dr))) przedzial=1;
  	else if ((psi>=min+dr) && (psi<(min+2*dr))) przedzial=2;
  	else if ((psi>=min+2*dr) && (psi<(min+3*dr))) przedzial=3;
  	else if ((psi>=min+3*dr) && (psi<(min+4*dr))) przedzial=4;
  	else przedzial=5;

    if (!delta) return Kolor; //jeeli min=max zwracamy kolor czarny
    switch (przedzial) {
        //przedzia pierwszy
        //R=G=0 B=0->255
        case 1 : Kolor.r=0; Kolor.g=0;
            	 dp=psi-min;
            	 Kolor.b=(255*dp/dr);
                 break;
        //przedzia drugi
        //R=0 B=255 G=0->255
        case 2 : Kolor.r=0; Kolor.b=255;
            	 dp=psi-(min+dr);
            	 Kolor.g=(255*dp/dr);
                 break;
        //przedzia trzeci
        //R=0 G=255 B=255->0
        case 3 : Kolor.r=0; Kolor.g=255;
            	 dp=psi-(min+2*dr);
            	 Kolor.b=255-(255*dp/dr);
                 break;
        //przedzia czwarty
        //G=255 B=0 R=0->255
        case 4 : Kolor.g=255; Kolor.b=0;
            	 dp=psi-(min+3*dr);
            	 Kolor.r=(255*dp/dr);
                 break;
        //przedzia piaty
        //R=255 B=0 G=255->0
		case 5 : Kolor.r=255; Kolor.b=0;
            	 dp=psi-(min+4*dr);
            	 Kolor.g=255-(255*dp/dr);
                 break;
    }
    return Kolor;
}
//---------------------------------------------------------------------------
rgb_triplet __fastcall TForm1::SetColorN7(double min, double max, double psi)
{
    rgb_triplet Kolor;
	unsigned char przedzial;
    double delta=max-min, dr=delta/7.0,dp;

    Kolor.r=Kolor.b=Kolor.g=0;
    if (!delta) return Kolor;
  	if ((psi>=min) && (psi<(min+dr))) przedzial=7;
  	else if ((psi>=min+dr) && (psi<(min+2*dr))) przedzial=6;
  	else if ((psi>=min+2*dr) && (psi<(min+3*dr))) przedzial=5;
  	else if ((psi>=min+3*dr) && (psi<(min+4*dr))) przedzial=4;
    else if ((psi>=min+4*dr) && (psi<(min+5*dr))) przedzial=3;
    else if ((psi>=min+5*dr) && (psi<(min+6*dr))) przedzial=2;
  	else przedzial=1;

    switch (przedzial) {
        case 1 : Kolor.r=255;
            	 dp=psi-(min+6*dr);
            	 Kolor.g=Kolor.b=(255*dp/dr);
                 break;
		case 2 : Kolor.r=255; Kolor.b=0;
            	 dp=psi-(min+5*dr);
            	 Kolor.g=255-(255*dp/dr);
                 break;
        case 3 : Kolor.g=255; Kolor.b=0;
            	 dp=psi-(min+4*dr);
            	 Kolor.r=(255*dp/dr);
                 break;
        case 4 : Kolor.r=0; Kolor.g=255;
            	 dp=psi-(min+3*dr);
            	 Kolor.b=255-(255*dp/dr);
                 break;
        case 5 : Kolor.r=0; Kolor.b=255;
            	 dp=psi-(min+2*dr);
            	 Kolor.g=(255*dp/dr);
                 break;
        case 6 : Kolor.g=0; Kolor.b=255;
            	 dp=psi-(min+dr);
            	 Kolor.r=255-(255*dp/dr);
                 break;
        case 7 : Kolor.g=0;
            	 dp=psi-min;
            	 Kolor.r=Kolor.b=(255*dp/dr);
                 break;
    }
    return Kolor;
}
//---------------------------------------------------------------------------
rgb_triplet __fastcall TForm1::SetColorSzary(ftyp min, ftyp max, ftyp psi)
{
	rgb_triplet Kolor;
    Kolor.r=Kolor.g=Kolor.b=0;
    ftyp delta=max-min, dp=psi-min;
    if (!delta) return Kolor;
  	Kolor.r=(255*dp/delta);
  	Kolor.g=(255*dp/delta);
  	Kolor.b=(255*dp/delta);
  	return Kolor;
}
//---------------------------------------------------------------------------
rgb_triplet __fastcall TForm1::SetColorTemp(ftyp min, ftyp max, ftyp psi)
{
    return BlackBodyTemperature2rgb(1000+(psi-min)*10000/(max-min));
}
//---------------------------------------------------------------------------
rgb_triplet __fastcall TForm1::SetColorWLength(ftyp min, ftyp max, ftyp psi)
{
    return SunWavelength2rgb(380+(psi-min)*400/(max-min));
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RysujPsiImpulsy()
{
    rgb_triplet zero = Kolor(min_value, max_value, 0.0); //kolor poziomu z=0
    //dla wszystkich danych z przedziau jmin:jmax z krokiem every
    for (int j=jmin; j<=jmax; j+=every) {
        float pkt1[3];
        pkt1[1]=gp->GetYmin()+j*gp->GetDy()-y_sr; //wsp. y
        //dla wszystkich danych z przedziau imin:imax z krokiem every
        for (int i=imin; i<=imax; i+=every){
            pkt1[0]=gp->GetXmin()+i*gp->GetDx()-x_sr;  //wsp. x
            glBegin(GL_LINES);
            //pierwszy punkt linii (supka) na poziomie z=0
            glColor3ub(zero.r,zero.g,zero.b);
            pkt1[2]=0.0;
            glVertex3fv(pkt1);

            //wyznaczamy wsp. z dla psi[i][j]
            //drugi punkt linii (supka)
            pkt1[2]=mod_psi?psi[i][j].psi_value*psi[i][j].psi_value:psi[i][j].psi_value; //wsp. z
            pkt1[2]*=wsp; //przeskalowanie
            glColor3ub(psi[i][j].kolor.r,psi[i][j].kolor.g,psi[i][j].kolor.b);
            glVertex3fv(pkt1);
            glEnd();
        }
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Punkty1Click(TObject *Sender)
{
    SetTyp(0);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Impulsy1Click(TObject *Sender)
{
    SetTyp(3);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RysujPsiLinie()
{
    for (int j=jmin; j<=jmax; j+=every) {
        float pkt1[3]; //tablica przechowujaca wsp. x, y i z
        pkt1[1]=gp->GetYmin()+j*gp->GetDy()-y_sr; //wsp. y
        glBegin(GL_LINE_STRIP); //poacz werteksy tworzac krzywa
        for (int i=imin; i<=imax; i+=every){
            pkt1[0]=gp->GetXmin()+i*gp->GetDx()-x_sr; //wsp. x
            pkt1[2]=mod_psi?psi[i][j].psi_value*psi[i][j].psi_value:psi[i][j].psi_value; //wsp. z
            pkt1[2]*=wsp; //przeskalowanie
            glColor3ub(psi[i][j].kolor.r,psi[i][j].kolor.g,psi[i][j].kolor.b);
            glVertex3fv(pkt1);
        }
        glEnd();
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Linie1Click(TObject *Sender)
{
    SetTyp(1);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RysujPsiPowierzchnia()
{
   float pkt1[3], pkt2[3], pkt3[3];
    for (int j=jmin; j<=jmax-1; j+=every) {
        double y=gp->GetYmin()+j*gp->GetDy()-y_sr; //wsp. y
        pkt1[1]=y; pkt2[1]=y;
        glBegin(GL_QUAD_STRIP);
        for (int i=imin; i<=imax; i+=every){
            double x=gp->GetXmin()+i*gp->GetDx()-x_sr; //wsp. x
            float normalna[3]; //tablica przechowujaca wsprzdne wektora normalnego
            //sparawdzamy czy nie wyjdziemy poza zakres sieci
            if (i+every<gp->GetNx() && j+every<gp->GetNy()) {
                //dolny lewy punkt
                pkt1[0]=x;
                pkt1[2]=(mod_psi?psi[i][j].psi_value*psi[i][j].psi_value:psi[i][j].psi_value)*wsp;

                //dolny prawy punkt
                pkt2[0]=x+every*gp->GetDx(); //wsp. x
                pkt2[2]=(mod_psi?psi[i+every][j].psi_value*psi[i+every][j].psi_value:psi[i+every][j].psi_value)*wsp; //wsp. z

                //gorny lewy punkt
                pkt3[0]=x; pkt3[1]=y+every*gp->GetDy();
                pkt3[2]=(mod_psi?psi[i][j+every].psi_value*psi[i][j+every].psi_value:psi[i][j+every].psi_value)*wsp;

                //wyznaczamy wektor normalny do paszczyzny zawierajacej pkt1, pkt2 i pkt3
                JednostkowyWektorNormalny3fv(pkt1, pkt2, pkt3, normalna);

                //ustawiamy wektor normalny
                glNormal3fv(normalna);
                glColor3ub(psi[i][j].kolor.r,psi[i][j].kolor.g,psi[i][j].kolor.b);
                //"rysujemy" pierwszy punkt
                glVertex3fv(pkt1);
                glColor3ub(psi[i][j+every].kolor.r,psi[i][j+every].kolor.g,psi[i][j+every].kolor.b);
                //"rysujemy" drugi punkt
                glVertex3fv(pkt3);
            }
        }
        glEnd();
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Powierzchnia1Click(TObject *Sender)
{
    SetTyp(2);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Ustawienia1Click(TObject *Sender)
{
    FormSettings->Show();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RysujLegende()
{
    if (paleta==5) return; //jeli jest wybrana paleta jednobarwna
                           //to nie wywietlamy legendy
    double max_wsp_x = 0.12, //maksymalna wsprzdna x legendy (prawa krawd)
           min_wsp_x=0.04;   //minimalna wsprzdna x legendy (lewa krawd)
   // float normalna[3];
    //normalna[1] = -0.080;
    //normalna[2] = 0.6; //wsp. z
    glBegin(GL_QUAD_STRIP);
    for (double x=min_wsp_x; x<=max_wsp_x; x+=0.00025){
            //kolor krawdzi
            rgb_triplet kolor = Kolor(min_wsp_x,max_wsp_x,x);
            glColor3ub(kolor.r,kolor.g,kolor.b);

            //normalna[0] = x;
            //glNormal3fv(normalna);
            //punkty wyznaczajace krawd
            glVertex3f(x,-0.080,-0.4);
            glVertex3f(x,-0.083,-0.4);
    }
    glEnd();

    glColor3ub(255, 255, 255);
    glBegin(GL_LINES);
        //znacznik przy lewej krawdzi legendy
        glVertex3f(min_wsp_x,-0.083,-0.4);
        glVertex3f(min_wsp_x,-0.085,-0.4);

        //znacznik umieszczony na rodku legendy
        glVertex3f(min_wsp_x+(max_wsp_x-min_wsp_x)/2,-0.083,-0.4);
        glVertex3f(min_wsp_x+(max_wsp_x-min_wsp_x)/2,-0.085,-0.4);

        //znacznik przy prawej krawdzi legendy
        glVertex3f(max_wsp_x,-0.083,-0.4);
        glVertex3f(max_wsp_x,-0.085,-0.4);
    glEnd();
    //opis legendy
    OpisLegendy();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RysujOsie()
{
    double minpsi=min_value,
           maxpsi=max_value;
    double Xmin=Form1->Xmin-x_sr, //minimalna warto wsprzdnej x przesunita o x_sr
           Xmax=Form1->Xmax-x_sr, //maksymalna warto wsprzdnej x przesunita o x_sr
           Ymin=Form1->Ymin-y_sr, //minimalna warto wsprzdnej y przesunita o y_sr
           Ymax=Form1->Ymax-y_sr; //maksymalna warto wsprzdnej y przesunita o y_sr

    if (minpsi>=0.0 && maxpsi>=0.0) minpsi=0.0;
    if (maxpsi<=0.0 && minpsi<=0.0) maxpsi=0.0;

    glColor3ub(255,255,255);
    //prostokat z=0
    glBegin(GL_LINE_STRIP);
    glVertex3f(Xmin,Ymin,0); //wsprzdne lewego dolnego rogu
    glVertex3f(Xmin,Ymax,0); //wsprzdne lewego grnego rogu
    glVertex3f(Xmax,Ymax,0); //wsprzdne prawego grnego rogu
    glVertex3f(Xmax,Ymin,0); //wsprzdne prawego dolnego rogu
    glVertex3f(Xmin,Ymin,0); //wsprzdne lewego dolnego rogu
    glEnd();

    //prostokat x=Xmin
    glBegin(GL_LINE_STRIP);
    glVertex3f(Xmin,Ymin,minpsi); //wsprzdne dolnego bardziej oddalonego rogu
    glVertex3f(Xmin,Ymin,maxpsi); //wsprzdne dolnego rogu
    glVertex3f(Xmin,Ymax,maxpsi); //wsprzdne grnego rogu
    glVertex3f(Xmin,Ymax,minpsi); //wsprzdne grnego bardziej oddalonego rogu
    glVertex3f(Xmin,Ymin,minpsi); //wsprzdne dolnego bardziej oddalonego rogu
    glEnd();

    //prostokat y=Ymax
    glBegin(GL_LINE_STRIP);
    glVertex3f(Xmin,Ymax,minpsi); //wsprzdne lewego bardziej oddalonego rogu
    glVertex3f(Xmin,Ymax,maxpsi); //wsprzdne lewego rogu
    glVertex3f(Xmax,Ymax,maxpsi); //wsprzdne prawego rogu
    glVertex3f(Xmax,Ymax,minpsi); //wsprzdne prawego bardziej oddalonego rogu
    glVertex3f(Xmin,Ymax,minpsi); //wsprzdne lewego bardziej oddalonego rogu
    glEnd();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::OpisLegendy()
{
    double max_wsp_x = 0.12,
           min_wsp_x=0.04;
           //okrelenie minimalnej i maksymalnej wartoci
           //(uwzgldnienie wartoci mod_psi)
    double min = mod_psi?_min:minpsi,
           max = mod_psi?_max:maxpsi;

    //opis legendy - wartosc minimalna
    glColor3ub(255, 255, 255);
    glRasterPos3f(min_wsp_x-0.015, -0.09, -0.4);
    glPrint(podstawa, "%4.2e", min);

    //opis legendy - wartosc porodku przedziau minimalna:maksymalna
    glRasterPos3f(min_wsp_x+(max_wsp_x-min_wsp_x)/2-0.015, -0.09, -0.4);
    glPrint(podstawa, "%4.2e", (max+min)/2.0);

    //opis legendy - wartosc maksymalna
    glRasterPos3f(max_wsp_x-0.015, -0.09, -0.4);
    glPrint(podstawa, "%4.2e", max);
}
//---------------------------------------------------------------------------



