//---------------------------------------------------------------------------


#pragma hdrstop

#include "GLNapisy.h"
#include <stdio.h>

//---------------------------------------------------------------------------

#pragma package(smart_init)


GLuint StworzCzcionkeBitmapowa(HWND Handle,AnsiString NazwaCzcionki,bool Pogrubiona,bool Kursywa)
{
	HFONT	font;		//uchwyt do czcionki
	HFONT	tmp_font;	//pomocniczy

	GLuint podstawa = glGenLists(256);	//Tworzy liste na pelen zestaw czcionek

	//funkcja WinAPI (GDI); tworzy obiekt czcionki
	tmp_font = CreateFont(-14, //wysokosc czcionki
						  0,	        		//uzywam szerokosci czcionki proporcjonalnej do wysokosci
						  0,			        //nachylenie czcionek
						  0,		        	//kat
						  Pogrubiona?FW_BOLD:FALSE, //pogrubionie
						  Kursywa?TRUE:FALSE,   //kursywa
						  FALSE,		        //podkreslenie
						  FALSE,                //przekreslenie
						  ANSI_CHARSET,   		//zbior liter ANSI
						  OUT_TT_PRECIS,		//czcionki true type
						  CLIP_DEFAULT_PRECIS,  //domyslna precyzja przycinania rozmiaru
						  ANTIALIASED_QUALITY,	//antyaliasing przy tworzeniu obrazow
						  FF_DONTCARE|DEFAULT_PITCH,  //styl i dekoracja czcionki
						  NazwaCzcionki.c_str());	  //nazwa czcionki

	HDC uchwytDC=GetDC(Handle); //ten uchwyt jest w klasie TGLForm, ale prywatny
	font=(HFONT)SelectObject(uchwytDC,tmp_font);       //zwiazanie z naszym kontekstem okna
	//Funkcja specyficzna dla Windows; 32-spacja; ilosc: 96 - alfabet lacinski, 256 - gdy tez polskie znaki
	wglUseFontBitmaps(uchwytDC,0,256,podstawa);       //buduje pelen zestaw 256 czcionek bitmapowych
   SelectObject(uchwytDC,font);   //Wybor czcionki, ktora stworzylismy
   DeleteObject(tmp_font);        //Usuwanie pomocniczego

	return podstawa;
}

GLuint StworzCzcionke3D(HWND Handle,AnsiString NazwaCzcionki,bool Pogrubiona,bool Kursywa)
{
   HFONT font;      //uchwyt do czcionki
   HFONT tmp_font;  //pomocniczy

   GLuint podstawa = glGenLists(256);   //Tworzy liste na pelen zestaw czcionek

   //funkcja WinAPI (GDI); tworzy obiekt czcionki
   tmp_font = CreateFont(30, //wysokosc czcionki
                         0,  //uzywam szerokosci czcionki proporcjonalnej do wysokosci
                         0,  //nachylenie czcionek
                         0,  //kat
                         Pogrubiona?FW_BOLD:FALSE, //pogrubionie
                         Kursywa?TRUE:FALSE,       //kursywa
                         FALSE,                //podkreslenie
                         FALSE,                //przekreslenie
                         ANSI_CHARSET,         //zbior liter ANSI
                         OUT_TT_PRECIS,        //czcionki true type
                         CLIP_DEFAULT_PRECIS,  //domyslna precyzja przycinania rozmiaru
                         ANTIALIASED_QUALITY,  //antyaliasing przy tworzeniu obrazow
                         FF_DONTCARE|DEFAULT_PITCH,  //styl i dekoracja czcionki
                         NazwaCzcionki.c_str());     //nazwa czcionki

	HDC uchwytDC=GetDC(Handle); //ten uchwyt jest w klasie TGLForm, ale prywatny
	font=(HFONT)SelectObject(uchwytDC,tmp_font);   //zwiazanie z naszym kontekstem okna
	//Funkcja specyficzna dla Windows; 32-spacja; ilosc: 96 - alfabet lacinski, 256 - gdy tez polskie znaki
	//wglUseFontBitmaps(uchwytDC,0,256,podstawa);       //buduje pelen zestaw 256 czcionek
	GLYPHMETRICSFLOAT gmf[256]; //informacje o rozmiarach czcionek (tutaj nie wykorzystywane)
	wglUseFontOutlines(uchwytDC,0,256,podstawa,  //buduje pelen zestaw 256 czcionek 3D
					   0.0f, //precyzja budowania czcionki
					   0.2f, //glebokosc czcionki
					   WGL_FONT_POLYGONS,
					   gmf); //informacje o rozmiarach czcionek
   SelectObject(uchwytDC,font);   //Wybor czcionki, ktora stworzylismy
   DeleteObject(tmp_font);        //Usuwanie pomocniczego

	return podstawa;
}


GLvoid Pisz(AnsiString napis,GLuint czcionka)
{
	if (napis.IsEmpty()) return;

   glPushAttrib(GL_LIST_BIT);   //Odklada na stos atrybuty wyswietlania
   glListBase(czcionka - 0);    //Ustawia podstawe znakow na 32
   glCallLists(napis.Length(), GL_UNSIGNED_BYTE, napis.c_str()); //Wyswietla liste liter (napis)
   glPopAttrib();               //Przywraca ze stosu atrybuty wyswietlania
}

void glPrint(GLuint podstawa, const char *fmt, ...)	// Custom GL "Print" Routine
{
	char		text[256];								// Holds Our String
	va_list		ap;										// Pointer To List Of Arguments

	if (fmt == NULL)									// If There's No Text
		return;											// Do Nothing

	va_start(ap, fmt);									// Parses The String For Variables
	    vsprintf(text, fmt, ap);						// And Converts Symbols To Actual Numbers
	va_end(ap);											// Results Are Stored In Text

	glPushAttrib(GL_LIST_BIT);							// Pushes The Display List Bits
	glListBase(podstawa - 0);							// Sets The Base Character to 32
	glCallLists(strlen(text), GL_UNSIGNED_BYTE, text);	// Draws The Display List Text
	glPopAttrib(); 	     								// Pops The Display List Bits
}

void KillFont(GLuint podstawa)					// Delete The Font List
{
	glDeleteLists(podstawa, 256);							// Delete All 256 Characters
}

