/* II.1 Dodanie plikw nagwkowych */
#include <windows.h>
#include <gl\gl.h>
#include <gl\glu.h>
/* II.1 ---*/

/* II.2 Stae i zmienne globalne */
HGLRC hRC = NULL; //uchwyt kontekstu renderingu
HDC uchwytDC = NULL; //uchwyt prywatnego kontekstu urzdzenia GDI
GLint ClientWidth; //szeroko obszaru roboczego okna
GLint ClientHeight; //wysoko obszaru roboczego okna
static LPCTSTR lpszAppName = "GLTemplate"; //nazwa okna i klasy okna
/* II.2 ---*/


/* II.7 Zmienne globalne kamery */
GLfloat kameraX = 0.0f; 
GLfloat kameraY = 0.0f; 
GLfloat tmpKameraX = 0.0f; 
GLfloat tmpKameraY = 0.0f; 
GLfloat kameraPhi = 30.0f; 
GLfloat kameraTheta = 30.0f; 
GLfloat tmpKameraPhi = 0.0f; 
GLfloat tmpKameraTheta = 0.0f; 
/* II.7 ---*/


/* II.5 Procedura okna */
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam,LPARAM lParam);
/* II.5 ---*/


/* II.7 Kopie funkcji z klasy GLForm*/
bool GL_UstalFormatPikseli(HDC uchwytDC);
void GL_UstawienieSceny();
void __fastcall GL_RysujScene();
void __fastcall RysujScene();


bool GL_UstalFormatPikseli(HDC uchwytDC)
{
   PIXELFORMATDESCRIPTOR opisFormatuPikseli;
   ZeroMemory(&opisFormatuPikseli,sizeof(opisFormatuPikseli));
   opisFormatuPikseli.nVersion=1;
   opisFormatuPikseli.dwFlags=PFD_SUPPORT_OPENGL | PFD_DRAW_TO_WINDOW |
   PFD_DOUBLEBUFFER; //w oknie, podwojne buforowanie
   opisFormatuPikseli.iPixelType=PFD_TYPE_RGBA; //typ koloru RGB
   opisFormatuPikseli.cColorBits=32; //jakosc kolorw 4 bajty
   opisFormatuPikseli.cDepthBits=16; //glebokosc bufora Z (z-buffer)
   opisFormatuPikseli.iLayerType=PFD_MAIN_PLANE;

   int formatPikseli=ChoosePixelFormat(uchwytDC,&opisFormatuPikseli);
   if (formatPikseli==0) return false;
   if (SetPixelFormat(uchwytDC,formatPikseli,&opisFormatuPikseli) != true) 
	   return false;

   return true;
}


void GL_UstawienieSceny()
{
   glViewport(0,0,ClientWidth,ClientHeight); //okno OpenGL = wnetrze formy (domyslnie)

   //ustawienie punktu projekcji
   glMatrixMode(GL_PROJECTION); //przeczenie na macierz projekcji
   glLoadIdentity();
   //left,right,bottom,top,znear,zfar (clipping)
   float wsp=ClientHeight/(float)ClientWidth;
   glFrustum(-0.1, 0.1, wsp*-0.1, wsp*0.1, 0.3, 25.0);
   //mnozenie macierzy rzutowania przez macierz perspektywy - ustalanie frustum
   glMatrixMode(GL_MODELVIEW); //powrt do macierzy widoku modelu
   glEnable(GL_DEPTH_TEST); //z-buffer aktywny = ukrywanie niewidocznych powierzchni
   //GL_Oswietlenie();
}


void __fastcall GL_RysujScene()
{
	//Przygotowanie bufora
	glClearColor(0.0f, 0.0f, 0.0f, 0.0);

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT); //czysci bufory
	glLoadIdentity(); //macierz model-widok = macierz jednostkowa
	//glTranslatef(0.0, 0.0, -10.0); //odsuniecie calosci o 10
	gluLookAt(0,0,10, 0,0,0, 0,1,0);
	glTranslatef(kameraX+tmpKameraX,kameraY+tmpKameraY,0);
	//przeksztalcenia macierzy model-widok i rysowanie figur
	glRotatef(kameraPhi+tmpKameraPhi,0,1,0);
	glRotatef(kameraTheta+tmpKameraTheta,1,0,0);
	RysujScene();

	//Z bufora na ekran
	glFlush();
	SwapBuffers(uchwytDC);
}


void __fastcall RysujScene()
{
	
   GLfloat a = 2.0f;
   a /= 2;
   glColor3f(0.1f, 0.4f, 0.5f);   
   glBegin(GL_QUADS);
   //przednia
   glNormal3f(0,0,1);
   //glNormal3f(-1,-1,1);
   glVertex3f(-a,-a,a);
   //glNormal3f(1,-1,1);
   glVertex3f(a,-a,a);
   //glNormal3f(1,1,1);
   glVertex3f(a,a,a);
   //glNormal3f(-1,1,1);
   glVertex3f(-a,a,a);

   //tylnia
   glNormal3f(0,0,-1);
   glVertex3f(-a,-a,-a);
   glVertex3f(a,-a,-a);
   glVertex3f(a,a,-a);
   glVertex3f(-a,a,-a);

   //lewa
   glNormal3f(-1,0,0);
   glVertex3f(-a,-a,-a);
   glVertex3f(-a,a,-a);
   glVertex3f(-a,a,a);
   glVertex3f(-a,-a,a);

   //prawa
   glNormal3f(1,0,0);
   glVertex3f(a,-a,-a);
   glVertex3f(a,a,-a);
   glVertex3f(a,a,a);
   glVertex3f(a,-a,a);

   //dolna
   glNormal3f(0,-1,0);
   glVertex3f(-a,-a,-a);
   glVertex3f(a,-a,-a);
   glVertex3f(a,-a,a);
   glVertex3f(-a,-a,a);

   //gorna
   glNormal3f(0,1,0);
   glVertex3f(-a,a,-a);
   glVertex3f(a,a,-a);
   glVertex3f(a,a,a);
   glVertex3f(-a,a,a);
   glEnd();
}
/* II.7 ---*/


/* II.5 Procedura okna */
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
/* II.5 ---*/
{
	/* III.1 Kontrola kamery za pomoc myszy */
	static int x0 = 0;
	static int y0 = 0;
	/* III.1 */

	switch (message)
	{
	case WM_CREATE: //Utworzenie okna
		uchwytDC = GetDC(hWnd);
		GL_UstalFormatPikseli(uchwytDC);
		//Utworzenie kontekstu renderowania i uczynienie go aktywnym
		hRC = wglCreateContext(uchwytDC);
		wglMakeCurrent(uchwytDC, hRC);
		GL_UstawienieSceny();
		
		/* III.2 Animacja */
		SetTimer(hWnd, 25, 1, NULL);
		/* III.2 ---*/

		break;

	case WM_DESTROY: //Usuwanie okna, czyszczenie
		//Usunicie kontekstu renderowania
		wglMakeCurrent(uchwytDC,NULL);
		wglDeleteContext(hRC);

		/* III.2 Animacja */
		KillTimer(hWnd, 1);
		/* III.2 ---*/

		//Wysanie komunikatu zamknicia aplikacji WM_QUIT
		PostQuitMessage(0);		
		break;
	
	case WM_SIZE: //Zmiana rozmiaru okna
		RECT rect;
		GetClientRect(hWnd, &rect);
		ClientHeight = rect.bottom - rect.top;
		ClientWidth = rect.right - rect.left;
		GL_UstawienieSceny();
		break;
	
	case WM_PAINT: //Okno wymaga odrysowania
		GL_RysujScene();
		ValidateRect(hWnd,NULL);
		break;

	/* III.1 Kontrola kamery za pomoc myszy */
	case WM_RBUTTONDOWN:
	case WM_LBUTTONDOWN:
		x0 = LOWORD(lParam);
		y0 = HIWORD(lParam);
		break;

	case WM_MOUSEMOVE:
		{
			//tmpKameraX = tmpKameraY = 0;
			int x = LOWORD(lParam);
			int y = HIWORD(lParam);
			int dx = x - x0;
			int dy = y - y0;
			
			if (wParam == MK_RBUTTON)
			{
				const GLfloat czulosc = 50.0f;
				kameraX += (GLfloat)dx / czulosc;
				kameraY -= (GLfloat)dy / czulosc;
			}

			if (wParam == MK_LBUTTON)
			{
				const GLfloat czulosc = 5.0f;
				kameraPhi += (GLfloat)dx / czulosc;
				kameraTheta += (GLfloat)dy / czulosc;
			}
			x0 = x;
			y0 = y;
			GL_RysujScene();
		}
		break;
	/* III.1 */

	/* III.2 Animacja */
	case WM_TIMER:
		kameraPhi += 0.5f;
		GL_RysujScene();
		break;
	/* III.2 ---*/


	default: //przetworzenie automatyczne pozostaych komunikatw
		return (DefWindowProc(hWnd, message, wParam, lParam));
	}

	return (0L);
}


/* II.3 Gwna funkcja programu */
int APIENTRY WinMain(HINSTANCE hInstance, //identyfikator danej instancji aplikacji
					 HINSTANCE hPrevInstance, //nie uywane w aplikacjach Win32
					 LPSTR lpCmdLine, //wskanik na list parametrw
					 int nCmdShow) //warto okrelajca czy aplikacja ma zosta uruchomiona zminimalizowana, zmaksymilizowana itp.
/* II.3 ---*/
{
	/* II.4.1 Deklaracja zmiennych */
	WNDCLASS wc;
	MSG msg;
	HWND hWnd;
	/* II.4.1 ---*/

	/* II.4.2 Utworzenie klasy okna */
	wc.style		= CS_HREDRAW | CS_VREDRAW | CS_OWNDC; //styl okna
	wc.lpfnWndProc	= (WNDPROC)WndProc; //procedura okna
	wc.cbClsExtra	= 0; //dodatkowe bajty zarezerwowane za klas okna
	wc.cbWndExtra	= 0; //dodatkowe bajty zarezerwowane za instancj okna
	wc.hInstance	= hInstance; //instancja aplikacji
	wc.hIcon		= NULL; //uchwyt ikony
	wc.hCursor		= LoadCursor(NULL, IDC_ARROW); //uchwyt kursora
	wc.hbrBackground= NULL; //uchwyt pdzla ta
	wc.lpszMenuName	= NULL; //nazwa menu
	wc.lpszClassName= lpszAppName; //nazwa klasy okna
	
	//Rejestracja klasy okna
	if (RegisterClass(&wc) == 0)
		return FALSE;
	/* II.4.2 ---*/

	/* II.4.3 Utworzewnie okna */
	hWnd = CreateWindow(lpszAppName, //nazwa klasy oknalpsz
						lpszAppName, //nazwa okna
						WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN | WS_CLIPSIBLINGS, //styl okna
						100, 100, //pooenie okna (x,y)
						250, 250, //rozmiar okna (szeroko, wysoko)
						NULL, //uchwyt okna nadrzdnego (parent)
						NULL, //uchwyt menu
						hInstance, //uchwyt instancji aplikacji
						NULL); //parametr tworzenia okna
	
	if(hWnd == NULL)return FALSE;
	/* II.4.3 ---*/

	/* II.4.4 Uaktywnienie i aktualizacja okna */
	ShowWindow(hWnd,SW_SHOW);
	UpdateWindow(hWnd);
	/* II.4.4 ---*/

	/* II.4.5 Procedura okna*/
	while(GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	/* II.4.5 ---*/

	/* II.4.6 Zwrcenie wartoci do systemu po zakoczeniu programu */
	return msg.wParam;
	/* II.4.6 ---*/
}