/* II.1 Dodanie plikw nagwkowych */
#include <windows.h>
#include <gl\gl.h>
#include <gl\glu.h>
/* II.1 ---*/

/* II.2 Stae i zmienne globalne */
HGLRC hRC = NULL; //uchwyt kontekstu renderingu
HDC uchwytDC = NULL; //uchwyt prywatnego kontekstu urzdzenia GDI
GLint ClientWidth; //szeroko obszaru roboczego okna
GLint ClientHeight; //wysoko obszaru roboczego okna
static LPCTSTR lpszAppName = "GLLustro"; //nazwa okna i klasy okna
/* II.2 ---*/

/* II.7 Zmienne globalne kamery */
GLfloat kameraX = -0.2f; 
GLfloat kameraY = 0.0f; 
GLfloat tmpKameraX = 0.0f; 
GLfloat tmpKameraY = 0.0f; 
GLfloat kameraPhi = 30.0f; 
GLfloat kameraTheta = 30.0f; 
GLfloat tmpKameraPhi = 0.0f; 
GLfloat tmpKameraTheta = 0.0f; 
/* II.7 ---*/

/* L.3 */
GLfloat x_pos = 0.0f;
GLfloat y_pos = 0.9f;
/* L.3 ---*/


/* II.5 Procedura okna */
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam,LPARAM lParam);
/* II.5 ---*/


/* II.7 Kopie funkcji z klasy GLForm*/
bool GL_UstalFormatPikseli(HDC uchwytDC);
void GL_UstawienieSceny();
void __fastcall GL_RysujScene();
void __fastcall RysujScene();

/* L.1 */
void __fastcall RysujLustro();
void __fastcall RysujScene2();
void __fastcall RysujSzybe();
/* L.1 */

bool GL_UstalFormatPikseli(HDC uchwytDC)
{
   PIXELFORMATDESCRIPTOR opisFormatuPikseli;
   ZeroMemory(&opisFormatuPikseli,sizeof(opisFormatuPikseli));
   opisFormatuPikseli.nVersion=1;
   opisFormatuPikseli.dwFlags=PFD_SUPPORT_OPENGL | PFD_DRAW_TO_WINDOW |
   PFD_DOUBLEBUFFER; //w oknie, podwojne buforowanie
   opisFormatuPikseli.iPixelType=PFD_TYPE_RGBA; //typ koloru RGB
   opisFormatuPikseli.cColorBits=32; //jakosc kolorw 4 bajty
   opisFormatuPikseli.cDepthBits=16; //glebokosc bufora Z (z-buffer)
   opisFormatuPikseli.iLayerType=PFD_MAIN_PLANE;
   /* L.4 */
   opisFormatuPikseli.cStencilBits = 1;
   /* L.4 ---*/
   glEnable(GL_STENCIL_TEST);
   /*kod rysujcy*/
   glDisable(GL_STENCIL_TEST);
   int formatPikseli=ChoosePixelFormat(uchwytDC,&opisFormatuPikseli);
   if (formatPikseli==0) return false;
   if (SetPixelFormat(uchwytDC,formatPikseli,&opisFormatuPikseli) != true) 
	   return false;

   return true;
}


void GL_UstawienieSceny()
{
   glViewport(0,0,ClientWidth,ClientHeight); //okno OpenGL = wnetrze formy (domyslnie)

   //ustawienie punktu projekcji
   glMatrixMode(GL_PROJECTION); //przeczenie na macierz projekcji
   glLoadIdentity();
   //left,right,bottom,top,znear,zfar (clipping)
   float wsp=ClientHeight/(float)ClientWidth;
   glFrustum(-0.1, 0.1, wsp*-0.1, wsp*0.1, 0.3, 50.0);
   //mnozenie macierzy rzutowania przez macierz perspektywy - ustalanie frustum
   glMatrixMode(GL_MODELVIEW); //powrt do macierzy widoku modelu
   glEnable(GL_DEPTH_TEST); //z-buffer aktywny = ukrywanie niewidocznych powierzchni
   //GL_Oswietlenie();

   /* Ustawienie wiata */
   /* L.0 */
   const float natezenie_swiatla_otoczenia = 0.5f;
   const float kolor_otoczenie[]={natezenie_swiatla_otoczenia,
									natezenie_swiatla_otoczenia,
									natezenie_swiatla_otoczenia};
   glEnable(GL_LIGHTING); //wlaczenie systemu oswietlania

   glEnable(GL_COLOR_MATERIAL);

   glColorMaterial(GL_FRONT_AND_BACK,GL_AMBIENT_AND_DIFFUSE);

   glLightModelfv(GL_LIGHT_MODEL_AMBIENT,kolor_otoczenie); //swiatlo tla

   const float kolor1_rozproszone[]={0.5,0.5,0.5,1.0};
   glLightfv(GL_LIGHT0,GL_DIFFUSE,kolor1_rozproszone);
   glEnable(GL_LIGHT0);

   const float pozycja[4]={5.0,10.0,10.0,1.0};
   glLightfv(GL_LIGHT0,GL_POSITION,pozycja);   
   /* L.0 */

   /* L.5 */
   glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
   /* L.5 */
}


void __fastcall GL_RysujScene()
{
	//Przygotowanie bufora
	glClearColor(0.0f, 0.0f, 0.0f, 0.0);

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT); //czysci bufory
	glLoadIdentity(); //macierz model-widok = macierz jednostkowa
	//glTranslatef(0.0, 0.0, -10.0); //odsuniecie calosci o 10
	gluLookAt(0,0,10, 0,0,0, 0,1,0);
	glTranslatef(kameraX+tmpKameraX,kameraY+tmpKameraY,0);
	//przeksztalcenia macierzy model-widok i rysowanie figur
	glRotatef(kameraPhi+tmpKameraPhi,0,1,0);
	glRotatef(kameraTheta+tmpKameraTheta,1,0,0);
	
	RysujScene();

	//Z bufora na ekran
	glFlush();
	SwapBuffers(uchwytDC);
}


void __fastcall RysujScene()
{
	/* L.6 */
	RysujLustro();
	/* L.6 */
}
/* II.7 ---*/

/* L.2 */
void __fastcall RysujSzybe()
{
    const float przezroczystosc = 0.3f;
    const int il_rzedow_kolumn = 8;
    const GLfloat a=0.5f;

    glPushMatrix();
		glTranslatef(-a*il_rzedow_kolumn/2.0f, 0.0f, -a*il_rzedow_kolumn/2.0f);
		glNormal3f(0.0f, 0.0f, 1.0f);
		for(int i = 0; i < il_rzedow_kolumn; i++)
			for(int j = 0; j < il_rzedow_kolumn; j++)
			{
				glBegin(GL_QUADS); 
					if((i+j)%2)
						glColor4f(1.0f, 0.0f, 0.0f, przezroczystosc);  //czerwony
					else
						glColor4f(1.0f, 1.0f, 0.0f, przezroczystosc);  //zolty

					glVertex3f(i*a, 0.0f, (j+1)*a);
					glVertex3f((i+1)*a, 0.0f, (j+1)*a);
					glVertex3f((i+1)*a, 0.0f, j*a);
					glVertex3f(i*a, 0.0f, j*a);
				glEnd();
			}
    glPopMatrix();
}


void __fastcall RysujScene2()
{
    glColor3f(0.5,0.5,0.8);
    const float a=0.5f;


	//ponowne pozycjonowanie wiatla!
	const float pozycja[4]={5.0,10.0,10.0,1.0};
	glLightfv(GL_LIGHT0,GL_POSITION,pozycja);

//*****
    glPushMatrix();
    glTranslatef(x_pos, y_pos, 0.0f);
    glRotatef(90.0f, 0.0f, 1.0f, 1.0f);
//*****
    glBegin(GL_QUADS);
    //tylna
    glNormal3f(0,0,-1);
    glTexCoord2f(1.0,1.0);
    glVertex3f(-a,-a,-a);
    glTexCoord2f(1.0,0.0);
    glVertex3f(-a,a,-a);
    glTexCoord2f(0.0,0.0);
    glVertex3f(a,a,-a);
    glTexCoord2f(0.0,1.0);
    glVertex3f(a,-a,-a);

    //przednia
    glNormal3f(0,0,1);
    glTexCoord2f(1.0,1.0);
    glVertex3f(-a,-a,a);
    glTexCoord2f(0.0,1.0);
    glVertex3f(a,-a,a);
    glTexCoord2f(0.0,0.0);
    glVertex3f(a,a,a);
    glTexCoord2f(1.0,0.0);
    glVertex3f(-a,a,a);

    //lewa
    glNormal3f(-1,0,0);
    glTexCoord2f(1.0,1.0);
    glVertex3f(-a,-a,a);
    glTexCoord2f(1.0,0.0);
    glVertex3f(-a,a,a);
    glTexCoord2f(0.0,0.0);
    glVertex3f(-a,a,-a);
    glTexCoord2f(0.0,1.0);
    glVertex3f(-a,-a,-a);

    //prawa
    glNormal3f(1,0,0);
    glTexCoord2f(1.0,1.0);
    glVertex3f(a,-a,a);
    glTexCoord2f(0.0,1.0);
    glVertex3f(a,-a,-a);
    glTexCoord2f(0.0,0.0);
    glVertex3f(a,a,-a);
    glTexCoord2f(1.0,0.0);
    glVertex3f(a,a,a);

    //gorna
    glNormal3f(0,1,0);
    glTexCoord2f(1.0,1.0);
    glVertex3f(-a,a,a);
    glTexCoord2f(1.0,0.0);
    glVertex3f(a,a,a);
    glTexCoord2f(0.0,0.0);
    glVertex3f(a,a,-a);
    glTexCoord2f(0.0,1.0);
    glVertex3f(-a,a,-a);

    //dolna
    glNormal3f(0,-1,0);
    glTexCoord2f(1.0,1.0);
    glVertex3f(-a,-a,a);
    glTexCoord2f(0.0,1.0);
    glVertex3f(-a,-a,-a);
    glTexCoord2f(0.0,0.0);
    glVertex3f(a,-a,-a);
    glTexCoord2f(1.0,0.0);
    glVertex3f(a,-a,a);    
   
    glEnd();

//*****
    glPopMatrix();
}


void __fastcall RysujLustro()
{
	const GLdouble rownanie[] = {0.0f, -1.0f, 0.0f, 0.0f};

	glClear(GL_STENCIL_BUFFER_BIT); //czyszczenie buforu szablonu

	//rysowanie szablonu lustra
	glColorMask(GL_FALSE, GL_FALSE, GL_FALSE, GL_FALSE); //wylaczenie rysowania w buforze koloru
	glDisable(GL_DEPTH_TEST); //wylaczenie testu glebokosci

	glEnable(GL_STENCIL_TEST); //wlaczenie testu szablonu
	glStencilFunc(GL_ALWAYS, 1, 1);
	glStencilOp(GL_KEEP, GL_KEEP, GL_REPLACE);
	
	//podloga - ksztalt
	glEnable(GL_CULL_FACE);
	//glCullFace(GL_BACK);
	RysujSzybe();
	glDisable(GL_CULL_FACE);

	//rysowanie odbicia w obrebie szablonu
	glEnable(GL_DEPTH_TEST);
	glColorMask(GL_TRUE, GL_TRUE, GL_TRUE, GL_TRUE);

	glStencilFunc(GL_EQUAL, 1, 1);
	glStencilOp(GL_KEEP, GL_KEEP, GL_KEEP);

	glEnable(GL_CLIP_PLANE0);
	glClipPlane(GL_CLIP_PLANE0, rownanie);
	glPushMatrix();
	glScalef(1.0f, -1.0f, 1.0f); //odbicie lustrzane osi Y
	RysujScene2();
	glPopMatrix();

	//wylaczenie powierzchni obcinajcej i bufora szablonu
	glDisable(GL_CLIP_PLANE0);
	glDisable(GL_STENCIL_TEST);

	//rysowanie rzeczywistej sceny
	RysujScene2();

	//rywanie podlogi
	glEnable(GL_BLEND);
	RysujSzybe();
	glDisable(GL_BLEND);
}
/* L.2 ---*/



/* II.5 Procedura okna */
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
/* II.5 ---*/
{
	/* III.1 Kontrola kamery za pomoc myszy */
	static int x0 = 0;
	static int y0 = 0;
	/* III.1 */

	switch (message)
	{
	case WM_CREATE: //Utworzenie okna
		uchwytDC = GetDC(hWnd);
		GL_UstalFormatPikseli(uchwytDC);
		//Utworzenie kontekstu renderowania i uczynienie go aktywnym
		hRC = wglCreateContext(uchwytDC);
		wglMakeCurrent(uchwytDC, hRC);
		GL_UstawienieSceny();
		
		/* III.2 Animacja */
		SetTimer(hWnd, 1, 25, NULL);
		/* III.2 ---*/

		break;

	case WM_DESTROY: //Usuwanie okna, czyszczenie
		//Usunicie kontekstu renderowania
		wglMakeCurrent(uchwytDC,NULL);
		wglDeleteContext(hRC);

		/* III.2 Animacja */
		KillTimer(hWnd, 1);
		/* III.2 ---*/

		//Wysanie komunikatu zamknicia aplikacji WM_QUIT
		PostQuitMessage(0);		
		break;
	
	case WM_SIZE: //Zmiana rozmiaru okna
		RECT rect;
		GetClientRect(hWnd, &rect);
		ClientHeight = rect.bottom - rect.top;
		ClientWidth = rect.right - rect.left;
		GL_UstawienieSceny();
		break;
	
	case WM_PAINT: //Okno wymaga odrysowania
		GL_RysujScene();
		ValidateRect(hWnd,NULL);
		break;

	/* III.1 Kontrola kamery za pomoc myszy */
	case WM_RBUTTONDOWN:
	case WM_LBUTTONDOWN:
		x0 = LOWORD(lParam);
		y0 = HIWORD(lParam);
		break;

	case WM_MOUSEMOVE:
		{
			if(!(wParam == MK_RBUTTON || wParam == MK_LBUTTON))
				break; //zapobiega odswiezaniu podczas zwyklego poruszania myszka

			int x = LOWORD(lParam);
			int y = HIWORD(lParam);
			int dx = x - x0;
			int dy = y - y0;
			
			if (wParam == MK_RBUTTON)
			{
				const GLfloat czulosc = 50.0f;
				kameraX += (GLfloat)dx / czulosc;
				kameraY -= (GLfloat)dy / czulosc;
			}

			if (wParam == MK_LBUTTON)
			{
				const GLfloat czulosc = 5.0f;
				kameraPhi += (GLfloat)dx / czulosc;
				kameraTheta += (GLfloat)dy / czulosc;
			}
			x0 = x;
			y0 = y;
			GL_RysujScene();
		}
		break;
	/* III.1 ---*/
	case WM_KEYDOWN:
		switch(wParam)
		{
		case VK_UP: 
			y_pos += 0.1f;
			break;
		case VK_DOWN:
			y_pos -= 0.1f;
			break;
		case VK_LEFT:
			x_pos -= 0.1f;
			break;
		case VK_RIGHT:
			x_pos += 0.1f;
			break;
		}
		break;

	/* III.2 Animacja */
	case WM_TIMER:
		kameraPhi += 0.5f;
		GL_RysujScene();
		break;
	/* III.2 ---*/

	default: //przetworzenie automatyczne pozostaych komunikatw
		return (DefWindowProc(hWnd, message, wParam, lParam));
	}

	return (0L);
}


/* II.3 Gwna funkcja programu */
int APIENTRY WinMain(HINSTANCE hInstance, //identyfikator danej instancji aplikacji
					 HINSTANCE hPrevInstance, //nie uywane w aplikacjach Win32
					 LPSTR lpCmdLine, //wskanik na list parametrw
					 int nCmdShow) //warto okrelajca czy aplikacja ma zosta uruchomiona zminimalizowana, zmaksymilizowana itp.
/* II.3 ---*/
{
	/* II.4.1 Deklaracja zmiennych */
	WNDCLASS wc;
	MSG msg;
	HWND hWnd;
	/* II.4.1 ---*/

	/* II.4.2 Utworzenie klasy okna */
	wc.style		= CS_HREDRAW | CS_VREDRAW | CS_OWNDC; //styl okna
	wc.lpfnWndProc	= (WNDPROC)WndProc; //procedura okna
	wc.cbClsExtra	= 0; //dodatkowe bajty zarezerwowane za klas okna
	wc.cbWndExtra	= 0; //dodatkowe bajty zarezerwowane za instancj okna
	wc.hInstance	= hInstance; //instancja aplikacji
	wc.hIcon		= NULL; //uchwyt ikony
	wc.hCursor		= LoadCursor(NULL, IDC_ARROW); //uchwyt kursora
	wc.hbrBackground= NULL; //uchwyt pdzla ta
	wc.lpszMenuName	= NULL; //nazwa menu
	wc.lpszClassName= lpszAppName; //nazwa klasy okna
	
	//Rejestracja klasy okna
	if (RegisterClass(&wc) == 0)
		return FALSE;
	/* II.4.2 ---*/

	/* II.4.3 Utworzewnie okna */
	hWnd = CreateWindow(lpszAppName, //nazwa klasy oknalpsz
						lpszAppName, //nazwa okna
						WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN | WS_CLIPSIBLINGS, //styl okna
						100, 100, //pooenie okna (x,y)
						800, 600, //rozmiar okna (szeroko, wysoko)
						NULL, //uchwyt okna nadrzdnego (parent)
						NULL, //uchwyt menu
						hInstance, //uchwyt instancji aplikacji
						NULL); //parametr tworzenia okna
	
	if(hWnd == NULL)return FALSE;
	/* II.4.3 ---*/

	/* II.4.4 Uaktywnienie i aktualizacja okna */
	ShowWindow(hWnd,SW_SHOW);
	UpdateWindow(hWnd);
	/* II.4.4 ---*/

	/* II.4.5 Procedura okna*/
	while(GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	/* II.4.5 ---*/

	/* II.4.6 Zwrcenie wartoci do systemu po zakoczeniu programu */
	return msg.wParam;
	/* II.4.6 ---*/
}