//---------------------------------------------------------------------------


#pragma hdrstop

#include "Teksturowanie.h"

#include <jpeg.hpp>
#include <Dialogs.hpp> //ShowMessage

//---------------------------------------------------------------------------

#pragma package(smart_init)

unsigned long* __fastcall WczytajTeksture(AnsiString nazwaPliku,int& TeksturaSzer,int& TeksturaWys)
{
	Graphics::TBitmap* obrazBMP=new Graphics::TBitmap();
	obrazBMP->PixelFormat=pf32bit;

	//Uwzgledniam czytanie z JPEG
	AnsiString rozszerzenie=ExtractFileExt(nazwaPliku);
	if (rozszerzenie==".jpg" || rozszerzenie==".jpe" || rozszerzenie==".jpeg")
	{
		//JPEG
		TJPEGImage* obrazJPEGtmp=new TJPEGImage();
		try
		{
			obrazJPEGtmp->LoadFromFile(nazwaPliku);
			obrazBMP->Width=obrazJPEGtmp->Width;
			obrazBMP->Height=obrazJPEGtmp->Height;
			obrazBMP->Canvas->Draw(0,0,obrazJPEGtmp);
		}
		catch(...)
		{
			ShowMessage("Brak pliku tekstury "+nazwaPliku);
			delete obrazJPEGtmp;
			delete obrazBMP;
			return NULL;
		}
		delete obrazJPEGtmp;
	}
	else
	{
		//BMP
		Graphics::TBitmap* obrazBMPtmp=new Graphics::TBitmap();
		try
		{
			//dodaje to kopiowanie obrazow, aby uniezaleznic sie od typu bitmapy
			obrazBMPtmp->LoadFromFile(nazwaPliku);
			obrazBMP->Width=obrazBMPtmp->Width;
			obrazBMP->Height=obrazBMPtmp->Height;
			obrazBMP->Canvas->Draw(0,0,obrazBMPtmp);
		}
		catch(...)
		{
			ShowMessage("Brak pliku tekstury "+nazwaPliku);
			delete obrazBMPtmp;
			delete obrazBMP;
			return NULL;
		}
		delete obrazBMPtmp;
	}

	//kopiowanie do dynamicznej tablicy RGBA
	TeksturaSzer=obrazBMP->Width;
	TeksturaWys=obrazBMP->Height;
	unsigned long* Tekstura=new unsigned long[TeksturaSzer*TeksturaWys];
	for(int ih=0;ih<TeksturaWys;ih++)
	{
		unsigned long* linia=(unsigned long*)obrazBMP->ScanLine[ih];
		for(int iw=0;iw<TeksturaSzer;iw++)
		{
			unsigned long c=*linia & 0x00FFFFFF;
			Tekstura[iw+(ih*TeksturaSzer)]=(((c & 0xFF) << 16)+(c >> 16)+ (c & 0xFF00)) | 0xFF000000; //podzial na 4 kanaly: RGBA
			linia++;
		}
	}
	delete obrazBMP;
	return Tekstura;
}
