//---------------------------------------------------------------------------


#pragma hdrstop

#include "GLNapisy.h"

//---------------------------------------------------------------------------

#pragma package(smart_init)


GLuint StworzCzcionkeBitmapowa(HWND Handle,AnsiString NazwaCzcionki,bool Pogrubiona,bool Kursywa)
{
	HFONT	font;		//uchwyt do czcionki
	HFONT	tmp_font;	//pomocniczy

	GLuint podstawa = glGenLists(256);	//Tworzy liste na pelen zestaw czcionek

	//funkcja WinAPI (GDI); tworzy obiekt czcionki
	tmp_font = CreateFont(30, //wysokosc czcionki
						  0,	        		//uzywam szerokosci czcionki proporcjonalnej do wysokosci
						  0,			        //nachylenie czcionek
						  0,		        	//kat
						  Pogrubiona?FW_BOLD:FALSE, //pogrubionie
						  Kursywa?TRUE:FALSE,   //kursywa
						  FALSE,		        //podkreslenie
						  FALSE,                //przekreslenie
						  ANSI_CHARSET,   		//zbior liter ANSI
						  OUT_TT_PRECIS,		//czcionki true type
						  CLIP_DEFAULT_PRECIS,  //domyslna precyzja przycinania rozmiaru
						  ANTIALIASED_QUALITY,	//antyaliasing przy tworzeniu obrazow
						  FF_DONTCARE|DEFAULT_PITCH,  //styl i dekoracja czcionki
						  NazwaCzcionki.c_str());	  //nazwa czcionki

	HDC uchwytDC=GetDC(Handle); //ten uchwyt jest w klasie TGLForm, ale prywatny
	font=(HFONT)SelectObject(uchwytDC,tmp_font);       //zwiazanie z naszym kontekstem okna
	//Funkcja specyficzna dla Windows; 32-spacja; ilosc: 96 - alfabet lacinski, 256 - gdy tez polskie znaki
	wglUseFontBitmaps(uchwytDC,0,256,podstawa);       //buduje pelen zestaw 256 czcionek bitmapowych
   SelectObject(uchwytDC,font);   //Wybor czcionki, ktora stworzylismy
   DeleteObject(tmp_font);        //Usuwanie pomocniczego

	return podstawa;
}

GLuint StworzCzcionke3D(HWND Handle,AnsiString NazwaCzcionki,bool Pogrubiona,bool Kursywa)
{
   HFONT font;      //uchwyt do czcionki
   HFONT tmp_font;  //pomocniczy

   GLuint podstawa = glGenLists(256);   //Tworzy liste na pelen zestaw czcionek

   //funkcja WinAPI (GDI); tworzy obiekt czcionki
   tmp_font = CreateFont(30, //wysokosc czcionki
                         0,  //uzywam szerokosci czcionki proporcjonalnej do wysokosci
                         0,  //nachylenie czcionek
                         0,  //kat
                         Pogrubiona?FW_BOLD:FALSE, //pogrubionie
                         Kursywa?TRUE:FALSE,       //kursywa
                         FALSE,                //podkreslenie
                         FALSE,                //przekreslenie
                         ANSI_CHARSET,         //zbior liter ANSI
                         OUT_TT_PRECIS,        //czcionki true type
                         CLIP_DEFAULT_PRECIS,  //domyslna precyzja przycinania rozmiaru
                         ANTIALIASED_QUALITY,  //antyaliasing przy tworzeniu obrazow
                         FF_DONTCARE|DEFAULT_PITCH,  //styl i dekoracja czcionki
                         NazwaCzcionki.c_str());     //nazwa czcionki

	HDC uchwytDC=GetDC(Handle); //ten uchwyt jest w klasie TGLForm, ale prywatny
	font=(HFONT)SelectObject(uchwytDC,tmp_font);   //zwiazanie z naszym kontekstem okna
	//Funkcja specyficzna dla Windows; 32-spacja; ilosc: 96 - alfabet lacinski, 256 - gdy tez polskie znaki
	//wglUseFontBitmaps(uchwytDC,0,256,podstawa);       //buduje pelen zestaw 256 czcionek
	GLYPHMETRICSFLOAT gmf[256]; //informacje o rozmiarach czcionek (tutaj nie wykorzystywane)
	wglUseFontOutlines(uchwytDC,0,256,podstawa,  //buduje pelen zestaw 256 czcionek 3D
					   0.0f, //precyzja budowania czcionki
					   0.2f, //glebokosc czcionki
					   WGL_FONT_POLYGONS,
					   gmf); //informacje o rozmiarach czcionek
   SelectObject(uchwytDC,font);   //Wybor czcionki, ktora stworzylismy
   DeleteObject(tmp_font);        //Usuwanie pomocniczego

	return podstawa;
}


GLvoid Pisz(AnsiString napis,GLuint czcionka)
{
	if (napis.IsEmpty()) return;

   glPushAttrib(GL_LIST_BIT);   //Odklada na stos atrybuty wyswietlania
   glListBase(czcionka - 0);    //Ustawia podstawe znakow na 32
   glCallLists(napis.Length(), GL_UNSIGNED_BYTE, napis.c_str()); //Wyswietla liste liter (napis)
   glPopAttrib();               //Przywraca ze stosu atrybuty wyswietlania
}
