using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

namespace LightCycles
{
    public static class Rozszerzenia
    {
        public static Point ToPoint(this Vector2 vector2)
        {
            return new Point((int)vector2.X, (int)vector2.Y);
        }

        public static Vector2 PrzyciagnijDoOsi(this Vector2 v)
        {
            if (v == Vector2.Zero) return Vector2.Zero;

            if (Math.Abs(v.X) > Math.Abs(v.Y))
            {
                v.X = (float)Math.Round(v.X);
                v.Y = 0;
            }
            else
            {
                v.X = 0;
                v.Y = (float)Math.Round(v.Y);
            }
            return v;
        }
    }

    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        BasicEffect efekt;

        bool czyGracz2Aktywny = false;

        static readonly int kolejkaPunktowPoczatkowaPojemnosc = 300;
        int kolejkaPunktowPojemnosc1 = kolejkaPunktowPoczatkowaPojemnosc;
        int kolejkaPunktowPojemnosc2 = kolejkaPunktowPoczatkowaPojemnosc;
        static readonly int przyrostPoTrafieniu = 100;
        //logika
        Queue<Vector2> kolejkaPunktow1 = new Queue<Vector2>(kolejkaPunktowPoczatkowaPojemnosc);
        Queue<Vector2> kolejkaPunktow2 = new Queue<Vector2>(kolejkaPunktowPoczatkowaPojemnosc);
        //wyswietlanie
        Queue<VertexPositionColor> kolejkaWerteksow1 = new Queue<VertexPositionColor>(kolejkaPunktowPoczatkowaPojemnosc);
        Queue<VertexPositionColor> kolejkaWerteksow2 = new Queue<VertexPositionColor>(kolejkaPunktowPoczatkowaPojemnosc);

        Vector2 biezacaPozycja1;
        Vector2 kierunek1;
        Vector2 biezacaPozycja2;
        Vector2 kierunek2;

        Random random = new Random();
        Rectangle? kwadrat = null;
        const int rozmiarKwadratu = 5;
        VertexPositionColor[] tablicaWerteksowKwadratu = null;

        int punkty1 = 0;
        int punkty2 = 0;

        SoundEffect ding;

        SpriteFont czcionka, malaCzcionka;
        bool czyTrwaRozgrywka = false;
        string napis1 = "Light Cycles";
        string napis2 = "Aby ropocz gr nacinij 1 lub 2";
        Color kolorNapisu = Color.Olive;
        Texture2D obraz;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            Window.Title = "Light Cycles 1.00";

            //pelny ekran
            graphics.PreferredBackBufferWidth = 640;
            graphics.PreferredBackBufferHeight = 480;
            //graphics.PreferredBackBufferWidth = graphics.GraphicsDevice.DisplayMode.Width;
            //graphics.PreferredBackBufferHeight = graphics.GraphicsDevice.DisplayMode.Height;
            //graphics.IsFullScreen = true; //tylko w Windows  
            graphics.ApplyChanges();            

            efekt = new BasicEffect(graphics.GraphicsDevice);
            efekt.Projection =
               Matrix.CreateOrthographic(2 * graphics.GraphicsDevice.Viewport.AspectRatio, 2, 0, 100);
            efekt.VertexColorEnabled = true;
            
            Reset();

            base.Initialize();
        }

        private void Reset()
        {
            kierunek1 = -Vector2.UnitX;
            kierunek2 = Vector2.UnitX;
            biezacaPozycja1 = new Vector2(Window.ClientBounds.Width / 2, Window.ClientBounds.Height / 2) - Vector2.UnitX;
            biezacaPozycja2 = new Vector2(Window.ClientBounds.Width - biezacaPozycja1.X - 1, biezacaPozycja1.Y);

            for (int i = 0; kolejkaPunktow1.Count>0; i++) kolejkaPunktow1.Dequeue();
            for (int i = 0; kolejkaWerteksow1.Count>0; i++) kolejkaWerteksow1.Dequeue();
            for (int i = 0; kolejkaPunktow2.Count>0; i++) kolejkaPunktow2.Dequeue();
            for (int i = 0; kolejkaWerteksow2.Count>0; i++) kolejkaWerteksow2.Dequeue();

            kolejkaPunktowPojemnosc1 = kolejkaPunktowPoczatkowaPojemnosc;
            kolejkaPunktowPojemnosc2 = kolejkaPunktowPoczatkowaPojemnosc;

            Update(null);
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            ding = Content.Load<SoundEffect>("ding");
            czcionka = Content.Load<SpriteFont>("Czcionka");
            obraz = Content.Load<Texture2D>("tron");
            malaCzcionka = Content.Load<SpriteFont>("MalaCzcionka");            
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            ding.Dispose();
            obraz.Dispose();
        }

        private Vector3 Unproject(Vector3 vector2D)
        {
            return graphics.GraphicsDevice.Viewport.Unproject(vector2D, efekt.Projection, efekt.View, efekt.World);
        }

        private Vector3 Unproject(Vector2 vector2D)
        {
            return Unproject(new Vector3(vector2D, 0));
        }

        private void WydluzLiniePoTrafieniu(Queue<Vector2> kolejkaPunktow, Queue<VertexPositionColor> kolejkaWerteksow, int nowyRozmiar)
        {
            Vector2[] tablicaPunktow = kolejkaPunktow.ToArray();
            VertexPositionColor[] tablicaWerteksow = kolejkaWerteksow.ToArray();
            int rozmiar=tablicaWerteksow.Count();
            int rozmiarNowejCzesci=nowyRozmiar-rozmiar;

            for (int i = 0; kolejkaPunktow.Count > 0; i++) kolejkaPunktow.Dequeue();
            for (int i = 0; kolejkaWerteksow.Count > 0; i++) kolejkaWerteksow.Dequeue();

            for (int i = 0; i < rozmiarNowejCzesci; i++)
            {
                kolejkaPunktow.Enqueue(tablicaPunktow[0]);
                kolejkaWerteksow.Enqueue(tablicaWerteksow[0]);
            }

            for (int i = 0; i < rozmiar; i++)
            {
                kolejkaPunktow.Enqueue(tablicaPunktow[i]);
                kolejkaWerteksow.Enqueue(tablicaWerteksow[i]);
            }
        }

        bool WyznaczKierunekNaPodstawieStanuGamepada(PlayerIndex indeksGracza,ref Vector2 kierunek)
        {
            GamePadState stanGamepada = GamePad.GetState(indeksGracza);
            if (!stanGamepada.IsConnected) return false;

            //klawisze XYAB, DirectionalPad
            if ((stanGamepada.IsButtonDown(Buttons.X) || stanGamepada.IsButtonDown(Buttons.DPadLeft)) && kierunek != Vector2.UnitX) kierunek = -Vector2.UnitX;
            if ((stanGamepada.IsButtonDown(Buttons.B) || stanGamepada.IsButtonDown(Buttons.DPadRight)) && kierunek != -Vector2.UnitX) kierunek = Vector2.UnitX;
            if ((stanGamepada.IsButtonDown(Buttons.Y) || stanGamepada.IsButtonDown(Buttons.DPadUp)) && kierunek != Vector2.UnitY) kierunek = -Vector2.UnitY;
            if ((stanGamepada.IsButtonDown(Buttons.A) || stanGamepada.IsButtonDown(Buttons.DPadDown)) && kierunek != -Vector2.UnitY) kierunek = Vector2.UnitY;
            
            //thumbsticks
            Vector2 nowyKierunek = (stanGamepada.ThumbSticks.Left + stanGamepada.ThumbSticks.Right).PrzyciagnijDoOsi();
            if (nowyKierunek != Vector2.Zero)
            {                
                nowyKierunek.Normalize();
                nowyKierunek.Y = -nowyKierunek.Y;
                if (nowyKierunek != -kierunek) kierunek = nowyKierunek;
            }

            return true;
        }

        KeyboardState poprzedniStanKlawiatury = Keyboard.GetState();
        GamePadState poprzedniStanGamepada = GamePad.GetState(PlayerIndex.One);

        bool wibracjeAktywne = true;
        TimeSpan momentWlaczeniaWibracji = TimeSpan.Zero;
        int czasTrwaniaWibracjiWMilisekundach = 0;

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            //wylaczanie wibracji
            if (gameTime != null)
            {
                if (gameTime.TotalGameTime.TotalMilliseconds > (momentWlaczeniaWibracji.TotalMilliseconds + czasTrwaniaWibracjiWMilisekundach))
                {
                    GamePad.SetVibration(PlayerIndex.One, 0, 0);
                }
            }

            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            KeyboardState stanKlawiatury = Keyboard.GetState();
            
            if (stanKlawiatury.IsKeyDown(Keys.Escape)) this.Exit();
            if (stanKlawiatury.IsKeyDown(Keys.Space) || (stanKlawiatury.IsKeyDown(Keys.LeftAlt) && stanKlawiatury.IsKeyDown(Keys.Enter))) graphics.ToggleFullScreen();

            if ((stanKlawiatury.IsKeyDown(Keys.P) && poprzedniStanKlawiatury.IsKeyUp(Keys.P)) || (stanKlawiatury.IsKeyDown(Keys.Pause) && poprzedniStanKlawiatury.IsKeyUp(Keys.Pause)))
            {                
                if (czyTrwaRozgrywka)
                {
                    napis1 = "Pauza";
                    napis2 = "Aby kontynuowa nacinij P lub Pause";
                    kolorNapisu = Color.Olive;
                }
                else
                {
                    napis2 = "Aby ropocz gr nacinij 1 lub 2";
                }                
                czyTrwaRozgrywka = !czyTrwaRozgrywka;
            }
           
            //obsluga strony tytulowej
            if (!czyTrwaRozgrywka)
            {
                GamePadState stanGamepada = GamePad.GetState(PlayerIndex.One);

                if ((stanKlawiatury.IsKeyDown(Keys.D1) && poprzedniStanKlawiatury.IsKeyUp(Keys.D1)) ||
                    (stanGamepada.IsButtonDown(Buttons.LeftShoulder) && poprzedniStanGamepada.IsButtonUp(Buttons.LeftShoulder)))
                {
                    czyGracz2Aktywny = false;
                    czyTrwaRozgrywka = true;
                    punkty1 = 0;
                    punkty2 = 0;
                    Reset();
                }
                if ((stanKlawiatury.IsKeyDown(Keys.D2) && poprzedniStanKlawiatury.IsKeyUp(Keys.D2)) ||
                    (stanGamepada.IsButtonDown(Buttons.Start) && poprzedniStanGamepada.IsButtonUp(Buttons.Start)) ||
                    (stanGamepada.IsButtonDown(Buttons.RightShoulder) && poprzedniStanGamepada.IsButtonUp(Buttons.RightShoulder)))
                {
                    czyGracz2Aktywny = true;
                    czyTrwaRozgrywka = true;
                    punkty1 = 0;
                    punkty2 = 0;                    
                    Reset();
                }

                poprzedniStanGamepada = stanGamepada;
                poprzedniStanKlawiatury = stanKlawiatury;
                return;
            }

            //Dalsze - tylko sterowanie gr

            //ustalanie kierunku z klawiatury
            //gracz 1            
            if (stanKlawiatury.IsKeyDown(Keys.Left) && poprzedniStanKlawiatury.IsKeyUp(Keys.Left) && kierunek1 != Vector2.UnitX) kierunek1 = -Vector2.UnitX;
            if (stanKlawiatury.IsKeyDown(Keys.Right) && poprzedniStanKlawiatury.IsKeyUp(Keys.Right) && kierunek1 != -Vector2.UnitX) kierunek1 = Vector2.UnitX;
            if (stanKlawiatury.IsKeyDown(Keys.Up) && poprzedniStanKlawiatury.IsKeyUp(Keys.Up) && kierunek1 != Vector2.UnitY) kierunek1 = -Vector2.UnitY;
            if (stanKlawiatury.IsKeyDown(Keys.Down) && poprzedniStanKlawiatury.IsKeyUp(Keys.Down) && kierunek1 != -Vector2.UnitY) kierunek1 = Vector2.UnitY;            
            //gracz 2
            if (stanKlawiatury.IsKeyDown(Keys.A) && poprzedniStanKlawiatury.IsKeyUp(Keys.A) && kierunek2 != Vector2.UnitX) kierunek2 = -Vector2.UnitX;
            if (stanKlawiatury.IsKeyDown(Keys.D) && poprzedniStanKlawiatury.IsKeyUp(Keys.D) && kierunek2 != -Vector2.UnitX) kierunek2 = Vector2.UnitX;
            if (stanKlawiatury.IsKeyDown(Keys.W) && poprzedniStanKlawiatury.IsKeyUp(Keys.W) && kierunek2 != Vector2.UnitY) kierunek2 = -Vector2.UnitY;
            if (stanKlawiatury.IsKeyDown(Keys.S) && poprzedniStanKlawiatury.IsKeyUp(Keys.S) && kierunek2 != -Vector2.UnitY) kierunek2 = Vector2.UnitY;
            poprzedniStanKlawiatury = stanKlawiatury;

            //ustalanie kierunku za pomoca gamepadow
            WyznaczKierunekNaPodstawieStanuGamepada(PlayerIndex.One, ref kierunek1);
            WyznaczKierunekNaPodstawieStanuGamepada(PlayerIndex.Two, ref kierunek2);

            //zmiana w 2D (piksele)
            biezacaPozycja1 += kierunek1;
            biezacaPozycja2 += kierunek2;            

            //obsluga kolejek
            while (kolejkaPunktow1.Count >= kolejkaPunktowPojemnosc1)
            {
                kolejkaPunktow1.Dequeue();
                kolejkaWerteksow1.Dequeue();
            }
            while (kolejkaPunktow1.Count < kolejkaPunktowPojemnosc1)
            {
                kolejkaPunktow1.Enqueue(biezacaPozycja1);
                kolejkaWerteksow1.Enqueue(new VertexPositionColor(Unproject(biezacaPozycja1),Color.CornflowerBlue));
            }

            if (czyGracz2Aktywny)
            {
                while (kolejkaPunktow2.Count >= kolejkaPunktowPojemnosc2)
                {
                    kolejkaPunktow2.Dequeue();
                    kolejkaWerteksow2.Dequeue();
                }
                while (kolejkaPunktow2.Count < kolejkaPunktowPojemnosc2)
                {
                    kolejkaPunktow2.Enqueue(biezacaPozycja2);
                    kolejkaWerteksow2.Enqueue(new VertexPositionColor(Unproject(biezacaPozycja2), Color.Lime));
                }
            }

            //nowy kwadrat
            if ((kwadrat == null) && (random.NextDouble() < 0.01))
            {
                ding.Play();
                //logika
                Point pozycjaKwadratu = new Point(rozmiarKwadratu + random.Next(Window.ClientBounds.Width - 2 * rozmiarKwadratu - 1), rozmiarKwadratu + random.Next(Window.ClientBounds.Height - 2 * rozmiarKwadratu - 1));
                kwadrat = new Rectangle(pozycjaKwadratu.X - rozmiarKwadratu, pozycjaKwadratu.Y - rozmiarKwadratu, 2 * rozmiarKwadratu, 2 * rozmiarKwadratu);
                //wyswietlanie
                tablicaWerteksowKwadratu = new VertexPositionColor[4];
                tablicaWerteksowKwadratu[0] = new VertexPositionColor(Unproject(new Vector3(kwadrat.Value.Left, kwadrat.Value.Bottom, 0)), Color.Red);
                tablicaWerteksowKwadratu[1] = new VertexPositionColor(Unproject(new Vector3(kwadrat.Value.Left, kwadrat.Value.Top, 0)), Color.Red);
                tablicaWerteksowKwadratu[2] = new VertexPositionColor(Unproject(new Vector3(kwadrat.Value.Right, kwadrat.Value.Bottom, 0)), Color.Red);
                tablicaWerteksowKwadratu[3] = new VertexPositionColor(Unproject(new Vector3(kwadrat.Value.Right, kwadrat.Value.Top, 0)), Color.Red);                
            }

            //detekcja kolizji linii
            //zalozenie - zmiany co jeden piksel          
            int kolizja1 = 0;
            int kolizja2 = 0;

            /*            
            //Metoda Queue.ElementAt jest bardzo czasozerna
            for(int i=0;i<kolejkaPunktow1.Count-1;i++) //bez ostatniego
            {
                if (biezacaPozycja1 == kolejkaPunktow1.ElementAt(i)) kolizja1++;
                if (biezacaPozycja2 == kolejkaPunktow1.ElementAt(i)) kolizja1++;
            }
            for (int i = 0; i < kolejkaPunktow2.Count - 1; i++) //bez ostatniego
            {
                if (biezacaPozycja2 == kolejkaPunktow2.ElementAt(i)) kolizja2++;
                if (biezacaPozycja1 == kolejkaPunktow2.ElementAt(i)) kolizja2++;
            }
            */
            Vector2[] tablicaPunktow1 = kolejkaPunktow1.ToArray();
            Vector2[] tablicaPunktow2 = kolejkaPunktow2.ToArray();
            for (int i = 0; i < tablicaPunktow1.Count() - 1; i++) //bez ostatniego
            {
                if (biezacaPozycja1 == tablicaPunktow1[i]) kolizja1++;
                if (biezacaPozycja2 == tablicaPunktow1[i]) kolizja2++;
            }
            for (int i = 0; i < tablicaPunktow2.Count() - 1; i++) //bez ostatniego
            {
                if (biezacaPozycja1 == tablicaPunktow2[i]) kolizja1++;
                if (biezacaPozycja2 == tablicaPunktow2[i]) kolizja2++;
            }            
            if (biezacaPozycja1 == biezacaPozycja2)
            {
                kolizja1++;
                kolizja2++;
            }
            if (biezacaPozycja1.X < 0 || biezacaPozycja1.X >= Window.ClientBounds.Width ||
                biezacaPozycja1.Y < 0 || biezacaPozycja1.Y >= Window.ClientBounds.Height)
               kolizja1++;
            if (biezacaPozycja2.X < 0 || biezacaPozycja2.X >= Window.ClientBounds.Width ||
                biezacaPozycja2.Y < 0 || biezacaPozycja2.Y >= Window.ClientBounds.Height)
               kolizja2++;

            //w chwili poczatkowej i po trafieniu czesc punktow znajduje si w tym samym miejscu
            if (kolizja1 > 2) kolizja1 = 0;
            if (kolizja2 > 2) kolizja2 = 0;

            if (!czyGracz2Aktywny) kolizja2 = 0;
            if (kolizja1 > 0 || kolizja2 > 0)
            {
                //wibracje
                if (wibracjeAktywne)
                {
                    momentWlaczeniaWibracji = gameTime.TotalGameTime;
                    czasTrwaniaWibracjiWMilisekundach = 500;
                    GamePad.SetVibration(PlayerIndex.One, 0, 0.5f);
                }

                ding.Play();
                if (kolizja1 != kolizja2)
                {
                    if (kolizja1 > 0) punkty2++;
                    if (kolizja2 > 0) punkty1++;
                }
                Reset();
            }            
              
            //trafienie kwadratu
            if(kwadrat!=null)
            {
                if (kwadrat.Value.Contains(biezacaPozycja1.ToPoint()))
                {
                    if (wibracjeAktywne)
                    {
                        momentWlaczeniaWibracji = gameTime.TotalGameTime;
                        czasTrwaniaWibracjiWMilisekundach = 1000;
                        GamePad.SetVibration(PlayerIndex.One, 0, 1);
                    }

                    ding.Play();
                    kwadrat = null;
                    kolejkaPunktowPojemnosc1 += przyrostPoTrafieniu;
                    WydluzLiniePoTrafieniu(kolejkaPunktow1, kolejkaWerteksow1, kolejkaPunktowPojemnosc1);
                    punkty1++;                    
                }
                else
                if (czyGracz2Aktywny)
                    if (kwadrat.Value.Contains(biezacaPozycja2.ToPoint()))
                    {
                        ding.Play();
                        kwadrat = null;
                        kolejkaPunktowPojemnosc2 += przyrostPoTrafieniu;
                        WydluzLiniePoTrafieniu(kolejkaPunktow2, kolejkaWerteksow2, kolejkaPunktowPojemnosc2);
                        punkty2++;                        
                    }
            }

            //Warunki zakonczenia gry
            if (punkty1 >= 10)
            {
                if (czyGracz2Aktywny) napis1 = "Wygra gracz pierwszy!";
                else napis1 = "Wygrae!";
                napis2 = "Aby ropocz gr nacinij 1 lub 2";
                czyTrwaRozgrywka = false;
                kolorNapisu = Color.Blue;
            }
            if (punkty2 >= 10)
            {
                if (czyGracz2Aktywny) napis1 = "Wygra gracz drugi!";
                else napis1 = "Przegrae!";
                napis2 = "Aby ropocz gr nacinij 1 lub 2";
                czyTrwaRozgrywka = false;
                kolorNapisu = Color.Green;
            }
              
            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {            
            GraphicsDevice gd = graphics.GraphicsDevice;
            gd.Clear(Color.Black);
            //graphics.GraphicsDevice.RasterizerState = RasterizerState.CullNone;

            //wyswietlanie strony tytulowej
            if(!czyTrwaRozgrywka)
            {                                
                spriteBatch.Begin();
                Vector2 srodekEkranu = new Vector2(Window.ClientBounds.Width / 2.0f, Window.ClientBounds.Height / 2.0f);
                float przesuniecieY = 0.3f * srodekEkranu.Y;
                //obraz
                float proporcjeObrazu = obraz.Width / obraz.Height;
                int wysokoscObrazu = (int)(srodekEkranu.Y);
                int szerokoscObrazu = (int)(wysokoscObrazu * proporcjeObrazu);
                spriteBatch.Draw(obraz, new Rectangle((int)(srodekEkranu.X-szerokoscObrazu/2), wysokoscObrazu/10, szerokoscObrazu, wysokoscObrazu), Color.White);
                //napis1                
                Vector2 polozenieNapisu1 = srodekEkranu - czcionka.MeasureString(napis1) / 2 + Vector2.UnitY * przesuniecieY;
                for (int i = 0; i < 10; i++)
                {
                    spriteBatch.DrawString(czcionka, napis1, polozenieNapisu1 + new Vector2(0.2f*i, 0.1f*i), kolorNapisu);
                }
                spriteBatch.DrawString(czcionka, napis1, polozenieNapisu1, Color.White);
                //napis2
                Vector2 polozenieNapisu2 = srodekEkranu - czcionka.MeasureString(napis2) / 2 + (przesuniecieY + czcionka.MeasureString("A").Y) * Vector2.UnitY;
                for (int i = 0; i < 10; i++)
                {
                    spriteBatch.DrawString(czcionka, napis2, polozenieNapisu2 + new Vector2(0.2f*i, 0.1f*i), Color.Gray);
                }
                spriteBatch.DrawString(czcionka, napis2, polozenieNapisu2, Color.White);
                //(c)
                string prawaAutorskie = "(c) Jacek Matulewski 2008";
                spriteBatch.DrawString(malaCzcionka, prawaAutorskie, new Vector2(srodekEkranu.X - malaCzcionka.MeasureString(prawaAutorskie).X / 2, 2 * (srodekEkranu.Y - malaCzcionka.MeasureString(prawaAutorskie).Y)), Color.DarkGray);
                spriteBatch.End();
                return;
            }

            //Przebieg gry

            //linie i kwadrat
            foreach (EffectPass pass in efekt.CurrentTechnique.Passes)
            {
                pass.Apply();

                //linie
                gd.DrawUserPrimitives<VertexPositionColor>(PrimitiveType.LineStrip, kolejkaWerteksow1.ToArray(), 0, kolejkaWerteksow1.Count() - 1);
                if (czyGracz2Aktywny) gd.DrawUserPrimitives<VertexPositionColor>(PrimitiveType.LineStrip, kolejkaWerteksow2.ToArray(), 0, kolejkaWerteksow2.Count() - 1);

                //kwadrat
                if (kwadrat.HasValue) gd.DrawUserPrimitives<VertexPositionColor>(PrimitiveType.TriangleStrip, tablicaWerteksowKwadratu, 0, 2);
            }

            //wyswietlanie punktow
            spriteBatch.Begin();
            Vector2 polozeniePunktacji1 = new Vector2(10, Window.ClientBounds.Height - czcionka.MeasureString("A").Y);
            Vector2 polozeniePunktacji2 = new Vector2(Window.ClientBounds.Width - 1.3f * czcionka.MeasureString("A").X, Window.ClientBounds.Height - czcionka.MeasureString("A").Y);
            spriteBatch.DrawString(czcionka, punkty1.ToString(), polozeniePunktacji1, Color.CornflowerBlue);
            spriteBatch.DrawString(czcionka, punkty2.ToString(), polozeniePunktacji2, Color.Lime);
            spriteBatch.End();

            base.Draw(gameTime);
        }
    }
}
