﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace MojaPierwszaGraMonoGame
{
    class SferaZBuforemIndeksów
    {
        private GraphicsDevice gd;
        private VertexBuffer buforWerteksów = null;
        private IndexBuffer buforIndeksów = null;

        private float promień;
        private int liczbaSekcjiNaRównoleżnikach, liczbaSekcjiNaPołudnikach;
        //private int TwórzTablicęIndeksów(GLuint*& indeksy);

        public SferaZBuforemIndeksów(
            GraphicsDevice gd,
            float promień,
            int liczbaSekcjiNaRównoleżnikach,
            int liczbaSekcjiNaPołudnikach,
            Color kolor)
        {
            this.gd = gd;
            this.promień = promień;
            this.liczbaSekcjiNaRównoleżnikach = liczbaSekcjiNaRównoleżnikach;
            this.liczbaSekcjiNaPołudnikach = liczbaSekcjiNaPołudnikach;

            //tablica werteksów
            int całkowitaLiczbaWerteksów = (liczbaSekcjiNaRównoleżnikach + 1) * (liczbaSekcjiNaPołudnikach + 1);
            List<VertexPositionColor> listaWerteksów = new List<VertexPositionColor>(całkowitaLiczbaWerteksów);

            double przyrostKątaTheta = Math.PI / liczbaSekcjiNaPołudnikach;
            double przyrostKątaPhi = 2 * Math.PI / liczbaSekcjiNaRównoleżnikach;

            for (int i = 0; i <= liczbaSekcjiNaPołudnikach; i++)
            {
                double kątTheta = i * przyrostKątaTheta;
                float _wysokość = (float)(promień * Math.Cos(kątTheta));
                float _promień = (float)(promień * Math.Sin(kątTheta));

                for (int j = 0; j <= liczbaSekcjiNaRównoleżnikach; j++)
                {
                    double kątPhi = j * przyrostKątaPhi;
                    int indeks = j + i * (liczbaSekcjiNaRównoleżnikach + 1);

                    Vector3 położenie = new Vector3(_promień * (float)Math.Cos(kątPhi), -_promień * (float)Math.Sin(kątPhi), _wysokość);

                    listaWerteksów.Add(new VertexPositionColor(położenie, kolor));
                }
            }
            ZbudujBuforWerteksów(listaWerteksów.ToArray());

            //tablica indeksów
            int liczbaIndeksówWPaśmie = 2 * (liczbaSekcjiNaRównoleżnikach + 1);
            int całkowitaLiczbaIndeksów = liczbaIndeksówWPaśmie * liczbaSekcjiNaPołudnikach;
            List<int> listaIndeksów = new List<int>(całkowitaLiczbaIndeksów);

            for (int i = 0; i < całkowitaLiczbaIndeksów / 2; i++)
            {
                listaIndeksów.Add(i);
                listaIndeksów.Add(listaIndeksów[2 * i] + (liczbaSekcjiNaRównoleżnikach + 1));
            }
            ZbudujBuforIndeksów(listaIndeksów.ToArray());
        }

        private void ZbudujBuforWerteksów(VertexPositionColor[] tablicaWerteksów)
        {
            buforWerteksów = new VertexBuffer(gd, VertexPositionColor.VertexDeclaration, tablicaWerteksów.Length, BufferUsage.WriteOnly);
            buforWerteksów.SetData<VertexPositionColor>(tablicaWerteksów);
        }

        private void ZbudujBuforIndeksów(int[] tablicaIndeksów)
        {
            buforIndeksów = new IndexBuffer(gd, IndexElementSize.ThirtyTwoBits, tablicaIndeksów.Length, BufferUsage.WriteOnly);
            buforIndeksów.SetData<int>(tablicaIndeksów);
        }

        public void Rysuj(Effect efekt)
        {
            int liczbaWerteksówWPaśmie = (liczbaSekcjiNaRównoleżnikach + 1) * 2;

            foreach (EffectPass przebieg in efekt.CurrentTechnique.Passes)
            {
                przebieg.Apply();
                gd.Indices = buforIndeksów;
                gd.SetVertexBuffer(buforWerteksów);
                for (int i = 0; i < liczbaSekcjiNaPołudnikach; i++)
                {
                    gd.DrawIndexedPrimitives(PrimitiveType.TriangleStrip, 0, 0, liczbaWerteksówWPaśmie, i * liczbaWerteksówWPaśmie, liczbaSekcjiNaRównoleżnikach * 2);
                }
            }
        }
    }
}
