﻿#region Using Statements
using System;
using System.Collections.Generic;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Storage;
using Microsoft.Xna.Framework.GamerServices;
#endregion

namespace MojaDrugaGraMonoGame
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Game
    {
        GraphicsDeviceManager graphics;

        BasicEffect efekt;

        Prostopadloscian sześcian, podłoże, cieńSześcianu;
        const float d = 2 - 0.1f;
        static Matrix macierzRzutowaniaNaPodłoże = CreateShadowMatrix(new Vector3(3, 5, 3), new Plane(Vector3.Up, d - 0.00001f));

        public Game1()
            : base()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";

            GraphicsDevice.GraphicsProfile = GraphicsProfile.Reach;
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            efekt = new BasicEffect(graphics.GraphicsDevice);
            efekt.VertexColorEnabled = true;
            efekt.Projection = Matrix.CreatePerspective(
                2.0f * graphics.GraphicsDevice.Viewport.AspectRatio,
                2.0f,
                1.0f,
                10.0f);
            efekt.View = Matrix.CreateLookAt(
                new Vector3(0, 0, 2.5f),
                new Vector3(0, 0, 0),
                new Vector3(0, 1, 0)
                );
            efekt.World = Matrix.Identity;

            efekt.EnableDefaultLighting();
            efekt.AmbientLightColor = Color.DarkGray.ToVector3();
            efekt.DiffuseColor = Color.White.ToVector3();
            efekt.SpecularColor = Color.White.ToVector3();
            efekt.DirectionalLight0.DiffuseColor = Color.White.ToVector3();
            efekt.DirectionalLight1.DiffuseColor = Color.Black.ToVector3();
            efekt.DirectionalLight2.DiffuseColor = Color.Black.ToVector3();
            efekt.DirectionalLight0.SpecularColor = Color.White.ToVector3();
            efekt.DirectionalLight1.SpecularColor = Color.Black.ToVector3();
            efekt.DirectionalLight2.SpecularColor = Color.Black.ToVector3();

            //aktor
            sześcian = new Prostopadloscian(this, efekt, 1.5f, 1.5f, 1.5f, Color.SandyBrown);
            sześcian.World = Matrix.CreateScale(0.75f);
            this.Components.Add(sześcian);

            //podłoże
            podłoże = new Prostopadloscian(this, efekt, 10f, 0.1f, 10f, Color.Green);
            podłoże.World = Matrix.CreateScale(0.75f) * Matrix.CreateTranslation(0, -2, 0);
            this.Components.Add(podłoże);

            //cień
            BasicEffect efektCienia = (BasicEffect)efekt.Clone();
            efektCienia.AmbientLightColor = Color.Black.ToVector3();
            efektCienia.DiffuseColor = Color.White.ToVector3();
            efektCienia.SpecularColor = Color.Black.ToVector3();
            cieńSześcianu = new Prostopadloscian(this, efektCienia, 1.5f, 1.5f, 1.5f, Color.DarkGreen);
            //cieńSześcianu.World = Matrix.CreateScale(0.75f) * macierzRzutowaniaNaPodłoże;            
            this.Components.Add(cieńSześcianu);

            base.Initialize();
        }

        static Matrix CreateShadowMatrix(Vector3 lightDirection, Plane plane)
        {
            Vector4 N = new Vector4(plane.Normal, plane.D);
            Vector4 L = new Vector4(lightDirection, 1);
            float alfa = Vector4.Dot(N, L);
            Matrix m = new Matrix();            
            m.M11 = alfa - N.X * L.X;
            m.M22 = alfa - N.Y * L.Y;
            m.M33 = alfa - N.Z * L.Z;
            m.M44 = alfa - N.W * L.W;
            m.M21 = -N.Y * L.X;
            m.M31 = -N.Z * L.X;
            m.M41 = -N.W * L.X;
            m.M12 = -N.X * L.Y;
            m.M32 = -N.Z * L.Y;
            m.M42 = -N.W * L.Y;
            m.M13 = -N.X * L.Z;
            m.M23 = -N.Y * L.Z;
            m.M43 = -N.W * L.Z;
            m.M14 = -N.X * L.W;
            m.M24 = -N.Y * L.W;
            m.M34 = -N.Z * L.W;
            return m;
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            Texture2D tekstura = Content.Load<Texture2D>("Tekstura_768x512");
            if (tekstura != null)
            {
                sześcian.Texture = tekstura;
                sześcian.TextureEnabled = true;
            }
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed || Keyboard.GetState().IsKeyDown(Keys.Escape))
                Exit();

            float wsp = 10f;
            if (Keyboard.GetState().IsKeyDown(Keys.LeftShift) || Keyboard.GetState().IsKeyDown(Keys.RightShift)) wsp = 100f;
            Matrix macierzPrzekształceniaWidoku = Matrix.Identity;
            if (Keyboard.GetState().IsKeyDown(Keys.Left)) macierzPrzekształceniaWidoku *= Matrix.CreateRotationY(MathHelper.PiOver4 / wsp);
            if (Keyboard.GetState().IsKeyDown(Keys.Right)) macierzPrzekształceniaWidoku *= Matrix.CreateRotationY(-MathHelper.PiOver4 / wsp);
            if (Keyboard.GetState().IsKeyDown(Keys.Up)) macierzPrzekształceniaWidoku *= Matrix.CreateRotationX(MathHelper.PiOver4 / wsp);
            if (Keyboard.GetState().IsKeyDown(Keys.Down)) macierzPrzekształceniaWidoku *= Matrix.CreateRotationX(-MathHelper.PiOver4 / wsp);
            efekt.World = macierzPrzekształceniaWidoku * efekt.World;
            sześcian.World = efekt.World;
            cieńSześcianu.World = efekt.World * macierzRzutowaniaNaPodłoże;

            /////ZMIANA W OBRACANIU!!!!!!!!!!!!!!!!!!!!!!!!!!! UŻYC PRZY CIENIACH!!!!!!!!!!!!!!!!!!!

            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.CornflowerBlue);

            // TODO: Add your drawing code here

            base.Draw(gameTime);
        }
    }
}
