﻿#region Using Statements
using System;
using System.Collections.Generic;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Storage;
using Microsoft.Xna.Framework.GamerServices;
#endregion

namespace MojaTrzeciaGraMonoGame
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Game
    {
        GraphicsDeviceManager graphics;
        BasicEffect efekt;
        VertexBuffer buforWerteksów;

        public Game1()
            : base()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            //efekt
            efekt = new BasicEffect(this.GraphicsDevice);
            efekt.Projection = Matrix.CreatePerspectiveFieldOfView(
                MathHelper.PiOver2,
                this.GraphicsDevice.Viewport.AspectRatio,
                1,
                10);
            efekt.View = Matrix.CreateLookAt(
                new Vector3(0, 0, 3),
                Vector3.Zero,
                Vector3.Up);
            efekt.World = Matrix.Identity;
            efekt.VertexColorEnabled = true;

            //konfiguracja wyświetlania
            GraphicsDevice.RasterizerState = RasterizerState.CullNone;

            //aktor
            Color kolor1 = Color.Red;
            Color kolor2 = Color.White;
            float z0 = 0.1f;
            VertexPositionColor[] tablicaWerteksów = new VertexPositionColor[]
            {
                //trójkąt biały
                new VertexPositionColor(new Vector3(1,-1,-z0), kolor1),
                new VertexPositionColor(new Vector3(-1,-1,-z0), kolor1),
                new VertexPositionColor(new Vector3(0,1,-z0), kolor1),
                //trójkąt czerwony
                new VertexPositionColor(new Vector3(1,-1,z0), kolor2),
                new VertexPositionColor(new Vector3(-1,-1,z0), kolor2),
                new VertexPositionColor(new Vector3(0,1,z0), kolor2)
            };
            buforWerteksów = new VertexBuffer(
                GraphicsDevice,
                VertexPositionColor.VertexDeclaration,
                6,
                BufferUsage.WriteOnly);
            buforWerteksów.SetData(tablicaWerteksów);

            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // TODO: use this.Content to load your game content here
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed || Keyboard.GetState().IsKeyDown(Keys.Escape))
                Exit();

            efekt.World *= Matrix.CreateRotationY(gameTime.ElapsedGameTime.Milliseconds / 1000.0f);

            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.Black);

            GraphicsDevice.SetVertexBuffer(buforWerteksów);

            foreach (EffectPass p in efekt.CurrentTechnique.Passes)
            {
                p.Apply();

                GraphicsDevice.DrawPrimitives(
                    PrimitiveType.TriangleList,
                    0,
                    2);
            }

            base.Draw(gameTime);
        }
    }
}
