﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;

namespace MojaDrugaGraMonoGame
{
    class Prostopadloscian : DrawableGameComponent
    {
        GraphicsDevice gd;
        BasicEffect efekt;
        VertexBuffer buforWerteksow;

        public Matrix World
        {
            set
            {
                efekt.World = value;
            }
            get
            {
                return efekt.World;
            }
        }

        public Prostopadloscian(
            Game game, BasicEffect efekt,
            float dx, float dy, float dz,
            Color? kolor)
            : base(game)
        {
            dx /= 2;
            dy /= 2;
            dz /= 2;

            gd = game.GraphicsDevice;
            this.efekt = (BasicEffect)efekt.Clone();            

            Vector3[] punkty = new Vector3[8]
            {
                new Vector3(-dx, -dy, dz),
                new Vector3(dx, -dy, dz),
                new Vector3(dx, dy, dz),
                new Vector3(-dx, dy, dz),
                new Vector3(-dx, -dy, -dz),
                new Vector3(dx, -dy, -dz),
                new Vector3(dx, dy, -dz),
                new Vector3(-dx, dy, -dz)                
            };

            Color kolor1 = kolor ?? Color.Cyan;
            Color kolor2 = kolor ?? Color.Magenta;
            Color kolor3 = kolor ?? Color.Yellow;                        

            VertexPositionNormalColor[] werteksy = new VertexPositionNormalColor[6 * 4]
            {
                //przednia ściana
                new VertexPositionNormalColor(punkty[3], Vector3.UnitZ, kolor1),
                new VertexPositionNormalColor(punkty[2], Vector3.UnitZ, kolor1),
                new VertexPositionNormalColor(punkty[0], Vector3.UnitZ, kolor1),
                new VertexPositionNormalColor(punkty[1], Vector3.UnitZ, kolor1),
                //tylna ściana
                new VertexPositionNormalColor(punkty[7], -Vector3.UnitZ, kolor1),
                new VertexPositionNormalColor(punkty[4], -Vector3.UnitZ, kolor1),
                new VertexPositionNormalColor(punkty[6], -Vector3.UnitZ, kolor1),
                new VertexPositionNormalColor(punkty[5], -Vector3.UnitZ, kolor1),
                
                //górna ściana
                new VertexPositionNormalColor(punkty[3], Vector3.UnitY, kolor2),
                new VertexPositionNormalColor(punkty[7], Vector3.UnitY, kolor2),
                new VertexPositionNormalColor(punkty[2], Vector3.UnitY, kolor2),
                new VertexPositionNormalColor(punkty[6], Vector3.UnitY, kolor2),
                //dolna ściana
                new VertexPositionNormalColor(punkty[0], -Vector3.UnitY, kolor2),
                new VertexPositionNormalColor(punkty[1], -Vector3.UnitY, kolor2),
                new VertexPositionNormalColor(punkty[4], -Vector3.UnitY, kolor2),
                new VertexPositionNormalColor(punkty[5], -Vector3.UnitY, kolor2),
                
                //lewa ściana
                new VertexPositionNormalColor(punkty[3], -Vector3.UnitX, kolor3),
                new VertexPositionNormalColor(punkty[0], -Vector3.UnitX, kolor3),
                new VertexPositionNormalColor(punkty[7], -Vector3.UnitX, kolor3),
                new VertexPositionNormalColor(punkty[4], -Vector3.UnitX, kolor3),
                //prawa ściana
                new VertexPositionNormalColor(punkty[1], Vector3.UnitX, kolor3),
                new VertexPositionNormalColor(punkty[2], Vector3.UnitX, kolor3),
                new VertexPositionNormalColor(punkty[5], Vector3.UnitX, kolor3),
                new VertexPositionNormalColor(punkty[6], Vector3.UnitX, kolor3)
            };

            buforWerteksow = new VertexBuffer(
                gd,
                VertexPositionNormalColor.VertexDeclaration,
                werteksy.Length,
                BufferUsage.WriteOnly);
            buforWerteksow.SetData<VertexPositionNormalColor>(werteksy);
        }

        public bool AnimacjaAktywna = false;
        private KeyboardState poprzedniStanKlawiatury = Keyboard.GetState();

        public override void Update(GameTime gameTime)
        {
            KeyboardState stanKlawiatury = Keyboard.GetState();
            if (stanKlawiatury.IsKeyDown(Keys.F5) &&
                !poprzedniStanKlawiatury.IsKeyDown(Keys.F5))
                AnimacjaAktywna = !AnimacjaAktywna;
            poprzedniStanKlawiatury = stanKlawiatury;

            if (AnimacjaAktywna)
            {
                efekt.World *=
                    Matrix.CreateRotationX(gameTime.ElapsedGameTime.Milliseconds / 1000.0f) *
                    Matrix.CreateRotationY(gameTime.ElapsedGameTime.Milliseconds / 1000.0f);
            }

            base.Update(gameTime);
        }

        public override void Draw(GameTime gameTime)
        {
            gd.SetVertexBuffer(buforWerteksow);

            foreach (EffectPass pass in efekt.CurrentTechnique.Passes)
            {
                pass.Apply();
                for (int i = 0; i < 6; ++i)
                    gd.DrawPrimitives(PrimitiveType.TriangleStrip, 4 * i, 2);
            }

            base.Draw(gameTime);
        }
    }
}
