﻿#region Using Statements
using System;
using System.Collections.Generic;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Storage;
using Microsoft.Xna.Framework.GamerServices;
#endregion

namespace MojaPierwszaGraMonoGame
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Game
    {
        GraphicsDeviceManager graphics;
        private BasicEffect efekt;
        Kwadryka kwadryka;

        public Game1()
            : base()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";

            this.Window.ClientSizeChanged += new EventHandler<EventArgs>(Window_ClientSizeChanged);
        }

        void Window_ClientSizeChanged(object sender, EventArgs e)
        {
            System.Reflection.FieldInfo field = typeof(OpenTKGameWindow).GetField(
                "updateClientBounds", 
                System.Reflection.BindingFlags.NonPublic | System.Reflection.BindingFlags.Instance);
            if (field != null) field.SetValue(this.Window, false);

            efekt.Projection = Matrix.CreatePerspectiveFieldOfView(MathHelper.PiOver2, graphics.GraphicsDevice.Viewport.AspectRatio, 1, 100);
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {            
            efekt = new BasicEffect(graphics.GraphicsDevice);
            efekt.VertexColorEnabled = true;

            efekt.World = Matrix.Identity;
            //efekt.View = Matrix.CreateTranslation(0, 0, -1);
            efekt.View = Matrix.CreateLookAt(
                new Vector3(0, 0, 1),
                Vector3.Zero,
                Vector3.Up);
            //efekt.Projection = Matrix.CreatePerspective(2*graphics.GraphicsDevice.Viewport.AspectRatio, 2, 1, 100);
            efekt.Projection = Matrix.CreatePerspectiveFieldOfView(MathHelper.PiOver2, graphics.GraphicsDevice.Viewport.AspectRatio, 1, 100);

            GraphicsDevice gd = graphics.GraphicsDevice;

            RasterizerState rs = new RasterizerState();
            //rs.CullMode = CullMode.CullCounterClockwiseFace;
            rs.CullMode = CullMode.None;
            rs.FillMode = FillMode.Solid;
            gd.RasterizerState = rs;
            //gd.RasterizerState = RasterizerState.CullCounterClockwise;

            this.TargetElapsedTime = TimeSpan.FromSeconds(1f/75f);
            this.IsFixedTimeStep = false;
            
            this.Window.Title = "Moja pierwsza gra MonoGame";
            this.Window.AllowUserResizing = true;

            //kwadryka = Kwadryka.StwórzŚciętyStożek(this.GraphicsDevice, 0.1f, 0.3f, 0f, 0.5f, 10, Color.CornflowerBlue);
            //kwadryka = Kwadryka.StwórzWalec(this.GraphicsDevice, 0.2f, 0f, 0.5f, 10, Color.CornflowerBlue);
            //kwadryka = Kwadryka.StwórzStożek(this.GraphicsDevice, 0.3f, 0f, 0.5f, 10, Color.CornflowerBlue);
            //kwadryka = Kwadryka.StwórzDysk(this.GraphicsDevice, 0.1f, 0.3f, 0f, 10, Color.CornflowerBlue);
            //kwadryka = Kwadryka.StwórzKoło(this.GraphicsDevice, 0.3f, 0f, 10, Color.CornflowerBlue);
            //kwadryka = Kwadryka.StwórzSferę(this.GraphicsDevice, 0.45f, 5, 5, Color.CornflowerBlue);            
            kwadryka = Kwadryka.StwórzSferę(this.GraphicsDevice, 0.45f, 10, 10, Color.CornflowerBlue);            

            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // TODO: use this.Content to load your game content here
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {            
            if (!this.IsActive) return;

            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed || Keyboard.GetState().IsKeyDown(Keys.Escape))
                Exit();

            if (Keyboard.GetState().IsKeyDown(Keys.Escape)) this.Exit();

            float wsp = 10f;
            if (Keyboard.GetState().IsKeyDown(Keys.LeftShift) || Keyboard.GetState().IsKeyDown(Keys.RightShift)) wsp = 10f;
            if (Keyboard.GetState().IsKeyDown(Keys.Left)) efekt.World *= Matrix.CreateRotationY(MathHelper.PiOver4 / wsp);
            if (Keyboard.GetState().IsKeyDown(Keys.Right)) efekt.World *= Matrix.CreateRotationY(-MathHelper.PiOver4 / wsp);
            if (Keyboard.GetState().IsKeyDown(Keys.Up)) efekt.World *= Matrix.CreateRotationX(MathHelper.PiOver4 / wsp);
            if (Keyboard.GetState().IsKeyDown(Keys.Down)) efekt.World *= Matrix.CreateRotationX(-MathHelper.PiOver4 / wsp);

            //efekt.World *= Matrix.CreateRotationZ((float)(gameTime.ElapsedGameTime.TotalSeconds / 10));

            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            if (gameTime.IsRunningSlowly) this.Window.Title = "Running slowly!";

            if (!this.IsActive) return;

            GraphicsDevice gd = graphics.GraphicsDevice;
            gd.Clear(Color.Black);
            kwadryka.Rysuj(efekt);

            base.Draw(gameTime);
        }
    }
}
