﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace MojaPierwszaGraMonoGame
{
    enum TypKwadryki { Nieznany, ŚciętyStożek, Walec, Stożek, Dysk, Koło, Sfera };

    class Kwadryka
    {
        private TypKwadryki typKwadryki = TypKwadryki.Nieznany;
        private GraphicsDevice gd;
        private VertexBuffer buforWerteksów = null;

        private int ilośćTrójkątówWPaśmie;
        private int ilośćPasm = 1;

        private Kwadryka()
        {
        }

        #region Metody statyczny
        static private VertexPositionColor[] BudujTablicęWerteksówŚciętegoStożka(
            float promieńDolny, float promieńGórny, float położeniePodstawy, float wysokość, int ilośćSekcji, 
            Color kolor)
        {
            int ilośćWerteksów = 2 * ilośćSekcji;

            VertexPositionColor[] tablicaWerteksów = new VertexPositionColor[ilośćWerteksów];
            float przyrostKąta = MathHelper.TwoPi / (ilośćSekcji - 1.0f);

            for (int i = 0; i < ilośćSekcji; i++)
            {
                float kąt = i * przyrostKąta;
                Vector3 kierunek = new Vector3((float)Math.Cos(kąt), (float)Math.Sin(kąt), 0);
                tablicaWerteksów[2 * i].Position = promieńDolny * kierunek + położeniePodstawy * Vector3.UnitZ;
                tablicaWerteksów[2 * i + 1].Position = promieńGórny * kierunek + (położeniePodstawy + wysokość) * Vector3.UnitZ;
                tablicaWerteksów[2 * i].Color = kolor;
                tablicaWerteksów[2 * i + 1].Color = kolor;
            }

            return tablicaWerteksów;
        }

        static private Kwadryka StwórzKwadrykę( //pseudokonstruktor
            GraphicsDevice gd,
            float promieńDolny, float promieńGórny, float położeniePodstawy, float wysokość, int ilośćSekcji, 
            Color kolor)
        {
            Kwadryka kwadryka = new Kwadryka();
            kwadryka.gd = gd;
            kwadryka.ilośćTrójkątówWPaśmie = 2 * ilośćSekcji;

            VertexPositionColor[] tablicaWerteksów = Kwadryka.BudujTablicęWerteksówŚciętegoStożka(
                promieńDolny, promieńGórny, położeniePodstawy, wysokość, ilośćSekcji, kolor);
            kwadryka.ZbudujBuforWerteksów(tablicaWerteksów);
            return kwadryka;
        }

        static public Kwadryka StwórzŚciętyStożek(
            GraphicsDevice gd,
            float promieńDolny, float promieńGórny, float położeniePodstawy, float wysokość, int ilośćSekcji,
            Color kolor)
        {
            Kwadryka kwadryka = StwórzKwadrykę(gd, promieńDolny, promieńGórny, położeniePodstawy, wysokość, ilośćSekcji, kolor);
            kwadryka.typKwadryki = TypKwadryki.ŚciętyStożek;
            return kwadryka;
        }

        static public Kwadryka StwórzWalec(
            GraphicsDevice gd,
            float promień, float położeniePodstawy, float wysokość, int ilośćSekcji,
            Color kolor)
        {
            Kwadryka kwadryka = Kwadryka.StwórzKwadrykę(gd, promień, promień, położeniePodstawy, wysokość, ilośćSekcji, kolor);
            kwadryka.typKwadryki = TypKwadryki.Walec;
            return kwadryka;
        }

        static public Kwadryka StwórzStożek(
            GraphicsDevice gd,
            float promieńDolny, float położeniePodstawy, float wysokość, int ilośćSekcji,
            Color kolor)
        {
            Kwadryka kwadryka = Kwadryka.StwórzKwadrykę(gd, 0, promieńDolny, położeniePodstawy, wysokość, ilośćSekcji, kolor);
            kwadryka.typKwadryki = TypKwadryki.Stożek;
            return kwadryka;
        }

        static public Kwadryka StwórzDysk(
            GraphicsDevice gd,
            float promieńWewnętrzny, float promieńZewnętrzny, float położeniePodstawy, int ilośćSekcji,
            Color kolor)
        {
            Kwadryka kwadryka = Kwadryka.StwórzKwadrykę(gd, promieńZewnętrzny, promieńWewnętrzny, położeniePodstawy, 0, ilośćSekcji, kolor);
            kwadryka.typKwadryki = TypKwadryki.Dysk;
            return kwadryka;
        }

        static public Kwadryka StwórzKoło(
            GraphicsDevice gd,
            float promień, float położeniePodstawy, int ilośćSekcji,
            Color kolor)
        {
            Kwadryka kwadryka = Kwadryka.StwórzKwadrykę(gd, promień, 0, położeniePodstawy, 0, ilośćSekcji, kolor);
            kwadryka.typKwadryki = TypKwadryki.Koło;
            return kwadryka;
        }

        static public Kwadryka StwórzSferę(
            GraphicsDevice gd,
            float promień, int ilośćSekcjiNaRównoleżnikach, int ilośćSekcjiNaPołudnikach,
            Color kolor)
        {
            Kwadryka kwadryka = new Kwadryka();
            kwadryka.gd = gd;
            kwadryka.typKwadryki = TypKwadryki.Sfera;
            kwadryka.ilośćTrójkątówWPaśmie = 2 * ilośćSekcjiNaRównoleżnikach;
            kwadryka.ilośćPasm = ilośćSekcjiNaPołudnikach;

            List<VertexPositionColor> listaWerteksów = new List<VertexPositionColor>(kwadryka.ilośćPasm * kwadryka.ilośćTrójkątówWPaśmie * 2);

            double przyrostKątaTheta = Math.PI / ilośćSekcjiNaPołudnikach;
            for (int i = 0; i < ilośćSekcjiNaRównoleżnikach; i++)
            {
                double kątThetaGórny = i * przyrostKątaTheta;
                double kątThetaDolny = (i + 1) * przyrostKątaTheta;
                float wysokośćGórna = (float)(promień * Math.Cos(kątThetaGórny));
                float wysokośćDolna = (float)(promień * Math.Cos(kątThetaDolny));
                float promieńGórny = (float)(promień * Math.Sin(kątThetaGórny));
                float promieńDolny = (float)(promień * Math.Sin(kątThetaDolny));

                VertexPositionColor[] werteksyPasma = BudujTablicęWerteksówŚciętegoStożka(
                    promieńDolny, promieńGórny, wysokośćDolna, wysokośćGórna - wysokośćDolna, ilośćSekcjiNaRównoleżnikach, 
                    kolor);

                listaWerteksów.AddRange(werteksyPasma);
            }

            //return listaWerteksów.ToArray(); //tu był błąd z końca zajęć!!!!!!!!
            kwadryka.ZbudujBuforWerteksów(listaWerteksów.ToArray());
            return kwadryka;
        }
        #endregion

        #region Metody
        private void ZbudujBuforWerteksów(VertexPositionColor[] tablicaWerteksów)
        {
            buforWerteksów = new VertexBuffer(gd, VertexPositionColor.VertexDeclaration, tablicaWerteksów.Length, BufferUsage.WriteOnly);
            buforWerteksów.SetData<VertexPositionColor>(tablicaWerteksów);
        }

        public void Rysuj(Effect efekt)
        {
            foreach (EffectPass przebieg in efekt.CurrentTechnique.Passes)
            {
                przebieg.Apply();
                gd.SetVertexBuffer(buforWerteksów);
                for (int i = 0; i < ilośćPasm; i++)
                {
                    gd.DrawPrimitives(PrimitiveType.TriangleStrip, i * ilośćTrójkątówWPaśmie, ilośćTrójkątówWPaśmie - 2);
                }
            }
        }
        #endregion        
    }
}
