﻿#region Using Statements
using System;
using System.Collections.Generic;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Storage;
using Microsoft.Xna.Framework.GamerServices;
#endregion

namespace MojaPierwszaGraMonoGame
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        /*
        private VertexPositionColor[] werteksyTrójkąta =
            new VertexPositionColor[3] {                
                new VertexPositionColor(new Vector3(0.5f,-0.5f,0), Color.Cyan),
                new VertexPositionColor(new Vector3(-0.5f,-0.5f,0), Color.Magenta),                
                new VertexPositionColor(new Vector3(0,0.5f,0), Color.Yellow) };
        */
          
        private BasicEffect efekt;

        VertexBuffer buforWerteksówTrójkąta;

        public Game1()
            : base()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            efekt = new BasicEffect(graphics.GraphicsDevice);
            efekt.VertexColorEnabled = true;

            efekt.World = Matrix.Identity;
            //efekt.View = Matrix.CreateTranslation(0, 0, -1);
            efekt.View = Matrix.CreateLookAt(
                new Vector3(0, 0, 1),
                Vector3.Zero,
                Vector3.Up);
            //efekt.Projection = Matrix.CreatePerspective(2*graphics.GraphicsDevice.Viewport.AspectRatio, 2, 1, 100);
            efekt.Projection = Matrix.CreatePerspectiveFieldOfView(MathHelper.PiOver2, graphics.GraphicsDevice.Viewport.AspectRatio, 1, 100);

            GraphicsDevice gd = graphics.GraphicsDevice;

            RasterizerState rs = new RasterizerState();
            //rs.CullMode = CullMode.CullCounterClockwiseFace;
            rs.CullMode = CullMode.None;
            rs.FillMode = FillMode.Solid;
            gd.RasterizerState = rs;
            //gd.RasterizerState = RasterizerState.CullCounterClockwise;

            VertexPositionColor[] werteksyTrójkąta =
                new VertexPositionColor[3] {                
                    new VertexPositionColor(new Vector3(0.5f,-0.5f,0), Color.Cyan),
                    new VertexPositionColor(new Vector3(-0.5f,-0.5f,0), Color.Magenta),                
                    new VertexPositionColor(new Vector3(0,0.5f,0), Color.Yellow) };

            buforWerteksówTrójkąta = new VertexBuffer(
                gd,
                VertexPositionColor.VertexDeclaration,
                werteksyTrójkąta.Length,
                BufferUsage.WriteOnly);
            buforWerteksówTrójkąta.SetData<VertexPositionColor>(werteksyTrójkąta);

            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            // TODO: use this.Content to load your game content here
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed || Keyboard.GetState().IsKeyDown(Keys.Escape))
                Exit();

            //Matrix macierzPrzekształcenia = Matrix.Identity;
            //macierzPrzekształcenia *= Matrix.CreateScale(0.5f);
            //macierzPrzekształcenia *= Matrix.CreateTranslation(0.5f, 0, 0);
            //macierzPrzekształcenia *= Matrix.CreateRotationZ(-MathHelper.PiOver2);            
            //efekt.World = macierzPrzekształcenia;

            //efekt.World *= Matrix.CreateRotationZ((float)(gameTime.ElapsedGameTime.TotalSeconds/1));
            efekt.World *= Matrix.CreateRotationY((float)(gameTime.ElapsedGameTime.TotalSeconds / 1));

            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            //GraphicsDevice.Clear(Color.CornflowerBlue);

            GraphicsDevice gd = graphics.GraphicsDevice;
            gd.Clear(Color.Black);
            gd.SetVertexBuffer(buforWerteksówTrójkąta);

            foreach (EffectPass pass in efekt.CurrentTechnique.Passes)
            {
                pass.Apply();
                /*
                gd.DrawUserPrimitives<VertexPositionColor>(
                    PrimitiveType.TriangleList,
                    werteksyTrójkąta, 0, 1,
                    VertexPositionColor.VertexDeclaration);
                */
                gd.DrawPrimitives(PrimitiveType.TriangleList, 0, 1);
            }

            base.Draw(gameTime);
        }
    }
}
