import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.media.j3d.Alpha;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Texture;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.Timer;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.universe.SimpleUniverse;

public class BouncingBall extends Applet implements ActionListener, KeyListener {

	private TransformGroup group1;
	private TransformGroup group2;
	private Transform3D trans = new Transform3D();
	private float height=0.0f;
	private float sign = 1.0f; // going up or down
	private Timer timer;
	private float xloc=0.0f;
	private int delay=20;
	
	public BranchGroup createSceneGraph() {
	   // Create the root of the branch graph
	   // tworzymy wezel, do ktorego mozemy dodac kolejne elementy - utworzyc poddrzewo
	   // uzywamy do oznaczenia konkretnego obiektu lub grupy obiektow, ktore tworza pelna calosc
	   BranchGroup root = new BranchGroup();
	
	   //tworzymy wezle, ktory ma przypisana jakas transformacje, czyli wszystkie obiekty przylaczone do tego wezla
	   //moga zostac np. przesuniete lub obrocone w ten sam sposob
	   group1 = new TransformGroup();
	   group1.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
	   root.addChild(group1);
	   group2 = new TransformGroup();
	   group2.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
	   root.addChild(group2);

	   ColorCube cb = new ColorCube(0.3f);
	   group2.addChild(cb);

	   Transform3D transform = new Transform3D();
	   transform.setTranslation(new Vector3f(0.5f,0.0f,0.0f));
	   //przeksztalca wartosci czasowe w wartosci od 0-1
	   Alpha rotationAlpha = new Alpha(-1, 4000);
	   //argumenty: alpha co powyzej, wezel ktorego bedzie dotyczyc rotacja, jaka transformacja ma zajsc, 
	   //minimalny kat obrotu, max kat obrotu (360 stopni)
	   BoundingSphere bounds = new BoundingSphere(new Point3d(0.0,0.0,0.0), 100.0f);
	   RotationInterpolator rotator = new RotationInterpolator(rotationAlpha, group2, transform, 0.0f, (float) Math.PI*2.0f);
	   rotator.setSchedulingBounds(bounds);
	   root.addChild(rotator);
	   
	   TextureLoader loader = new TextureLoader("C:\\lilie.jpg", "TEXTURE", new Container());
	   Texture texture = loader.getTexture();
	   
	   Appearance ap = new Appearance();
	   ap.setTexture(texture);
	   int primflags = Primitive.GENERATE_TEXTURE_COORDS;
	   
	   // Create a simple shape leaf node, add it to the scene graph.
	   Sphere sphere = new Sphere(0.25f, primflags, ap);
	   //Sphere sphere = new Sphere(0.25f);
	   group1.addChild(sphere);
	
	
	   Color3f light1Color = new Color3f(1.0f, 1.0f, 1.0f);
	   Vector3f light1Direction = new Vector3f(-1.0f, -1.0f, -2.0f);
	   DirectionalLight light1 = new DirectionalLight(light1Color, light1Direction);
	   //light1.setInfluencingBounds(bounds);	
	   root.addChild(light1);
	
	   // Set up the ambient light
//	   Color3f ambientColor = new Color3f(1.0f, 1.0f, 1.0f);	
//	   AmbientLight ambientLightNode = new AmbientLight(ambientColor);
//	   ambientLightNode.setInfluencingBounds(bounds);
//	   root.addChild(ambientLightNode);
	   
	   Background background = new Background(new Color3f(0.0f,0.0f,0.0f));
	   //BoundingSphere bsphere = new BoundingSphere(new Point3d(0,0,0), 100.0f);
	   //background.setApplicationBounds(bounds);
	   root.addChild(background);
	   
	   
	   
	   return root;
	}
	
	public BouncingBall() {
	   this.setLayout(new BorderLayout());
	   //pobieramy konfiguracje grafiki, ktora powinna byc optymalna dla naszego sprzetu
	   GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
	   //tworzymy obiekt canvas - jest to komponent, ktory sluzy do renderowania swiata 3d
	   Canvas3D canvas = new Canvas3D(config);
	   //dodajemy canvas do naszego okienka
	   this.add(canvas);
	   canvas.addKeyListener(this);
	   timer = new Timer(delay,this);
	   // Create a simple scene and attach it to the virtual universe
	   BranchGroup scene = createSceneGraph();
	   //uzywamy metody compile, ktora optymalizuje strukture obiektow dodanych do sceny, 
	   //powinno sie tego uzywac, gdyz moze to zwiekszyc wydajnosc - zwlaszcza przy bardziej rozbudowanych scenach
	   scene.compile();
	   //tworzymy obiekt swiata SimpleUniverse i jest on przypisany do wczesniej utworzonego obiektu canvasa
	   SimpleUniverse universe = new SimpleUniverse(canvas);
	   universe.getViewingPlatform().setNominalViewingTransform();
	   //dodajemy do swiata nasza wczesniej utworzona scene
	   universe.addBranchGraph(scene);
	   timer.start();
	}
	
	public void keyPressed(KeyEvent e) {
	   //Invoked when a key has been pressed.
	   if (e.getKeyChar()=='d') {xloc = xloc + .05f;}
	   if (e.getKeyChar()=='a') {xloc = xloc - .05f;}	
	   if (e.getKeyChar()=='s') {
		   delay+=5;
		   timer.setDelay(delay);
	   }		
	   if (e.getKeyChar()=='w') {
		   if(delay>5){
			   delay-=5;
			   timer.setDelay(delay);
		   }
	   }	
	}
	
	public void keyReleased(KeyEvent e){
	   // Invoked when a key has been released.
	}
	
	public void keyTyped(KeyEvent e){
	   //Invoked when a key has been typed.
	}
	
	public void actionPerformed(ActionEvent e ){
		height += .02 * sign;
	    if (Math.abs(height *2) >= 1 ) sign = -1.0f * sign;
//	    if (height<-0.4f || height>0.4f) {
//	    	trans.setScale(new Vector3d(1.0, .95, 1.0));
//	    }
//		else {
//			trans.setScale(new Vector3d(1.0, 1.0, 1.0));
//		}
		
		trans.setTranslation(new Vector3f(xloc,height,0.0f));
		group1.setTransform(trans);
	}
	
	public static void main(String[] args) {
	   BouncingBall bb = new BouncingBall();
	   bb.addKeyListener(bb);
	   MainFrame mf = new MainFrame(bb, 640, 480);   
	}
}



