#pragma once

#ifndef __gx_gameclock_h__
	#define __gx_gameclock_h__

#include "foundation.h"

namespace Gx
{
	class GX_API GameClock
	{
	public:
		GameClock();

		// in seconds
		GxF32 getTime();
		GxF32 getElapsedTime();

		void suspend();
		void resume();
		void reset();

	private:
		GxF64	m_frequency; // ticks per second
		GxF64	m_resolution; // in seconds (1/freq)
		GxI64	m_lastCounter; //
		GxI32	m_suspendCount;
		GxI64	m_suspendStartTime;
		GxI64	m_timeLostToSuspension;

		GxI64 getCounter();

		bool m_isHighResolution;
	};
}

#endif /* __gx_gameclock_h__ */