#include "glext.h"
#include <string>
#include <assert.h>

#pragma region typedefs

/* ## GL_VERSION_1_2 ## */
typedef void (APIENTRYP PFNGLBLENDCOLORPROC) (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
typedef void (APIENTRYP PFNGLBLENDEQUATIONPROC) (GLenum mode);
typedef void (APIENTRYP PFNGLDRAWRANGEELEMENTSPROC) (GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices);
typedef void (APIENTRYP PFNGLTEXIMAGE3DPROC) (GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
typedef void (APIENTRYP PFNGLTEXSUBIMAGE3DPROC) (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels);
typedef void (APIENTRYP PFNGLCOPYTEXSUBIMAGE3DPROC) (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);

/* ## GL_VERSION_1_3 ## */
typedef void (APIENTRYP PFNGLACTIVETEXTUREPROC) (GLenum texture);
typedef void (APIENTRYP PFNGLSAMPLECOVERAGEPROC) (GLfloat value, GLboolean invert);
typedef void (APIENTRYP PFNGLCOMPRESSEDTEXIMAGE3DPROC) (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid *data);
typedef void (APIENTRYP PFNGLCOMPRESSEDTEXIMAGE2DPROC) (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *data);
typedef void (APIENTRYP PFNGLCOMPRESSEDTEXIMAGE1DPROC) (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid *data);
typedef void (APIENTRYP PFNGLCOMPRESSEDTEXSUBIMAGE3DPROC) (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *data);
typedef void (APIENTRYP PFNGLCOMPRESSEDTEXSUBIMAGE2DPROC) (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *data);
typedef void (APIENTRYP PFNGLCOMPRESSEDTEXSUBIMAGE1DPROC) (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *data);
typedef void (APIENTRYP PFNGLGETCOMPRESSEDTEXIMAGEPROC) (GLenum target, GLint level, GLvoid *img);

/* ## GL_VERSION_1_4 ## */
typedef void (APIENTRYP PFNGLBLENDFUNCSEPARATEPROC) (GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha);
typedef void (APIENTRYP PFNGLMULTIDRAWARRAYSPROC) (GLenum mode, const GLint *first, const GLsizei *count, GLsizei drawcount);
typedef void (APIENTRYP PFNGLMULTIDRAWELEMENTSPROC) (GLenum mode, const GLsizei *count, GLenum type, const GLvoid* const *indices, GLsizei drawcount);
typedef void (APIENTRYP PFNGLPOINTPARAMETERFPROC) (GLenum pname, GLfloat param);
typedef void (APIENTRYP PFNGLPOINTPARAMETERFVPROC) (GLenum pname, const GLfloat *params);
typedef void (APIENTRYP PFNGLPOINTPARAMETERIPROC) (GLenum pname, GLint param);
typedef void (APIENTRYP PFNGLPOINTPARAMETERIVPROC) (GLenum pname, const GLint *params);

/* ## GL_VERSION_1_5 ## */
typedef void (APIENTRYP PFNGLGENQUERIESPROC) (GLsizei n, GLuint *ids);
typedef void (APIENTRYP PFNGLDELETEQUERIESPROC) (GLsizei n, const GLuint *ids);
typedef GLboolean (APIENTRYP PFNGLISQUERYPROC) (GLuint id);
typedef void (APIENTRYP PFNGLBEGINQUERYPROC) (GLenum target, GLuint id);
typedef void (APIENTRYP PFNGLENDQUERYPROC) (GLenum target);
typedef void (APIENTRYP PFNGLGETQUERYIVPROC) (GLenum target, GLenum pname, GLint *params);
typedef void (APIENTRYP PFNGLGETQUERYOBJECTIVPROC) (GLuint id, GLenum pname, GLint *params);
typedef void (APIENTRYP PFNGLGETQUERYOBJECTUIVPROC) (GLuint id, GLenum pname, GLuint *params);
typedef void (APIENTRYP PFNGLBINDBUFFERPROC) (GLenum target, GLuint buffer);
typedef void (APIENTRYP PFNGLDELETEBUFFERSPROC) (GLsizei n, const GLuint *buffers);
typedef void (APIENTRYP PFNGLGENBUFFERSPROC) (GLsizei n, GLuint *buffers);
typedef GLboolean (APIENTRYP PFNGLISBUFFERPROC) (GLuint buffer);
typedef void (APIENTRYP PFNGLBUFFERDATAPROC) (GLenum target, GLsizeiptr size, const GLvoid *data, GLenum usage);
typedef void (APIENTRYP PFNGLBUFFERSUBDATAPROC) (GLenum target, GLintptr offset, GLsizeiptr size, const GLvoid *data);
typedef void (APIENTRYP PFNGLGETBUFFERSUBDATAPROC) (GLenum target, GLintptr offset, GLsizeiptr size, GLvoid *data);
typedef GLvoid* (APIENTRYP PFNGLMAPBUFFERPROC) (GLenum target, GLenum access);
typedef GLboolean (APIENTRYP PFNGLUNMAPBUFFERPROC) (GLenum target);
typedef void (APIENTRYP PFNGLGETBUFFERPARAMETERIVPROC) (GLenum target, GLenum pname, GLint *params);
typedef void (APIENTRYP PFNGLGETBUFFERPOINTERVPROC) (GLenum target, GLenum pname, GLvoid* *params);

/* ## GL_VERSION_2_0 ## */
typedef void (APIENTRYP PFNGLBLENDEQUATIONSEPARATEPROC) (GLenum modeRGB, GLenum modeAlpha);
typedef void (APIENTRYP PFNGLDRAWBUFFERSPROC) (GLsizei n, const GLenum *bufs);
typedef void (APIENTRYP PFNGLSTENCILOPSEPARATEPROC) (GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass);
typedef void (APIENTRYP PFNGLSTENCILFUNCSEPARATEPROC) (GLenum face, GLenum func, GLint ref, GLuint mask);
typedef void (APIENTRYP PFNGLSTENCILMASKSEPARATEPROC) (GLenum face, GLuint mask);
typedef void (APIENTRYP PFNGLATTACHSHADERPROC) (GLuint program, GLuint shader);
typedef void (APIENTRYP PFNGLBINDATTRIBLOCATIONPROC) (GLuint program, GLuint index, const GLchar *name);
typedef void (APIENTRYP PFNGLCOMPILESHADERPROC) (GLuint shader);
typedef GLuint (APIENTRYP PFNGLCREATEPROGRAMPROC) (void);
typedef GLuint (APIENTRYP PFNGLCREATESHADERPROC) (GLenum type);
typedef void (APIENTRYP PFNGLDELETEPROGRAMPROC) (GLuint program);
typedef void (APIENTRYP PFNGLDELETESHADERPROC) (GLuint shader);
typedef void (APIENTRYP PFNGLDETACHSHADERPROC) (GLuint program, GLuint shader);
typedef void (APIENTRYP PFNGLDISABLEVERTEXATTRIBARRAYPROC) (GLuint index);
typedef void (APIENTRYP PFNGLENABLEVERTEXATTRIBARRAYPROC) (GLuint index);
typedef void (APIENTRYP PFNGLGETACTIVEATTRIBPROC) (GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLint *size, GLenum *type, GLchar *name);
typedef void (APIENTRYP PFNGLGETACTIVEUNIFORMPROC) (GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLint *size, GLenum *type, GLchar *name);
typedef void (APIENTRYP PFNGLGETATTACHEDSHADERSPROC) (GLuint program, GLsizei maxCount, GLsizei *count, GLuint *obj);
typedef GLint (APIENTRYP PFNGLGETATTRIBLOCATIONPROC) (GLuint program, const GLchar *name);
typedef void (APIENTRYP PFNGLGETPROGRAMIVPROC) (GLuint program, GLenum pname, GLint *params);
typedef void (APIENTRYP PFNGLGETPROGRAMINFOLOGPROC) (GLuint program, GLsizei bufSize, GLsizei *length, GLchar *infoLog);
typedef void (APIENTRYP PFNGLGETSHADERIVPROC) (GLuint shader, GLenum pname, GLint *params);
typedef void (APIENTRYP PFNGLGETSHADERINFOLOGPROC) (GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *infoLog);
typedef void (APIENTRYP PFNGLGETSHADERSOURCEPROC) (GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *source);
typedef GLint (APIENTRYP PFNGLGETUNIFORMLOCATIONPROC) (GLuint program, const GLchar *name);
typedef void (APIENTRYP PFNGLGETUNIFORMFVPROC) (GLuint program, GLint location, GLfloat *params);
typedef void (APIENTRYP PFNGLGETUNIFORMIVPROC) (GLuint program, GLint location, GLint *params);
typedef void (APIENTRYP PFNGLGETVERTEXATTRIBDVPROC) (GLuint index, GLenum pname, GLdouble *params);
typedef void (APIENTRYP PFNGLGETVERTEXATTRIBFVPROC) (GLuint index, GLenum pname, GLfloat *params);
typedef void (APIENTRYP PFNGLGETVERTEXATTRIBIVPROC) (GLuint index, GLenum pname, GLint *params);
typedef void (APIENTRYP PFNGLGETVERTEXATTRIBPOINTERVPROC) (GLuint index, GLenum pname, GLvoid* *pointer);
typedef GLboolean (APIENTRYP PFNGLISPROGRAMPROC) (GLuint program);
typedef GLboolean (APIENTRYP PFNGLISSHADERPROC) (GLuint shader);
typedef void (APIENTRYP PFNGLLINKPROGRAMPROC) (GLuint program);
typedef void (APIENTRYP PFNGLSHADERSOURCEPROC) (GLuint shader, GLsizei count, const GLchar* const *string, const GLint *length);
typedef void (APIENTRYP PFNGLUSEPROGRAMPROC) (GLuint program);
typedef void (APIENTRYP PFNGLUNIFORM1FPROC) (GLint location, GLfloat v0);
typedef void (APIENTRYP PFNGLUNIFORM2FPROC) (GLint location, GLfloat v0, GLfloat v1);
typedef void (APIENTRYP PFNGLUNIFORM3FPROC) (GLint location, GLfloat v0, GLfloat v1, GLfloat v2);
typedef void (APIENTRYP PFNGLUNIFORM4FPROC) (GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3);
typedef void (APIENTRYP PFNGLUNIFORM1IPROC) (GLint location, GLint v0);
typedef void (APIENTRYP PFNGLUNIFORM2IPROC) (GLint location, GLint v0, GLint v1);
typedef void (APIENTRYP PFNGLUNIFORM3IPROC) (GLint location, GLint v0, GLint v1, GLint v2);
typedef void (APIENTRYP PFNGLUNIFORM4IPROC) (GLint location, GLint v0, GLint v1, GLint v2, GLint v3);
typedef void (APIENTRYP PFNGLUNIFORM1FVPROC) (GLint location, GLsizei count, const GLfloat *value);
typedef void (APIENTRYP PFNGLUNIFORM2FVPROC) (GLint location, GLsizei count, const GLfloat *value);
typedef void (APIENTRYP PFNGLUNIFORM3FVPROC) (GLint location, GLsizei count, const GLfloat *value);
typedef void (APIENTRYP PFNGLUNIFORM4FVPROC) (GLint location, GLsizei count, const GLfloat *value);
typedef void (APIENTRYP PFNGLUNIFORM1IVPROC) (GLint location, GLsizei count, const GLint *value);
typedef void (APIENTRYP PFNGLUNIFORM2IVPROC) (GLint location, GLsizei count, const GLint *value);
typedef void (APIENTRYP PFNGLUNIFORM3IVPROC) (GLint location, GLsizei count, const GLint *value);
typedef void (APIENTRYP PFNGLUNIFORM4IVPROC) (GLint location, GLsizei count, const GLint *value);
typedef void (APIENTRYP PFNGLUNIFORMMATRIX2FVPROC) (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
typedef void (APIENTRYP PFNGLUNIFORMMATRIX3FVPROC) (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
typedef void (APIENTRYP PFNGLUNIFORMMATRIX4FVPROC) (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
typedef void (APIENTRYP PFNGLVALIDATEPROGRAMPROC) (GLuint program);
typedef void (APIENTRYP PFNGLVERTEXATTRIB1DPROC) (GLuint index, GLdouble x);
typedef void (APIENTRYP PFNGLVERTEXATTRIB1DVPROC) (GLuint index, const GLdouble *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIB1FPROC) (GLuint index, GLfloat x);
typedef void (APIENTRYP PFNGLVERTEXATTRIB1FVPROC) (GLuint index, const GLfloat *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIB1SPROC) (GLuint index, GLshort x);
typedef void (APIENTRYP PFNGLVERTEXATTRIB1SVPROC) (GLuint index, const GLshort *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIB2DPROC) (GLuint index, GLdouble x, GLdouble y);
typedef void (APIENTRYP PFNGLVERTEXATTRIB2DVPROC) (GLuint index, const GLdouble *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIB2FPROC) (GLuint index, GLfloat x, GLfloat y);
typedef void (APIENTRYP PFNGLVERTEXATTRIB2FVPROC) (GLuint index, const GLfloat *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIB2SPROC) (GLuint index, GLshort x, GLshort y);
typedef void (APIENTRYP PFNGLVERTEXATTRIB2SVPROC) (GLuint index, const GLshort *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIB3DPROC) (GLuint index, GLdouble x, GLdouble y, GLdouble z);
typedef void (APIENTRYP PFNGLVERTEXATTRIB3DVPROC) (GLuint index, const GLdouble *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIB3FPROC) (GLuint index, GLfloat x, GLfloat y, GLfloat z);
typedef void (APIENTRYP PFNGLVERTEXATTRIB3FVPROC) (GLuint index, const GLfloat *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIB3SPROC) (GLuint index, GLshort x, GLshort y, GLshort z);
typedef void (APIENTRYP PFNGLVERTEXATTRIB3SVPROC) (GLuint index, const GLshort *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIB4NBVPROC) (GLuint index, const GLbyte *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIB4NIVPROC) (GLuint index, const GLint *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIB4NSVPROC) (GLuint index, const GLshort *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIB4NUBPROC) (GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w);
typedef void (APIENTRYP PFNGLVERTEXATTRIB4NUBVPROC) (GLuint index, const GLubyte *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIB4NUIVPROC) (GLuint index, const GLuint *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIB4NUSVPROC) (GLuint index, const GLushort *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIB4BVPROC) (GLuint index, const GLbyte *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIB4DPROC) (GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
typedef void (APIENTRYP PFNGLVERTEXATTRIB4DVPROC) (GLuint index, const GLdouble *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIB4FPROC) (GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
typedef void (APIENTRYP PFNGLVERTEXATTRIB4FVPROC) (GLuint index, const GLfloat *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIB4IVPROC) (GLuint index, const GLint *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIB4SPROC) (GLuint index, GLshort x, GLshort y, GLshort z, GLshort w);
typedef void (APIENTRYP PFNGLVERTEXATTRIB4SVPROC) (GLuint index, const GLshort *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIB4UBVPROC) (GLuint index, const GLubyte *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIB4UIVPROC) (GLuint index, const GLuint *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIB4USVPROC) (GLuint index, const GLushort *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIBPOINTERPROC) (GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid *pointer);

/* ## GL_VERSION_2_1 ## */
typedef void (APIENTRYP PFNGLUNIFORMMATRIX2X3FVPROC) (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
typedef void (APIENTRYP PFNGLUNIFORMMATRIX3X2FVPROC) (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
typedef void (APIENTRYP PFNGLUNIFORMMATRIX2X4FVPROC) (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
typedef void (APIENTRYP PFNGLUNIFORMMATRIX4X2FVPROC) (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
typedef void (APIENTRYP PFNGLUNIFORMMATRIX3X4FVPROC) (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
typedef void (APIENTRYP PFNGLUNIFORMMATRIX4X3FVPROC) (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);

/* ## GL_VERSION_3_0 ## */
typedef void (APIENTRYP PFNGLCOLORMASKIPROC) (GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a);
typedef void (APIENTRYP PFNGLGETBOOLEANI_VPROC) (GLenum target, GLuint index, GLboolean *data);
typedef void (APIENTRYP PFNGLGETINTEGERI_VPROC) (GLenum target, GLuint index, GLint *data);
typedef void (APIENTRYP PFNGLENABLEIPROC) (GLenum target, GLuint index);
typedef void (APIENTRYP PFNGLDISABLEIPROC) (GLenum target, GLuint index);
typedef GLboolean (APIENTRYP PFNGLISENABLEDIPROC) (GLenum target, GLuint index);
typedef void (APIENTRYP PFNGLBEGINTRANSFORMFEEDBACKPROC) (GLenum primitiveMode);
typedef void (APIENTRYP PFNGLENDTRANSFORMFEEDBACKPROC) (void);
typedef void (APIENTRYP PFNGLBINDBUFFERRANGEPROC) (GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size);
typedef void (APIENTRYP PFNGLBINDBUFFERBASEPROC) (GLenum target, GLuint index, GLuint buffer);
typedef void (APIENTRYP PFNGLTRANSFORMFEEDBACKVARYINGSPROC) (GLuint program, GLsizei count, const GLchar* const *varyings, GLenum bufferMode);
typedef void (APIENTRYP PFNGLGETTRANSFORMFEEDBACKVARYINGPROC) (GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name);
typedef void (APIENTRYP PFNGLCLAMPCOLORPROC) (GLenum target, GLenum clamp);
typedef void (APIENTRYP PFNGLBEGINCONDITIONALRENDERPROC) (GLuint id, GLenum mode);
typedef void (APIENTRYP PFNGLENDCONDITIONALRENDERPROC) (void);
typedef void (APIENTRYP PFNGLVERTEXATTRIBIPOINTERPROC) (GLuint index, GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
typedef void (APIENTRYP PFNGLGETVERTEXATTRIBIIVPROC) (GLuint index, GLenum pname, GLint *params);
typedef void (APIENTRYP PFNGLGETVERTEXATTRIBIUIVPROC) (GLuint index, GLenum pname, GLuint *params);
typedef void (APIENTRYP PFNGLVERTEXATTRIBI1IPROC) (GLuint index, GLint x);
typedef void (APIENTRYP PFNGLVERTEXATTRIBI2IPROC) (GLuint index, GLint x, GLint y);
typedef void (APIENTRYP PFNGLVERTEXATTRIBI3IPROC) (GLuint index, GLint x, GLint y, GLint z);
typedef void (APIENTRYP PFNGLVERTEXATTRIBI4IPROC) (GLuint index, GLint x, GLint y, GLint z, GLint w);
typedef void (APIENTRYP PFNGLVERTEXATTRIBI1UIPROC) (GLuint index, GLuint x);
typedef void (APIENTRYP PFNGLVERTEXATTRIBI2UIPROC) (GLuint index, GLuint x, GLuint y);
typedef void (APIENTRYP PFNGLVERTEXATTRIBI3UIPROC) (GLuint index, GLuint x, GLuint y, GLuint z);
typedef void (APIENTRYP PFNGLVERTEXATTRIBI4UIPROC) (GLuint index, GLuint x, GLuint y, GLuint z, GLuint w);
typedef void (APIENTRYP PFNGLVERTEXATTRIBI1IVPROC) (GLuint index, const GLint *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIBI2IVPROC) (GLuint index, const GLint *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIBI3IVPROC) (GLuint index, const GLint *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIBI4IVPROC) (GLuint index, const GLint *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIBI1UIVPROC) (GLuint index, const GLuint *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIBI2UIVPROC) (GLuint index, const GLuint *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIBI3UIVPROC) (GLuint index, const GLuint *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIBI4UIVPROC) (GLuint index, const GLuint *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIBI4BVPROC) (GLuint index, const GLbyte *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIBI4SVPROC) (GLuint index, const GLshort *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIBI4UBVPROC) (GLuint index, const GLubyte *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIBI4USVPROC) (GLuint index, const GLushort *v);
typedef void (APIENTRYP PFNGLGETUNIFORMUIVPROC) (GLuint program, GLint location, GLuint *params);
typedef void (APIENTRYP PFNGLBINDFRAGDATALOCATIONPROC) (GLuint program, GLuint color, const GLchar *name);
typedef GLint (APIENTRYP PFNGLGETFRAGDATALOCATIONPROC) (GLuint program, const GLchar *name);
typedef void (APIENTRYP PFNGLUNIFORM1UIPROC) (GLint location, GLuint v0);
typedef void (APIENTRYP PFNGLUNIFORM2UIPROC) (GLint location, GLuint v0, GLuint v1);
typedef void (APIENTRYP PFNGLUNIFORM3UIPROC) (GLint location, GLuint v0, GLuint v1, GLuint v2);
typedef void (APIENTRYP PFNGLUNIFORM4UIPROC) (GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3);
typedef void (APIENTRYP PFNGLUNIFORM1UIVPROC) (GLint location, GLsizei count, const GLuint *value);
typedef void (APIENTRYP PFNGLUNIFORM2UIVPROC) (GLint location, GLsizei count, const GLuint *value);
typedef void (APIENTRYP PFNGLUNIFORM3UIVPROC) (GLint location, GLsizei count, const GLuint *value);
typedef void (APIENTRYP PFNGLUNIFORM4UIVPROC) (GLint location, GLsizei count, const GLuint *value);
typedef void (APIENTRYP PFNGLTEXPARAMETERIIVPROC) (GLenum target, GLenum pname, const GLint *params);
typedef void (APIENTRYP PFNGLTEXPARAMETERIUIVPROC) (GLenum target, GLenum pname, const GLuint *params);
typedef void (APIENTRYP PFNGLGETTEXPARAMETERIIVPROC) (GLenum target, GLenum pname, GLint *params);
typedef void (APIENTRYP PFNGLGETTEXPARAMETERIUIVPROC) (GLenum target, GLenum pname, GLuint *params);
typedef void (APIENTRYP PFNGLCLEARBUFFERIVPROC) (GLenum buffer, GLint drawbuffer, const GLint *value);
typedef void (APIENTRYP PFNGLCLEARBUFFERUIVPROC) (GLenum buffer, GLint drawbuffer, const GLuint *value);
typedef void (APIENTRYP PFNGLCLEARBUFFERFVPROC) (GLenum buffer, GLint drawbuffer, const GLfloat *value);
typedef void (APIENTRYP PFNGLCLEARBUFFERFIPROC) (GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil);
typedef const GLubyte * (APIENTRYP PFNGLGETSTRINGIPROC) (GLenum name, GLuint index);

/* ## GL_VERSION_3_1 ## */
typedef void (APIENTRYP PFNGLDRAWARRAYSINSTANCEDPROC) (GLenum mode, GLint first, GLsizei count, GLsizei instancecount);
typedef void (APIENTRYP PFNGLDRAWELEMENTSINSTANCEDPROC) (GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLsizei instancecount);
typedef void (APIENTRYP PFNGLTEXBUFFERPROC) (GLenum target, GLenum internalformat, GLuint buffer);
typedef void (APIENTRYP PFNGLPRIMITIVERESTARTINDEXPROC) (GLuint index);

/* ## GL_VERSION_3_2 ## */
typedef void (APIENTRYP PFNGLGETINTEGER64I_VPROC) (GLenum target, GLuint index, GLint64 *data);
typedef void (APIENTRYP PFNGLGETBUFFERPARAMETERI64VPROC) (GLenum target, GLenum pname, GLint64 *params);
typedef void (APIENTRYP PFNGLFRAMEBUFFERTEXTUREPROC) (GLenum target, GLenum attachment, GLuint texture, GLint level);

/* ## GL_VERSION_3_3 ## */
typedef void (APIENTRYP PFNGLVERTEXATTRIBDIVISORPROC) (GLuint index, GLuint divisor);

/* ## GL_VERSION_4_0 ## */
typedef void (APIENTRYP PFNGLMINSAMPLESHADINGPROC) (GLfloat value);
typedef void (APIENTRYP PFNGLBLENDEQUATIONIPROC) (GLuint buf, GLenum mode);
typedef void (APIENTRYP PFNGLBLENDEQUATIONSEPARATEIPROC) (GLuint buf, GLenum modeRGB, GLenum modeAlpha);
typedef void (APIENTRYP PFNGLBLENDFUNCIPROC) (GLuint buf, GLenum src, GLenum dst);
typedef void (APIENTRYP PFNGLBLENDFUNCSEPARATEIPROC) (GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha);

/* ## GL_VERSION_4_1 ## */

/* ## GL_VERSION_4_2 ## */

/* ## GL_VERSION_4_3 ## */

/* ## GL_ARB_depth_buffer_float ## */

/* ## GL_ARB_framebuffer_object ## */
typedef GLboolean (APIENTRYP PFNGLISRENDERBUFFERPROC) (GLuint renderbuffer);
typedef void (APIENTRYP PFNGLBINDRENDERBUFFERPROC) (GLenum target, GLuint renderbuffer);
typedef void (APIENTRYP PFNGLDELETERENDERBUFFERSPROC) (GLsizei n, const GLuint *renderbuffers);
typedef void (APIENTRYP PFNGLGENRENDERBUFFERSPROC) (GLsizei n, GLuint *renderbuffers);
typedef void (APIENTRYP PFNGLRENDERBUFFERSTORAGEPROC) (GLenum target, GLenum internalformat, GLsizei width, GLsizei height);
typedef void (APIENTRYP PFNGLGETRENDERBUFFERPARAMETERIVPROC) (GLenum target, GLenum pname, GLint *params);
typedef GLboolean (APIENTRYP PFNGLISFRAMEBUFFERPROC) (GLuint framebuffer);
typedef void (APIENTRYP PFNGLBINDFRAMEBUFFERPROC) (GLenum target, GLuint framebuffer);
typedef void (APIENTRYP PFNGLDELETEFRAMEBUFFERSPROC) (GLsizei n, const GLuint *framebuffers);
typedef void (APIENTRYP PFNGLGENFRAMEBUFFERSPROC) (GLsizei n, GLuint *framebuffers);
typedef GLenum (APIENTRYP PFNGLCHECKFRAMEBUFFERSTATUSPROC) (GLenum target);
typedef void (APIENTRYP PFNGLFRAMEBUFFERTEXTURE1DPROC) (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
typedef void (APIENTRYP PFNGLFRAMEBUFFERTEXTURE2DPROC) (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
typedef void (APIENTRYP PFNGLFRAMEBUFFERTEXTURE3DPROC) (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset);
typedef void (APIENTRYP PFNGLFRAMEBUFFERRENDERBUFFERPROC) (GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer);
typedef void (APIENTRYP PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVPROC) (GLenum target, GLenum attachment, GLenum pname, GLint *params);
typedef void (APIENTRYP PFNGLGENERATEMIPMAPPROC) (GLenum target);
typedef void (APIENTRYP PFNGLBLITFRAMEBUFFERPROC) (GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter);
typedef void (APIENTRYP PFNGLRENDERBUFFERSTORAGEMULTISAMPLEPROC) (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);
typedef void (APIENTRYP PFNGLFRAMEBUFFERTEXTURELAYERPROC) (GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer);

/* ## GL_ARB_framebuffer_sRGB ## */

/* ## GL_ARB_half_float_vertex ## */

/* ## GL_ARB_map_buffer_range ## */
typedef GLvoid* (APIENTRYP PFNGLMAPBUFFERRANGEPROC) (GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access);
typedef void (APIENTRYP PFNGLFLUSHMAPPEDBUFFERRANGEPROC) (GLenum target, GLintptr offset, GLsizeiptr length);

/* ## GL_ARB_texture_compression_rgtc ## */

/* ## GL_ARB_texture_rg ## */

/* ## GL_ARB_vertex_array_object ## */
typedef void (APIENTRYP PFNGLBINDVERTEXARRAYPROC) (GLuint array);
typedef void (APIENTRYP PFNGLDELETEVERTEXARRAYSPROC) (GLsizei n, const GLuint *arrays);
typedef void (APIENTRYP PFNGLGENVERTEXARRAYSPROC) (GLsizei n, GLuint *arrays);
typedef GLboolean (APIENTRYP PFNGLISVERTEXARRAYPROC) (GLuint array);

/* ## GL_ARB_uniform_buffer_object ## */
typedef void (APIENTRYP PFNGLGETUNIFORMINDICESPROC) (GLuint program, GLsizei uniformCount, const GLchar* const *uniformNames, GLuint *uniformIndices);
typedef void (APIENTRYP PFNGLGETACTIVEUNIFORMSIVPROC) (GLuint program, GLsizei uniformCount, const GLuint *uniformIndices, GLenum pname, GLint *params);
typedef void (APIENTRYP PFNGLGETACTIVEUNIFORMNAMEPROC) (GLuint program, GLuint uniformIndex, GLsizei bufSize, GLsizei *length, GLchar *uniformName);
typedef GLuint (APIENTRYP PFNGLGETUNIFORMBLOCKINDEXPROC) (GLuint program, const GLchar *uniformBlockName);
typedef void (APIENTRYP PFNGLGETACTIVEUNIFORMBLOCKIVPROC) (GLuint program, GLuint uniformBlockIndex, GLenum pname, GLint *params);
typedef void (APIENTRYP PFNGLGETACTIVEUNIFORMBLOCKNAMEPROC) (GLuint program, GLuint uniformBlockIndex, GLsizei bufSize, GLsizei *length, GLchar *uniformBlockName);
typedef void (APIENTRYP PFNGLUNIFORMBLOCKBINDINGPROC) (GLuint program, GLuint uniformBlockIndex, GLuint uniformBlockBinding);

/* ## GL_ARB_copy_buffer ## */
typedef void (APIENTRYP PFNGLCOPYBUFFERSUBDATAPROC) (GLenum readTarget, GLenum writeTarget, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size);

/* ## GL_ARB_depth_clamp ## */

/* ## GL_ARB_draw_elements_base_vertex ## */
typedef void (APIENTRYP PFNGLDRAWELEMENTSBASEVERTEXPROC) (GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLint basevertex);
typedef void (APIENTRYP PFNGLDRAWRANGEELEMENTSBASEVERTEXPROC) (GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices, GLint basevertex);
typedef void (APIENTRYP PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXPROC) (GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLsizei instancecount, GLint basevertex);
typedef void (APIENTRYP PFNGLMULTIDRAWELEMENTSBASEVERTEXPROC) (GLenum mode, const GLsizei *count, GLenum type, const GLvoid* const *indices, GLsizei drawcount, const GLint *basevertex);

/* ## GL_ARB_fragment_coord_conventions ## */

/* ## GL_ARB_provoking_vertex ## */
typedef void (APIENTRYP PFNGLPROVOKINGVERTEXPROC) (GLenum mode);

/* ## GL_ARB_seamless_cube_map ## */

/* ## GL_ARB_sync ## */
typedef GLsync (APIENTRYP PFNGLFENCESYNCPROC) (GLenum condition, GLbitfield flags);
typedef GLboolean (APIENTRYP PFNGLISSYNCPROC) (GLsync sync);
typedef void (APIENTRYP PFNGLDELETESYNCPROC) (GLsync sync);
typedef GLenum (APIENTRYP PFNGLCLIENTWAITSYNCPROC) (GLsync sync, GLbitfield flags, GLuint64 timeout);
typedef void (APIENTRYP PFNGLWAITSYNCPROC) (GLsync sync, GLbitfield flags, GLuint64 timeout);
typedef void (APIENTRYP PFNGLGETINTEGER64VPROC) (GLenum pname, GLint64 *params);
typedef void (APIENTRYP PFNGLGETSYNCIVPROC) (GLsync sync, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *values);

/* ## GL_ARB_texture_multisample ## */
typedef void (APIENTRYP PFNGLTEXIMAGE2DMULTISAMPLEPROC) (GLenum target, GLsizei samples, GLint internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations);
typedef void (APIENTRYP PFNGLTEXIMAGE3DMULTISAMPLEPROC) (GLenum target, GLsizei samples, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations);
typedef void (APIENTRYP PFNGLGETMULTISAMPLEFVPROC) (GLenum pname, GLuint index, GLfloat *val);
typedef void (APIENTRYP PFNGLSAMPLEMASKIPROC) (GLuint index, GLbitfield mask);

/* ## GL_ARB_vertex_array_bgra ## */

/* ## GL_ARB_draw_buffers_blend ## */
typedef void (APIENTRYP PFNGLBLENDEQUATIONIARBPROC) (GLuint buf, GLenum mode);
typedef void (APIENTRYP PFNGLBLENDEQUATIONSEPARATEIARBPROC) (GLuint buf, GLenum modeRGB, GLenum modeAlpha);
typedef void (APIENTRYP PFNGLBLENDFUNCIARBPROC) (GLuint buf, GLenum src, GLenum dst);
typedef void (APIENTRYP PFNGLBLENDFUNCSEPARATEIARBPROC) (GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha);

/* ## GL_ARB_sample_shading ## */
typedef void (APIENTRYP PFNGLMINSAMPLESHADINGARBPROC) (GLfloat value);

/* ## GL_ARB_texture_cube_map_array ## */

/* ## GL_ARB_texture_gather ## */

/* ## GL_ARB_texture_query_lod ## */

/* ## GL_ARB_shading_language_include ## */
typedef void (APIENTRYP PFNGLNAMEDSTRINGARBPROC) (GLenum type, GLint namelen, const GLchar *name, GLint stringlen, const GLchar *string);
typedef void (APIENTRYP PFNGLDELETENAMEDSTRINGARBPROC) (GLint namelen, const GLchar *name);
typedef void (APIENTRYP PFNGLCOMPILESHADERINCLUDEARBPROC) (GLuint shader, GLsizei count, const GLchar* *path, const GLint *length);
typedef GLboolean (APIENTRYP PFNGLISNAMEDSTRINGARBPROC) (GLint namelen, const GLchar *name);
typedef void (APIENTRYP PFNGLGETNAMEDSTRINGARBPROC) (GLint namelen, const GLchar *name, GLsizei bufSize, GLint *stringlen, GLchar *string);
typedef void (APIENTRYP PFNGLGETNAMEDSTRINGIVARBPROC) (GLint namelen, const GLchar *name, GLenum pname, GLint *params);

/* ## GL_ARB_texture_compression_bptc ## */

/* ## GL_ARB_blend_func_extended ## */
typedef void (APIENTRYP PFNGLBINDFRAGDATALOCATIONINDEXEDPROC) (GLuint program, GLuint colorNumber, GLuint index, const GLchar *name);
typedef GLint (APIENTRYP PFNGLGETFRAGDATAINDEXPROC) (GLuint program, const GLchar *name);

/* ## GL_ARB_explicit_attrib_location ## */

/* ## GL_ARB_occlusion_query2 ## */

/* ## GL_ARB_sampler_objects ## */
typedef void (APIENTRYP PFNGLGENSAMPLERSPROC) (GLsizei count, GLuint *samplers);
typedef void (APIENTRYP PFNGLDELETESAMPLERSPROC) (GLsizei count, const GLuint *samplers);
typedef GLboolean (APIENTRYP PFNGLISSAMPLERPROC) (GLuint sampler);
typedef void (APIENTRYP PFNGLBINDSAMPLERPROC) (GLuint unit, GLuint sampler);
typedef void (APIENTRYP PFNGLSAMPLERPARAMETERIPROC) (GLuint sampler, GLenum pname, GLint param);
typedef void (APIENTRYP PFNGLSAMPLERPARAMETERIVPROC) (GLuint sampler, GLenum pname, const GLint *param);
typedef void (APIENTRYP PFNGLSAMPLERPARAMETERFPROC) (GLuint sampler, GLenum pname, GLfloat param);
typedef void (APIENTRYP PFNGLSAMPLERPARAMETERFVPROC) (GLuint sampler, GLenum pname, const GLfloat *param);
typedef void (APIENTRYP PFNGLSAMPLERPARAMETERIIVPROC) (GLuint sampler, GLenum pname, const GLint *param);
typedef void (APIENTRYP PFNGLSAMPLERPARAMETERIUIVPROC) (GLuint sampler, GLenum pname, const GLuint *param);
typedef void (APIENTRYP PFNGLGETSAMPLERPARAMETERIVPROC) (GLuint sampler, GLenum pname, GLint *params);
typedef void (APIENTRYP PFNGLGETSAMPLERPARAMETERIIVPROC) (GLuint sampler, GLenum pname, GLint *params);
typedef void (APIENTRYP PFNGLGETSAMPLERPARAMETERFVPROC) (GLuint sampler, GLenum pname, GLfloat *params);
typedef void (APIENTRYP PFNGLGETSAMPLERPARAMETERIUIVPROC) (GLuint sampler, GLenum pname, GLuint *params);

/* ## GL_ARB_shader_bit_encoding ## */

/* ## GL_ARB_texture_rgb10_a2ui ## */

/* ## GL_ARB_texture_swizzle ## */

/* ## GL_ARB_timer_query ## */
typedef void (APIENTRYP PFNGLQUERYCOUNTERPROC) (GLuint id, GLenum target);
typedef void (APIENTRYP PFNGLGETQUERYOBJECTI64VPROC) (GLuint id, GLenum pname, GLint64 *params);
typedef void (APIENTRYP PFNGLGETQUERYOBJECTUI64VPROC) (GLuint id, GLenum pname, GLuint64 *params);

/* ## GL_ARB_vertex_type_2_10_10_10_rev ## */
typedef void (APIENTRYP PFNGLVERTEXP2UIPROC) (GLenum type, GLuint value);
typedef void (APIENTRYP PFNGLVERTEXP2UIVPROC) (GLenum type, const GLuint *value);
typedef void (APIENTRYP PFNGLVERTEXP3UIPROC) (GLenum type, GLuint value);
typedef void (APIENTRYP PFNGLVERTEXP3UIVPROC) (GLenum type, const GLuint *value);
typedef void (APIENTRYP PFNGLVERTEXP4UIPROC) (GLenum type, GLuint value);
typedef void (APIENTRYP PFNGLVERTEXP4UIVPROC) (GLenum type, const GLuint *value);
typedef void (APIENTRYP PFNGLTEXCOORDP1UIPROC) (GLenum type, GLuint coords);
typedef void (APIENTRYP PFNGLTEXCOORDP1UIVPROC) (GLenum type, const GLuint *coords);
typedef void (APIENTRYP PFNGLTEXCOORDP2UIPROC) (GLenum type, GLuint coords);
typedef void (APIENTRYP PFNGLTEXCOORDP2UIVPROC) (GLenum type, const GLuint *coords);
typedef void (APIENTRYP PFNGLTEXCOORDP3UIPROC) (GLenum type, GLuint coords);
typedef void (APIENTRYP PFNGLTEXCOORDP3UIVPROC) (GLenum type, const GLuint *coords);
typedef void (APIENTRYP PFNGLTEXCOORDP4UIPROC) (GLenum type, GLuint coords);
typedef void (APIENTRYP PFNGLTEXCOORDP4UIVPROC) (GLenum type, const GLuint *coords);
typedef void (APIENTRYP PFNGLMULTITEXCOORDP1UIPROC) (GLenum texture, GLenum type, GLuint coords);
typedef void (APIENTRYP PFNGLMULTITEXCOORDP1UIVPROC) (GLenum texture, GLenum type, const GLuint *coords);
typedef void (APIENTRYP PFNGLMULTITEXCOORDP2UIPROC) (GLenum texture, GLenum type, GLuint coords);
typedef void (APIENTRYP PFNGLMULTITEXCOORDP2UIVPROC) (GLenum texture, GLenum type, const GLuint *coords);
typedef void (APIENTRYP PFNGLMULTITEXCOORDP3UIPROC) (GLenum texture, GLenum type, GLuint coords);
typedef void (APIENTRYP PFNGLMULTITEXCOORDP3UIVPROC) (GLenum texture, GLenum type, const GLuint *coords);
typedef void (APIENTRYP PFNGLMULTITEXCOORDP4UIPROC) (GLenum texture, GLenum type, GLuint coords);
typedef void (APIENTRYP PFNGLMULTITEXCOORDP4UIVPROC) (GLenum texture, GLenum type, const GLuint *coords);
typedef void (APIENTRYP PFNGLNORMALP3UIPROC) (GLenum type, GLuint coords);
typedef void (APIENTRYP PFNGLNORMALP3UIVPROC) (GLenum type, const GLuint *coords);
typedef void (APIENTRYP PFNGLCOLORP3UIPROC) (GLenum type, GLuint color);
typedef void (APIENTRYP PFNGLCOLORP3UIVPROC) (GLenum type, const GLuint *color);
typedef void (APIENTRYP PFNGLCOLORP4UIPROC) (GLenum type, GLuint color);
typedef void (APIENTRYP PFNGLCOLORP4UIVPROC) (GLenum type, const GLuint *color);
typedef void (APIENTRYP PFNGLSECONDARYCOLORP3UIPROC) (GLenum type, GLuint color);
typedef void (APIENTRYP PFNGLSECONDARYCOLORP3UIVPROC) (GLenum type, const GLuint *color);
typedef void (APIENTRYP PFNGLVERTEXATTRIBP1UIPROC) (GLuint index, GLenum type, GLboolean normalized, GLuint value);
typedef void (APIENTRYP PFNGLVERTEXATTRIBP1UIVPROC) (GLuint index, GLenum type, GLboolean normalized, const GLuint *value);
typedef void (APIENTRYP PFNGLVERTEXATTRIBP2UIPROC) (GLuint index, GLenum type, GLboolean normalized, GLuint value);
typedef void (APIENTRYP PFNGLVERTEXATTRIBP2UIVPROC) (GLuint index, GLenum type, GLboolean normalized, const GLuint *value);
typedef void (APIENTRYP PFNGLVERTEXATTRIBP3UIPROC) (GLuint index, GLenum type, GLboolean normalized, GLuint value);
typedef void (APIENTRYP PFNGLVERTEXATTRIBP3UIVPROC) (GLuint index, GLenum type, GLboolean normalized, const GLuint *value);
typedef void (APIENTRYP PFNGLVERTEXATTRIBP4UIPROC) (GLuint index, GLenum type, GLboolean normalized, GLuint value);
typedef void (APIENTRYP PFNGLVERTEXATTRIBP4UIVPROC) (GLuint index, GLenum type, GLboolean normalized, const GLuint *value);

/* ## GL_ARB_draw_indirect ## */
typedef void (APIENTRYP PFNGLDRAWARRAYSINDIRECTPROC) (GLenum mode, const GLvoid *indirect);
typedef void (APIENTRYP PFNGLDRAWELEMENTSINDIRECTPROC) (GLenum mode, GLenum type, const GLvoid *indirect);

/* ## GL_ARB_gpu_shader5 ## */

/* ## GL_ARB_gpu_shader_fp64 ## */
typedef void (APIENTRYP PFNGLUNIFORM1DPROC) (GLint location, GLdouble x);
typedef void (APIENTRYP PFNGLUNIFORM2DPROC) (GLint location, GLdouble x, GLdouble y);
typedef void (APIENTRYP PFNGLUNIFORM3DPROC) (GLint location, GLdouble x, GLdouble y, GLdouble z);
typedef void (APIENTRYP PFNGLUNIFORM4DPROC) (GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
typedef void (APIENTRYP PFNGLUNIFORM1DVPROC) (GLint location, GLsizei count, const GLdouble *value);
typedef void (APIENTRYP PFNGLUNIFORM2DVPROC) (GLint location, GLsizei count, const GLdouble *value);
typedef void (APIENTRYP PFNGLUNIFORM3DVPROC) (GLint location, GLsizei count, const GLdouble *value);
typedef void (APIENTRYP PFNGLUNIFORM4DVPROC) (GLint location, GLsizei count, const GLdouble *value);
typedef void (APIENTRYP PFNGLUNIFORMMATRIX2DVPROC) (GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
typedef void (APIENTRYP PFNGLUNIFORMMATRIX3DVPROC) (GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
typedef void (APIENTRYP PFNGLUNIFORMMATRIX4DVPROC) (GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
typedef void (APIENTRYP PFNGLUNIFORMMATRIX2X3DVPROC) (GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
typedef void (APIENTRYP PFNGLUNIFORMMATRIX2X4DVPROC) (GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
typedef void (APIENTRYP PFNGLUNIFORMMATRIX3X2DVPROC) (GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
typedef void (APIENTRYP PFNGLUNIFORMMATRIX3X4DVPROC) (GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
typedef void (APIENTRYP PFNGLUNIFORMMATRIX4X2DVPROC) (GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
typedef void (APIENTRYP PFNGLUNIFORMMATRIX4X3DVPROC) (GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
typedef void (APIENTRYP PFNGLGETUNIFORMDVPROC) (GLuint program, GLint location, GLdouble *params);

/* ## GL_ARB_shader_subroutine ## */
typedef GLint (APIENTRYP PFNGLGETSUBROUTINEUNIFORMLOCATIONPROC) (GLuint program, GLenum shadertype, const GLchar *name);
typedef GLuint (APIENTRYP PFNGLGETSUBROUTINEINDEXPROC) (GLuint program, GLenum shadertype, const GLchar *name);
typedef void (APIENTRYP PFNGLGETACTIVESUBROUTINEUNIFORMIVPROC) (GLuint program, GLenum shadertype, GLuint index, GLenum pname, GLint *values);
typedef void (APIENTRYP PFNGLGETACTIVESUBROUTINEUNIFORMNAMEPROC) (GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei *length, GLchar *name);
typedef void (APIENTRYP PFNGLGETACTIVESUBROUTINENAMEPROC) (GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei *length, GLchar *name);
typedef void (APIENTRYP PFNGLUNIFORMSUBROUTINESUIVPROC) (GLenum shadertype, GLsizei count, const GLuint *indices);
typedef void (APIENTRYP PFNGLGETUNIFORMSUBROUTINEUIVPROC) (GLenum shadertype, GLint location, GLuint *params);
typedef void (APIENTRYP PFNGLGETPROGRAMSTAGEIVPROC) (GLuint program, GLenum shadertype, GLenum pname, GLint *values);

/* ## GL_ARB_tessellation_shader ## */
typedef void (APIENTRYP PFNGLPATCHPARAMETERIPROC) (GLenum pname, GLint value);
typedef void (APIENTRYP PFNGLPATCHPARAMETERFVPROC) (GLenum pname, const GLfloat *values);

/* ## GL_ARB_texture_buffer_object_rgb32 ## */

/* ## GL_ARB_transform_feedback2 ## */
typedef void (APIENTRYP PFNGLBINDTRANSFORMFEEDBACKPROC) (GLenum target, GLuint id);
typedef void (APIENTRYP PFNGLDELETETRANSFORMFEEDBACKSPROC) (GLsizei n, const GLuint *ids);
typedef void (APIENTRYP PFNGLGENTRANSFORMFEEDBACKSPROC) (GLsizei n, GLuint *ids);
typedef GLboolean (APIENTRYP PFNGLISTRANSFORMFEEDBACKPROC) (GLuint id);
typedef void (APIENTRYP PFNGLPAUSETRANSFORMFEEDBACKPROC) (void);
typedef void (APIENTRYP PFNGLRESUMETRANSFORMFEEDBACKPROC) (void);
typedef void (APIENTRYP PFNGLDRAWTRANSFORMFEEDBACKPROC) (GLenum mode, GLuint id);

/* ## GL_ARB_transform_feedback3 ## */
typedef void (APIENTRYP PFNGLDRAWTRANSFORMFEEDBACKSTREAMPROC) (GLenum mode, GLuint id, GLuint stream);
typedef void (APIENTRYP PFNGLBEGINQUERYINDEXEDPROC) (GLenum target, GLuint index, GLuint id);
typedef void (APIENTRYP PFNGLENDQUERYINDEXEDPROC) (GLenum target, GLuint index);
typedef void (APIENTRYP PFNGLGETQUERYINDEXEDIVPROC) (GLenum target, GLuint index, GLenum pname, GLint *params);

/* ## GL_ARB_ES2_compatibility ## */
typedef void (APIENTRYP PFNGLRELEASESHADERCOMPILERPROC) (void);
typedef void (APIENTRYP PFNGLSHADERBINARYPROC) (GLsizei count, const GLuint *shaders, GLenum binaryformat, const GLvoid *binary, GLsizei length);
typedef void (APIENTRYP PFNGLGETSHADERPRECISIONFORMATPROC) (GLenum shadertype, GLenum precisiontype, GLint *range, GLint *precision);
typedef void (APIENTRYP PFNGLDEPTHRANGEFPROC) (GLfloat n, GLfloat f);
typedef void (APIENTRYP PFNGLCLEARDEPTHFPROC) (GLfloat d);

/* ## GL_ARB_get_program_binary ## */
typedef void (APIENTRYP PFNGLGETPROGRAMBINARYPROC) (GLuint program, GLsizei bufSize, GLsizei *length, GLenum *binaryFormat, GLvoid *binary);
typedef void (APIENTRYP PFNGLPROGRAMBINARYPROC) (GLuint program, GLenum binaryFormat, const GLvoid *binary, GLsizei length);
typedef void (APIENTRYP PFNGLPROGRAMPARAMETERIPROC) (GLuint program, GLenum pname, GLint value);

/* ## GL_ARB_separate_shader_objects ## */
typedef void (APIENTRYP PFNGLUSEPROGRAMSTAGESPROC) (GLuint pipeline, GLbitfield stages, GLuint program);
typedef void (APIENTRYP PFNGLACTIVESHADERPROGRAMPROC) (GLuint pipeline, GLuint program);
typedef GLuint (APIENTRYP PFNGLCREATESHADERPROGRAMVPROC) (GLenum type, GLsizei count, const GLchar* const *strings);
typedef void (APIENTRYP PFNGLBINDPROGRAMPIPELINEPROC) (GLuint pipeline);
typedef void (APIENTRYP PFNGLDELETEPROGRAMPIPELINESPROC) (GLsizei n, const GLuint *pipelines);
typedef void (APIENTRYP PFNGLGENPROGRAMPIPELINESPROC) (GLsizei n, GLuint *pipelines);
typedef GLboolean (APIENTRYP PFNGLISPROGRAMPIPELINEPROC) (GLuint pipeline);
typedef void (APIENTRYP PFNGLGETPROGRAMPIPELINEIVPROC) (GLuint pipeline, GLenum pname, GLint *params);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORM1IPROC) (GLuint program, GLint location, GLint v0);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORM1IVPROC) (GLuint program, GLint location, GLsizei count, const GLint *value);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORM1FPROC) (GLuint program, GLint location, GLfloat v0);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORM1FVPROC) (GLuint program, GLint location, GLsizei count, const GLfloat *value);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORM1DPROC) (GLuint program, GLint location, GLdouble v0);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORM1DVPROC) (GLuint program, GLint location, GLsizei count, const GLdouble *value);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORM1UIPROC) (GLuint program, GLint location, GLuint v0);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORM1UIVPROC) (GLuint program, GLint location, GLsizei count, const GLuint *value);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORM2IPROC) (GLuint program, GLint location, GLint v0, GLint v1);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORM2IVPROC) (GLuint program, GLint location, GLsizei count, const GLint *value);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORM2FPROC) (GLuint program, GLint location, GLfloat v0, GLfloat v1);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORM2FVPROC) (GLuint program, GLint location, GLsizei count, const GLfloat *value);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORM2DPROC) (GLuint program, GLint location, GLdouble v0, GLdouble v1);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORM2DVPROC) (GLuint program, GLint location, GLsizei count, const GLdouble *value);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORM2UIPROC) (GLuint program, GLint location, GLuint v0, GLuint v1);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORM2UIVPROC) (GLuint program, GLint location, GLsizei count, const GLuint *value);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORM3IPROC) (GLuint program, GLint location, GLint v0, GLint v1, GLint v2);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORM3IVPROC) (GLuint program, GLint location, GLsizei count, const GLint *value);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORM3FPROC) (GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORM3FVPROC) (GLuint program, GLint location, GLsizei count, const GLfloat *value);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORM3DPROC) (GLuint program, GLint location, GLdouble v0, GLdouble v1, GLdouble v2);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORM3DVPROC) (GLuint program, GLint location, GLsizei count, const GLdouble *value);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORM3UIPROC) (GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORM3UIVPROC) (GLuint program, GLint location, GLsizei count, const GLuint *value);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORM4IPROC) (GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORM4IVPROC) (GLuint program, GLint location, GLsizei count, const GLint *value);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORM4FPROC) (GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORM4FVPROC) (GLuint program, GLint location, GLsizei count, const GLfloat *value);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORM4DPROC) (GLuint program, GLint location, GLdouble v0, GLdouble v1, GLdouble v2, GLdouble v3);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORM4DVPROC) (GLuint program, GLint location, GLsizei count, const GLdouble *value);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORM4UIPROC) (GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORM4UIVPROC) (GLuint program, GLint location, GLsizei count, const GLuint *value);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORMMATRIX2FVPROC) (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORMMATRIX3FVPROC) (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORMMATRIX4FVPROC) (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORMMATRIX2DVPROC) (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORMMATRIX3DVPROC) (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORMMATRIX4DVPROC) (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORMMATRIX2X3FVPROC) (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORMMATRIX3X2FVPROC) (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORMMATRIX2X4FVPROC) (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORMMATRIX4X2FVPROC) (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORMMATRIX3X4FVPROC) (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORMMATRIX4X3FVPROC) (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORMMATRIX2X3DVPROC) (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORMMATRIX3X2DVPROC) (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORMMATRIX2X4DVPROC) (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORMMATRIX4X2DVPROC) (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORMMATRIX3X4DVPROC) (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
typedef void (APIENTRYP PFNGLPROGRAMUNIFORMMATRIX4X3DVPROC) (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
typedef void (APIENTRYP PFNGLVALIDATEPROGRAMPIPELINEPROC) (GLuint pipeline);
typedef void (APIENTRYP PFNGLGETPROGRAMPIPELINEINFOLOGPROC) (GLuint pipeline, GLsizei bufSize, GLsizei *length, GLchar *infoLog);

/* ## GL_ARB_vertex_attrib_64bit ## */
typedef void (APIENTRYP PFNGLVERTEXATTRIBL1DPROC) (GLuint index, GLdouble x);
typedef void (APIENTRYP PFNGLVERTEXATTRIBL2DPROC) (GLuint index, GLdouble x, GLdouble y);
typedef void (APIENTRYP PFNGLVERTEXATTRIBL3DPROC) (GLuint index, GLdouble x, GLdouble y, GLdouble z);
typedef void (APIENTRYP PFNGLVERTEXATTRIBL4DPROC) (GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
typedef void (APIENTRYP PFNGLVERTEXATTRIBL1DVPROC) (GLuint index, const GLdouble *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIBL2DVPROC) (GLuint index, const GLdouble *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIBL3DVPROC) (GLuint index, const GLdouble *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIBL4DVPROC) (GLuint index, const GLdouble *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIBLPOINTERPROC) (GLuint index, GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
typedef void (APIENTRYP PFNGLGETVERTEXATTRIBLDVPROC) (GLuint index, GLenum pname, GLdouble *params);

/* ## GL_ARB_viewport_array ## */
typedef void (APIENTRYP PFNGLVIEWPORTARRAYVPROC) (GLuint first, GLsizei count, const GLfloat *v);
typedef void (APIENTRYP PFNGLVIEWPORTINDEXEDFPROC) (GLuint index, GLfloat x, GLfloat y, GLfloat w, GLfloat h);
typedef void (APIENTRYP PFNGLVIEWPORTINDEXEDFVPROC) (GLuint index, const GLfloat *v);
typedef void (APIENTRYP PFNGLSCISSORARRAYVPROC) (GLuint first, GLsizei count, const GLint *v);
typedef void (APIENTRYP PFNGLSCISSORINDEXEDPROC) (GLuint index, GLint left, GLint bottom, GLsizei width, GLsizei height);
typedef void (APIENTRYP PFNGLSCISSORINDEXEDVPROC) (GLuint index, const GLint *v);
typedef void (APIENTRYP PFNGLDEPTHRANGEARRAYVPROC) (GLuint first, GLsizei count, const GLdouble *v);
typedef void (APIENTRYP PFNGLDEPTHRANGEINDEXEDPROC) (GLuint index, GLdouble n, GLdouble f);
typedef void (APIENTRYP PFNGLGETFLOATI_VPROC) (GLenum target, GLuint index, GLfloat *data);
typedef void (APIENTRYP PFNGLGETDOUBLEI_VPROC) (GLenum target, GLuint index, GLdouble *data);

/* ## GL_ARB_cl_event ## */
typedef GLsync (APIENTRYP PFNGLCREATESYNCFROMCLEVENTARBPROC) (struct _cl_context * context, struct _cl_event * event, GLbitfield flags);

/* ## GL_ARB_debug_output ## */
typedef void (APIENTRYP PFNGLDEBUGMESSAGECONTROLARBPROC) (GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint *ids, GLboolean enabled);
typedef void (APIENTRYP PFNGLDEBUGMESSAGEINSERTARBPROC) (GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar *buf);
typedef void (APIENTRYP PFNGLDEBUGMESSAGECALLBACKARBPROC) (GLDEBUGPROCARB callback, const GLvoid *userParam);
typedef GLuint (APIENTRYP PFNGLGETDEBUGMESSAGELOGARBPROC) (GLuint count, GLsizei bufsize, GLenum *sources, GLenum *types, GLuint *ids, GLenum *severities, GLsizei *lengths, GLchar *messageLog);

/* ## GL_ARB_robustness ## */
typedef GLenum (APIENTRYP PFNGLGETGRAPHICSRESETSTATUSARBPROC) (void);
typedef void (APIENTRYP PFNGLGETNTEXIMAGEARBPROC) (GLenum target, GLint level, GLenum format, GLenum type, GLsizei bufSize, GLvoid *img);
typedef void (APIENTRYP PFNGLREADNPIXELSARBPROC) (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, GLvoid *data);
typedef void (APIENTRYP PFNGLGETNCOMPRESSEDTEXIMAGEARBPROC) (GLenum target, GLint lod, GLsizei bufSize, GLvoid *img);
typedef void (APIENTRYP PFNGLGETNUNIFORMFVARBPROC) (GLuint program, GLint location, GLsizei bufSize, GLfloat *params);
typedef void (APIENTRYP PFNGLGETNUNIFORMIVARBPROC) (GLuint program, GLint location, GLsizei bufSize, GLint *params);
typedef void (APIENTRYP PFNGLGETNUNIFORMUIVARBPROC) (GLuint program, GLint location, GLsizei bufSize, GLuint *params);
typedef void (APIENTRYP PFNGLGETNUNIFORMDVARBPROC) (GLuint program, GLint location, GLsizei bufSize, GLdouble *params);

/* ## GL_ARB_shader_stencil_export ## */

/* ## GL_ARB_base_instance ## */
typedef void (APIENTRYP PFNGLDRAWARRAYSINSTANCEDBASEINSTANCEPROC) (GLenum mode, GLint first, GLsizei count, GLsizei instancecount, GLuint baseinstance);
typedef void (APIENTRYP PFNGLDRAWELEMENTSINSTANCEDBASEINSTANCEPROC) (GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLuint baseinstance);
typedef void (APIENTRYP PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXBASEINSTANCEPROC) (GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLint basevertex, GLuint baseinstance);

/* ## GL_ARB_shading_language_420pack ## */

/* ## GL_ARB_transform_feedback_instanced ## */
typedef void (APIENTRYP PFNGLDRAWTRANSFORMFEEDBACKINSTANCEDPROC) (GLenum mode, GLuint id, GLsizei instancecount);
typedef void (APIENTRYP PFNGLDRAWTRANSFORMFEEDBACKSTREAMINSTANCEDPROC) (GLenum mode, GLuint id, GLuint stream, GLsizei instancecount);

/* ## GL_ARB_compressed_texture_pixel_storage ## */

/* ## GL_ARB_conservative_depth ## */

/* ## GL_ARB_internalformat_query ## */
typedef void (APIENTRYP PFNGLGETINTERNALFORMATIVPROC) (GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint *params);

/* ## GL_ARB_map_buffer_alignment ## */

/* ## GL_ARB_shader_atomic_counters ## */
typedef void (APIENTRYP PFNGLGETACTIVEATOMICCOUNTERBUFFERIVPROC) (GLuint program, GLuint bufferIndex, GLenum pname, GLint *params);

/* ## GL_ARB_shader_image_load_store ## */
typedef void (APIENTRYP PFNGLBINDIMAGETEXTUREPROC) (GLuint unit, GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum access, GLenum format);
typedef void (APIENTRYP PFNGLMEMORYBARRIERPROC) (GLbitfield barriers);

/* ## GL_ARB_shading_language_packing ## */

/* ## GL_ARB_texture_storage ## */
typedef void (APIENTRYP PFNGLTEXSTORAGE1DPROC) (GLenum target, GLsizei levels, GLenum internalformat, GLsizei width);
typedef void (APIENTRYP PFNGLTEXSTORAGE2DPROC) (GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height);
typedef void (APIENTRYP PFNGLTEXSTORAGE3DPROC) (GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth);
typedef void (APIENTRYP PFNGLTEXTURESTORAGE1DEXTPROC) (GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width);
typedef void (APIENTRYP PFNGLTEXTURESTORAGE2DEXTPROC) (GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height);
typedef void (APIENTRYP PFNGLTEXTURESTORAGE3DEXTPROC) (GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth);

/* ## GL_KHR_texture_compression_astc_ldr ## */

/* ## GL_KHR_debug ## */
typedef void (APIENTRYP PFNGLDEBUGMESSAGECONTROLPROC) (GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint *ids, GLboolean enabled);
typedef void (APIENTRYP PFNGLDEBUGMESSAGEINSERTPROC) (GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar *buf);
typedef void (APIENTRYP PFNGLDEBUGMESSAGECALLBACKPROC) (GLDEBUGPROC callback, const void *userParam);
typedef GLuint (APIENTRYP PFNGLGETDEBUGMESSAGELOGPROC) (GLuint count, GLsizei bufsize, GLenum *sources, GLenum *types, GLuint *ids, GLenum *severities, GLsizei *lengths, GLchar *messageLog);
typedef void (APIENTRYP PFNGLPUSHDEBUGGROUPPROC) (GLenum source, GLuint id, GLsizei length, const GLchar *message);
typedef void (APIENTRYP PFNGLPOPDEBUGGROUPPROC) (void);
typedef void (APIENTRYP PFNGLOBJECTLABELPROC) (GLenum identifier, GLuint name, GLsizei length, const GLchar *label);
typedef void (APIENTRYP PFNGLGETOBJECTLABELPROC) (GLenum identifier, GLuint name, GLsizei bufSize, GLsizei *length, GLchar *label);
typedef void (APIENTRYP PFNGLOBJECTPTRLABELPROC) (const void *ptr, GLsizei length, const GLchar *label);
typedef void (APIENTRYP PFNGLGETOBJECTPTRLABELPROC) (const void *ptr, GLsizei bufSize, GLsizei *length, GLchar *label);

/* ## GL_ARB_arrays_of_arrays ## */

/* ## GL_ARB_clear_buffer_object ## */
typedef void (APIENTRYP PFNGLCLEARBUFFERDATAPROC) (GLenum target, GLenum internalformat, GLenum format, GLenum type, const void *data);
typedef void (APIENTRYP PFNGLCLEARBUFFERSUBDATAPROC) (GLenum target, GLenum internalformat, GLintptr offset, GLsizeiptr size, GLenum format, GLenum type, const void *data);
typedef void (APIENTRYP PFNGLCLEARNAMEDBUFFERDATAEXTPROC) (GLuint buffer, GLenum internalformat, GLenum format, GLenum type, const void *data);
typedef void (APIENTRYP PFNGLCLEARNAMEDBUFFERSUBDATAEXTPROC) (GLuint buffer, GLenum internalformat, GLenum format, GLenum type, GLsizeiptr offset, GLsizeiptr size, const void *data);

/* ## GL_ARB_compute_shader ## */
typedef void (APIENTRYP PFNGLDISPATCHCOMPUTEPROC) (GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z);
typedef void (APIENTRYP PFNGLDISPATCHCOMPUTEINDIRECTPROC) (GLintptr indirect);

/* ## GL_ARB_copy_image ## */
typedef void (APIENTRYP PFNGLCOPYIMAGESUBDATAPROC) (GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei srcWidth, GLsizei srcHeight, GLsizei srcDepth);

/* ## GL_ARB_texture_view ## */
typedef void (APIENTRYP PFNGLTEXTUREVIEWPROC) (GLuint texture, GLenum target, GLuint origtexture, GLenum internalformat, GLuint minlevel, GLuint numlevels, GLuint minlayer, GLuint numlayers);

/* ## GL_ARB_vertex_attrib_binding ## */
typedef void (APIENTRYP PFNGLBINDVERTEXBUFFERPROC) (GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride);
typedef void (APIENTRYP PFNGLVERTEXATTRIBFORMATPROC) (GLuint attribindex, GLint size, GLenum type, GLboolean normalized, GLuint relativeoffset);
typedef void (APIENTRYP PFNGLVERTEXATTRIBIFORMATPROC) (GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset);
typedef void (APIENTRYP PFNGLVERTEXATTRIBLFORMATPROC) (GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset);
typedef void (APIENTRYP PFNGLVERTEXATTRIBBINDINGPROC) (GLuint attribindex, GLuint bindingindex);
typedef void (APIENTRYP PFNGLVERTEXBINDINGDIVISORPROC) (GLuint bindingindex, GLuint divisor);
typedef void (APIENTRYP PFNGLVERTEXARRAYBINDVERTEXBUFFEREXTPROC) (GLuint vaobj, GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride);
typedef void (APIENTRYP PFNGLVERTEXARRAYVERTEXATTRIBFORMATEXTPROC) (GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLboolean normalized, GLuint relativeoffset);
typedef void (APIENTRYP PFNGLVERTEXARRAYVERTEXATTRIBIFORMATEXTPROC) (GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset);
typedef void (APIENTRYP PFNGLVERTEXARRAYVERTEXATTRIBLFORMATEXTPROC) (GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset);
typedef void (APIENTRYP PFNGLVERTEXARRAYVERTEXATTRIBBINDINGEXTPROC) (GLuint vaobj, GLuint attribindex, GLuint bindingindex);
typedef void (APIENTRYP PFNGLVERTEXARRAYVERTEXBINDINGDIVISOREXTPROC) (GLuint vaobj, GLuint bindingindex, GLuint divisor);

/* ## GL_ARB_robustness_isolation ## */

/* ## GL_ARB_ES3_compatibility ## */

/* ## GL_ARB_explicit_uniform_location ## */

/* ## GL_ARB_fragment_layer_viewport ## */

/* ## GL_ARB_framebuffer_no_attachments ## */
typedef void (APIENTRYP PFNGLFRAMEBUFFERPARAMETERIPROC) (GLenum target, GLenum pname, GLint param);
typedef void (APIENTRYP PFNGLGETFRAMEBUFFERPARAMETERIVPROC) (GLenum target, GLenum pname, GLint *params);
typedef void (APIENTRYP PFNGLNAMEDFRAMEBUFFERPARAMETERIEXTPROC) (GLuint framebuffer, GLenum pname, GLint param);
typedef void (APIENTRYP PFNGLGETNAMEDFRAMEBUFFERPARAMETERIVEXTPROC) (GLuint framebuffer, GLenum pname, GLint *params);

/* ## GL_ARB_internalformat_query2 ## */
typedef void (APIENTRYP PFNGLGETINTERNALFORMATI64VPROC) (GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint64 *params);

/* ## GL_ARB_invalidate_subdata ## */
typedef void (APIENTRYP PFNGLINVALIDATETEXSUBIMAGEPROC) (GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth);
typedef void (APIENTRYP PFNGLINVALIDATETEXIMAGEPROC) (GLuint texture, GLint level);
typedef void (APIENTRYP PFNGLINVALIDATEBUFFERSUBDATAPROC) (GLuint buffer, GLintptr offset, GLsizeiptr length);
typedef void (APIENTRYP PFNGLINVALIDATEBUFFERDATAPROC) (GLuint buffer);
typedef void (APIENTRYP PFNGLINVALIDATEFRAMEBUFFERPROC) (GLenum target, GLsizei numAttachments, const GLenum *attachments);
typedef void (APIENTRYP PFNGLINVALIDATESUBFRAMEBUFFERPROC) (GLenum target, GLsizei numAttachments, const GLenum *attachments, GLint x, GLint y, GLsizei width, GLsizei height);

/* ## GL_ARB_multi_draw_indirect ## */
typedef void (APIENTRYP PFNGLMULTIDRAWARRAYSINDIRECTPROC) (GLenum mode, const void *indirect, GLsizei drawcount, GLsizei stride);
typedef void (APIENTRYP PFNGLMULTIDRAWELEMENTSINDIRECTPROC) (GLenum mode, GLenum type, const void *indirect, GLsizei drawcount, GLsizei stride);

/* ## GL_ARB_program_interface_query ## */
typedef void (APIENTRYP PFNGLGETPROGRAMINTERFACEIVPROC) (GLuint program, GLenum programInterface, GLenum pname, GLint *params);
typedef GLuint (APIENTRYP PFNGLGETPROGRAMRESOURCEINDEXPROC) (GLuint program, GLenum programInterface, const GLchar *name);
typedef void (APIENTRYP PFNGLGETPROGRAMRESOURCENAMEPROC) (GLuint program, GLenum programInterface, GLuint index, GLsizei bufSize, GLsizei *length, GLchar *name);
typedef void (APIENTRYP PFNGLGETPROGRAMRESOURCEIVPROC) (GLuint program, GLenum programInterface, GLuint index, GLsizei propCount, const GLenum *props, GLsizei bufSize, GLsizei *length, GLint *params);
typedef GLint (APIENTRYP PFNGLGETPROGRAMRESOURCELOCATIONPROC) (GLuint program, GLenum programInterface, const GLchar *name);
typedef GLint (APIENTRYP PFNGLGETPROGRAMRESOURCELOCATIONINDEXPROC) (GLuint program, GLenum programInterface, const GLchar *name);

/* ## GL_ARB_robust_buffer_access_behavior ## */

/* ## GL_ARB_shader_image_size ## */

/* ## GL_ARB_shader_storage_buffer_object ## */
typedef void (APIENTRYP PFNGLSHADERSTORAGEBLOCKBINDINGPROC) (GLuint program, GLuint storageBlockIndex, GLuint storageBlockBinding);

/* ## GL_ARB_stencil_texturing ## */

/* ## GL_ARB_texture_buffer_range ## */
typedef void (APIENTRYP PFNGLTEXBUFFERRANGEPROC) (GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size);
typedef void (APIENTRYP PFNGLTEXTUREBUFFERRANGEEXTPROC) (GLuint texture, GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size);

/* ## GL_ARB_texture_query_levels ## */

/* ## GL_ARB_texture_storage_multisample ## */
typedef void (APIENTRYP PFNGLTEXSTORAGE2DMULTISAMPLEPROC) (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations);
typedef void (APIENTRYP PFNGLTEXSTORAGE3DMULTISAMPLEPROC) (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations);
typedef void (APIENTRYP PFNGLTEXTURESTORAGE2DMULTISAMPLEEXTPROC) (GLuint texture, GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations);
typedef void (APIENTRYP PFNGLTEXTURESTORAGE3DMULTISAMPLEEXTPROC) (GLuint texture, GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations);

#pragma endregion

#pragma region function definitions

/* ## GL_VERSION_1_2 ## */
static PFNGLBLENDCOLORPROC glBlendColorPtr = NULL;
void APIENTRY glBlendColor (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
	assert(glBlendColorPtr != NULL);
	return glBlendColorPtr(red, green, blue, alpha);
}

static PFNGLBLENDEQUATIONPROC glBlendEquationPtr = NULL;
void APIENTRY glBlendEquation (GLenum mode)
{
	assert(glBlendEquationPtr != NULL);
	return glBlendEquationPtr(mode);
}

static PFNGLDRAWRANGEELEMENTSPROC glDrawRangeElementsPtr = NULL;
void APIENTRY glDrawRangeElements (GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices)
{
	assert(glDrawRangeElementsPtr != NULL);
	return glDrawRangeElementsPtr(mode, start, end, count, type, indices);
}

static PFNGLTEXIMAGE3DPROC glTexImage3DPtr = NULL;
void APIENTRY glTexImage3D (GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
	assert(glTexImage3DPtr != NULL);
	return glTexImage3DPtr(target, level, internalformat, width, height, depth, border, format, type, pixels);
}

static PFNGLTEXSUBIMAGE3DPROC glTexSubImage3DPtr = NULL;
void APIENTRY glTexSubImage3D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels)
{
	assert(glTexSubImage3DPtr != NULL);
	return glTexSubImage3DPtr(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
}

static PFNGLCOPYTEXSUBIMAGE3DPROC glCopyTexSubImage3DPtr = NULL;
void APIENTRY glCopyTexSubImage3D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height)
{
	assert(glCopyTexSubImage3DPtr != NULL);
	return glCopyTexSubImage3DPtr(target, level, xoffset, yoffset, zoffset, x, y, width, height);
}

/* ## GL_VERSION_1_3 ## */
static PFNGLACTIVETEXTUREPROC glActiveTexturePtr = NULL;
void APIENTRY glActiveTexture (GLenum texture)
{
	assert(glActiveTexturePtr != NULL);
	return glActiveTexturePtr(texture);
}

static PFNGLSAMPLECOVERAGEPROC glSampleCoveragePtr = NULL;
void APIENTRY glSampleCoverage (GLfloat value, GLboolean invert)
{
	assert(glSampleCoveragePtr != NULL);
	return glSampleCoveragePtr(value, invert);
}

static PFNGLCOMPRESSEDTEXIMAGE3DPROC glCompressedTexImage3DPtr = NULL;
void APIENTRY glCompressedTexImage3D (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid *data)
{
	assert(glCompressedTexImage3DPtr != NULL);
	return glCompressedTexImage3DPtr(target, level, internalformat, width, height, depth, border, imageSize, data);
}

static PFNGLCOMPRESSEDTEXIMAGE2DPROC glCompressedTexImage2DPtr = NULL;
void APIENTRY glCompressedTexImage2D (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *data)
{
	assert(glCompressedTexImage2DPtr != NULL);
	return glCompressedTexImage2DPtr(target, level, internalformat, width, height, border, imageSize, data);
}

static PFNGLCOMPRESSEDTEXIMAGE1DPROC glCompressedTexImage1DPtr = NULL;
void APIENTRY glCompressedTexImage1D (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid *data)
{
	assert(glCompressedTexImage1DPtr != NULL);
	return glCompressedTexImage1DPtr(target, level, internalformat, width, border, imageSize, data);
}

static PFNGLCOMPRESSEDTEXSUBIMAGE3DPROC glCompressedTexSubImage3DPtr = NULL;
void APIENTRY glCompressedTexSubImage3D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *data)
{
	assert(glCompressedTexSubImage3DPtr != NULL);
	return glCompressedTexSubImage3DPtr(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
}

static PFNGLCOMPRESSEDTEXSUBIMAGE2DPROC glCompressedTexSubImage2DPtr = NULL;
void APIENTRY glCompressedTexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *data)
{
	assert(glCompressedTexSubImage2DPtr != NULL);
	return glCompressedTexSubImage2DPtr(target, level, xoffset, yoffset, width, height, format, imageSize, data);
}

static PFNGLCOMPRESSEDTEXSUBIMAGE1DPROC glCompressedTexSubImage1DPtr = NULL;
void APIENTRY glCompressedTexSubImage1D (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *data)
{
	assert(glCompressedTexSubImage1DPtr != NULL);
	return glCompressedTexSubImage1DPtr(target, level, xoffset, width, format, imageSize, data);
}

static PFNGLGETCOMPRESSEDTEXIMAGEPROC glGetCompressedTexImagePtr = NULL;
void APIENTRY glGetCompressedTexImage (GLenum target, GLint level, GLvoid *img)
{
	assert(glGetCompressedTexImagePtr != NULL);
	return glGetCompressedTexImagePtr(target, level, img);
}

/* ## GL_VERSION_1_4 ## */
static PFNGLBLENDFUNCSEPARATEPROC glBlendFuncSeparatePtr = NULL;
void APIENTRY glBlendFuncSeparate (GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha)
{
	assert(glBlendFuncSeparatePtr != NULL);
	return glBlendFuncSeparatePtr(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);
}

static PFNGLMULTIDRAWARRAYSPROC glMultiDrawArraysPtr = NULL;
void APIENTRY glMultiDrawArrays (GLenum mode, const GLint *first, const GLsizei *count, GLsizei drawcount)
{
	assert(glMultiDrawArraysPtr != NULL);
	return glMultiDrawArraysPtr(mode, first, count, drawcount);
}

static PFNGLMULTIDRAWELEMENTSPROC glMultiDrawElementsPtr = NULL;
void APIENTRY glMultiDrawElements (GLenum mode, const GLsizei *count, GLenum type, const GLvoid* const *indices, GLsizei drawcount)
{
	assert(glMultiDrawElementsPtr != NULL);
	return glMultiDrawElementsPtr(mode, count, type, indices, drawcount);
}

static PFNGLPOINTPARAMETERFPROC glPointParameterfPtr = NULL;
void APIENTRY glPointParameterf (GLenum pname, GLfloat param)
{
	assert(glPointParameterfPtr != NULL);
	return glPointParameterfPtr(pname, param);
}

static PFNGLPOINTPARAMETERFVPROC glPointParameterfvPtr = NULL;
void APIENTRY glPointParameterfv (GLenum pname, const GLfloat *params)
{
	assert(glPointParameterfvPtr != NULL);
	return glPointParameterfvPtr(pname, params);
}

static PFNGLPOINTPARAMETERIPROC glPointParameteriPtr = NULL;
void APIENTRY glPointParameteri (GLenum pname, GLint param)
{
	assert(glPointParameteriPtr != NULL);
	return glPointParameteriPtr(pname, param);
}

static PFNGLPOINTPARAMETERIVPROC glPointParameterivPtr = NULL;
void APIENTRY glPointParameteriv (GLenum pname, const GLint *params)
{
	assert(glPointParameterivPtr != NULL);
	return glPointParameterivPtr(pname, params);
}

/* ## GL_VERSION_1_5 ## */
static PFNGLGENQUERIESPROC glGenQueriesPtr = NULL;
void APIENTRY glGenQueries (GLsizei n, GLuint *ids)
{
	assert(glGenQueriesPtr != NULL);
	return glGenQueriesPtr(n, ids);
}

static PFNGLDELETEQUERIESPROC glDeleteQueriesPtr = NULL;
void APIENTRY glDeleteQueries (GLsizei n, const GLuint *ids)
{
	assert(glDeleteQueriesPtr != NULL);
	return glDeleteQueriesPtr(n, ids);
}

static PFNGLISQUERYPROC glIsQueryPtr = NULL;
GLboolean APIENTRY glIsQuery (GLuint id)
{
	assert(glIsQueryPtr != NULL);
	return glIsQueryPtr(id);
}

static PFNGLBEGINQUERYPROC glBeginQueryPtr = NULL;
void APIENTRY glBeginQuery (GLenum target, GLuint id)
{
	assert(glBeginQueryPtr != NULL);
	return glBeginQueryPtr(target, id);
}

static PFNGLENDQUERYPROC glEndQueryPtr = NULL;
void APIENTRY glEndQuery (GLenum target)
{
	assert(glEndQueryPtr != NULL);
	return glEndQueryPtr(target);
}

static PFNGLGETQUERYIVPROC glGetQueryivPtr = NULL;
void APIENTRY glGetQueryiv (GLenum target, GLenum pname, GLint *params)
{
	assert(glGetQueryivPtr != NULL);
	return glGetQueryivPtr(target, pname, params);
}

static PFNGLGETQUERYOBJECTIVPROC glGetQueryObjectivPtr = NULL;
void APIENTRY glGetQueryObjectiv (GLuint id, GLenum pname, GLint *params)
{
	assert(glGetQueryObjectivPtr != NULL);
	return glGetQueryObjectivPtr(id, pname, params);
}

static PFNGLGETQUERYOBJECTUIVPROC glGetQueryObjectuivPtr = NULL;
void APIENTRY glGetQueryObjectuiv (GLuint id, GLenum pname, GLuint *params)
{
	assert(glGetQueryObjectuivPtr != NULL);
	return glGetQueryObjectuivPtr(id, pname, params);
}

static PFNGLBINDBUFFERPROC glBindBufferPtr = NULL;
void APIENTRY glBindBuffer (GLenum target, GLuint buffer)
{
	assert(glBindBufferPtr != NULL);
	return glBindBufferPtr(target, buffer);
}

static PFNGLDELETEBUFFERSPROC glDeleteBuffersPtr = NULL;
void APIENTRY glDeleteBuffers (GLsizei n, const GLuint *buffers)
{
	assert(glDeleteBuffersPtr != NULL);
	return glDeleteBuffersPtr(n, buffers);
}

static PFNGLGENBUFFERSPROC glGenBuffersPtr = NULL;
void APIENTRY glGenBuffers (GLsizei n, GLuint *buffers)
{
	assert(glGenBuffersPtr != NULL);
	return glGenBuffersPtr(n, buffers);
}

static PFNGLISBUFFERPROC glIsBufferPtr = NULL;
GLboolean APIENTRY glIsBuffer (GLuint buffer)
{
	assert(glIsBufferPtr != NULL);
	return glIsBufferPtr(buffer);
}

static PFNGLBUFFERDATAPROC glBufferDataPtr = NULL;
void APIENTRY glBufferData (GLenum target, GLsizeiptr size, const GLvoid *data, GLenum usage)
{
	assert(glBufferDataPtr != NULL);
	return glBufferDataPtr(target, size, data, usage);
}

static PFNGLBUFFERSUBDATAPROC glBufferSubDataPtr = NULL;
void APIENTRY glBufferSubData (GLenum target, GLintptr offset, GLsizeiptr size, const GLvoid *data)
{
	assert(glBufferSubDataPtr != NULL);
	return glBufferSubDataPtr(target, offset, size, data);
}

static PFNGLGETBUFFERSUBDATAPROC glGetBufferSubDataPtr = NULL;
void APIENTRY glGetBufferSubData (GLenum target, GLintptr offset, GLsizeiptr size, GLvoid *data)
{
	assert(glGetBufferSubDataPtr != NULL);
	return glGetBufferSubDataPtr(target, offset, size, data);
}

static PFNGLMAPBUFFERPROC glMapBufferPtr = NULL;
GLvoid* APIENTRY glMapBuffer (GLenum target, GLenum access)
{
	assert(glMapBufferPtr != NULL);
	return glMapBufferPtr(target, access);
}

static PFNGLUNMAPBUFFERPROC glUnmapBufferPtr = NULL;
GLboolean APIENTRY glUnmapBuffer (GLenum target)
{
	assert(glUnmapBufferPtr != NULL);
	return glUnmapBufferPtr(target);
}

static PFNGLGETBUFFERPARAMETERIVPROC glGetBufferParameterivPtr = NULL;
void APIENTRY glGetBufferParameteriv (GLenum target, GLenum pname, GLint *params)
{
	assert(glGetBufferParameterivPtr != NULL);
	return glGetBufferParameterivPtr(target, pname, params);
}

static PFNGLGETBUFFERPOINTERVPROC glGetBufferPointervPtr = NULL;
void APIENTRY glGetBufferPointerv (GLenum target, GLenum pname, GLvoid* *params)
{
	assert(glGetBufferPointervPtr != NULL);
	return glGetBufferPointervPtr(target, pname, params);
}

/* ## GL_VERSION_2_0 ## */
static PFNGLBLENDEQUATIONSEPARATEPROC glBlendEquationSeparatePtr = NULL;
void APIENTRY glBlendEquationSeparate (GLenum modeRGB, GLenum modeAlpha)
{
	assert(glBlendEquationSeparatePtr != NULL);
	return glBlendEquationSeparatePtr(modeRGB, modeAlpha);
}

static PFNGLDRAWBUFFERSPROC glDrawBuffersPtr = NULL;
void APIENTRY glDrawBuffers (GLsizei n, const GLenum *bufs)
{
	assert(glDrawBuffersPtr != NULL);
	return glDrawBuffersPtr(n, bufs);
}

static PFNGLSTENCILOPSEPARATEPROC glStencilOpSeparatePtr = NULL;
void APIENTRY glStencilOpSeparate (GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass)
{
	assert(glStencilOpSeparatePtr != NULL);
	return glStencilOpSeparatePtr(face, sfail, dpfail, dppass);
}

static PFNGLSTENCILFUNCSEPARATEPROC glStencilFuncSeparatePtr = NULL;
void APIENTRY glStencilFuncSeparate (GLenum face, GLenum func, GLint ref, GLuint mask)
{
	assert(glStencilFuncSeparatePtr != NULL);
	return glStencilFuncSeparatePtr(face, func, ref, mask);
}

static PFNGLSTENCILMASKSEPARATEPROC glStencilMaskSeparatePtr = NULL;
void APIENTRY glStencilMaskSeparate (GLenum face, GLuint mask)
{
	assert(glStencilMaskSeparatePtr != NULL);
	return glStencilMaskSeparatePtr(face, mask);
}

static PFNGLATTACHSHADERPROC glAttachShaderPtr = NULL;
void APIENTRY glAttachShader (GLuint program, GLuint shader)
{
	assert(glAttachShaderPtr != NULL);
	return glAttachShaderPtr(program, shader);
}

static PFNGLBINDATTRIBLOCATIONPROC glBindAttribLocationPtr = NULL;
void APIENTRY glBindAttribLocation (GLuint program, GLuint index, const GLchar *name)
{
	assert(glBindAttribLocationPtr != NULL);
	return glBindAttribLocationPtr(program, index, name);
}

static PFNGLCOMPILESHADERPROC glCompileShaderPtr = NULL;
void APIENTRY glCompileShader (GLuint shader)
{
	assert(glCompileShaderPtr != NULL);
	return glCompileShaderPtr(shader);
}

static PFNGLCREATEPROGRAMPROC glCreateProgramPtr = NULL;
GLuint APIENTRY glCreateProgram (void)
{
	assert(glCreateProgramPtr != NULL);
	return glCreateProgramPtr();
}

static PFNGLCREATESHADERPROC glCreateShaderPtr = NULL;
GLuint APIENTRY glCreateShader (GLenum type)
{
	assert(glCreateShaderPtr != NULL);
	return glCreateShaderPtr(type);
}

static PFNGLDELETEPROGRAMPROC glDeleteProgramPtr = NULL;
void APIENTRY glDeleteProgram (GLuint program)
{
	assert(glDeleteProgramPtr != NULL);
	return glDeleteProgramPtr(program);
}

static PFNGLDELETESHADERPROC glDeleteShaderPtr = NULL;
void APIENTRY glDeleteShader (GLuint shader)
{
	assert(glDeleteShaderPtr != NULL);
	return glDeleteShaderPtr(shader);
}

static PFNGLDETACHSHADERPROC glDetachShaderPtr = NULL;
void APIENTRY glDetachShader (GLuint program, GLuint shader)
{
	assert(glDetachShaderPtr != NULL);
	return glDetachShaderPtr(program, shader);
}

static PFNGLDISABLEVERTEXATTRIBARRAYPROC glDisableVertexAttribArrayPtr = NULL;
void APIENTRY glDisableVertexAttribArray (GLuint index)
{
	assert(glDisableVertexAttribArrayPtr != NULL);
	return glDisableVertexAttribArrayPtr(index);
}

static PFNGLENABLEVERTEXATTRIBARRAYPROC glEnableVertexAttribArrayPtr = NULL;
void APIENTRY glEnableVertexAttribArray (GLuint index)
{
	assert(glEnableVertexAttribArrayPtr != NULL);
	return glEnableVertexAttribArrayPtr(index);
}

static PFNGLGETACTIVEATTRIBPROC glGetActiveAttribPtr = NULL;
void APIENTRY glGetActiveAttrib (GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLint *size, GLenum *type, GLchar *name)
{
	assert(glGetActiveAttribPtr != NULL);
	return glGetActiveAttribPtr(program, index, bufSize, length, size, type, name);
}

static PFNGLGETACTIVEUNIFORMPROC glGetActiveUniformPtr = NULL;
void APIENTRY glGetActiveUniform (GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLint *size, GLenum *type, GLchar *name)
{
	assert(glGetActiveUniformPtr != NULL);
	return glGetActiveUniformPtr(program, index, bufSize, length, size, type, name);
}

static PFNGLGETATTACHEDSHADERSPROC glGetAttachedShadersPtr = NULL;
void APIENTRY glGetAttachedShaders (GLuint program, GLsizei maxCount, GLsizei *count, GLuint *obj)
{
	assert(glGetAttachedShadersPtr != NULL);
	return glGetAttachedShadersPtr(program, maxCount, count, obj);
}

static PFNGLGETATTRIBLOCATIONPROC glGetAttribLocationPtr = NULL;
GLint APIENTRY glGetAttribLocation (GLuint program, const GLchar *name)
{
	assert(glGetAttribLocationPtr != NULL);
	return glGetAttribLocationPtr(program, name);
}

static PFNGLGETPROGRAMIVPROC glGetProgramivPtr = NULL;
void APIENTRY glGetProgramiv (GLuint program, GLenum pname, GLint *params)
{
	assert(glGetProgramivPtr != NULL);
	return glGetProgramivPtr(program, pname, params);
}

static PFNGLGETPROGRAMINFOLOGPROC glGetProgramInfoLogPtr = NULL;
void APIENTRY glGetProgramInfoLog (GLuint program, GLsizei bufSize, GLsizei *length, GLchar *infoLog)
{
	assert(glGetProgramInfoLogPtr != NULL);
	return glGetProgramInfoLogPtr(program, bufSize, length, infoLog);
}

static PFNGLGETSHADERIVPROC glGetShaderivPtr = NULL;
void APIENTRY glGetShaderiv (GLuint shader, GLenum pname, GLint *params)
{
	assert(glGetShaderivPtr != NULL);
	return glGetShaderivPtr(shader, pname, params);
}

static PFNGLGETSHADERINFOLOGPROC glGetShaderInfoLogPtr = NULL;
void APIENTRY glGetShaderInfoLog (GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *infoLog)
{
	assert(glGetShaderInfoLogPtr != NULL);
	return glGetShaderInfoLogPtr(shader, bufSize, length, infoLog);
}

static PFNGLGETSHADERSOURCEPROC glGetShaderSourcePtr = NULL;
void APIENTRY glGetShaderSource (GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *source)
{
	assert(glGetShaderSourcePtr != NULL);
	return glGetShaderSourcePtr(shader, bufSize, length, source);
}

static PFNGLGETUNIFORMLOCATIONPROC glGetUniformLocationPtr = NULL;
GLint APIENTRY glGetUniformLocation (GLuint program, const GLchar *name)
{
	assert(glGetUniformLocationPtr != NULL);
	return glGetUniformLocationPtr(program, name);
}

static PFNGLGETUNIFORMFVPROC glGetUniformfvPtr = NULL;
void APIENTRY glGetUniformfv (GLuint program, GLint location, GLfloat *params)
{
	assert(glGetUniformfvPtr != NULL);
	return glGetUniformfvPtr(program, location, params);
}

static PFNGLGETUNIFORMIVPROC glGetUniformivPtr = NULL;
void APIENTRY glGetUniformiv (GLuint program, GLint location, GLint *params)
{
	assert(glGetUniformivPtr != NULL);
	return glGetUniformivPtr(program, location, params);
}

static PFNGLGETVERTEXATTRIBDVPROC glGetVertexAttribdvPtr = NULL;
void APIENTRY glGetVertexAttribdv (GLuint index, GLenum pname, GLdouble *params)
{
	assert(glGetVertexAttribdvPtr != NULL);
	return glGetVertexAttribdvPtr(index, pname, params);
}

static PFNGLGETVERTEXATTRIBFVPROC glGetVertexAttribfvPtr = NULL;
void APIENTRY glGetVertexAttribfv (GLuint index, GLenum pname, GLfloat *params)
{
	assert(glGetVertexAttribfvPtr != NULL);
	return glGetVertexAttribfvPtr(index, pname, params);
}

static PFNGLGETVERTEXATTRIBIVPROC glGetVertexAttribivPtr = NULL;
void APIENTRY glGetVertexAttribiv (GLuint index, GLenum pname, GLint *params)
{
	assert(glGetVertexAttribivPtr != NULL);
	return glGetVertexAttribivPtr(index, pname, params);
}

static PFNGLGETVERTEXATTRIBPOINTERVPROC glGetVertexAttribPointervPtr = NULL;
void APIENTRY glGetVertexAttribPointerv (GLuint index, GLenum pname, GLvoid* *pointer)
{
	assert(glGetVertexAttribPointervPtr != NULL);
	return glGetVertexAttribPointervPtr(index, pname, pointer);
}

static PFNGLISPROGRAMPROC glIsProgramPtr = NULL;
GLboolean APIENTRY glIsProgram (GLuint program)
{
	assert(glIsProgramPtr != NULL);
	return glIsProgramPtr(program);
}

static PFNGLISSHADERPROC glIsShaderPtr = NULL;
GLboolean APIENTRY glIsShader (GLuint shader)
{
	assert(glIsShaderPtr != NULL);
	return glIsShaderPtr(shader);
}

static PFNGLLINKPROGRAMPROC glLinkProgramPtr = NULL;
void APIENTRY glLinkProgram (GLuint program)
{
	assert(glLinkProgramPtr != NULL);
	return glLinkProgramPtr(program);
}

static PFNGLSHADERSOURCEPROC glShaderSourcePtr = NULL;
void APIENTRY glShaderSource (GLuint shader, GLsizei count, const GLchar* const *string, const GLint *length)
{
	assert(glShaderSourcePtr != NULL);
	return glShaderSourcePtr(shader, count, string, length);
}

static PFNGLUSEPROGRAMPROC glUseProgramPtr = NULL;
void APIENTRY glUseProgram (GLuint program)
{
	assert(glUseProgramPtr != NULL);
	return glUseProgramPtr(program);
}

static PFNGLUNIFORM1FPROC glUniform1fPtr = NULL;
void APIENTRY glUniform1f (GLint location, GLfloat v0)
{
	assert(glUniform1fPtr != NULL);
	return glUniform1fPtr(location, v0);
}

static PFNGLUNIFORM2FPROC glUniform2fPtr = NULL;
void APIENTRY glUniform2f (GLint location, GLfloat v0, GLfloat v1)
{
	assert(glUniform2fPtr != NULL);
	return glUniform2fPtr(location, v0, v1);
}

static PFNGLUNIFORM3FPROC glUniform3fPtr = NULL;
void APIENTRY glUniform3f (GLint location, GLfloat v0, GLfloat v1, GLfloat v2)
{
	assert(glUniform3fPtr != NULL);
	return glUniform3fPtr(location, v0, v1, v2);
}

static PFNGLUNIFORM4FPROC glUniform4fPtr = NULL;
void APIENTRY glUniform4f (GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)
{
	assert(glUniform4fPtr != NULL);
	return glUniform4fPtr(location, v0, v1, v2, v3);
}

static PFNGLUNIFORM1IPROC glUniform1iPtr = NULL;
void APIENTRY glUniform1i (GLint location, GLint v0)
{
	assert(glUniform1iPtr != NULL);
	return glUniform1iPtr(location, v0);
}

static PFNGLUNIFORM2IPROC glUniform2iPtr = NULL;
void APIENTRY glUniform2i (GLint location, GLint v0, GLint v1)
{
	assert(glUniform2iPtr != NULL);
	return glUniform2iPtr(location, v0, v1);
}

static PFNGLUNIFORM3IPROC glUniform3iPtr = NULL;
void APIENTRY glUniform3i (GLint location, GLint v0, GLint v1, GLint v2)
{
	assert(glUniform3iPtr != NULL);
	return glUniform3iPtr(location, v0, v1, v2);
}

static PFNGLUNIFORM4IPROC glUniform4iPtr = NULL;
void APIENTRY glUniform4i (GLint location, GLint v0, GLint v1, GLint v2, GLint v3)
{
	assert(glUniform4iPtr != NULL);
	return glUniform4iPtr(location, v0, v1, v2, v3);
}

static PFNGLUNIFORM1FVPROC glUniform1fvPtr = NULL;
void APIENTRY glUniform1fv (GLint location, GLsizei count, const GLfloat *value)
{
	assert(glUniform1fvPtr != NULL);
	return glUniform1fvPtr(location, count, value);
}

static PFNGLUNIFORM2FVPROC glUniform2fvPtr = NULL;
void APIENTRY glUniform2fv (GLint location, GLsizei count, const GLfloat *value)
{
	assert(glUniform2fvPtr != NULL);
	return glUniform2fvPtr(location, count, value);
}

static PFNGLUNIFORM3FVPROC glUniform3fvPtr = NULL;
void APIENTRY glUniform3fv (GLint location, GLsizei count, const GLfloat *value)
{
	assert(glUniform3fvPtr != NULL);
	return glUniform3fvPtr(location, count, value);
}

static PFNGLUNIFORM4FVPROC glUniform4fvPtr = NULL;
void APIENTRY glUniform4fv (GLint location, GLsizei count, const GLfloat *value)
{
	assert(glUniform4fvPtr != NULL);
	return glUniform4fvPtr(location, count, value);
}

static PFNGLUNIFORM1IVPROC glUniform1ivPtr = NULL;
void APIENTRY glUniform1iv (GLint location, GLsizei count, const GLint *value)
{
	assert(glUniform1ivPtr != NULL);
	return glUniform1ivPtr(location, count, value);
}

static PFNGLUNIFORM2IVPROC glUniform2ivPtr = NULL;
void APIENTRY glUniform2iv (GLint location, GLsizei count, const GLint *value)
{
	assert(glUniform2ivPtr != NULL);
	return glUniform2ivPtr(location, count, value);
}

static PFNGLUNIFORM3IVPROC glUniform3ivPtr = NULL;
void APIENTRY glUniform3iv (GLint location, GLsizei count, const GLint *value)
{
	assert(glUniform3ivPtr != NULL);
	return glUniform3ivPtr(location, count, value);
}

static PFNGLUNIFORM4IVPROC glUniform4ivPtr = NULL;
void APIENTRY glUniform4iv (GLint location, GLsizei count, const GLint *value)
{
	assert(glUniform4ivPtr != NULL);
	return glUniform4ivPtr(location, count, value);
}

static PFNGLUNIFORMMATRIX2FVPROC glUniformMatrix2fvPtr = NULL;
void APIENTRY glUniformMatrix2fv (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
	assert(glUniformMatrix2fvPtr != NULL);
	return glUniformMatrix2fvPtr(location, count, transpose, value);
}

static PFNGLUNIFORMMATRIX3FVPROC glUniformMatrix3fvPtr = NULL;
void APIENTRY glUniformMatrix3fv (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
	assert(glUniformMatrix3fvPtr != NULL);
	return glUniformMatrix3fvPtr(location, count, transpose, value);
}

static PFNGLUNIFORMMATRIX4FVPROC glUniformMatrix4fvPtr = NULL;
void APIENTRY glUniformMatrix4fv (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
	assert(glUniformMatrix4fvPtr != NULL);
	return glUniformMatrix4fvPtr(location, count, transpose, value);
}

static PFNGLVALIDATEPROGRAMPROC glValidateProgramPtr = NULL;
void APIENTRY glValidateProgram (GLuint program)
{
	assert(glValidateProgramPtr != NULL);
	return glValidateProgramPtr(program);
}

static PFNGLVERTEXATTRIB1DPROC glVertexAttrib1dPtr = NULL;
void APIENTRY glVertexAttrib1d (GLuint index, GLdouble x)
{
	assert(glVertexAttrib1dPtr != NULL);
	return glVertexAttrib1dPtr(index, x);
}

static PFNGLVERTEXATTRIB1DVPROC glVertexAttrib1dvPtr = NULL;
void APIENTRY glVertexAttrib1dv (GLuint index, const GLdouble *v)
{
	assert(glVertexAttrib1dvPtr != NULL);
	return glVertexAttrib1dvPtr(index, v);
}

static PFNGLVERTEXATTRIB1FPROC glVertexAttrib1fPtr = NULL;
void APIENTRY glVertexAttrib1f (GLuint index, GLfloat x)
{
	assert(glVertexAttrib1fPtr != NULL);
	return glVertexAttrib1fPtr(index, x);
}

static PFNGLVERTEXATTRIB1FVPROC glVertexAttrib1fvPtr = NULL;
void APIENTRY glVertexAttrib1fv (GLuint index, const GLfloat *v)
{
	assert(glVertexAttrib1fvPtr != NULL);
	return glVertexAttrib1fvPtr(index, v);
}

static PFNGLVERTEXATTRIB1SPROC glVertexAttrib1sPtr = NULL;
void APIENTRY glVertexAttrib1s (GLuint index, GLshort x)
{
	assert(glVertexAttrib1sPtr != NULL);
	return glVertexAttrib1sPtr(index, x);
}

static PFNGLVERTEXATTRIB1SVPROC glVertexAttrib1svPtr = NULL;
void APIENTRY glVertexAttrib1sv (GLuint index, const GLshort *v)
{
	assert(glVertexAttrib1svPtr != NULL);
	return glVertexAttrib1svPtr(index, v);
}

static PFNGLVERTEXATTRIB2DPROC glVertexAttrib2dPtr = NULL;
void APIENTRY glVertexAttrib2d (GLuint index, GLdouble x, GLdouble y)
{
	assert(glVertexAttrib2dPtr != NULL);
	return glVertexAttrib2dPtr(index, x, y);
}

static PFNGLVERTEXATTRIB2DVPROC glVertexAttrib2dvPtr = NULL;
void APIENTRY glVertexAttrib2dv (GLuint index, const GLdouble *v)
{
	assert(glVertexAttrib2dvPtr != NULL);
	return glVertexAttrib2dvPtr(index, v);
}

static PFNGLVERTEXATTRIB2FPROC glVertexAttrib2fPtr = NULL;
void APIENTRY glVertexAttrib2f (GLuint index, GLfloat x, GLfloat y)
{
	assert(glVertexAttrib2fPtr != NULL);
	return glVertexAttrib2fPtr(index, x, y);
}

static PFNGLVERTEXATTRIB2FVPROC glVertexAttrib2fvPtr = NULL;
void APIENTRY glVertexAttrib2fv (GLuint index, const GLfloat *v)
{
	assert(glVertexAttrib2fvPtr != NULL);
	return glVertexAttrib2fvPtr(index, v);
}

static PFNGLVERTEXATTRIB2SPROC glVertexAttrib2sPtr = NULL;
void APIENTRY glVertexAttrib2s (GLuint index, GLshort x, GLshort y)
{
	assert(glVertexAttrib2sPtr != NULL);
	return glVertexAttrib2sPtr(index, x, y);
}

static PFNGLVERTEXATTRIB2SVPROC glVertexAttrib2svPtr = NULL;
void APIENTRY glVertexAttrib2sv (GLuint index, const GLshort *v)
{
	assert(glVertexAttrib2svPtr != NULL);
	return glVertexAttrib2svPtr(index, v);
}

static PFNGLVERTEXATTRIB3DPROC glVertexAttrib3dPtr = NULL;
void APIENTRY glVertexAttrib3d (GLuint index, GLdouble x, GLdouble y, GLdouble z)
{
	assert(glVertexAttrib3dPtr != NULL);
	return glVertexAttrib3dPtr(index, x, y, z);
}

static PFNGLVERTEXATTRIB3DVPROC glVertexAttrib3dvPtr = NULL;
void APIENTRY glVertexAttrib3dv (GLuint index, const GLdouble *v)
{
	assert(glVertexAttrib3dvPtr != NULL);
	return glVertexAttrib3dvPtr(index, v);
}

static PFNGLVERTEXATTRIB3FPROC glVertexAttrib3fPtr = NULL;
void APIENTRY glVertexAttrib3f (GLuint index, GLfloat x, GLfloat y, GLfloat z)
{
	assert(glVertexAttrib3fPtr != NULL);
	return glVertexAttrib3fPtr(index, x, y, z);
}

static PFNGLVERTEXATTRIB3FVPROC glVertexAttrib3fvPtr = NULL;
void APIENTRY glVertexAttrib3fv (GLuint index, const GLfloat *v)
{
	assert(glVertexAttrib3fvPtr != NULL);
	return glVertexAttrib3fvPtr(index, v);
}

static PFNGLVERTEXATTRIB3SPROC glVertexAttrib3sPtr = NULL;
void APIENTRY glVertexAttrib3s (GLuint index, GLshort x, GLshort y, GLshort z)
{
	assert(glVertexAttrib3sPtr != NULL);
	return glVertexAttrib3sPtr(index, x, y, z);
}

static PFNGLVERTEXATTRIB3SVPROC glVertexAttrib3svPtr = NULL;
void APIENTRY glVertexAttrib3sv (GLuint index, const GLshort *v)
{
	assert(glVertexAttrib3svPtr != NULL);
	return glVertexAttrib3svPtr(index, v);
}

static PFNGLVERTEXATTRIB4NBVPROC glVertexAttrib4NbvPtr = NULL;
void APIENTRY glVertexAttrib4Nbv (GLuint index, const GLbyte *v)
{
	assert(glVertexAttrib4NbvPtr != NULL);
	return glVertexAttrib4NbvPtr(index, v);
}

static PFNGLVERTEXATTRIB4NIVPROC glVertexAttrib4NivPtr = NULL;
void APIENTRY glVertexAttrib4Niv (GLuint index, const GLint *v)
{
	assert(glVertexAttrib4NivPtr != NULL);
	return glVertexAttrib4NivPtr(index, v);
}

static PFNGLVERTEXATTRIB4NSVPROC glVertexAttrib4NsvPtr = NULL;
void APIENTRY glVertexAttrib4Nsv (GLuint index, const GLshort *v)
{
	assert(glVertexAttrib4NsvPtr != NULL);
	return glVertexAttrib4NsvPtr(index, v);
}

static PFNGLVERTEXATTRIB4NUBPROC glVertexAttrib4NubPtr = NULL;
void APIENTRY glVertexAttrib4Nub (GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w)
{
	assert(glVertexAttrib4NubPtr != NULL);
	return glVertexAttrib4NubPtr(index, x, y, z, w);
}

static PFNGLVERTEXATTRIB4NUBVPROC glVertexAttrib4NubvPtr = NULL;
void APIENTRY glVertexAttrib4Nubv (GLuint index, const GLubyte *v)
{
	assert(glVertexAttrib4NubvPtr != NULL);
	return glVertexAttrib4NubvPtr(index, v);
}

static PFNGLVERTEXATTRIB4NUIVPROC glVertexAttrib4NuivPtr = NULL;
void APIENTRY glVertexAttrib4Nuiv (GLuint index, const GLuint *v)
{
	assert(glVertexAttrib4NuivPtr != NULL);
	return glVertexAttrib4NuivPtr(index, v);
}

static PFNGLVERTEXATTRIB4NUSVPROC glVertexAttrib4NusvPtr = NULL;
void APIENTRY glVertexAttrib4Nusv (GLuint index, const GLushort *v)
{
	assert(glVertexAttrib4NusvPtr != NULL);
	return glVertexAttrib4NusvPtr(index, v);
}

static PFNGLVERTEXATTRIB4BVPROC glVertexAttrib4bvPtr = NULL;
void APIENTRY glVertexAttrib4bv (GLuint index, const GLbyte *v)
{
	assert(glVertexAttrib4bvPtr != NULL);
	return glVertexAttrib4bvPtr(index, v);
}

static PFNGLVERTEXATTRIB4DPROC glVertexAttrib4dPtr = NULL;
void APIENTRY glVertexAttrib4d (GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
	assert(glVertexAttrib4dPtr != NULL);
	return glVertexAttrib4dPtr(index, x, y, z, w);
}

static PFNGLVERTEXATTRIB4DVPROC glVertexAttrib4dvPtr = NULL;
void APIENTRY glVertexAttrib4dv (GLuint index, const GLdouble *v)
{
	assert(glVertexAttrib4dvPtr != NULL);
	return glVertexAttrib4dvPtr(index, v);
}

static PFNGLVERTEXATTRIB4FPROC glVertexAttrib4fPtr = NULL;
void APIENTRY glVertexAttrib4f (GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
	assert(glVertexAttrib4fPtr != NULL);
	return glVertexAttrib4fPtr(index, x, y, z, w);
}

static PFNGLVERTEXATTRIB4FVPROC glVertexAttrib4fvPtr = NULL;
void APIENTRY glVertexAttrib4fv (GLuint index, const GLfloat *v)
{
	assert(glVertexAttrib4fvPtr != NULL);
	return glVertexAttrib4fvPtr(index, v);
}

static PFNGLVERTEXATTRIB4IVPROC glVertexAttrib4ivPtr = NULL;
void APIENTRY glVertexAttrib4iv (GLuint index, const GLint *v)
{
	assert(glVertexAttrib4ivPtr != NULL);
	return glVertexAttrib4ivPtr(index, v);
}

static PFNGLVERTEXATTRIB4SPROC glVertexAttrib4sPtr = NULL;
void APIENTRY glVertexAttrib4s (GLuint index, GLshort x, GLshort y, GLshort z, GLshort w)
{
	assert(glVertexAttrib4sPtr != NULL);
	return glVertexAttrib4sPtr(index, x, y, z, w);
}

static PFNGLVERTEXATTRIB4SVPROC glVertexAttrib4svPtr = NULL;
void APIENTRY glVertexAttrib4sv (GLuint index, const GLshort *v)
{
	assert(glVertexAttrib4svPtr != NULL);
	return glVertexAttrib4svPtr(index, v);
}

static PFNGLVERTEXATTRIB4UBVPROC glVertexAttrib4ubvPtr = NULL;
void APIENTRY glVertexAttrib4ubv (GLuint index, const GLubyte *v)
{
	assert(glVertexAttrib4ubvPtr != NULL);
	return glVertexAttrib4ubvPtr(index, v);
}

static PFNGLVERTEXATTRIB4UIVPROC glVertexAttrib4uivPtr = NULL;
void APIENTRY glVertexAttrib4uiv (GLuint index, const GLuint *v)
{
	assert(glVertexAttrib4uivPtr != NULL);
	return glVertexAttrib4uivPtr(index, v);
}

static PFNGLVERTEXATTRIB4USVPROC glVertexAttrib4usvPtr = NULL;
void APIENTRY glVertexAttrib4usv (GLuint index, const GLushort *v)
{
	assert(glVertexAttrib4usvPtr != NULL);
	return glVertexAttrib4usvPtr(index, v);
}

static PFNGLVERTEXATTRIBPOINTERPROC glVertexAttribPointerPtr = NULL;
void APIENTRY glVertexAttribPointer (GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid *pointer)
{
	assert(glVertexAttribPointerPtr != NULL);
	return glVertexAttribPointerPtr(index, size, type, normalized, stride, pointer);
}

/* ## GL_VERSION_2_1 ## */
static PFNGLUNIFORMMATRIX2X3FVPROC glUniformMatrix2x3fvPtr = NULL;
void APIENTRY glUniformMatrix2x3fv (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
	assert(glUniformMatrix2x3fvPtr != NULL);
	return glUniformMatrix2x3fvPtr(location, count, transpose, value);
}

static PFNGLUNIFORMMATRIX3X2FVPROC glUniformMatrix3x2fvPtr = NULL;
void APIENTRY glUniformMatrix3x2fv (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
	assert(glUniformMatrix3x2fvPtr != NULL);
	return glUniformMatrix3x2fvPtr(location, count, transpose, value);
}

static PFNGLUNIFORMMATRIX2X4FVPROC glUniformMatrix2x4fvPtr = NULL;
void APIENTRY glUniformMatrix2x4fv (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
	assert(glUniformMatrix2x4fvPtr != NULL);
	return glUniformMatrix2x4fvPtr(location, count, transpose, value);
}

static PFNGLUNIFORMMATRIX4X2FVPROC glUniformMatrix4x2fvPtr = NULL;
void APIENTRY glUniformMatrix4x2fv (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
	assert(glUniformMatrix4x2fvPtr != NULL);
	return glUniformMatrix4x2fvPtr(location, count, transpose, value);
}

static PFNGLUNIFORMMATRIX3X4FVPROC glUniformMatrix3x4fvPtr = NULL;
void APIENTRY glUniformMatrix3x4fv (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
	assert(glUniformMatrix3x4fvPtr != NULL);
	return glUniformMatrix3x4fvPtr(location, count, transpose, value);
}

static PFNGLUNIFORMMATRIX4X3FVPROC glUniformMatrix4x3fvPtr = NULL;
void APIENTRY glUniformMatrix4x3fv (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
	assert(glUniformMatrix4x3fvPtr != NULL);
	return glUniformMatrix4x3fvPtr(location, count, transpose, value);
}

/* ## GL_VERSION_3_0 ## */
static PFNGLCOLORMASKIPROC glColorMaskiPtr = NULL;
void APIENTRY glColorMaski (GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a)
{
	assert(glColorMaskiPtr != NULL);
	return glColorMaskiPtr(index, r, g, b, a);
}

static PFNGLGETBOOLEANI_VPROC glGetBooleani_vPtr = NULL;
void APIENTRY glGetBooleani_v (GLenum target, GLuint index, GLboolean *data)
{
	assert(glGetBooleani_vPtr != NULL);
	return glGetBooleani_vPtr(target, index, data);
}

static PFNGLGETINTEGERI_VPROC glGetIntegeri_vPtr = NULL;
void APIENTRY glGetIntegeri_v (GLenum target, GLuint index, GLint *data)
{
	assert(glGetIntegeri_vPtr != NULL);
	return glGetIntegeri_vPtr(target, index, data);
}

static PFNGLENABLEIPROC glEnableiPtr = NULL;
void APIENTRY glEnablei (GLenum target, GLuint index)
{
	assert(glEnableiPtr != NULL);
	return glEnableiPtr(target, index);
}

static PFNGLDISABLEIPROC glDisableiPtr = NULL;
void APIENTRY glDisablei (GLenum target, GLuint index)
{
	assert(glDisableiPtr != NULL);
	return glDisableiPtr(target, index);
}

static PFNGLISENABLEDIPROC glIsEnablediPtr = NULL;
GLboolean APIENTRY glIsEnabledi (GLenum target, GLuint index)
{
	assert(glIsEnablediPtr != NULL);
	return glIsEnablediPtr(target, index);
}

static PFNGLBEGINTRANSFORMFEEDBACKPROC glBeginTransformFeedbackPtr = NULL;
void APIENTRY glBeginTransformFeedback (GLenum primitiveMode)
{
	assert(glBeginTransformFeedbackPtr != NULL);
	return glBeginTransformFeedbackPtr(primitiveMode);
}

static PFNGLENDTRANSFORMFEEDBACKPROC glEndTransformFeedbackPtr = NULL;
void APIENTRY glEndTransformFeedback (void)
{
	assert(glEndTransformFeedbackPtr != NULL);
	return glEndTransformFeedbackPtr();
}

static PFNGLBINDBUFFERRANGEPROC glBindBufferRangePtr = NULL;
void APIENTRY glBindBufferRange (GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size)
{
	assert(glBindBufferRangePtr != NULL);
	return glBindBufferRangePtr(target, index, buffer, offset, size);
}

static PFNGLBINDBUFFERBASEPROC glBindBufferBasePtr = NULL;
void APIENTRY glBindBufferBase (GLenum target, GLuint index, GLuint buffer)
{
	assert(glBindBufferBasePtr != NULL);
	return glBindBufferBasePtr(target, index, buffer);
}

static PFNGLTRANSFORMFEEDBACKVARYINGSPROC glTransformFeedbackVaryingsPtr = NULL;
void APIENTRY glTransformFeedbackVaryings (GLuint program, GLsizei count, const GLchar* const *varyings, GLenum bufferMode)
{
	assert(glTransformFeedbackVaryingsPtr != NULL);
	return glTransformFeedbackVaryingsPtr(program, count, varyings, bufferMode);
}

static PFNGLGETTRANSFORMFEEDBACKVARYINGPROC glGetTransformFeedbackVaryingPtr = NULL;
void APIENTRY glGetTransformFeedbackVarying (GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name)
{
	assert(glGetTransformFeedbackVaryingPtr != NULL);
	return glGetTransformFeedbackVaryingPtr(program, index, bufSize, length, size, type, name);
}

static PFNGLCLAMPCOLORPROC glClampColorPtr = NULL;
void APIENTRY glClampColor (GLenum target, GLenum clamp)
{
	assert(glClampColorPtr != NULL);
	return glClampColorPtr(target, clamp);
}

static PFNGLBEGINCONDITIONALRENDERPROC glBeginConditionalRenderPtr = NULL;
void APIENTRY glBeginConditionalRender (GLuint id, GLenum mode)
{
	assert(glBeginConditionalRenderPtr != NULL);
	return glBeginConditionalRenderPtr(id, mode);
}

static PFNGLENDCONDITIONALRENDERPROC glEndConditionalRenderPtr = NULL;
void APIENTRY glEndConditionalRender (void)
{
	assert(glEndConditionalRenderPtr != NULL);
	return glEndConditionalRenderPtr();
}

static PFNGLVERTEXATTRIBIPOINTERPROC glVertexAttribIPointerPtr = NULL;
void APIENTRY glVertexAttribIPointer (GLuint index, GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)
{
	assert(glVertexAttribIPointerPtr != NULL);
	return glVertexAttribIPointerPtr(index, size, type, stride, pointer);
}

static PFNGLGETVERTEXATTRIBIIVPROC glGetVertexAttribIivPtr = NULL;
void APIENTRY glGetVertexAttribIiv (GLuint index, GLenum pname, GLint *params)
{
	assert(glGetVertexAttribIivPtr != NULL);
	return glGetVertexAttribIivPtr(index, pname, params);
}

static PFNGLGETVERTEXATTRIBIUIVPROC glGetVertexAttribIuivPtr = NULL;
void APIENTRY glGetVertexAttribIuiv (GLuint index, GLenum pname, GLuint *params)
{
	assert(glGetVertexAttribIuivPtr != NULL);
	return glGetVertexAttribIuivPtr(index, pname, params);
}

static PFNGLVERTEXATTRIBI1IPROC glVertexAttribI1iPtr = NULL;
void APIENTRY glVertexAttribI1i (GLuint index, GLint x)
{
	assert(glVertexAttribI1iPtr != NULL);
	return glVertexAttribI1iPtr(index, x);
}

static PFNGLVERTEXATTRIBI2IPROC glVertexAttribI2iPtr = NULL;
void APIENTRY glVertexAttribI2i (GLuint index, GLint x, GLint y)
{
	assert(glVertexAttribI2iPtr != NULL);
	return glVertexAttribI2iPtr(index, x, y);
}

static PFNGLVERTEXATTRIBI3IPROC glVertexAttribI3iPtr = NULL;
void APIENTRY glVertexAttribI3i (GLuint index, GLint x, GLint y, GLint z)
{
	assert(glVertexAttribI3iPtr != NULL);
	return glVertexAttribI3iPtr(index, x, y, z);
}

static PFNGLVERTEXATTRIBI4IPROC glVertexAttribI4iPtr = NULL;
void APIENTRY glVertexAttribI4i (GLuint index, GLint x, GLint y, GLint z, GLint w)
{
	assert(glVertexAttribI4iPtr != NULL);
	return glVertexAttribI4iPtr(index, x, y, z, w);
}

static PFNGLVERTEXATTRIBI1UIPROC glVertexAttribI1uiPtr = NULL;
void APIENTRY glVertexAttribI1ui (GLuint index, GLuint x)
{
	assert(glVertexAttribI1uiPtr != NULL);
	return glVertexAttribI1uiPtr(index, x);
}

static PFNGLVERTEXATTRIBI2UIPROC glVertexAttribI2uiPtr = NULL;
void APIENTRY glVertexAttribI2ui (GLuint index, GLuint x, GLuint y)
{
	assert(glVertexAttribI2uiPtr != NULL);
	return glVertexAttribI2uiPtr(index, x, y);
}

static PFNGLVERTEXATTRIBI3UIPROC glVertexAttribI3uiPtr = NULL;
void APIENTRY glVertexAttribI3ui (GLuint index, GLuint x, GLuint y, GLuint z)
{
	assert(glVertexAttribI3uiPtr != NULL);
	return glVertexAttribI3uiPtr(index, x, y, z);
}

static PFNGLVERTEXATTRIBI4UIPROC glVertexAttribI4uiPtr = NULL;
void APIENTRY glVertexAttribI4ui (GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)
{
	assert(glVertexAttribI4uiPtr != NULL);
	return glVertexAttribI4uiPtr(index, x, y, z, w);
}

static PFNGLVERTEXATTRIBI1IVPROC glVertexAttribI1ivPtr = NULL;
void APIENTRY glVertexAttribI1iv (GLuint index, const GLint *v)
{
	assert(glVertexAttribI1ivPtr != NULL);
	return glVertexAttribI1ivPtr(index, v);
}

static PFNGLVERTEXATTRIBI2IVPROC glVertexAttribI2ivPtr = NULL;
void APIENTRY glVertexAttribI2iv (GLuint index, const GLint *v)
{
	assert(glVertexAttribI2ivPtr != NULL);
	return glVertexAttribI2ivPtr(index, v);
}

static PFNGLVERTEXATTRIBI3IVPROC glVertexAttribI3ivPtr = NULL;
void APIENTRY glVertexAttribI3iv (GLuint index, const GLint *v)
{
	assert(glVertexAttribI3ivPtr != NULL);
	return glVertexAttribI3ivPtr(index, v);
}

static PFNGLVERTEXATTRIBI4IVPROC glVertexAttribI4ivPtr = NULL;
void APIENTRY glVertexAttribI4iv (GLuint index, const GLint *v)
{
	assert(glVertexAttribI4ivPtr != NULL);
	return glVertexAttribI4ivPtr(index, v);
}

static PFNGLVERTEXATTRIBI1UIVPROC glVertexAttribI1uivPtr = NULL;
void APIENTRY glVertexAttribI1uiv (GLuint index, const GLuint *v)
{
	assert(glVertexAttribI1uivPtr != NULL);
	return glVertexAttribI1uivPtr(index, v);
}

static PFNGLVERTEXATTRIBI2UIVPROC glVertexAttribI2uivPtr = NULL;
void APIENTRY glVertexAttribI2uiv (GLuint index, const GLuint *v)
{
	assert(glVertexAttribI2uivPtr != NULL);
	return glVertexAttribI2uivPtr(index, v);
}

static PFNGLVERTEXATTRIBI3UIVPROC glVertexAttribI3uivPtr = NULL;
void APIENTRY glVertexAttribI3uiv (GLuint index, const GLuint *v)
{
	assert(glVertexAttribI3uivPtr != NULL);
	return glVertexAttribI3uivPtr(index, v);
}

static PFNGLVERTEXATTRIBI4UIVPROC glVertexAttribI4uivPtr = NULL;
void APIENTRY glVertexAttribI4uiv (GLuint index, const GLuint *v)
{
	assert(glVertexAttribI4uivPtr != NULL);
	return glVertexAttribI4uivPtr(index, v);
}

static PFNGLVERTEXATTRIBI4BVPROC glVertexAttribI4bvPtr = NULL;
void APIENTRY glVertexAttribI4bv (GLuint index, const GLbyte *v)
{
	assert(glVertexAttribI4bvPtr != NULL);
	return glVertexAttribI4bvPtr(index, v);
}

static PFNGLVERTEXATTRIBI4SVPROC glVertexAttribI4svPtr = NULL;
void APIENTRY glVertexAttribI4sv (GLuint index, const GLshort *v)
{
	assert(glVertexAttribI4svPtr != NULL);
	return glVertexAttribI4svPtr(index, v);
}

static PFNGLVERTEXATTRIBI4UBVPROC glVertexAttribI4ubvPtr = NULL;
void APIENTRY glVertexAttribI4ubv (GLuint index, const GLubyte *v)
{
	assert(glVertexAttribI4ubvPtr != NULL);
	return glVertexAttribI4ubvPtr(index, v);
}

static PFNGLVERTEXATTRIBI4USVPROC glVertexAttribI4usvPtr = NULL;
void APIENTRY glVertexAttribI4usv (GLuint index, const GLushort *v)
{
	assert(glVertexAttribI4usvPtr != NULL);
	return glVertexAttribI4usvPtr(index, v);
}

static PFNGLGETUNIFORMUIVPROC glGetUniformuivPtr = NULL;
void APIENTRY glGetUniformuiv (GLuint program, GLint location, GLuint *params)
{
	assert(glGetUniformuivPtr != NULL);
	return glGetUniformuivPtr(program, location, params);
}

static PFNGLBINDFRAGDATALOCATIONPROC glBindFragDataLocationPtr = NULL;
void APIENTRY glBindFragDataLocation (GLuint program, GLuint color, const GLchar *name)
{
	assert(glBindFragDataLocationPtr != NULL);
	return glBindFragDataLocationPtr(program, color, name);
}

static PFNGLGETFRAGDATALOCATIONPROC glGetFragDataLocationPtr = NULL;
GLint APIENTRY glGetFragDataLocation (GLuint program, const GLchar *name)
{
	assert(glGetFragDataLocationPtr != NULL);
	return glGetFragDataLocationPtr(program, name);
}

static PFNGLUNIFORM1UIPROC glUniform1uiPtr = NULL;
void APIENTRY glUniform1ui (GLint location, GLuint v0)
{
	assert(glUniform1uiPtr != NULL);
	return glUniform1uiPtr(location, v0);
}

static PFNGLUNIFORM2UIPROC glUniform2uiPtr = NULL;
void APIENTRY glUniform2ui (GLint location, GLuint v0, GLuint v1)
{
	assert(glUniform2uiPtr != NULL);
	return glUniform2uiPtr(location, v0, v1);
}

static PFNGLUNIFORM3UIPROC glUniform3uiPtr = NULL;
void APIENTRY glUniform3ui (GLint location, GLuint v0, GLuint v1, GLuint v2)
{
	assert(glUniform3uiPtr != NULL);
	return glUniform3uiPtr(location, v0, v1, v2);
}

static PFNGLUNIFORM4UIPROC glUniform4uiPtr = NULL;
void APIENTRY glUniform4ui (GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)
{
	assert(glUniform4uiPtr != NULL);
	return glUniform4uiPtr(location, v0, v1, v2, v3);
}

static PFNGLUNIFORM1UIVPROC glUniform1uivPtr = NULL;
void APIENTRY glUniform1uiv (GLint location, GLsizei count, const GLuint *value)
{
	assert(glUniform1uivPtr != NULL);
	return glUniform1uivPtr(location, count, value);
}

static PFNGLUNIFORM2UIVPROC glUniform2uivPtr = NULL;
void APIENTRY glUniform2uiv (GLint location, GLsizei count, const GLuint *value)
{
	assert(glUniform2uivPtr != NULL);
	return glUniform2uivPtr(location, count, value);
}

static PFNGLUNIFORM3UIVPROC glUniform3uivPtr = NULL;
void APIENTRY glUniform3uiv (GLint location, GLsizei count, const GLuint *value)
{
	assert(glUniform3uivPtr != NULL);
	return glUniform3uivPtr(location, count, value);
}

static PFNGLUNIFORM4UIVPROC glUniform4uivPtr = NULL;
void APIENTRY glUniform4uiv (GLint location, GLsizei count, const GLuint *value)
{
	assert(glUniform4uivPtr != NULL);
	return glUniform4uivPtr(location, count, value);
}

static PFNGLTEXPARAMETERIIVPROC glTexParameterIivPtr = NULL;
void APIENTRY glTexParameterIiv (GLenum target, GLenum pname, const GLint *params)
{
	assert(glTexParameterIivPtr != NULL);
	return glTexParameterIivPtr(target, pname, params);
}

static PFNGLTEXPARAMETERIUIVPROC glTexParameterIuivPtr = NULL;
void APIENTRY glTexParameterIuiv (GLenum target, GLenum pname, const GLuint *params)
{
	assert(glTexParameterIuivPtr != NULL);
	return glTexParameterIuivPtr(target, pname, params);
}

static PFNGLGETTEXPARAMETERIIVPROC glGetTexParameterIivPtr = NULL;
void APIENTRY glGetTexParameterIiv (GLenum target, GLenum pname, GLint *params)
{
	assert(glGetTexParameterIivPtr != NULL);
	return glGetTexParameterIivPtr(target, pname, params);
}

static PFNGLGETTEXPARAMETERIUIVPROC glGetTexParameterIuivPtr = NULL;
void APIENTRY glGetTexParameterIuiv (GLenum target, GLenum pname, GLuint *params)
{
	assert(glGetTexParameterIuivPtr != NULL);
	return glGetTexParameterIuivPtr(target, pname, params);
}

static PFNGLCLEARBUFFERIVPROC glClearBufferivPtr = NULL;
void APIENTRY glClearBufferiv (GLenum buffer, GLint drawbuffer, const GLint *value)
{
	assert(glClearBufferivPtr != NULL);
	return glClearBufferivPtr(buffer, drawbuffer, value);
}

static PFNGLCLEARBUFFERUIVPROC glClearBufferuivPtr = NULL;
void APIENTRY glClearBufferuiv (GLenum buffer, GLint drawbuffer, const GLuint *value)
{
	assert(glClearBufferuivPtr != NULL);
	return glClearBufferuivPtr(buffer, drawbuffer, value);
}

static PFNGLCLEARBUFFERFVPROC glClearBufferfvPtr = NULL;
void APIENTRY glClearBufferfv (GLenum buffer, GLint drawbuffer, const GLfloat *value)
{
	assert(glClearBufferfvPtr != NULL);
	return glClearBufferfvPtr(buffer, drawbuffer, value);
}

static PFNGLCLEARBUFFERFIPROC glClearBufferfiPtr = NULL;
void APIENTRY glClearBufferfi (GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil)
{
	assert(glClearBufferfiPtr != NULL);
	return glClearBufferfiPtr(buffer, drawbuffer, depth, stencil);
}

static PFNGLGETSTRINGIPROC glGetStringiPtr = NULL;
const GLubyte * APIENTRY glGetStringi (GLenum name, GLuint index)
{
	assert(glGetStringiPtr != NULL);
	return glGetStringiPtr(name, index);
}

/* ## GL_VERSION_3_1 ## */
static PFNGLDRAWARRAYSINSTANCEDPROC glDrawArraysInstancedPtr = NULL;
void APIENTRY glDrawArraysInstanced (GLenum mode, GLint first, GLsizei count, GLsizei instancecount)
{
	assert(glDrawArraysInstancedPtr != NULL);
	return glDrawArraysInstancedPtr(mode, first, count, instancecount);
}

static PFNGLDRAWELEMENTSINSTANCEDPROC glDrawElementsInstancedPtr = NULL;
void APIENTRY glDrawElementsInstanced (GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLsizei instancecount)
{
	assert(glDrawElementsInstancedPtr != NULL);
	return glDrawElementsInstancedPtr(mode, count, type, indices, instancecount);
}

static PFNGLTEXBUFFERPROC glTexBufferPtr = NULL;
void APIENTRY glTexBuffer (GLenum target, GLenum internalformat, GLuint buffer)
{
	assert(glTexBufferPtr != NULL);
	return glTexBufferPtr(target, internalformat, buffer);
}

static PFNGLPRIMITIVERESTARTINDEXPROC glPrimitiveRestartIndexPtr = NULL;
void APIENTRY glPrimitiveRestartIndex (GLuint index)
{
	assert(glPrimitiveRestartIndexPtr != NULL);
	return glPrimitiveRestartIndexPtr(index);
}

/* ## GL_VERSION_3_2 ## */
static PFNGLGETINTEGER64I_VPROC glGetInteger64i_vPtr = NULL;
void APIENTRY glGetInteger64i_v (GLenum target, GLuint index, GLint64 *data)
{
	assert(glGetInteger64i_vPtr != NULL);
	return glGetInteger64i_vPtr(target, index, data);
}

static PFNGLGETBUFFERPARAMETERI64VPROC glGetBufferParameteri64vPtr = NULL;
void APIENTRY glGetBufferParameteri64v (GLenum target, GLenum pname, GLint64 *params)
{
	assert(glGetBufferParameteri64vPtr != NULL);
	return glGetBufferParameteri64vPtr(target, pname, params);
}

static PFNGLFRAMEBUFFERTEXTUREPROC glFramebufferTexturePtr = NULL;
void APIENTRY glFramebufferTexture (GLenum target, GLenum attachment, GLuint texture, GLint level)
{
	assert(glFramebufferTexturePtr != NULL);
	return glFramebufferTexturePtr(target, attachment, texture, level);
}

/* ## GL_VERSION_3_3 ## */
static PFNGLVERTEXATTRIBDIVISORPROC glVertexAttribDivisorPtr = NULL;
void APIENTRY glVertexAttribDivisor (GLuint index, GLuint divisor)
{
	assert(glVertexAttribDivisorPtr != NULL);
	return glVertexAttribDivisorPtr(index, divisor);
}

/* ## GL_VERSION_4_0 ## */
static PFNGLMINSAMPLESHADINGPROC glMinSampleShadingPtr = NULL;
void APIENTRY glMinSampleShading (GLfloat value)
{
	assert(glMinSampleShadingPtr != NULL);
	return glMinSampleShadingPtr(value);
}

static PFNGLBLENDEQUATIONIPROC glBlendEquationiPtr = NULL;
void APIENTRY glBlendEquationi (GLuint buf, GLenum mode)
{
	assert(glBlendEquationiPtr != NULL);
	return glBlendEquationiPtr(buf, mode);
}

static PFNGLBLENDEQUATIONSEPARATEIPROC glBlendEquationSeparateiPtr = NULL;
void APIENTRY glBlendEquationSeparatei (GLuint buf, GLenum modeRGB, GLenum modeAlpha)
{
	assert(glBlendEquationSeparateiPtr != NULL);
	return glBlendEquationSeparateiPtr(buf, modeRGB, modeAlpha);
}

static PFNGLBLENDFUNCIPROC glBlendFunciPtr = NULL;
void APIENTRY glBlendFunci (GLuint buf, GLenum src, GLenum dst)
{
	assert(glBlendFunciPtr != NULL);
	return glBlendFunciPtr(buf, src, dst);
}

static PFNGLBLENDFUNCSEPARATEIPROC glBlendFuncSeparateiPtr = NULL;
void APIENTRY glBlendFuncSeparatei (GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha)
{
	assert(glBlendFuncSeparateiPtr != NULL);
	return glBlendFuncSeparateiPtr(buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
}

/* ## GL_ARB_framebuffer_object ## */
static PFNGLISRENDERBUFFERPROC glIsRenderbufferPtr = NULL;
GLboolean APIENTRY glIsRenderbuffer (GLuint renderbuffer)
{
	assert(glIsRenderbufferPtr != NULL);
	return glIsRenderbufferPtr(renderbuffer);
}

static PFNGLBINDRENDERBUFFERPROC glBindRenderbufferPtr = NULL;
void APIENTRY glBindRenderbuffer (GLenum target, GLuint renderbuffer)
{
	assert(glBindRenderbufferPtr != NULL);
	return glBindRenderbufferPtr(target, renderbuffer);
}

static PFNGLDELETERENDERBUFFERSPROC glDeleteRenderbuffersPtr = NULL;
void APIENTRY glDeleteRenderbuffers (GLsizei n, const GLuint *renderbuffers)
{
	assert(glDeleteRenderbuffersPtr != NULL);
	return glDeleteRenderbuffersPtr(n, renderbuffers);
}

static PFNGLGENRENDERBUFFERSPROC glGenRenderbuffersPtr = NULL;
void APIENTRY glGenRenderbuffers (GLsizei n, GLuint *renderbuffers)
{
	assert(glGenRenderbuffersPtr != NULL);
	return glGenRenderbuffersPtr(n, renderbuffers);
}

static PFNGLRENDERBUFFERSTORAGEPROC glRenderbufferStoragePtr = NULL;
void APIENTRY glRenderbufferStorage (GLenum target, GLenum internalformat, GLsizei width, GLsizei height)
{
	assert(glRenderbufferStoragePtr != NULL);
	return glRenderbufferStoragePtr(target, internalformat, width, height);
}

static PFNGLGETRENDERBUFFERPARAMETERIVPROC glGetRenderbufferParameterivPtr = NULL;
void APIENTRY glGetRenderbufferParameteriv (GLenum target, GLenum pname, GLint *params)
{
	assert(glGetRenderbufferParameterivPtr != NULL);
	return glGetRenderbufferParameterivPtr(target, pname, params);
}

static PFNGLISFRAMEBUFFERPROC glIsFramebufferPtr = NULL;
GLboolean APIENTRY glIsFramebuffer (GLuint framebuffer)
{
	assert(glIsFramebufferPtr != NULL);
	return glIsFramebufferPtr(framebuffer);
}

static PFNGLBINDFRAMEBUFFERPROC glBindFramebufferPtr = NULL;
void APIENTRY glBindFramebuffer (GLenum target, GLuint framebuffer)
{
	assert(glBindFramebufferPtr != NULL);
	return glBindFramebufferPtr(target, framebuffer);
}

static PFNGLDELETEFRAMEBUFFERSPROC glDeleteFramebuffersPtr = NULL;
void APIENTRY glDeleteFramebuffers (GLsizei n, const GLuint *framebuffers)
{
	assert(glDeleteFramebuffersPtr != NULL);
	return glDeleteFramebuffersPtr(n, framebuffers);
}

static PFNGLGENFRAMEBUFFERSPROC glGenFramebuffersPtr = NULL;
void APIENTRY glGenFramebuffers (GLsizei n, GLuint *framebuffers)
{
	assert(glGenFramebuffersPtr != NULL);
	return glGenFramebuffersPtr(n, framebuffers);
}

static PFNGLCHECKFRAMEBUFFERSTATUSPROC glCheckFramebufferStatusPtr = NULL;
GLenum APIENTRY glCheckFramebufferStatus (GLenum target)
{
	assert(glCheckFramebufferStatusPtr != NULL);
	return glCheckFramebufferStatusPtr(target);
}

static PFNGLFRAMEBUFFERTEXTURE1DPROC glFramebufferTexture1DPtr = NULL;
void APIENTRY glFramebufferTexture1D (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level)
{
	assert(glFramebufferTexture1DPtr != NULL);
	return glFramebufferTexture1DPtr(target, attachment, textarget, texture, level);
}

static PFNGLFRAMEBUFFERTEXTURE2DPROC glFramebufferTexture2DPtr = NULL;
void APIENTRY glFramebufferTexture2D (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level)
{
	assert(glFramebufferTexture2DPtr != NULL);
	return glFramebufferTexture2DPtr(target, attachment, textarget, texture, level);
}

static PFNGLFRAMEBUFFERTEXTURE3DPROC glFramebufferTexture3DPtr = NULL;
void APIENTRY glFramebufferTexture3D (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset)
{
	assert(glFramebufferTexture3DPtr != NULL);
	return glFramebufferTexture3DPtr(target, attachment, textarget, texture, level, zoffset);
}

static PFNGLFRAMEBUFFERRENDERBUFFERPROC glFramebufferRenderbufferPtr = NULL;
void APIENTRY glFramebufferRenderbuffer (GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer)
{
	assert(glFramebufferRenderbufferPtr != NULL);
	return glFramebufferRenderbufferPtr(target, attachment, renderbuffertarget, renderbuffer);
}

static PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVPROC glGetFramebufferAttachmentParameterivPtr = NULL;
void APIENTRY glGetFramebufferAttachmentParameteriv (GLenum target, GLenum attachment, GLenum pname, GLint *params)
{
	assert(glGetFramebufferAttachmentParameterivPtr != NULL);
	return glGetFramebufferAttachmentParameterivPtr(target, attachment, pname, params);
}

static PFNGLGENERATEMIPMAPPROC glGenerateMipmapPtr = NULL;
void APIENTRY glGenerateMipmap (GLenum target)
{
	assert(glGenerateMipmapPtr != NULL);
	return glGenerateMipmapPtr(target);
}

static PFNGLBLITFRAMEBUFFERPROC glBlitFramebufferPtr = NULL;
void APIENTRY glBlitFramebuffer (GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter)
{
	assert(glBlitFramebufferPtr != NULL);
	return glBlitFramebufferPtr(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
}

static PFNGLRENDERBUFFERSTORAGEMULTISAMPLEPROC glRenderbufferStorageMultisamplePtr = NULL;
void APIENTRY glRenderbufferStorageMultisample (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height)
{
	assert(glRenderbufferStorageMultisamplePtr != NULL);
	return glRenderbufferStorageMultisamplePtr(target, samples, internalformat, width, height);
}

static PFNGLFRAMEBUFFERTEXTURELAYERPROC glFramebufferTextureLayerPtr = NULL;
void APIENTRY glFramebufferTextureLayer (GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer)
{
	assert(glFramebufferTextureLayerPtr != NULL);
	return glFramebufferTextureLayerPtr(target, attachment, texture, level, layer);
}

/* ## GL_ARB_map_buffer_range ## */
static PFNGLMAPBUFFERRANGEPROC glMapBufferRangePtr = NULL;
GLvoid* APIENTRY glMapBufferRange (GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access)
{
	assert(glMapBufferRangePtr != NULL);
	return glMapBufferRangePtr(target, offset, length, access);
}

static PFNGLFLUSHMAPPEDBUFFERRANGEPROC glFlushMappedBufferRangePtr = NULL;
void APIENTRY glFlushMappedBufferRange (GLenum target, GLintptr offset, GLsizeiptr length)
{
	assert(glFlushMappedBufferRangePtr != NULL);
	return glFlushMappedBufferRangePtr(target, offset, length);
}

/* ## GL_ARB_vertex_array_object ## */
static PFNGLBINDVERTEXARRAYPROC glBindVertexArrayPtr = NULL;
void APIENTRY glBindVertexArray (GLuint array)
{
	assert(glBindVertexArrayPtr != NULL);
	return glBindVertexArrayPtr(array);
}

static PFNGLDELETEVERTEXARRAYSPROC glDeleteVertexArraysPtr = NULL;
void APIENTRY glDeleteVertexArrays (GLsizei n, const GLuint *arrays)
{
	assert(glDeleteVertexArraysPtr != NULL);
	return glDeleteVertexArraysPtr(n, arrays);
}

static PFNGLGENVERTEXARRAYSPROC glGenVertexArraysPtr = NULL;
void APIENTRY glGenVertexArrays (GLsizei n, GLuint *arrays)
{
	assert(glGenVertexArraysPtr != NULL);
	return glGenVertexArraysPtr(n, arrays);
}

static PFNGLISVERTEXARRAYPROC glIsVertexArrayPtr = NULL;
GLboolean APIENTRY glIsVertexArray (GLuint array)
{
	assert(glIsVertexArrayPtr != NULL);
	return glIsVertexArrayPtr(array);
}

/* ## GL_ARB_uniform_buffer_object ## */
static PFNGLGETUNIFORMINDICESPROC glGetUniformIndicesPtr = NULL;
void APIENTRY glGetUniformIndices (GLuint program, GLsizei uniformCount, const GLchar* const *uniformNames, GLuint *uniformIndices)
{
	assert(glGetUniformIndicesPtr != NULL);
	return glGetUniformIndicesPtr(program, uniformCount, uniformNames, uniformIndices);
}

static PFNGLGETACTIVEUNIFORMSIVPROC glGetActiveUniformsivPtr = NULL;
void APIENTRY glGetActiveUniformsiv (GLuint program, GLsizei uniformCount, const GLuint *uniformIndices, GLenum pname, GLint *params)
{
	assert(glGetActiveUniformsivPtr != NULL);
	return glGetActiveUniformsivPtr(program, uniformCount, uniformIndices, pname, params);
}

static PFNGLGETACTIVEUNIFORMNAMEPROC glGetActiveUniformNamePtr = NULL;
void APIENTRY glGetActiveUniformName (GLuint program, GLuint uniformIndex, GLsizei bufSize, GLsizei *length, GLchar *uniformName)
{
	assert(glGetActiveUniformNamePtr != NULL);
	return glGetActiveUniformNamePtr(program, uniformIndex, bufSize, length, uniformName);
}

static PFNGLGETUNIFORMBLOCKINDEXPROC glGetUniformBlockIndexPtr = NULL;
GLuint APIENTRY glGetUniformBlockIndex (GLuint program, const GLchar *uniformBlockName)
{
	assert(glGetUniformBlockIndexPtr != NULL);
	return glGetUniformBlockIndexPtr(program, uniformBlockName);
}

static PFNGLGETACTIVEUNIFORMBLOCKIVPROC glGetActiveUniformBlockivPtr = NULL;
void APIENTRY glGetActiveUniformBlockiv (GLuint program, GLuint uniformBlockIndex, GLenum pname, GLint *params)
{
	assert(glGetActiveUniformBlockivPtr != NULL);
	return glGetActiveUniformBlockivPtr(program, uniformBlockIndex, pname, params);
}

static PFNGLGETACTIVEUNIFORMBLOCKNAMEPROC glGetActiveUniformBlockNamePtr = NULL;
void APIENTRY glGetActiveUniformBlockName (GLuint program, GLuint uniformBlockIndex, GLsizei bufSize, GLsizei *length, GLchar *uniformBlockName)
{
	assert(glGetActiveUniformBlockNamePtr != NULL);
	return glGetActiveUniformBlockNamePtr(program, uniformBlockIndex, bufSize, length, uniformBlockName);
}

static PFNGLUNIFORMBLOCKBINDINGPROC glUniformBlockBindingPtr = NULL;
void APIENTRY glUniformBlockBinding (GLuint program, GLuint uniformBlockIndex, GLuint uniformBlockBinding)
{
	assert(glUniformBlockBindingPtr != NULL);
	return glUniformBlockBindingPtr(program, uniformBlockIndex, uniformBlockBinding);
}

/* ## GL_ARB_copy_buffer ## */
static PFNGLCOPYBUFFERSUBDATAPROC glCopyBufferSubDataPtr = NULL;
void APIENTRY glCopyBufferSubData (GLenum readTarget, GLenum writeTarget, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size)
{
	assert(glCopyBufferSubDataPtr != NULL);
	return glCopyBufferSubDataPtr(readTarget, writeTarget, readOffset, writeOffset, size);
}

/* ## GL_ARB_draw_elements_base_vertex ## */
static PFNGLDRAWELEMENTSBASEVERTEXPROC glDrawElementsBaseVertexPtr = NULL;
void APIENTRY glDrawElementsBaseVertex (GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLint basevertex)
{
	assert(glDrawElementsBaseVertexPtr != NULL);
	return glDrawElementsBaseVertexPtr(mode, count, type, indices, basevertex);
}

static PFNGLDRAWRANGEELEMENTSBASEVERTEXPROC glDrawRangeElementsBaseVertexPtr = NULL;
void APIENTRY glDrawRangeElementsBaseVertex (GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices, GLint basevertex)
{
	assert(glDrawRangeElementsBaseVertexPtr != NULL);
	return glDrawRangeElementsBaseVertexPtr(mode, start, end, count, type, indices, basevertex);
}

static PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXPROC glDrawElementsInstancedBaseVertexPtr = NULL;
void APIENTRY glDrawElementsInstancedBaseVertex (GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLsizei instancecount, GLint basevertex)
{
	assert(glDrawElementsInstancedBaseVertexPtr != NULL);
	return glDrawElementsInstancedBaseVertexPtr(mode, count, type, indices, instancecount, basevertex);
}

static PFNGLMULTIDRAWELEMENTSBASEVERTEXPROC glMultiDrawElementsBaseVertexPtr = NULL;
void APIENTRY glMultiDrawElementsBaseVertex (GLenum mode, const GLsizei *count, GLenum type, const GLvoid* const *indices, GLsizei drawcount, const GLint *basevertex)
{
	assert(glMultiDrawElementsBaseVertexPtr != NULL);
	return glMultiDrawElementsBaseVertexPtr(mode, count, type, indices, drawcount, basevertex);
}

/* ## GL_ARB_provoking_vertex ## */
static PFNGLPROVOKINGVERTEXPROC glProvokingVertexPtr = NULL;
void APIENTRY glProvokingVertex (GLenum mode)
{
	assert(glProvokingVertexPtr != NULL);
	return glProvokingVertexPtr(mode);
}

/* ## GL_ARB_sync ## */
static PFNGLFENCESYNCPROC glFenceSyncPtr = NULL;
GLsync APIENTRY glFenceSync (GLenum condition, GLbitfield flags)
{
	assert(glFenceSyncPtr != NULL);
	return glFenceSyncPtr(condition, flags);
}

static PFNGLISSYNCPROC glIsSyncPtr = NULL;
GLboolean APIENTRY glIsSync (GLsync sync)
{
	assert(glIsSyncPtr != NULL);
	return glIsSyncPtr(sync);
}

static PFNGLDELETESYNCPROC glDeleteSyncPtr = NULL;
void APIENTRY glDeleteSync (GLsync sync)
{
	assert(glDeleteSyncPtr != NULL);
	return glDeleteSyncPtr(sync);
}

static PFNGLCLIENTWAITSYNCPROC glClientWaitSyncPtr = NULL;
GLenum APIENTRY glClientWaitSync (GLsync sync, GLbitfield flags, GLuint64 timeout)
{
	assert(glClientWaitSyncPtr != NULL);
	return glClientWaitSyncPtr(sync, flags, timeout);
}

static PFNGLWAITSYNCPROC glWaitSyncPtr = NULL;
void APIENTRY glWaitSync (GLsync sync, GLbitfield flags, GLuint64 timeout)
{
	assert(glWaitSyncPtr != NULL);
	return glWaitSyncPtr(sync, flags, timeout);
}

static PFNGLGETINTEGER64VPROC glGetInteger64vPtr = NULL;
void APIENTRY glGetInteger64v (GLenum pname, GLint64 *params)
{
	assert(glGetInteger64vPtr != NULL);
	return glGetInteger64vPtr(pname, params);
}

static PFNGLGETSYNCIVPROC glGetSyncivPtr = NULL;
void APIENTRY glGetSynciv (GLsync sync, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *values)
{
	assert(glGetSyncivPtr != NULL);
	return glGetSyncivPtr(sync, pname, bufSize, length, values);
}

/* ## GL_ARB_texture_multisample ## */
static PFNGLTEXIMAGE2DMULTISAMPLEPROC glTexImage2DMultisamplePtr = NULL;
void APIENTRY glTexImage2DMultisample (GLenum target, GLsizei samples, GLint internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations)
{
	assert(glTexImage2DMultisamplePtr != NULL);
	return glTexImage2DMultisamplePtr(target, samples, internalformat, width, height, fixedsamplelocations);
}

static PFNGLTEXIMAGE3DMULTISAMPLEPROC glTexImage3DMultisamplePtr = NULL;
void APIENTRY glTexImage3DMultisample (GLenum target, GLsizei samples, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations)
{
	assert(glTexImage3DMultisamplePtr != NULL);
	return glTexImage3DMultisamplePtr(target, samples, internalformat, width, height, depth, fixedsamplelocations);
}

static PFNGLGETMULTISAMPLEFVPROC glGetMultisamplefvPtr = NULL;
void APIENTRY glGetMultisamplefv (GLenum pname, GLuint index, GLfloat *val)
{
	assert(glGetMultisamplefvPtr != NULL);
	return glGetMultisamplefvPtr(pname, index, val);
}

static PFNGLSAMPLEMASKIPROC glSampleMaskiPtr = NULL;
void APIENTRY glSampleMaski (GLuint index, GLbitfield mask)
{
	assert(glSampleMaskiPtr != NULL);
	return glSampleMaskiPtr(index, mask);
}

/* ## GL_ARB_draw_buffers_blend ## */
static PFNGLBLENDEQUATIONIARBPROC glBlendEquationiARBPtr = NULL;
void APIENTRY glBlendEquationiARB (GLuint buf, GLenum mode)
{
	assert(glBlendEquationiARBPtr != NULL);
	return glBlendEquationiARBPtr(buf, mode);
}

static PFNGLBLENDEQUATIONSEPARATEIARBPROC glBlendEquationSeparateiARBPtr = NULL;
void APIENTRY glBlendEquationSeparateiARB (GLuint buf, GLenum modeRGB, GLenum modeAlpha)
{
	assert(glBlendEquationSeparateiARBPtr != NULL);
	return glBlendEquationSeparateiARBPtr(buf, modeRGB, modeAlpha);
}

static PFNGLBLENDFUNCIARBPROC glBlendFunciARBPtr = NULL;
void APIENTRY glBlendFunciARB (GLuint buf, GLenum src, GLenum dst)
{
	assert(glBlendFunciARBPtr != NULL);
	return glBlendFunciARBPtr(buf, src, dst);
}

static PFNGLBLENDFUNCSEPARATEIARBPROC glBlendFuncSeparateiARBPtr = NULL;
void APIENTRY glBlendFuncSeparateiARB (GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha)
{
	assert(glBlendFuncSeparateiARBPtr != NULL);
	return glBlendFuncSeparateiARBPtr(buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
}

/* ## GL_ARB_sample_shading ## */
static PFNGLMINSAMPLESHADINGARBPROC glMinSampleShadingARBPtr = NULL;
void APIENTRY glMinSampleShadingARB (GLfloat value)
{
	assert(glMinSampleShadingARBPtr != NULL);
	return glMinSampleShadingARBPtr(value);
}

/* ## GL_ARB_shading_language_include ## */
static PFNGLNAMEDSTRINGARBPROC glNamedStringARBPtr = NULL;
void APIENTRY glNamedStringARB (GLenum type, GLint namelen, const GLchar *name, GLint stringlen, const GLchar *string)
{
	assert(glNamedStringARBPtr != NULL);
	return glNamedStringARBPtr(type, namelen, name, stringlen, string);
}

static PFNGLDELETENAMEDSTRINGARBPROC glDeleteNamedStringARBPtr = NULL;
void APIENTRY glDeleteNamedStringARB (GLint namelen, const GLchar *name)
{
	assert(glDeleteNamedStringARBPtr != NULL);
	return glDeleteNamedStringARBPtr(namelen, name);
}

static PFNGLCOMPILESHADERINCLUDEARBPROC glCompileShaderIncludeARBPtr = NULL;
void APIENTRY glCompileShaderIncludeARB (GLuint shader, GLsizei count, const GLchar* *path, const GLint *length)
{
	assert(glCompileShaderIncludeARBPtr != NULL);
	return glCompileShaderIncludeARBPtr(shader, count, path, length);
}

static PFNGLISNAMEDSTRINGARBPROC glIsNamedStringARBPtr = NULL;
GLboolean APIENTRY glIsNamedStringARB (GLint namelen, const GLchar *name)
{
	assert(glIsNamedStringARBPtr != NULL);
	return glIsNamedStringARBPtr(namelen, name);
}

static PFNGLGETNAMEDSTRINGARBPROC glGetNamedStringARBPtr = NULL;
void APIENTRY glGetNamedStringARB (GLint namelen, const GLchar *name, GLsizei bufSize, GLint *stringlen, GLchar *string)
{
	assert(glGetNamedStringARBPtr != NULL);
	return glGetNamedStringARBPtr(namelen, name, bufSize, stringlen, string);
}

static PFNGLGETNAMEDSTRINGIVARBPROC glGetNamedStringivARBPtr = NULL;
void APIENTRY glGetNamedStringivARB (GLint namelen, const GLchar *name, GLenum pname, GLint *params)
{
	assert(glGetNamedStringivARBPtr != NULL);
	return glGetNamedStringivARBPtr(namelen, name, pname, params);
}

/* ## GL_ARB_blend_func_extended ## */
static PFNGLBINDFRAGDATALOCATIONINDEXEDPROC glBindFragDataLocationIndexedPtr = NULL;
void APIENTRY glBindFragDataLocationIndexed (GLuint program, GLuint colorNumber, GLuint index, const GLchar *name)
{
	assert(glBindFragDataLocationIndexedPtr != NULL);
	return glBindFragDataLocationIndexedPtr(program, colorNumber, index, name);
}

static PFNGLGETFRAGDATAINDEXPROC glGetFragDataIndexPtr = NULL;
GLint APIENTRY glGetFragDataIndex (GLuint program, const GLchar *name)
{
	assert(glGetFragDataIndexPtr != NULL);
	return glGetFragDataIndexPtr(program, name);
}

/* ## GL_ARB_sampler_objects ## */
static PFNGLGENSAMPLERSPROC glGenSamplersPtr = NULL;
void APIENTRY glGenSamplers (GLsizei count, GLuint *samplers)
{
	assert(glGenSamplersPtr != NULL);
	return glGenSamplersPtr(count, samplers);
}

static PFNGLDELETESAMPLERSPROC glDeleteSamplersPtr = NULL;
void APIENTRY glDeleteSamplers (GLsizei count, const GLuint *samplers)
{
	assert(glDeleteSamplersPtr != NULL);
	return glDeleteSamplersPtr(count, samplers);
}

static PFNGLISSAMPLERPROC glIsSamplerPtr = NULL;
GLboolean APIENTRY glIsSampler (GLuint sampler)
{
	assert(glIsSamplerPtr != NULL);
	return glIsSamplerPtr(sampler);
}

static PFNGLBINDSAMPLERPROC glBindSamplerPtr = NULL;
void APIENTRY glBindSampler (GLuint unit, GLuint sampler)
{
	assert(glBindSamplerPtr != NULL);
	return glBindSamplerPtr(unit, sampler);
}

static PFNGLSAMPLERPARAMETERIPROC glSamplerParameteriPtr = NULL;
void APIENTRY glSamplerParameteri (GLuint sampler, GLenum pname, GLint param)
{
	assert(glSamplerParameteriPtr != NULL);
	return glSamplerParameteriPtr(sampler, pname, param);
}

static PFNGLSAMPLERPARAMETERIVPROC glSamplerParameterivPtr = NULL;
void APIENTRY glSamplerParameteriv (GLuint sampler, GLenum pname, const GLint *param)
{
	assert(glSamplerParameterivPtr != NULL);
	return glSamplerParameterivPtr(sampler, pname, param);
}

static PFNGLSAMPLERPARAMETERFPROC glSamplerParameterfPtr = NULL;
void APIENTRY glSamplerParameterf (GLuint sampler, GLenum pname, GLfloat param)
{
	assert(glSamplerParameterfPtr != NULL);
	return glSamplerParameterfPtr(sampler, pname, param);
}

static PFNGLSAMPLERPARAMETERFVPROC glSamplerParameterfvPtr = NULL;
void APIENTRY glSamplerParameterfv (GLuint sampler, GLenum pname, const GLfloat *param)
{
	assert(glSamplerParameterfvPtr != NULL);
	return glSamplerParameterfvPtr(sampler, pname, param);
}

static PFNGLSAMPLERPARAMETERIIVPROC glSamplerParameterIivPtr = NULL;
void APIENTRY glSamplerParameterIiv (GLuint sampler, GLenum pname, const GLint *param)
{
	assert(glSamplerParameterIivPtr != NULL);
	return glSamplerParameterIivPtr(sampler, pname, param);
}

static PFNGLSAMPLERPARAMETERIUIVPROC glSamplerParameterIuivPtr = NULL;
void APIENTRY glSamplerParameterIuiv (GLuint sampler, GLenum pname, const GLuint *param)
{
	assert(glSamplerParameterIuivPtr != NULL);
	return glSamplerParameterIuivPtr(sampler, pname, param);
}

static PFNGLGETSAMPLERPARAMETERIVPROC glGetSamplerParameterivPtr = NULL;
void APIENTRY glGetSamplerParameteriv (GLuint sampler, GLenum pname, GLint *params)
{
	assert(glGetSamplerParameterivPtr != NULL);
	return glGetSamplerParameterivPtr(sampler, pname, params);
}

static PFNGLGETSAMPLERPARAMETERIIVPROC glGetSamplerParameterIivPtr = NULL;
void APIENTRY glGetSamplerParameterIiv (GLuint sampler, GLenum pname, GLint *params)
{
	assert(glGetSamplerParameterIivPtr != NULL);
	return glGetSamplerParameterIivPtr(sampler, pname, params);
}

static PFNGLGETSAMPLERPARAMETERFVPROC glGetSamplerParameterfvPtr = NULL;
void APIENTRY glGetSamplerParameterfv (GLuint sampler, GLenum pname, GLfloat *params)
{
	assert(glGetSamplerParameterfvPtr != NULL);
	return glGetSamplerParameterfvPtr(sampler, pname, params);
}

static PFNGLGETSAMPLERPARAMETERIUIVPROC glGetSamplerParameterIuivPtr = NULL;
void APIENTRY glGetSamplerParameterIuiv (GLuint sampler, GLenum pname, GLuint *params)
{
	assert(glGetSamplerParameterIuivPtr != NULL);
	return glGetSamplerParameterIuivPtr(sampler, pname, params);
}

/* ## GL_ARB_timer_query ## */
static PFNGLQUERYCOUNTERPROC glQueryCounterPtr = NULL;
void APIENTRY glQueryCounter (GLuint id, GLenum target)
{
	assert(glQueryCounterPtr != NULL);
	return glQueryCounterPtr(id, target);
}

static PFNGLGETQUERYOBJECTI64VPROC glGetQueryObjecti64vPtr = NULL;
void APIENTRY glGetQueryObjecti64v (GLuint id, GLenum pname, GLint64 *params)
{
	assert(glGetQueryObjecti64vPtr != NULL);
	return glGetQueryObjecti64vPtr(id, pname, params);
}

static PFNGLGETQUERYOBJECTUI64VPROC glGetQueryObjectui64vPtr = NULL;
void APIENTRY glGetQueryObjectui64v (GLuint id, GLenum pname, GLuint64 *params)
{
	assert(glGetQueryObjectui64vPtr != NULL);
	return glGetQueryObjectui64vPtr(id, pname, params);
}

/* ## GL_ARB_vertex_type_2_10_10_10_rev ## */
static PFNGLVERTEXP2UIPROC glVertexP2uiPtr = NULL;
void APIENTRY glVertexP2ui (GLenum type, GLuint value)
{
	assert(glVertexP2uiPtr != NULL);
	return glVertexP2uiPtr(type, value);
}

static PFNGLVERTEXP2UIVPROC glVertexP2uivPtr = NULL;
void APIENTRY glVertexP2uiv (GLenum type, const GLuint *value)
{
	assert(glVertexP2uivPtr != NULL);
	return glVertexP2uivPtr(type, value);
}

static PFNGLVERTEXP3UIPROC glVertexP3uiPtr = NULL;
void APIENTRY glVertexP3ui (GLenum type, GLuint value)
{
	assert(glVertexP3uiPtr != NULL);
	return glVertexP3uiPtr(type, value);
}

static PFNGLVERTEXP3UIVPROC glVertexP3uivPtr = NULL;
void APIENTRY glVertexP3uiv (GLenum type, const GLuint *value)
{
	assert(glVertexP3uivPtr != NULL);
	return glVertexP3uivPtr(type, value);
}

static PFNGLVERTEXP4UIPROC glVertexP4uiPtr = NULL;
void APIENTRY glVertexP4ui (GLenum type, GLuint value)
{
	assert(glVertexP4uiPtr != NULL);
	return glVertexP4uiPtr(type, value);
}

static PFNGLVERTEXP4UIVPROC glVertexP4uivPtr = NULL;
void APIENTRY glVertexP4uiv (GLenum type, const GLuint *value)
{
	assert(glVertexP4uivPtr != NULL);
	return glVertexP4uivPtr(type, value);
}

static PFNGLTEXCOORDP1UIPROC glTexCoordP1uiPtr = NULL;
void APIENTRY glTexCoordP1ui (GLenum type, GLuint coords)
{
	assert(glTexCoordP1uiPtr != NULL);
	return glTexCoordP1uiPtr(type, coords);
}

static PFNGLTEXCOORDP1UIVPROC glTexCoordP1uivPtr = NULL;
void APIENTRY glTexCoordP1uiv (GLenum type, const GLuint *coords)
{
	assert(glTexCoordP1uivPtr != NULL);
	return glTexCoordP1uivPtr(type, coords);
}

static PFNGLTEXCOORDP2UIPROC glTexCoordP2uiPtr = NULL;
void APIENTRY glTexCoordP2ui (GLenum type, GLuint coords)
{
	assert(glTexCoordP2uiPtr != NULL);
	return glTexCoordP2uiPtr(type, coords);
}

static PFNGLTEXCOORDP2UIVPROC glTexCoordP2uivPtr = NULL;
void APIENTRY glTexCoordP2uiv (GLenum type, const GLuint *coords)
{
	assert(glTexCoordP2uivPtr != NULL);
	return glTexCoordP2uivPtr(type, coords);
}

static PFNGLTEXCOORDP3UIPROC glTexCoordP3uiPtr = NULL;
void APIENTRY glTexCoordP3ui (GLenum type, GLuint coords)
{
	assert(glTexCoordP3uiPtr != NULL);
	return glTexCoordP3uiPtr(type, coords);
}

static PFNGLTEXCOORDP3UIVPROC glTexCoordP3uivPtr = NULL;
void APIENTRY glTexCoordP3uiv (GLenum type, const GLuint *coords)
{
	assert(glTexCoordP3uivPtr != NULL);
	return glTexCoordP3uivPtr(type, coords);
}

static PFNGLTEXCOORDP4UIPROC glTexCoordP4uiPtr = NULL;
void APIENTRY glTexCoordP4ui (GLenum type, GLuint coords)
{
	assert(glTexCoordP4uiPtr != NULL);
	return glTexCoordP4uiPtr(type, coords);
}

static PFNGLTEXCOORDP4UIVPROC glTexCoordP4uivPtr = NULL;
void APIENTRY glTexCoordP4uiv (GLenum type, const GLuint *coords)
{
	assert(glTexCoordP4uivPtr != NULL);
	return glTexCoordP4uivPtr(type, coords);
}

static PFNGLMULTITEXCOORDP1UIPROC glMultiTexCoordP1uiPtr = NULL;
void APIENTRY glMultiTexCoordP1ui (GLenum texture, GLenum type, GLuint coords)
{
	assert(glMultiTexCoordP1uiPtr != NULL);
	return glMultiTexCoordP1uiPtr(texture, type, coords);
}

static PFNGLMULTITEXCOORDP1UIVPROC glMultiTexCoordP1uivPtr = NULL;
void APIENTRY glMultiTexCoordP1uiv (GLenum texture, GLenum type, const GLuint *coords)
{
	assert(glMultiTexCoordP1uivPtr != NULL);
	return glMultiTexCoordP1uivPtr(texture, type, coords);
}

static PFNGLMULTITEXCOORDP2UIPROC glMultiTexCoordP2uiPtr = NULL;
void APIENTRY glMultiTexCoordP2ui (GLenum texture, GLenum type, GLuint coords)
{
	assert(glMultiTexCoordP2uiPtr != NULL);
	return glMultiTexCoordP2uiPtr(texture, type, coords);
}

static PFNGLMULTITEXCOORDP2UIVPROC glMultiTexCoordP2uivPtr = NULL;
void APIENTRY glMultiTexCoordP2uiv (GLenum texture, GLenum type, const GLuint *coords)
{
	assert(glMultiTexCoordP2uivPtr != NULL);
	return glMultiTexCoordP2uivPtr(texture, type, coords);
}

static PFNGLMULTITEXCOORDP3UIPROC glMultiTexCoordP3uiPtr = NULL;
void APIENTRY glMultiTexCoordP3ui (GLenum texture, GLenum type, GLuint coords)
{
	assert(glMultiTexCoordP3uiPtr != NULL);
	return glMultiTexCoordP3uiPtr(texture, type, coords);
}

static PFNGLMULTITEXCOORDP3UIVPROC glMultiTexCoordP3uivPtr = NULL;
void APIENTRY glMultiTexCoordP3uiv (GLenum texture, GLenum type, const GLuint *coords)
{
	assert(glMultiTexCoordP3uivPtr != NULL);
	return glMultiTexCoordP3uivPtr(texture, type, coords);
}

static PFNGLMULTITEXCOORDP4UIPROC glMultiTexCoordP4uiPtr = NULL;
void APIENTRY glMultiTexCoordP4ui (GLenum texture, GLenum type, GLuint coords)
{
	assert(glMultiTexCoordP4uiPtr != NULL);
	return glMultiTexCoordP4uiPtr(texture, type, coords);
}

static PFNGLMULTITEXCOORDP4UIVPROC glMultiTexCoordP4uivPtr = NULL;
void APIENTRY glMultiTexCoordP4uiv (GLenum texture, GLenum type, const GLuint *coords)
{
	assert(glMultiTexCoordP4uivPtr != NULL);
	return glMultiTexCoordP4uivPtr(texture, type, coords);
}

static PFNGLNORMALP3UIPROC glNormalP3uiPtr = NULL;
void APIENTRY glNormalP3ui (GLenum type, GLuint coords)
{
	assert(glNormalP3uiPtr != NULL);
	return glNormalP3uiPtr(type, coords);
}

static PFNGLNORMALP3UIVPROC glNormalP3uivPtr = NULL;
void APIENTRY glNormalP3uiv (GLenum type, const GLuint *coords)
{
	assert(glNormalP3uivPtr != NULL);
	return glNormalP3uivPtr(type, coords);
}

static PFNGLCOLORP3UIPROC glColorP3uiPtr = NULL;
void APIENTRY glColorP3ui (GLenum type, GLuint color)
{
	assert(glColorP3uiPtr != NULL);
	return glColorP3uiPtr(type, color);
}

static PFNGLCOLORP3UIVPROC glColorP3uivPtr = NULL;
void APIENTRY glColorP3uiv (GLenum type, const GLuint *color)
{
	assert(glColorP3uivPtr != NULL);
	return glColorP3uivPtr(type, color);
}

static PFNGLCOLORP4UIPROC glColorP4uiPtr = NULL;
void APIENTRY glColorP4ui (GLenum type, GLuint color)
{
	assert(glColorP4uiPtr != NULL);
	return glColorP4uiPtr(type, color);
}

static PFNGLCOLORP4UIVPROC glColorP4uivPtr = NULL;
void APIENTRY glColorP4uiv (GLenum type, const GLuint *color)
{
	assert(glColorP4uivPtr != NULL);
	return glColorP4uivPtr(type, color);
}

static PFNGLSECONDARYCOLORP3UIPROC glSecondaryColorP3uiPtr = NULL;
void APIENTRY glSecondaryColorP3ui (GLenum type, GLuint color)
{
	assert(glSecondaryColorP3uiPtr != NULL);
	return glSecondaryColorP3uiPtr(type, color);
}

static PFNGLSECONDARYCOLORP3UIVPROC glSecondaryColorP3uivPtr = NULL;
void APIENTRY glSecondaryColorP3uiv (GLenum type, const GLuint *color)
{
	assert(glSecondaryColorP3uivPtr != NULL);
	return glSecondaryColorP3uivPtr(type, color);
}

static PFNGLVERTEXATTRIBP1UIPROC glVertexAttribP1uiPtr = NULL;
void APIENTRY glVertexAttribP1ui (GLuint index, GLenum type, GLboolean normalized, GLuint value)
{
	assert(glVertexAttribP1uiPtr != NULL);
	return glVertexAttribP1uiPtr(index, type, normalized, value);
}

static PFNGLVERTEXATTRIBP1UIVPROC glVertexAttribP1uivPtr = NULL;
void APIENTRY glVertexAttribP1uiv (GLuint index, GLenum type, GLboolean normalized, const GLuint *value)
{
	assert(glVertexAttribP1uivPtr != NULL);
	return glVertexAttribP1uivPtr(index, type, normalized, value);
}

static PFNGLVERTEXATTRIBP2UIPROC glVertexAttribP2uiPtr = NULL;
void APIENTRY glVertexAttribP2ui (GLuint index, GLenum type, GLboolean normalized, GLuint value)
{
	assert(glVertexAttribP2uiPtr != NULL);
	return glVertexAttribP2uiPtr(index, type, normalized, value);
}

static PFNGLVERTEXATTRIBP2UIVPROC glVertexAttribP2uivPtr = NULL;
void APIENTRY glVertexAttribP2uiv (GLuint index, GLenum type, GLboolean normalized, const GLuint *value)
{
	assert(glVertexAttribP2uivPtr != NULL);
	return glVertexAttribP2uivPtr(index, type, normalized, value);
}

static PFNGLVERTEXATTRIBP3UIPROC glVertexAttribP3uiPtr = NULL;
void APIENTRY glVertexAttribP3ui (GLuint index, GLenum type, GLboolean normalized, GLuint value)
{
	assert(glVertexAttribP3uiPtr != NULL);
	return glVertexAttribP3uiPtr(index, type, normalized, value);
}

static PFNGLVERTEXATTRIBP3UIVPROC glVertexAttribP3uivPtr = NULL;
void APIENTRY glVertexAttribP3uiv (GLuint index, GLenum type, GLboolean normalized, const GLuint *value)
{
	assert(glVertexAttribP3uivPtr != NULL);
	return glVertexAttribP3uivPtr(index, type, normalized, value);
}

static PFNGLVERTEXATTRIBP4UIPROC glVertexAttribP4uiPtr = NULL;
void APIENTRY glVertexAttribP4ui (GLuint index, GLenum type, GLboolean normalized, GLuint value)
{
	assert(glVertexAttribP4uiPtr != NULL);
	return glVertexAttribP4uiPtr(index, type, normalized, value);
}

static PFNGLVERTEXATTRIBP4UIVPROC glVertexAttribP4uivPtr = NULL;
void APIENTRY glVertexAttribP4uiv (GLuint index, GLenum type, GLboolean normalized, const GLuint *value)
{
	assert(glVertexAttribP4uivPtr != NULL);
	return glVertexAttribP4uivPtr(index, type, normalized, value);
}

/* ## GL_ARB_draw_indirect ## */
static PFNGLDRAWARRAYSINDIRECTPROC glDrawArraysIndirectPtr = NULL;
void APIENTRY glDrawArraysIndirect (GLenum mode, const GLvoid *indirect)
{
	assert(glDrawArraysIndirectPtr != NULL);
	return glDrawArraysIndirectPtr(mode, indirect);
}

static PFNGLDRAWELEMENTSINDIRECTPROC glDrawElementsIndirectPtr = NULL;
void APIENTRY glDrawElementsIndirect (GLenum mode, GLenum type, const GLvoid *indirect)
{
	assert(glDrawElementsIndirectPtr != NULL);
	return glDrawElementsIndirectPtr(mode, type, indirect);
}

/* ## GL_ARB_gpu_shader_fp64 ## */
static PFNGLUNIFORM1DPROC glUniform1dPtr = NULL;
void APIENTRY glUniform1d (GLint location, GLdouble x)
{
	assert(glUniform1dPtr != NULL);
	return glUniform1dPtr(location, x);
}

static PFNGLUNIFORM2DPROC glUniform2dPtr = NULL;
void APIENTRY glUniform2d (GLint location, GLdouble x, GLdouble y)
{
	assert(glUniform2dPtr != NULL);
	return glUniform2dPtr(location, x, y);
}

static PFNGLUNIFORM3DPROC glUniform3dPtr = NULL;
void APIENTRY glUniform3d (GLint location, GLdouble x, GLdouble y, GLdouble z)
{
	assert(glUniform3dPtr != NULL);
	return glUniform3dPtr(location, x, y, z);
}

static PFNGLUNIFORM4DPROC glUniform4dPtr = NULL;
void APIENTRY glUniform4d (GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
	assert(glUniform4dPtr != NULL);
	return glUniform4dPtr(location, x, y, z, w);
}

static PFNGLUNIFORM1DVPROC glUniform1dvPtr = NULL;
void APIENTRY glUniform1dv (GLint location, GLsizei count, const GLdouble *value)
{
	assert(glUniform1dvPtr != NULL);
	return glUniform1dvPtr(location, count, value);
}

static PFNGLUNIFORM2DVPROC glUniform2dvPtr = NULL;
void APIENTRY glUniform2dv (GLint location, GLsizei count, const GLdouble *value)
{
	assert(glUniform2dvPtr != NULL);
	return glUniform2dvPtr(location, count, value);
}

static PFNGLUNIFORM3DVPROC glUniform3dvPtr = NULL;
void APIENTRY glUniform3dv (GLint location, GLsizei count, const GLdouble *value)
{
	assert(glUniform3dvPtr != NULL);
	return glUniform3dvPtr(location, count, value);
}

static PFNGLUNIFORM4DVPROC glUniform4dvPtr = NULL;
void APIENTRY glUniform4dv (GLint location, GLsizei count, const GLdouble *value)
{
	assert(glUniform4dvPtr != NULL);
	return glUniform4dvPtr(location, count, value);
}

static PFNGLUNIFORMMATRIX2DVPROC glUniformMatrix2dvPtr = NULL;
void APIENTRY glUniformMatrix2dv (GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
	assert(glUniformMatrix2dvPtr != NULL);
	return glUniformMatrix2dvPtr(location, count, transpose, value);
}

static PFNGLUNIFORMMATRIX3DVPROC glUniformMatrix3dvPtr = NULL;
void APIENTRY glUniformMatrix3dv (GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
	assert(glUniformMatrix3dvPtr != NULL);
	return glUniformMatrix3dvPtr(location, count, transpose, value);
}

static PFNGLUNIFORMMATRIX4DVPROC glUniformMatrix4dvPtr = NULL;
void APIENTRY glUniformMatrix4dv (GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
	assert(glUniformMatrix4dvPtr != NULL);
	return glUniformMatrix4dvPtr(location, count, transpose, value);
}

static PFNGLUNIFORMMATRIX2X3DVPROC glUniformMatrix2x3dvPtr = NULL;
void APIENTRY glUniformMatrix2x3dv (GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
	assert(glUniformMatrix2x3dvPtr != NULL);
	return glUniformMatrix2x3dvPtr(location, count, transpose, value);
}

static PFNGLUNIFORMMATRIX2X4DVPROC glUniformMatrix2x4dvPtr = NULL;
void APIENTRY glUniformMatrix2x4dv (GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
	assert(glUniformMatrix2x4dvPtr != NULL);
	return glUniformMatrix2x4dvPtr(location, count, transpose, value);
}

static PFNGLUNIFORMMATRIX3X2DVPROC glUniformMatrix3x2dvPtr = NULL;
void APIENTRY glUniformMatrix3x2dv (GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
	assert(glUniformMatrix3x2dvPtr != NULL);
	return glUniformMatrix3x2dvPtr(location, count, transpose, value);
}

static PFNGLUNIFORMMATRIX3X4DVPROC glUniformMatrix3x4dvPtr = NULL;
void APIENTRY glUniformMatrix3x4dv (GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
	assert(glUniformMatrix3x4dvPtr != NULL);
	return glUniformMatrix3x4dvPtr(location, count, transpose, value);
}

static PFNGLUNIFORMMATRIX4X2DVPROC glUniformMatrix4x2dvPtr = NULL;
void APIENTRY glUniformMatrix4x2dv (GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
	assert(glUniformMatrix4x2dvPtr != NULL);
	return glUniformMatrix4x2dvPtr(location, count, transpose, value);
}

static PFNGLUNIFORMMATRIX4X3DVPROC glUniformMatrix4x3dvPtr = NULL;
void APIENTRY glUniformMatrix4x3dv (GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
	assert(glUniformMatrix4x3dvPtr != NULL);
	return glUniformMatrix4x3dvPtr(location, count, transpose, value);
}

static PFNGLGETUNIFORMDVPROC glGetUniformdvPtr = NULL;
void APIENTRY glGetUniformdv (GLuint program, GLint location, GLdouble *params)
{
	assert(glGetUniformdvPtr != NULL);
	return glGetUniformdvPtr(program, location, params);
}

/* ## GL_ARB_shader_subroutine ## */
static PFNGLGETSUBROUTINEUNIFORMLOCATIONPROC glGetSubroutineUniformLocationPtr = NULL;
GLint APIENTRY glGetSubroutineUniformLocation (GLuint program, GLenum shadertype, const GLchar *name)
{
	assert(glGetSubroutineUniformLocationPtr != NULL);
	return glGetSubroutineUniformLocationPtr(program, shadertype, name);
}

static PFNGLGETSUBROUTINEINDEXPROC glGetSubroutineIndexPtr = NULL;
GLuint APIENTRY glGetSubroutineIndex (GLuint program, GLenum shadertype, const GLchar *name)
{
	assert(glGetSubroutineIndexPtr != NULL);
	return glGetSubroutineIndexPtr(program, shadertype, name);
}

static PFNGLGETACTIVESUBROUTINEUNIFORMIVPROC glGetActiveSubroutineUniformivPtr = NULL;
void APIENTRY glGetActiveSubroutineUniformiv (GLuint program, GLenum shadertype, GLuint index, GLenum pname, GLint *values)
{
	assert(glGetActiveSubroutineUniformivPtr != NULL);
	return glGetActiveSubroutineUniformivPtr(program, shadertype, index, pname, values);
}

static PFNGLGETACTIVESUBROUTINEUNIFORMNAMEPROC glGetActiveSubroutineUniformNamePtr = NULL;
void APIENTRY glGetActiveSubroutineUniformName (GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei *length, GLchar *name)
{
	assert(glGetActiveSubroutineUniformNamePtr != NULL);
	return glGetActiveSubroutineUniformNamePtr(program, shadertype, index, bufsize, length, name);
}

static PFNGLGETACTIVESUBROUTINENAMEPROC glGetActiveSubroutineNamePtr = NULL;
void APIENTRY glGetActiveSubroutineName (GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei *length, GLchar *name)
{
	assert(glGetActiveSubroutineNamePtr != NULL);
	return glGetActiveSubroutineNamePtr(program, shadertype, index, bufsize, length, name);
}

static PFNGLUNIFORMSUBROUTINESUIVPROC glUniformSubroutinesuivPtr = NULL;
void APIENTRY glUniformSubroutinesuiv (GLenum shadertype, GLsizei count, const GLuint *indices)
{
	assert(glUniformSubroutinesuivPtr != NULL);
	return glUniformSubroutinesuivPtr(shadertype, count, indices);
}

static PFNGLGETUNIFORMSUBROUTINEUIVPROC glGetUniformSubroutineuivPtr = NULL;
void APIENTRY glGetUniformSubroutineuiv (GLenum shadertype, GLint location, GLuint *params)
{
	assert(glGetUniformSubroutineuivPtr != NULL);
	return glGetUniformSubroutineuivPtr(shadertype, location, params);
}

static PFNGLGETPROGRAMSTAGEIVPROC glGetProgramStageivPtr = NULL;
void APIENTRY glGetProgramStageiv (GLuint program, GLenum shadertype, GLenum pname, GLint *values)
{
	assert(glGetProgramStageivPtr != NULL);
	return glGetProgramStageivPtr(program, shadertype, pname, values);
}

/* ## GL_ARB_tessellation_shader ## */
static PFNGLPATCHPARAMETERIPROC glPatchParameteriPtr = NULL;
void APIENTRY glPatchParameteri (GLenum pname, GLint value)
{
	assert(glPatchParameteriPtr != NULL);
	return glPatchParameteriPtr(pname, value);
}

static PFNGLPATCHPARAMETERFVPROC glPatchParameterfvPtr = NULL;
void APIENTRY glPatchParameterfv (GLenum pname, const GLfloat *values)
{
	assert(glPatchParameterfvPtr != NULL);
	return glPatchParameterfvPtr(pname, values);
}

/* ## GL_ARB_transform_feedback2 ## */
static PFNGLBINDTRANSFORMFEEDBACKPROC glBindTransformFeedbackPtr = NULL;
void APIENTRY glBindTransformFeedback (GLenum target, GLuint id)
{
	assert(glBindTransformFeedbackPtr != NULL);
	return glBindTransformFeedbackPtr(target, id);
}

static PFNGLDELETETRANSFORMFEEDBACKSPROC glDeleteTransformFeedbacksPtr = NULL;
void APIENTRY glDeleteTransformFeedbacks (GLsizei n, const GLuint *ids)
{
	assert(glDeleteTransformFeedbacksPtr != NULL);
	return glDeleteTransformFeedbacksPtr(n, ids);
}

static PFNGLGENTRANSFORMFEEDBACKSPROC glGenTransformFeedbacksPtr = NULL;
void APIENTRY glGenTransformFeedbacks (GLsizei n, GLuint *ids)
{
	assert(glGenTransformFeedbacksPtr != NULL);
	return glGenTransformFeedbacksPtr(n, ids);
}

static PFNGLISTRANSFORMFEEDBACKPROC glIsTransformFeedbackPtr = NULL;
GLboolean APIENTRY glIsTransformFeedback (GLuint id)
{
	assert(glIsTransformFeedbackPtr != NULL);
	return glIsTransformFeedbackPtr(id);
}

static PFNGLPAUSETRANSFORMFEEDBACKPROC glPauseTransformFeedbackPtr = NULL;
void APIENTRY glPauseTransformFeedback (void)
{
	assert(glPauseTransformFeedbackPtr != NULL);
	return glPauseTransformFeedbackPtr();
}

static PFNGLRESUMETRANSFORMFEEDBACKPROC glResumeTransformFeedbackPtr = NULL;
void APIENTRY glResumeTransformFeedback (void)
{
	assert(glResumeTransformFeedbackPtr != NULL);
	return glResumeTransformFeedbackPtr();
}

static PFNGLDRAWTRANSFORMFEEDBACKPROC glDrawTransformFeedbackPtr = NULL;
void APIENTRY glDrawTransformFeedback (GLenum mode, GLuint id)
{
	assert(glDrawTransformFeedbackPtr != NULL);
	return glDrawTransformFeedbackPtr(mode, id);
}

/* ## GL_ARB_transform_feedback3 ## */
static PFNGLDRAWTRANSFORMFEEDBACKSTREAMPROC glDrawTransformFeedbackStreamPtr = NULL;
void APIENTRY glDrawTransformFeedbackStream (GLenum mode, GLuint id, GLuint stream)
{
	assert(glDrawTransformFeedbackStreamPtr != NULL);
	return glDrawTransformFeedbackStreamPtr(mode, id, stream);
}

static PFNGLBEGINQUERYINDEXEDPROC glBeginQueryIndexedPtr = NULL;
void APIENTRY glBeginQueryIndexed (GLenum target, GLuint index, GLuint id)
{
	assert(glBeginQueryIndexedPtr != NULL);
	return glBeginQueryIndexedPtr(target, index, id);
}

static PFNGLENDQUERYINDEXEDPROC glEndQueryIndexedPtr = NULL;
void APIENTRY glEndQueryIndexed (GLenum target, GLuint index)
{
	assert(glEndQueryIndexedPtr != NULL);
	return glEndQueryIndexedPtr(target, index);
}

static PFNGLGETQUERYINDEXEDIVPROC glGetQueryIndexedivPtr = NULL;
void APIENTRY glGetQueryIndexediv (GLenum target, GLuint index, GLenum pname, GLint *params)
{
	assert(glGetQueryIndexedivPtr != NULL);
	return glGetQueryIndexedivPtr(target, index, pname, params);
}

/* ## GL_ARB_ES2_compatibility ## */
static PFNGLRELEASESHADERCOMPILERPROC glReleaseShaderCompilerPtr = NULL;
void APIENTRY glReleaseShaderCompiler (void)
{
	assert(glReleaseShaderCompilerPtr != NULL);
	return glReleaseShaderCompilerPtr();
}

static PFNGLSHADERBINARYPROC glShaderBinaryPtr = NULL;
void APIENTRY glShaderBinary (GLsizei count, const GLuint *shaders, GLenum binaryformat, const GLvoid *binary, GLsizei length)
{
	assert(glShaderBinaryPtr != NULL);
	return glShaderBinaryPtr(count, shaders, binaryformat, binary, length);
}

static PFNGLGETSHADERPRECISIONFORMATPROC glGetShaderPrecisionFormatPtr = NULL;
void APIENTRY glGetShaderPrecisionFormat (GLenum shadertype, GLenum precisiontype, GLint *range, GLint *precision)
{
	assert(glGetShaderPrecisionFormatPtr != NULL);
	return glGetShaderPrecisionFormatPtr(shadertype, precisiontype, range, precision);
}

static PFNGLDEPTHRANGEFPROC glDepthRangefPtr = NULL;
void APIENTRY glDepthRangef (GLfloat n, GLfloat f)
{
	assert(glDepthRangefPtr != NULL);
	return glDepthRangefPtr(n, f);
}

static PFNGLCLEARDEPTHFPROC glClearDepthfPtr = NULL;
void APIENTRY glClearDepthf (GLfloat d)
{
	assert(glClearDepthfPtr != NULL);
	return glClearDepthfPtr(d);
}

/* ## GL_ARB_get_program_binary ## */
static PFNGLGETPROGRAMBINARYPROC glGetProgramBinaryPtr = NULL;
void APIENTRY glGetProgramBinary (GLuint program, GLsizei bufSize, GLsizei *length, GLenum *binaryFormat, GLvoid *binary)
{
	assert(glGetProgramBinaryPtr != NULL);
	return glGetProgramBinaryPtr(program, bufSize, length, binaryFormat, binary);
}

static PFNGLPROGRAMBINARYPROC glProgramBinaryPtr = NULL;
void APIENTRY glProgramBinary (GLuint program, GLenum binaryFormat, const GLvoid *binary, GLsizei length)
{
	assert(glProgramBinaryPtr != NULL);
	return glProgramBinaryPtr(program, binaryFormat, binary, length);
}

static PFNGLPROGRAMPARAMETERIPROC glProgramParameteriPtr = NULL;
void APIENTRY glProgramParameteri (GLuint program, GLenum pname, GLint value)
{
	assert(glProgramParameteriPtr != NULL);
	return glProgramParameteriPtr(program, pname, value);
}

/* ## GL_ARB_separate_shader_objects ## */
static PFNGLUSEPROGRAMSTAGESPROC glUseProgramStagesPtr = NULL;
void APIENTRY glUseProgramStages (GLuint pipeline, GLbitfield stages, GLuint program)
{
	assert(glUseProgramStagesPtr != NULL);
	return glUseProgramStagesPtr(pipeline, stages, program);
}

static PFNGLACTIVESHADERPROGRAMPROC glActiveShaderProgramPtr = NULL;
void APIENTRY glActiveShaderProgram (GLuint pipeline, GLuint program)
{
	assert(glActiveShaderProgramPtr != NULL);
	return glActiveShaderProgramPtr(pipeline, program);
}

static PFNGLCREATESHADERPROGRAMVPROC glCreateShaderProgramvPtr = NULL;
GLuint APIENTRY glCreateShaderProgramv (GLenum type, GLsizei count, const GLchar* const *strings)
{
	assert(glCreateShaderProgramvPtr != NULL);
	return glCreateShaderProgramvPtr(type, count, strings);
}

static PFNGLBINDPROGRAMPIPELINEPROC glBindProgramPipelinePtr = NULL;
void APIENTRY glBindProgramPipeline (GLuint pipeline)
{
	assert(glBindProgramPipelinePtr != NULL);
	return glBindProgramPipelinePtr(pipeline);
}

static PFNGLDELETEPROGRAMPIPELINESPROC glDeleteProgramPipelinesPtr = NULL;
void APIENTRY glDeleteProgramPipelines (GLsizei n, const GLuint *pipelines)
{
	assert(glDeleteProgramPipelinesPtr != NULL);
	return glDeleteProgramPipelinesPtr(n, pipelines);
}

static PFNGLGENPROGRAMPIPELINESPROC glGenProgramPipelinesPtr = NULL;
void APIENTRY glGenProgramPipelines (GLsizei n, GLuint *pipelines)
{
	assert(glGenProgramPipelinesPtr != NULL);
	return glGenProgramPipelinesPtr(n, pipelines);
}

static PFNGLISPROGRAMPIPELINEPROC glIsProgramPipelinePtr = NULL;
GLboolean APIENTRY glIsProgramPipeline (GLuint pipeline)
{
	assert(glIsProgramPipelinePtr != NULL);
	return glIsProgramPipelinePtr(pipeline);
}

static PFNGLGETPROGRAMPIPELINEIVPROC glGetProgramPipelineivPtr = NULL;
void APIENTRY glGetProgramPipelineiv (GLuint pipeline, GLenum pname, GLint *params)
{
	assert(glGetProgramPipelineivPtr != NULL);
	return glGetProgramPipelineivPtr(pipeline, pname, params);
}

static PFNGLPROGRAMUNIFORM1IPROC glProgramUniform1iPtr = NULL;
void APIENTRY glProgramUniform1i (GLuint program, GLint location, GLint v0)
{
	assert(glProgramUniform1iPtr != NULL);
	return glProgramUniform1iPtr(program, location, v0);
}

static PFNGLPROGRAMUNIFORM1IVPROC glProgramUniform1ivPtr = NULL;
void APIENTRY glProgramUniform1iv (GLuint program, GLint location, GLsizei count, const GLint *value)
{
	assert(glProgramUniform1ivPtr != NULL);
	return glProgramUniform1ivPtr(program, location, count, value);
}

static PFNGLPROGRAMUNIFORM1FPROC glProgramUniform1fPtr = NULL;
void APIENTRY glProgramUniform1f (GLuint program, GLint location, GLfloat v0)
{
	assert(glProgramUniform1fPtr != NULL);
	return glProgramUniform1fPtr(program, location, v0);
}

static PFNGLPROGRAMUNIFORM1FVPROC glProgramUniform1fvPtr = NULL;
void APIENTRY glProgramUniform1fv (GLuint program, GLint location, GLsizei count, const GLfloat *value)
{
	assert(glProgramUniform1fvPtr != NULL);
	return glProgramUniform1fvPtr(program, location, count, value);
}

static PFNGLPROGRAMUNIFORM1DPROC glProgramUniform1dPtr = NULL;
void APIENTRY glProgramUniform1d (GLuint program, GLint location, GLdouble v0)
{
	assert(glProgramUniform1dPtr != NULL);
	return glProgramUniform1dPtr(program, location, v0);
}

static PFNGLPROGRAMUNIFORM1DVPROC glProgramUniform1dvPtr = NULL;
void APIENTRY glProgramUniform1dv (GLuint program, GLint location, GLsizei count, const GLdouble *value)
{
	assert(glProgramUniform1dvPtr != NULL);
	return glProgramUniform1dvPtr(program, location, count, value);
}

static PFNGLPROGRAMUNIFORM1UIPROC glProgramUniform1uiPtr = NULL;
void APIENTRY glProgramUniform1ui (GLuint program, GLint location, GLuint v0)
{
	assert(glProgramUniform1uiPtr != NULL);
	return glProgramUniform1uiPtr(program, location, v0);
}

static PFNGLPROGRAMUNIFORM1UIVPROC glProgramUniform1uivPtr = NULL;
void APIENTRY glProgramUniform1uiv (GLuint program, GLint location, GLsizei count, const GLuint *value)
{
	assert(glProgramUniform1uivPtr != NULL);
	return glProgramUniform1uivPtr(program, location, count, value);
}

static PFNGLPROGRAMUNIFORM2IPROC glProgramUniform2iPtr = NULL;
void APIENTRY glProgramUniform2i (GLuint program, GLint location, GLint v0, GLint v1)
{
	assert(glProgramUniform2iPtr != NULL);
	return glProgramUniform2iPtr(program, location, v0, v1);
}

static PFNGLPROGRAMUNIFORM2IVPROC glProgramUniform2ivPtr = NULL;
void APIENTRY glProgramUniform2iv (GLuint program, GLint location, GLsizei count, const GLint *value)
{
	assert(glProgramUniform2ivPtr != NULL);
	return glProgramUniform2ivPtr(program, location, count, value);
}

static PFNGLPROGRAMUNIFORM2FPROC glProgramUniform2fPtr = NULL;
void APIENTRY glProgramUniform2f (GLuint program, GLint location, GLfloat v0, GLfloat v1)
{
	assert(glProgramUniform2fPtr != NULL);
	return glProgramUniform2fPtr(program, location, v0, v1);
}

static PFNGLPROGRAMUNIFORM2FVPROC glProgramUniform2fvPtr = NULL;
void APIENTRY glProgramUniform2fv (GLuint program, GLint location, GLsizei count, const GLfloat *value)
{
	assert(glProgramUniform2fvPtr != NULL);
	return glProgramUniform2fvPtr(program, location, count, value);
}

static PFNGLPROGRAMUNIFORM2DPROC glProgramUniform2dPtr = NULL;
void APIENTRY glProgramUniform2d (GLuint program, GLint location, GLdouble v0, GLdouble v1)
{
	assert(glProgramUniform2dPtr != NULL);
	return glProgramUniform2dPtr(program, location, v0, v1);
}

static PFNGLPROGRAMUNIFORM2DVPROC glProgramUniform2dvPtr = NULL;
void APIENTRY glProgramUniform2dv (GLuint program, GLint location, GLsizei count, const GLdouble *value)
{
	assert(glProgramUniform2dvPtr != NULL);
	return glProgramUniform2dvPtr(program, location, count, value);
}

static PFNGLPROGRAMUNIFORM2UIPROC glProgramUniform2uiPtr = NULL;
void APIENTRY glProgramUniform2ui (GLuint program, GLint location, GLuint v0, GLuint v1)
{
	assert(glProgramUniform2uiPtr != NULL);
	return glProgramUniform2uiPtr(program, location, v0, v1);
}

static PFNGLPROGRAMUNIFORM2UIVPROC glProgramUniform2uivPtr = NULL;
void APIENTRY glProgramUniform2uiv (GLuint program, GLint location, GLsizei count, const GLuint *value)
{
	assert(glProgramUniform2uivPtr != NULL);
	return glProgramUniform2uivPtr(program, location, count, value);
}

static PFNGLPROGRAMUNIFORM3IPROC glProgramUniform3iPtr = NULL;
void APIENTRY glProgramUniform3i (GLuint program, GLint location, GLint v0, GLint v1, GLint v2)
{
	assert(glProgramUniform3iPtr != NULL);
	return glProgramUniform3iPtr(program, location, v0, v1, v2);
}

static PFNGLPROGRAMUNIFORM3IVPROC glProgramUniform3ivPtr = NULL;
void APIENTRY glProgramUniform3iv (GLuint program, GLint location, GLsizei count, const GLint *value)
{
	assert(glProgramUniform3ivPtr != NULL);
	return glProgramUniform3ivPtr(program, location, count, value);
}

static PFNGLPROGRAMUNIFORM3FPROC glProgramUniform3fPtr = NULL;
void APIENTRY glProgramUniform3f (GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2)
{
	assert(glProgramUniform3fPtr != NULL);
	return glProgramUniform3fPtr(program, location, v0, v1, v2);
}

static PFNGLPROGRAMUNIFORM3FVPROC glProgramUniform3fvPtr = NULL;
void APIENTRY glProgramUniform3fv (GLuint program, GLint location, GLsizei count, const GLfloat *value)
{
	assert(glProgramUniform3fvPtr != NULL);
	return glProgramUniform3fvPtr(program, location, count, value);
}

static PFNGLPROGRAMUNIFORM3DPROC glProgramUniform3dPtr = NULL;
void APIENTRY glProgramUniform3d (GLuint program, GLint location, GLdouble v0, GLdouble v1, GLdouble v2)
{
	assert(glProgramUniform3dPtr != NULL);
	return glProgramUniform3dPtr(program, location, v0, v1, v2);
}

static PFNGLPROGRAMUNIFORM3DVPROC glProgramUniform3dvPtr = NULL;
void APIENTRY glProgramUniform3dv (GLuint program, GLint location, GLsizei count, const GLdouble *value)
{
	assert(glProgramUniform3dvPtr != NULL);
	return glProgramUniform3dvPtr(program, location, count, value);
}

static PFNGLPROGRAMUNIFORM3UIPROC glProgramUniform3uiPtr = NULL;
void APIENTRY glProgramUniform3ui (GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2)
{
	assert(glProgramUniform3uiPtr != NULL);
	return glProgramUniform3uiPtr(program, location, v0, v1, v2);
}

static PFNGLPROGRAMUNIFORM3UIVPROC glProgramUniform3uivPtr = NULL;
void APIENTRY glProgramUniform3uiv (GLuint program, GLint location, GLsizei count, const GLuint *value)
{
	assert(glProgramUniform3uivPtr != NULL);
	return glProgramUniform3uivPtr(program, location, count, value);
}

static PFNGLPROGRAMUNIFORM4IPROC glProgramUniform4iPtr = NULL;
void APIENTRY glProgramUniform4i (GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3)
{
	assert(glProgramUniform4iPtr != NULL);
	return glProgramUniform4iPtr(program, location, v0, v1, v2, v3);
}

static PFNGLPROGRAMUNIFORM4IVPROC glProgramUniform4ivPtr = NULL;
void APIENTRY glProgramUniform4iv (GLuint program, GLint location, GLsizei count, const GLint *value)
{
	assert(glProgramUniform4ivPtr != NULL);
	return glProgramUniform4ivPtr(program, location, count, value);
}

static PFNGLPROGRAMUNIFORM4FPROC glProgramUniform4fPtr = NULL;
void APIENTRY glProgramUniform4f (GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)
{
	assert(glProgramUniform4fPtr != NULL);
	return glProgramUniform4fPtr(program, location, v0, v1, v2, v3);
}

static PFNGLPROGRAMUNIFORM4FVPROC glProgramUniform4fvPtr = NULL;
void APIENTRY glProgramUniform4fv (GLuint program, GLint location, GLsizei count, const GLfloat *value)
{
	assert(glProgramUniform4fvPtr != NULL);
	return glProgramUniform4fvPtr(program, location, count, value);
}

static PFNGLPROGRAMUNIFORM4DPROC glProgramUniform4dPtr = NULL;
void APIENTRY glProgramUniform4d (GLuint program, GLint location, GLdouble v0, GLdouble v1, GLdouble v2, GLdouble v3)
{
	assert(glProgramUniform4dPtr != NULL);
	return glProgramUniform4dPtr(program, location, v0, v1, v2, v3);
}

static PFNGLPROGRAMUNIFORM4DVPROC glProgramUniform4dvPtr = NULL;
void APIENTRY glProgramUniform4dv (GLuint program, GLint location, GLsizei count, const GLdouble *value)
{
	assert(glProgramUniform4dvPtr != NULL);
	return glProgramUniform4dvPtr(program, location, count, value);
}

static PFNGLPROGRAMUNIFORM4UIPROC glProgramUniform4uiPtr = NULL;
void APIENTRY glProgramUniform4ui (GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)
{
	assert(glProgramUniform4uiPtr != NULL);
	return glProgramUniform4uiPtr(program, location, v0, v1, v2, v3);
}

static PFNGLPROGRAMUNIFORM4UIVPROC glProgramUniform4uivPtr = NULL;
void APIENTRY glProgramUniform4uiv (GLuint program, GLint location, GLsizei count, const GLuint *value)
{
	assert(glProgramUniform4uivPtr != NULL);
	return glProgramUniform4uivPtr(program, location, count, value);
}

static PFNGLPROGRAMUNIFORMMATRIX2FVPROC glProgramUniformMatrix2fvPtr = NULL;
void APIENTRY glProgramUniformMatrix2fv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
	assert(glProgramUniformMatrix2fvPtr != NULL);
	return glProgramUniformMatrix2fvPtr(program, location, count, transpose, value);
}

static PFNGLPROGRAMUNIFORMMATRIX3FVPROC glProgramUniformMatrix3fvPtr = NULL;
void APIENTRY glProgramUniformMatrix3fv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
	assert(glProgramUniformMatrix3fvPtr != NULL);
	return glProgramUniformMatrix3fvPtr(program, location, count, transpose, value);
}

static PFNGLPROGRAMUNIFORMMATRIX4FVPROC glProgramUniformMatrix4fvPtr = NULL;
void APIENTRY glProgramUniformMatrix4fv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
	assert(glProgramUniformMatrix4fvPtr != NULL);
	return glProgramUniformMatrix4fvPtr(program, location, count, transpose, value);
}

static PFNGLPROGRAMUNIFORMMATRIX2DVPROC glProgramUniformMatrix2dvPtr = NULL;
void APIENTRY glProgramUniformMatrix2dv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
	assert(glProgramUniformMatrix2dvPtr != NULL);
	return glProgramUniformMatrix2dvPtr(program, location, count, transpose, value);
}

static PFNGLPROGRAMUNIFORMMATRIX3DVPROC glProgramUniformMatrix3dvPtr = NULL;
void APIENTRY glProgramUniformMatrix3dv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
	assert(glProgramUniformMatrix3dvPtr != NULL);
	return glProgramUniformMatrix3dvPtr(program, location, count, transpose, value);
}

static PFNGLPROGRAMUNIFORMMATRIX4DVPROC glProgramUniformMatrix4dvPtr = NULL;
void APIENTRY glProgramUniformMatrix4dv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
	assert(glProgramUniformMatrix4dvPtr != NULL);
	return glProgramUniformMatrix4dvPtr(program, location, count, transpose, value);
}

static PFNGLPROGRAMUNIFORMMATRIX2X3FVPROC glProgramUniformMatrix2x3fvPtr = NULL;
void APIENTRY glProgramUniformMatrix2x3fv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
	assert(glProgramUniformMatrix2x3fvPtr != NULL);
	return glProgramUniformMatrix2x3fvPtr(program, location, count, transpose, value);
}

static PFNGLPROGRAMUNIFORMMATRIX3X2FVPROC glProgramUniformMatrix3x2fvPtr = NULL;
void APIENTRY glProgramUniformMatrix3x2fv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
	assert(glProgramUniformMatrix3x2fvPtr != NULL);
	return glProgramUniformMatrix3x2fvPtr(program, location, count, transpose, value);
}

static PFNGLPROGRAMUNIFORMMATRIX2X4FVPROC glProgramUniformMatrix2x4fvPtr = NULL;
void APIENTRY glProgramUniformMatrix2x4fv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
	assert(glProgramUniformMatrix2x4fvPtr != NULL);
	return glProgramUniformMatrix2x4fvPtr(program, location, count, transpose, value);
}

static PFNGLPROGRAMUNIFORMMATRIX4X2FVPROC glProgramUniformMatrix4x2fvPtr = NULL;
void APIENTRY glProgramUniformMatrix4x2fv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
	assert(glProgramUniformMatrix4x2fvPtr != NULL);
	return glProgramUniformMatrix4x2fvPtr(program, location, count, transpose, value);
}

static PFNGLPROGRAMUNIFORMMATRIX3X4FVPROC glProgramUniformMatrix3x4fvPtr = NULL;
void APIENTRY glProgramUniformMatrix3x4fv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
	assert(glProgramUniformMatrix3x4fvPtr != NULL);
	return glProgramUniformMatrix3x4fvPtr(program, location, count, transpose, value);
}

static PFNGLPROGRAMUNIFORMMATRIX4X3FVPROC glProgramUniformMatrix4x3fvPtr = NULL;
void APIENTRY glProgramUniformMatrix4x3fv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
	assert(glProgramUniformMatrix4x3fvPtr != NULL);
	return glProgramUniformMatrix4x3fvPtr(program, location, count, transpose, value);
}

static PFNGLPROGRAMUNIFORMMATRIX2X3DVPROC glProgramUniformMatrix2x3dvPtr = NULL;
void APIENTRY glProgramUniformMatrix2x3dv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
	assert(glProgramUniformMatrix2x3dvPtr != NULL);
	return glProgramUniformMatrix2x3dvPtr(program, location, count, transpose, value);
}

static PFNGLPROGRAMUNIFORMMATRIX3X2DVPROC glProgramUniformMatrix3x2dvPtr = NULL;
void APIENTRY glProgramUniformMatrix3x2dv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
	assert(glProgramUniformMatrix3x2dvPtr != NULL);
	return glProgramUniformMatrix3x2dvPtr(program, location, count, transpose, value);
}

static PFNGLPROGRAMUNIFORMMATRIX2X4DVPROC glProgramUniformMatrix2x4dvPtr = NULL;
void APIENTRY glProgramUniformMatrix2x4dv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
	assert(glProgramUniformMatrix2x4dvPtr != NULL);
	return glProgramUniformMatrix2x4dvPtr(program, location, count, transpose, value);
}

static PFNGLPROGRAMUNIFORMMATRIX4X2DVPROC glProgramUniformMatrix4x2dvPtr = NULL;
void APIENTRY glProgramUniformMatrix4x2dv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
	assert(glProgramUniformMatrix4x2dvPtr != NULL);
	return glProgramUniformMatrix4x2dvPtr(program, location, count, transpose, value);
}

static PFNGLPROGRAMUNIFORMMATRIX3X4DVPROC glProgramUniformMatrix3x4dvPtr = NULL;
void APIENTRY glProgramUniformMatrix3x4dv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
	assert(glProgramUniformMatrix3x4dvPtr != NULL);
	return glProgramUniformMatrix3x4dvPtr(program, location, count, transpose, value);
}

static PFNGLPROGRAMUNIFORMMATRIX4X3DVPROC glProgramUniformMatrix4x3dvPtr = NULL;
void APIENTRY glProgramUniformMatrix4x3dv (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value)
{
	assert(glProgramUniformMatrix4x3dvPtr != NULL);
	return glProgramUniformMatrix4x3dvPtr(program, location, count, transpose, value);
}

static PFNGLVALIDATEPROGRAMPIPELINEPROC glValidateProgramPipelinePtr = NULL;
void APIENTRY glValidateProgramPipeline (GLuint pipeline)
{
	assert(glValidateProgramPipelinePtr != NULL);
	return glValidateProgramPipelinePtr(pipeline);
}

static PFNGLGETPROGRAMPIPELINEINFOLOGPROC glGetProgramPipelineInfoLogPtr = NULL;
void APIENTRY glGetProgramPipelineInfoLog (GLuint pipeline, GLsizei bufSize, GLsizei *length, GLchar *infoLog)
{
	assert(glGetProgramPipelineInfoLogPtr != NULL);
	return glGetProgramPipelineInfoLogPtr(pipeline, bufSize, length, infoLog);
}

/* ## GL_ARB_vertex_attrib_64bit ## */
static PFNGLVERTEXATTRIBL1DPROC glVertexAttribL1dPtr = NULL;
void APIENTRY glVertexAttribL1d (GLuint index, GLdouble x)
{
	assert(glVertexAttribL1dPtr != NULL);
	return glVertexAttribL1dPtr(index, x);
}

static PFNGLVERTEXATTRIBL2DPROC glVertexAttribL2dPtr = NULL;
void APIENTRY glVertexAttribL2d (GLuint index, GLdouble x, GLdouble y)
{
	assert(glVertexAttribL2dPtr != NULL);
	return glVertexAttribL2dPtr(index, x, y);
}

static PFNGLVERTEXATTRIBL3DPROC glVertexAttribL3dPtr = NULL;
void APIENTRY glVertexAttribL3d (GLuint index, GLdouble x, GLdouble y, GLdouble z)
{
	assert(glVertexAttribL3dPtr != NULL);
	return glVertexAttribL3dPtr(index, x, y, z);
}

static PFNGLVERTEXATTRIBL4DPROC glVertexAttribL4dPtr = NULL;
void APIENTRY glVertexAttribL4d (GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
	assert(glVertexAttribL4dPtr != NULL);
	return glVertexAttribL4dPtr(index, x, y, z, w);
}

static PFNGLVERTEXATTRIBL1DVPROC glVertexAttribL1dvPtr = NULL;
void APIENTRY glVertexAttribL1dv (GLuint index, const GLdouble *v)
{
	assert(glVertexAttribL1dvPtr != NULL);
	return glVertexAttribL1dvPtr(index, v);
}

static PFNGLVERTEXATTRIBL2DVPROC glVertexAttribL2dvPtr = NULL;
void APIENTRY glVertexAttribL2dv (GLuint index, const GLdouble *v)
{
	assert(glVertexAttribL2dvPtr != NULL);
	return glVertexAttribL2dvPtr(index, v);
}

static PFNGLVERTEXATTRIBL3DVPROC glVertexAttribL3dvPtr = NULL;
void APIENTRY glVertexAttribL3dv (GLuint index, const GLdouble *v)
{
	assert(glVertexAttribL3dvPtr != NULL);
	return glVertexAttribL3dvPtr(index, v);
}

static PFNGLVERTEXATTRIBL4DVPROC glVertexAttribL4dvPtr = NULL;
void APIENTRY glVertexAttribL4dv (GLuint index, const GLdouble *v)
{
	assert(glVertexAttribL4dvPtr != NULL);
	return glVertexAttribL4dvPtr(index, v);
}

static PFNGLVERTEXATTRIBLPOINTERPROC glVertexAttribLPointerPtr = NULL;
void APIENTRY glVertexAttribLPointer (GLuint index, GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)
{
	assert(glVertexAttribLPointerPtr != NULL);
	return glVertexAttribLPointerPtr(index, size, type, stride, pointer);
}

static PFNGLGETVERTEXATTRIBLDVPROC glGetVertexAttribLdvPtr = NULL;
void APIENTRY glGetVertexAttribLdv (GLuint index, GLenum pname, GLdouble *params)
{
	assert(glGetVertexAttribLdvPtr != NULL);
	return glGetVertexAttribLdvPtr(index, pname, params);
}

/* ## GL_ARB_viewport_array ## */
static PFNGLVIEWPORTARRAYVPROC glViewportArrayvPtr = NULL;
void APIENTRY glViewportArrayv (GLuint first, GLsizei count, const GLfloat *v)
{
	assert(glViewportArrayvPtr != NULL);
	return glViewportArrayvPtr(first, count, v);
}

static PFNGLVIEWPORTINDEXEDFPROC glViewportIndexedfPtr = NULL;
void APIENTRY glViewportIndexedf (GLuint index, GLfloat x, GLfloat y, GLfloat w, GLfloat h)
{
	assert(glViewportIndexedfPtr != NULL);
	return glViewportIndexedfPtr(index, x, y, w, h);
}

static PFNGLVIEWPORTINDEXEDFVPROC glViewportIndexedfvPtr = NULL;
void APIENTRY glViewportIndexedfv (GLuint index, const GLfloat *v)
{
	assert(glViewportIndexedfvPtr != NULL);
	return glViewportIndexedfvPtr(index, v);
}

static PFNGLSCISSORARRAYVPROC glScissorArrayvPtr = NULL;
void APIENTRY glScissorArrayv (GLuint first, GLsizei count, const GLint *v)
{
	assert(glScissorArrayvPtr != NULL);
	return glScissorArrayvPtr(first, count, v);
}

static PFNGLSCISSORINDEXEDPROC glScissorIndexedPtr = NULL;
void APIENTRY glScissorIndexed (GLuint index, GLint left, GLint bottom, GLsizei width, GLsizei height)
{
	assert(glScissorIndexedPtr != NULL);
	return glScissorIndexedPtr(index, left, bottom, width, height);
}

static PFNGLSCISSORINDEXEDVPROC glScissorIndexedvPtr = NULL;
void APIENTRY glScissorIndexedv (GLuint index, const GLint *v)
{
	assert(glScissorIndexedvPtr != NULL);
	return glScissorIndexedvPtr(index, v);
}

static PFNGLDEPTHRANGEARRAYVPROC glDepthRangeArrayvPtr = NULL;
void APIENTRY glDepthRangeArrayv (GLuint first, GLsizei count, const GLdouble *v)
{
	assert(glDepthRangeArrayvPtr != NULL);
	return glDepthRangeArrayvPtr(first, count, v);
}

static PFNGLDEPTHRANGEINDEXEDPROC glDepthRangeIndexedPtr = NULL;
void APIENTRY glDepthRangeIndexed (GLuint index, GLdouble n, GLdouble f)
{
	assert(glDepthRangeIndexedPtr != NULL);
	return glDepthRangeIndexedPtr(index, n, f);
}

static PFNGLGETFLOATI_VPROC glGetFloati_vPtr = NULL;
void APIENTRY glGetFloati_v (GLenum target, GLuint index, GLfloat *data)
{
	assert(glGetFloati_vPtr != NULL);
	return glGetFloati_vPtr(target, index, data);
}

static PFNGLGETDOUBLEI_VPROC glGetDoublei_vPtr = NULL;
void APIENTRY glGetDoublei_v (GLenum target, GLuint index, GLdouble *data)
{
	assert(glGetDoublei_vPtr != NULL);
	return glGetDoublei_vPtr(target, index, data);
}

/* ## GL_ARB_cl_event ## */
static PFNGLCREATESYNCFROMCLEVENTARBPROC glCreateSyncFromCLeventARBPtr = NULL;
GLsync APIENTRY glCreateSyncFromCLeventARB (struct _cl_context * context, struct _cl_event * event, GLbitfield flags)
{
	assert(glCreateSyncFromCLeventARBPtr != NULL);
	return glCreateSyncFromCLeventARBPtr( context,  event, flags);
}

/* ## GL_ARB_debug_output ## */
static PFNGLDEBUGMESSAGECONTROLARBPROC glDebugMessageControlARBPtr = NULL;
void APIENTRY glDebugMessageControlARB (GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint *ids, GLboolean enabled)
{
	assert(glDebugMessageControlARBPtr != NULL);
	return glDebugMessageControlARBPtr(source, type, severity, count, ids, enabled);
}

static PFNGLDEBUGMESSAGEINSERTARBPROC glDebugMessageInsertARBPtr = NULL;
void APIENTRY glDebugMessageInsertARB (GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar *buf)
{
	assert(glDebugMessageInsertARBPtr != NULL);
	return glDebugMessageInsertARBPtr(source, type, id, severity, length, buf);
}

static PFNGLDEBUGMESSAGECALLBACKARBPROC glDebugMessageCallbackARBPtr = NULL;
void APIENTRY glDebugMessageCallbackARB (GLDEBUGPROCARB callback, const GLvoid *userParam)
{
	assert(glDebugMessageCallbackARBPtr != NULL);
	return glDebugMessageCallbackARBPtr(callback, userParam);
}

static PFNGLGETDEBUGMESSAGELOGARBPROC glGetDebugMessageLogARBPtr = NULL;
GLuint APIENTRY glGetDebugMessageLogARB (GLuint count, GLsizei bufsize, GLenum *sources, GLenum *types, GLuint *ids, GLenum *severities, GLsizei *lengths, GLchar *messageLog)
{
	assert(glGetDebugMessageLogARBPtr != NULL);
	return glGetDebugMessageLogARBPtr(count, bufsize, sources, types, ids, severities, lengths, messageLog);
}

/* ## GL_ARB_robustness ## */
static PFNGLGETGRAPHICSRESETSTATUSARBPROC glGetGraphicsResetStatusARBPtr = NULL;
GLenum APIENTRY glGetGraphicsResetStatusARB (void)
{
	assert(glGetGraphicsResetStatusARBPtr != NULL);
	return glGetGraphicsResetStatusARBPtr();
}

static PFNGLGETNTEXIMAGEARBPROC glGetnTexImageARBPtr = NULL;
void APIENTRY glGetnTexImageARB (GLenum target, GLint level, GLenum format, GLenum type, GLsizei bufSize, GLvoid *img)
{
	assert(glGetnTexImageARBPtr != NULL);
	return glGetnTexImageARBPtr(target, level, format, type, bufSize, img);
}

static PFNGLREADNPIXELSARBPROC glReadnPixelsARBPtr = NULL;
void APIENTRY glReadnPixelsARB (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, GLvoid *data)
{
	assert(glReadnPixelsARBPtr != NULL);
	return glReadnPixelsARBPtr(x, y, width, height, format, type, bufSize, data);
}

static PFNGLGETNCOMPRESSEDTEXIMAGEARBPROC glGetnCompressedTexImageARBPtr = NULL;
void APIENTRY glGetnCompressedTexImageARB (GLenum target, GLint lod, GLsizei bufSize, GLvoid *img)
{
	assert(glGetnCompressedTexImageARBPtr != NULL);
	return glGetnCompressedTexImageARBPtr(target, lod, bufSize, img);
}

static PFNGLGETNUNIFORMFVARBPROC glGetnUniformfvARBPtr = NULL;
void APIENTRY glGetnUniformfvARB (GLuint program, GLint location, GLsizei bufSize, GLfloat *params)
{
	assert(glGetnUniformfvARBPtr != NULL);
	return glGetnUniformfvARBPtr(program, location, bufSize, params);
}

static PFNGLGETNUNIFORMIVARBPROC glGetnUniformivARBPtr = NULL;
void APIENTRY glGetnUniformivARB (GLuint program, GLint location, GLsizei bufSize, GLint *params)
{
	assert(glGetnUniformivARBPtr != NULL);
	return glGetnUniformivARBPtr(program, location, bufSize, params);
}

static PFNGLGETNUNIFORMUIVARBPROC glGetnUniformuivARBPtr = NULL;
void APIENTRY glGetnUniformuivARB (GLuint program, GLint location, GLsizei bufSize, GLuint *params)
{
	assert(glGetnUniformuivARBPtr != NULL);
	return glGetnUniformuivARBPtr(program, location, bufSize, params);
}

static PFNGLGETNUNIFORMDVARBPROC glGetnUniformdvARBPtr = NULL;
void APIENTRY glGetnUniformdvARB (GLuint program, GLint location, GLsizei bufSize, GLdouble *params)
{
	assert(glGetnUniformdvARBPtr != NULL);
	return glGetnUniformdvARBPtr(program, location, bufSize, params);
}

/* ## GL_ARB_base_instance ## */
static PFNGLDRAWARRAYSINSTANCEDBASEINSTANCEPROC glDrawArraysInstancedBaseInstancePtr = NULL;
void APIENTRY glDrawArraysInstancedBaseInstance (GLenum mode, GLint first, GLsizei count, GLsizei instancecount, GLuint baseinstance)
{
	assert(glDrawArraysInstancedBaseInstancePtr != NULL);
	return glDrawArraysInstancedBaseInstancePtr(mode, first, count, instancecount, baseinstance);
}

static PFNGLDRAWELEMENTSINSTANCEDBASEINSTANCEPROC glDrawElementsInstancedBaseInstancePtr = NULL;
void APIENTRY glDrawElementsInstancedBaseInstance (GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLuint baseinstance)
{
	assert(glDrawElementsInstancedBaseInstancePtr != NULL);
	return glDrawElementsInstancedBaseInstancePtr(mode, count, type, indices, instancecount, baseinstance);
}

static PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXBASEINSTANCEPROC glDrawElementsInstancedBaseVertexBaseInstancePtr = NULL;
void APIENTRY glDrawElementsInstancedBaseVertexBaseInstance (GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLint basevertex, GLuint baseinstance)
{
	assert(glDrawElementsInstancedBaseVertexBaseInstancePtr != NULL);
	return glDrawElementsInstancedBaseVertexBaseInstancePtr(mode, count, type, indices, instancecount, basevertex, baseinstance);
}

/* ## GL_ARB_transform_feedback_instanced ## */
static PFNGLDRAWTRANSFORMFEEDBACKINSTANCEDPROC glDrawTransformFeedbackInstancedPtr = NULL;
void APIENTRY glDrawTransformFeedbackInstanced (GLenum mode, GLuint id, GLsizei instancecount)
{
	assert(glDrawTransformFeedbackInstancedPtr != NULL);
	return glDrawTransformFeedbackInstancedPtr(mode, id, instancecount);
}

static PFNGLDRAWTRANSFORMFEEDBACKSTREAMINSTANCEDPROC glDrawTransformFeedbackStreamInstancedPtr = NULL;
void APIENTRY glDrawTransformFeedbackStreamInstanced (GLenum mode, GLuint id, GLuint stream, GLsizei instancecount)
{
	assert(glDrawTransformFeedbackStreamInstancedPtr != NULL);
	return glDrawTransformFeedbackStreamInstancedPtr(mode, id, stream, instancecount);
}

/* ## GL_ARB_internalformat_query ## */
static PFNGLGETINTERNALFORMATIVPROC glGetInternalformativPtr = NULL;
void APIENTRY glGetInternalformativ (GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint *params)
{
	assert(glGetInternalformativPtr != NULL);
	return glGetInternalformativPtr(target, internalformat, pname, bufSize, params);
}

/* ## GL_ARB_shader_atomic_counters ## */
static PFNGLGETACTIVEATOMICCOUNTERBUFFERIVPROC glGetActiveAtomicCounterBufferivPtr = NULL;
void APIENTRY glGetActiveAtomicCounterBufferiv (GLuint program, GLuint bufferIndex, GLenum pname, GLint *params)
{
	assert(glGetActiveAtomicCounterBufferivPtr != NULL);
	return glGetActiveAtomicCounterBufferivPtr(program, bufferIndex, pname, params);
}

/* ## GL_ARB_shader_image_load_store ## */
static PFNGLBINDIMAGETEXTUREPROC glBindImageTexturePtr = NULL;
void APIENTRY glBindImageTexture (GLuint unit, GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum access, GLenum format)
{
	assert(glBindImageTexturePtr != NULL);
	return glBindImageTexturePtr(unit, texture, level, layered, layer, access, format);
}

static PFNGLMEMORYBARRIERPROC glMemoryBarrierPtr = NULL;
void APIENTRY glMemoryBarrier (GLbitfield barriers)
{
	assert(glMemoryBarrierPtr != NULL);
	return glMemoryBarrierPtr(barriers);
}

/* ## GL_ARB_texture_storage ## */
static PFNGLTEXSTORAGE1DPROC glTexStorage1DPtr = NULL;
void APIENTRY glTexStorage1D (GLenum target, GLsizei levels, GLenum internalformat, GLsizei width)
{
	assert(glTexStorage1DPtr != NULL);
	return glTexStorage1DPtr(target, levels, internalformat, width);
}

static PFNGLTEXSTORAGE2DPROC glTexStorage2DPtr = NULL;
void APIENTRY glTexStorage2D (GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height)
{
	assert(glTexStorage2DPtr != NULL);
	return glTexStorage2DPtr(target, levels, internalformat, width, height);
}

static PFNGLTEXSTORAGE3DPROC glTexStorage3DPtr = NULL;
void APIENTRY glTexStorage3D (GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth)
{
	assert(glTexStorage3DPtr != NULL);
	return glTexStorage3DPtr(target, levels, internalformat, width, height, depth);
}

static PFNGLTEXTURESTORAGE1DEXTPROC glTextureStorage1DEXTPtr = NULL;
void APIENTRY glTextureStorage1DEXT (GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width)
{
	assert(glTextureStorage1DEXTPtr != NULL);
	return glTextureStorage1DEXTPtr(texture, target, levels, internalformat, width);
}

static PFNGLTEXTURESTORAGE2DEXTPROC glTextureStorage2DEXTPtr = NULL;
void APIENTRY glTextureStorage2DEXT (GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height)
{
	assert(glTextureStorage2DEXTPtr != NULL);
	return glTextureStorage2DEXTPtr(texture, target, levels, internalformat, width, height);
}

static PFNGLTEXTURESTORAGE3DEXTPROC glTextureStorage3DEXTPtr = NULL;
void APIENTRY glTextureStorage3DEXT (GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth)
{
	assert(glTextureStorage3DEXTPtr != NULL);
	return glTextureStorage3DEXTPtr(texture, target, levels, internalformat, width, height, depth);
}

/* ## GL_KHR_debug ## */
static PFNGLDEBUGMESSAGECONTROLPROC glDebugMessageControlPtr = NULL;
void APIENTRY glDebugMessageControl (GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint *ids, GLboolean enabled)
{
	assert(glDebugMessageControlPtr != NULL);
	return glDebugMessageControlPtr(source, type, severity, count, ids, enabled);
}

static PFNGLDEBUGMESSAGEINSERTPROC glDebugMessageInsertPtr = NULL;
void APIENTRY glDebugMessageInsert (GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar *buf)
{
	assert(glDebugMessageInsertPtr != NULL);
	return glDebugMessageInsertPtr(source, type, id, severity, length, buf);
}

static PFNGLDEBUGMESSAGECALLBACKPROC glDebugMessageCallbackPtr = NULL;
void APIENTRY glDebugMessageCallback (GLDEBUGPROC callback, const void *userParam)
{
	assert(glDebugMessageCallbackPtr != NULL);
	return glDebugMessageCallbackPtr(callback, userParam);
}

static PFNGLGETDEBUGMESSAGELOGPROC glGetDebugMessageLogPtr = NULL;
GLuint APIENTRY glGetDebugMessageLog (GLuint count, GLsizei bufsize, GLenum *sources, GLenum *types, GLuint *ids, GLenum *severities, GLsizei *lengths, GLchar *messageLog)
{
	assert(glGetDebugMessageLogPtr != NULL);
	return glGetDebugMessageLogPtr(count, bufsize, sources, types, ids, severities, lengths, messageLog);
}

static PFNGLPUSHDEBUGGROUPPROC glPushDebugGroupPtr = NULL;
void APIENTRY glPushDebugGroup (GLenum source, GLuint id, GLsizei length, const GLchar *message)
{
	assert(glPushDebugGroupPtr != NULL);
	return glPushDebugGroupPtr(source, id, length, message);
}

static PFNGLPOPDEBUGGROUPPROC glPopDebugGroupPtr = NULL;
void APIENTRY glPopDebugGroup (void)
{
	assert(glPopDebugGroupPtr != NULL);
	return glPopDebugGroupPtr();
}

static PFNGLOBJECTLABELPROC glObjectLabelPtr = NULL;
void APIENTRY glObjectLabel (GLenum identifier, GLuint name, GLsizei length, const GLchar *label)
{
	assert(glObjectLabelPtr != NULL);
	return glObjectLabelPtr(identifier, name, length, label);
}

static PFNGLGETOBJECTLABELPROC glGetObjectLabelPtr = NULL;
void APIENTRY glGetObjectLabel (GLenum identifier, GLuint name, GLsizei bufSize, GLsizei *length, GLchar *label)
{
	assert(glGetObjectLabelPtr != NULL);
	return glGetObjectLabelPtr(identifier, name, bufSize, length, label);
}

static PFNGLOBJECTPTRLABELPROC glObjectPtrLabelPtr = NULL;
void APIENTRY glObjectPtrLabel (const void *ptr, GLsizei length, const GLchar *label)
{
	assert(glObjectPtrLabelPtr != NULL);
	return glObjectPtrLabelPtr(ptr, length, label);
}

static PFNGLGETOBJECTPTRLABELPROC glGetObjectPtrLabelPtr = NULL;
void APIENTRY glGetObjectPtrLabel (const void *ptr, GLsizei bufSize, GLsizei *length, GLchar *label)
{
	assert(glGetObjectPtrLabelPtr != NULL);
	return glGetObjectPtrLabelPtr(ptr, bufSize, length, label);
}

/* ## GL_ARB_clear_buffer_object ## */
static PFNGLCLEARBUFFERDATAPROC glClearBufferDataPtr = NULL;
void APIENTRY glClearBufferData (GLenum target, GLenum internalformat, GLenum format, GLenum type, const void *data)
{
	assert(glClearBufferDataPtr != NULL);
	return glClearBufferDataPtr(target, internalformat, format, type, data);
}

static PFNGLCLEARBUFFERSUBDATAPROC glClearBufferSubDataPtr = NULL;
void APIENTRY glClearBufferSubData (GLenum target, GLenum internalformat, GLintptr offset, GLsizeiptr size, GLenum format, GLenum type, const void *data)
{
	assert(glClearBufferSubDataPtr != NULL);
	return glClearBufferSubDataPtr(target, internalformat, offset, size, format, type, data);
}

static PFNGLCLEARNAMEDBUFFERDATAEXTPROC glClearNamedBufferDataEXTPtr = NULL;
void APIENTRY glClearNamedBufferDataEXT (GLuint buffer, GLenum internalformat, GLenum format, GLenum type, const void *data)
{
	assert(glClearNamedBufferDataEXTPtr != NULL);
	return glClearNamedBufferDataEXTPtr(buffer, internalformat, format, type, data);
}

static PFNGLCLEARNAMEDBUFFERSUBDATAEXTPROC glClearNamedBufferSubDataEXTPtr = NULL;
void APIENTRY glClearNamedBufferSubDataEXT (GLuint buffer, GLenum internalformat, GLenum format, GLenum type, GLsizeiptr offset, GLsizeiptr size, const void *data)
{
	assert(glClearNamedBufferSubDataEXTPtr != NULL);
	return glClearNamedBufferSubDataEXTPtr(buffer, internalformat, format, type, offset, size, data);
}

/* ## GL_ARB_compute_shader ## */
static PFNGLDISPATCHCOMPUTEPROC glDispatchComputePtr = NULL;
void APIENTRY glDispatchCompute (GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z)
{
	assert(glDispatchComputePtr != NULL);
	return glDispatchComputePtr(num_groups_x, num_groups_y, num_groups_z);
}

static PFNGLDISPATCHCOMPUTEINDIRECTPROC glDispatchComputeIndirectPtr = NULL;
void APIENTRY glDispatchComputeIndirect (GLintptr indirect)
{
	assert(glDispatchComputeIndirectPtr != NULL);
	return glDispatchComputeIndirectPtr(indirect);
}

/* ## GL_ARB_copy_image ## */
static PFNGLCOPYIMAGESUBDATAPROC glCopyImageSubDataPtr = NULL;
void APIENTRY glCopyImageSubData (GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei srcWidth, GLsizei srcHeight, GLsizei srcDepth)
{
	assert(glCopyImageSubDataPtr != NULL);
	return glCopyImageSubDataPtr(srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight, srcDepth);
}

/* ## GL_ARB_texture_view ## */
static PFNGLTEXTUREVIEWPROC glTextureViewPtr = NULL;
void APIENTRY glTextureView (GLuint texture, GLenum target, GLuint origtexture, GLenum internalformat, GLuint minlevel, GLuint numlevels, GLuint minlayer, GLuint numlayers)
{
	assert(glTextureViewPtr != NULL);
	return glTextureViewPtr(texture, target, origtexture, internalformat, minlevel, numlevels, minlayer, numlayers);
}

/* ## GL_ARB_vertex_attrib_binding ## */
static PFNGLBINDVERTEXBUFFERPROC glBindVertexBufferPtr = NULL;
void APIENTRY glBindVertexBuffer (GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride)
{
	assert(glBindVertexBufferPtr != NULL);
	return glBindVertexBufferPtr(bindingindex, buffer, offset, stride);
}

static PFNGLVERTEXATTRIBFORMATPROC glVertexAttribFormatPtr = NULL;
void APIENTRY glVertexAttribFormat (GLuint attribindex, GLint size, GLenum type, GLboolean normalized, GLuint relativeoffset)
{
	assert(glVertexAttribFormatPtr != NULL);
	return glVertexAttribFormatPtr(attribindex, size, type, normalized, relativeoffset);
}

static PFNGLVERTEXATTRIBIFORMATPROC glVertexAttribIFormatPtr = NULL;
void APIENTRY glVertexAttribIFormat (GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset)
{
	assert(glVertexAttribIFormatPtr != NULL);
	return glVertexAttribIFormatPtr(attribindex, size, type, relativeoffset);
}

static PFNGLVERTEXATTRIBLFORMATPROC glVertexAttribLFormatPtr = NULL;
void APIENTRY glVertexAttribLFormat (GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset)
{
	assert(glVertexAttribLFormatPtr != NULL);
	return glVertexAttribLFormatPtr(attribindex, size, type, relativeoffset);
}

static PFNGLVERTEXATTRIBBINDINGPROC glVertexAttribBindingPtr = NULL;
void APIENTRY glVertexAttribBinding (GLuint attribindex, GLuint bindingindex)
{
	assert(glVertexAttribBindingPtr != NULL);
	return glVertexAttribBindingPtr(attribindex, bindingindex);
}

static PFNGLVERTEXBINDINGDIVISORPROC glVertexBindingDivisorPtr = NULL;
void APIENTRY glVertexBindingDivisor (GLuint bindingindex, GLuint divisor)
{
	assert(glVertexBindingDivisorPtr != NULL);
	return glVertexBindingDivisorPtr(bindingindex, divisor);
}

static PFNGLVERTEXARRAYBINDVERTEXBUFFEREXTPROC glVertexArrayBindVertexBufferEXTPtr = NULL;
void APIENTRY glVertexArrayBindVertexBufferEXT (GLuint vaobj, GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride)
{
	assert(glVertexArrayBindVertexBufferEXTPtr != NULL);
	return glVertexArrayBindVertexBufferEXTPtr(vaobj, bindingindex, buffer, offset, stride);
}

static PFNGLVERTEXARRAYVERTEXATTRIBFORMATEXTPROC glVertexArrayVertexAttribFormatEXTPtr = NULL;
void APIENTRY glVertexArrayVertexAttribFormatEXT (GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLboolean normalized, GLuint relativeoffset)
{
	assert(glVertexArrayVertexAttribFormatEXTPtr != NULL);
	return glVertexArrayVertexAttribFormatEXTPtr(vaobj, attribindex, size, type, normalized, relativeoffset);
}

static PFNGLVERTEXARRAYVERTEXATTRIBIFORMATEXTPROC glVertexArrayVertexAttribIFormatEXTPtr = NULL;
void APIENTRY glVertexArrayVertexAttribIFormatEXT (GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset)
{
	assert(glVertexArrayVertexAttribIFormatEXTPtr != NULL);
	return glVertexArrayVertexAttribIFormatEXTPtr(vaobj, attribindex, size, type, relativeoffset);
}

static PFNGLVERTEXARRAYVERTEXATTRIBLFORMATEXTPROC glVertexArrayVertexAttribLFormatEXTPtr = NULL;
void APIENTRY glVertexArrayVertexAttribLFormatEXT (GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset)
{
	assert(glVertexArrayVertexAttribLFormatEXTPtr != NULL);
	return glVertexArrayVertexAttribLFormatEXTPtr(vaobj, attribindex, size, type, relativeoffset);
}

static PFNGLVERTEXARRAYVERTEXATTRIBBINDINGEXTPROC glVertexArrayVertexAttribBindingEXTPtr = NULL;
void APIENTRY glVertexArrayVertexAttribBindingEXT (GLuint vaobj, GLuint attribindex, GLuint bindingindex)
{
	assert(glVertexArrayVertexAttribBindingEXTPtr != NULL);
	return glVertexArrayVertexAttribBindingEXTPtr(vaobj, attribindex, bindingindex);
}

static PFNGLVERTEXARRAYVERTEXBINDINGDIVISOREXTPROC glVertexArrayVertexBindingDivisorEXTPtr = NULL;
void APIENTRY glVertexArrayVertexBindingDivisorEXT (GLuint vaobj, GLuint bindingindex, GLuint divisor)
{
	assert(glVertexArrayVertexBindingDivisorEXTPtr != NULL);
	return glVertexArrayVertexBindingDivisorEXTPtr(vaobj, bindingindex, divisor);
}

/* ## GL_ARB_framebuffer_no_attachments ## */
static PFNGLFRAMEBUFFERPARAMETERIPROC glFramebufferParameteriPtr = NULL;
void APIENTRY glFramebufferParameteri (GLenum target, GLenum pname, GLint param)
{
	assert(glFramebufferParameteriPtr != NULL);
	return glFramebufferParameteriPtr(target, pname, param);
}

static PFNGLGETFRAMEBUFFERPARAMETERIVPROC glGetFramebufferParameterivPtr = NULL;
void APIENTRY glGetFramebufferParameteriv (GLenum target, GLenum pname, GLint *params)
{
	assert(glGetFramebufferParameterivPtr != NULL);
	return glGetFramebufferParameterivPtr(target, pname, params);
}

static PFNGLNAMEDFRAMEBUFFERPARAMETERIEXTPROC glNamedFramebufferParameteriEXTPtr = NULL;
void APIENTRY glNamedFramebufferParameteriEXT (GLuint framebuffer, GLenum pname, GLint param)
{
	assert(glNamedFramebufferParameteriEXTPtr != NULL);
	return glNamedFramebufferParameteriEXTPtr(framebuffer, pname, param);
}

static PFNGLGETNAMEDFRAMEBUFFERPARAMETERIVEXTPROC glGetNamedFramebufferParameterivEXTPtr = NULL;
void APIENTRY glGetNamedFramebufferParameterivEXT (GLuint framebuffer, GLenum pname, GLint *params)
{
	assert(glGetNamedFramebufferParameterivEXTPtr != NULL);
	return glGetNamedFramebufferParameterivEXTPtr(framebuffer, pname, params);
}

/* ## GL_ARB_internalformat_query2 ## */
static PFNGLGETINTERNALFORMATI64VPROC glGetInternalformati64vPtr = NULL;
void APIENTRY glGetInternalformati64v (GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint64 *params)
{
	assert(glGetInternalformati64vPtr != NULL);
	return glGetInternalformati64vPtr(target, internalformat, pname, bufSize, params);
}

/* ## GL_ARB_invalidate_subdata ## */
static PFNGLINVALIDATETEXSUBIMAGEPROC glInvalidateTexSubImagePtr = NULL;
void APIENTRY glInvalidateTexSubImage (GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth)
{
	assert(glInvalidateTexSubImagePtr != NULL);
	return glInvalidateTexSubImagePtr(texture, level, xoffset, yoffset, zoffset, width, height, depth);
}

static PFNGLINVALIDATETEXIMAGEPROC glInvalidateTexImagePtr = NULL;
void APIENTRY glInvalidateTexImage (GLuint texture, GLint level)
{
	assert(glInvalidateTexImagePtr != NULL);
	return glInvalidateTexImagePtr(texture, level);
}

static PFNGLINVALIDATEBUFFERSUBDATAPROC glInvalidateBufferSubDataPtr = NULL;
void APIENTRY glInvalidateBufferSubData (GLuint buffer, GLintptr offset, GLsizeiptr length)
{
	assert(glInvalidateBufferSubDataPtr != NULL);
	return glInvalidateBufferSubDataPtr(buffer, offset, length);
}

static PFNGLINVALIDATEBUFFERDATAPROC glInvalidateBufferDataPtr = NULL;
void APIENTRY glInvalidateBufferData (GLuint buffer)
{
	assert(glInvalidateBufferDataPtr != NULL);
	return glInvalidateBufferDataPtr(buffer);
}

static PFNGLINVALIDATEFRAMEBUFFERPROC glInvalidateFramebufferPtr = NULL;
void APIENTRY glInvalidateFramebuffer (GLenum target, GLsizei numAttachments, const GLenum *attachments)
{
	assert(glInvalidateFramebufferPtr != NULL);
	return glInvalidateFramebufferPtr(target, numAttachments, attachments);
}

static PFNGLINVALIDATESUBFRAMEBUFFERPROC glInvalidateSubFramebufferPtr = NULL;
void APIENTRY glInvalidateSubFramebuffer (GLenum target, GLsizei numAttachments, const GLenum *attachments, GLint x, GLint y, GLsizei width, GLsizei height)
{
	assert(glInvalidateSubFramebufferPtr != NULL);
	return glInvalidateSubFramebufferPtr(target, numAttachments, attachments, x, y, width, height);
}

/* ## GL_ARB_multi_draw_indirect ## */
static PFNGLMULTIDRAWARRAYSINDIRECTPROC glMultiDrawArraysIndirectPtr = NULL;
void APIENTRY glMultiDrawArraysIndirect (GLenum mode, const void *indirect, GLsizei drawcount, GLsizei stride)
{
	assert(glMultiDrawArraysIndirectPtr != NULL);
	return glMultiDrawArraysIndirectPtr(mode, indirect, drawcount, stride);
}

static PFNGLMULTIDRAWELEMENTSINDIRECTPROC glMultiDrawElementsIndirectPtr = NULL;
void APIENTRY glMultiDrawElementsIndirect (GLenum mode, GLenum type, const void *indirect, GLsizei drawcount, GLsizei stride)
{
	assert(glMultiDrawElementsIndirectPtr != NULL);
	return glMultiDrawElementsIndirectPtr(mode, type, indirect, drawcount, stride);
}

/* ## GL_ARB_program_interface_query ## */
static PFNGLGETPROGRAMINTERFACEIVPROC glGetProgramInterfaceivPtr = NULL;
void APIENTRY glGetProgramInterfaceiv (GLuint program, GLenum programInterface, GLenum pname, GLint *params)
{
	assert(glGetProgramInterfaceivPtr != NULL);
	return glGetProgramInterfaceivPtr(program, programInterface, pname, params);
}

static PFNGLGETPROGRAMRESOURCEINDEXPROC glGetProgramResourceIndexPtr = NULL;
GLuint APIENTRY glGetProgramResourceIndex (GLuint program, GLenum programInterface, const GLchar *name)
{
	assert(glGetProgramResourceIndexPtr != NULL);
	return glGetProgramResourceIndexPtr(program, programInterface, name);
}

static PFNGLGETPROGRAMRESOURCENAMEPROC glGetProgramResourceNamePtr = NULL;
void APIENTRY glGetProgramResourceName (GLuint program, GLenum programInterface, GLuint index, GLsizei bufSize, GLsizei *length, GLchar *name)
{
	assert(glGetProgramResourceNamePtr != NULL);
	return glGetProgramResourceNamePtr(program, programInterface, index, bufSize, length, name);
}

static PFNGLGETPROGRAMRESOURCEIVPROC glGetProgramResourceivPtr = NULL;
void APIENTRY glGetProgramResourceiv (GLuint program, GLenum programInterface, GLuint index, GLsizei propCount, const GLenum *props, GLsizei bufSize, GLsizei *length, GLint *params)
{
	assert(glGetProgramResourceivPtr != NULL);
	return glGetProgramResourceivPtr(program, programInterface, index, propCount, props, bufSize, length, params);
}

static PFNGLGETPROGRAMRESOURCELOCATIONPROC glGetProgramResourceLocationPtr = NULL;
GLint APIENTRY glGetProgramResourceLocation (GLuint program, GLenum programInterface, const GLchar *name)
{
	assert(glGetProgramResourceLocationPtr != NULL);
	return glGetProgramResourceLocationPtr(program, programInterface, name);
}

static PFNGLGETPROGRAMRESOURCELOCATIONINDEXPROC glGetProgramResourceLocationIndexPtr = NULL;
GLint APIENTRY glGetProgramResourceLocationIndex (GLuint program, GLenum programInterface, const GLchar *name)
{
	assert(glGetProgramResourceLocationIndexPtr != NULL);
	return glGetProgramResourceLocationIndexPtr(program, programInterface, name);
}

/* ## GL_ARB_shader_storage_buffer_object ## */
static PFNGLSHADERSTORAGEBLOCKBINDINGPROC glShaderStorageBlockBindingPtr = NULL;
void APIENTRY glShaderStorageBlockBinding (GLuint program, GLuint storageBlockIndex, GLuint storageBlockBinding)
{
	assert(glShaderStorageBlockBindingPtr != NULL);
	return glShaderStorageBlockBindingPtr(program, storageBlockIndex, storageBlockBinding);
}

/* ## GL_ARB_texture_buffer_range ## */
static PFNGLTEXBUFFERRANGEPROC glTexBufferRangePtr = NULL;
void APIENTRY glTexBufferRange (GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size)
{
	assert(glTexBufferRangePtr != NULL);
	return glTexBufferRangePtr(target, internalformat, buffer, offset, size);
}

static PFNGLTEXTUREBUFFERRANGEEXTPROC glTextureBufferRangeEXTPtr = NULL;
void APIENTRY glTextureBufferRangeEXT (GLuint texture, GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size)
{
	assert(glTextureBufferRangeEXTPtr != NULL);
	return glTextureBufferRangeEXTPtr(texture, target, internalformat, buffer, offset, size);
}

/* ## GL_ARB_texture_storage_multisample ## */
static PFNGLTEXSTORAGE2DMULTISAMPLEPROC glTexStorage2DMultisamplePtr = NULL;
void APIENTRY glTexStorage2DMultisample (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations)
{
	assert(glTexStorage2DMultisamplePtr != NULL);
	return glTexStorage2DMultisamplePtr(target, samples, internalformat, width, height, fixedsamplelocations);
}

static PFNGLTEXSTORAGE3DMULTISAMPLEPROC glTexStorage3DMultisamplePtr = NULL;
void APIENTRY glTexStorage3DMultisample (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations)
{
	assert(glTexStorage3DMultisamplePtr != NULL);
	return glTexStorage3DMultisamplePtr(target, samples, internalformat, width, height, depth, fixedsamplelocations);
}

static PFNGLTEXTURESTORAGE2DMULTISAMPLEEXTPROC glTextureStorage2DMultisampleEXTPtr = NULL;
void APIENTRY glTextureStorage2DMultisampleEXT (GLuint texture, GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations)
{
	assert(glTextureStorage2DMultisampleEXTPtr != NULL);
	return glTextureStorage2DMultisampleEXTPtr(texture, target, samples, internalformat, width, height, fixedsamplelocations);
}

static PFNGLTEXTURESTORAGE3DMULTISAMPLEEXTPROC glTextureStorage3DMultisampleEXTPtr = NULL;
void APIENTRY glTextureStorage3DMultisampleEXT (GLuint texture, GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations)
{
	assert(glTextureStorage3DMultisampleEXTPtr != NULL);
	return glTextureStorage3DMultisampleEXTPtr(texture, target, samples, internalformat, width, height, depth, fixedsamplelocations);
}

#pragma endregion

inline bool loadGL_version_1_2()
{
	glBlendColorPtr = reinterpret_cast<PFNGLBLENDCOLORPROC>(::wglGetProcAddress("glBlendColor"));
	glBlendEquationPtr = reinterpret_cast<PFNGLBLENDEQUATIONPROC>(::wglGetProcAddress("glBlendEquation"));
	glDrawRangeElementsPtr = reinterpret_cast<PFNGLDRAWRANGEELEMENTSPROC>(::wglGetProcAddress("glDrawRangeElements"));
	glTexImage3DPtr = reinterpret_cast<PFNGLTEXIMAGE3DPROC>(::wglGetProcAddress("glTexImage3D"));
	glTexSubImage3DPtr = reinterpret_cast<PFNGLTEXSUBIMAGE3DPROC>(::wglGetProcAddress("glTexSubImage3D"));
	glCopyTexSubImage3DPtr = reinterpret_cast<PFNGLCOPYTEXSUBIMAGE3DPROC>(::wglGetProcAddress("glCopyTexSubImage3D"));

	return glBlendColorPtr != NULL && glBlendEquationPtr != NULL && glDrawRangeElementsPtr != NULL && glTexImage3DPtr != NULL && glTexSubImage3DPtr != NULL && 
		glCopyTexSubImage3DPtr != NULL;
}

inline bool loadGL_version_1_3()
{
	glActiveTexturePtr = reinterpret_cast<PFNGLACTIVETEXTUREPROC>(::wglGetProcAddress("glActiveTexture"));
	glSampleCoveragePtr = reinterpret_cast<PFNGLSAMPLECOVERAGEPROC>(::wglGetProcAddress("glSampleCoverage"));
	glCompressedTexImage3DPtr = reinterpret_cast<PFNGLCOMPRESSEDTEXIMAGE3DPROC>(::wglGetProcAddress("glCompressedTexImage3D"));
	glCompressedTexImage2DPtr = reinterpret_cast<PFNGLCOMPRESSEDTEXIMAGE2DPROC>(::wglGetProcAddress("glCompressedTexImage2D"));
	glCompressedTexImage1DPtr = reinterpret_cast<PFNGLCOMPRESSEDTEXIMAGE1DPROC>(::wglGetProcAddress("glCompressedTexImage1D"));
	glCompressedTexSubImage3DPtr = reinterpret_cast<PFNGLCOMPRESSEDTEXSUBIMAGE3DPROC>(::wglGetProcAddress("glCompressedTexSubImage3D"));
	glCompressedTexSubImage2DPtr = reinterpret_cast<PFNGLCOMPRESSEDTEXSUBIMAGE2DPROC>(::wglGetProcAddress("glCompressedTexSubImage2D"));
	glCompressedTexSubImage1DPtr = reinterpret_cast<PFNGLCOMPRESSEDTEXSUBIMAGE1DPROC>(::wglGetProcAddress("glCompressedTexSubImage1D"));
	glGetCompressedTexImagePtr = reinterpret_cast<PFNGLGETCOMPRESSEDTEXIMAGEPROC>(::wglGetProcAddress("glGetCompressedTexImage"));

	return glActiveTexturePtr != NULL && glSampleCoveragePtr != NULL && glCompressedTexImage3DPtr != NULL && glCompressedTexImage2DPtr != NULL && glCompressedTexImage1DPtr != NULL && 
		glCompressedTexSubImage3DPtr != NULL && glCompressedTexSubImage2DPtr != NULL && glCompressedTexSubImage1DPtr != NULL && glGetCompressedTexImagePtr != NULL;
}

inline bool loadGL_version_1_4()
{
	glBlendFuncSeparatePtr = reinterpret_cast<PFNGLBLENDFUNCSEPARATEPROC>(::wglGetProcAddress("glBlendFuncSeparate"));
	glMultiDrawArraysPtr = reinterpret_cast<PFNGLMULTIDRAWARRAYSPROC>(::wglGetProcAddress("glMultiDrawArrays"));
	glMultiDrawElementsPtr = reinterpret_cast<PFNGLMULTIDRAWELEMENTSPROC>(::wglGetProcAddress("glMultiDrawElements"));
	glPointParameterfPtr = reinterpret_cast<PFNGLPOINTPARAMETERFPROC>(::wglGetProcAddress("glPointParameterf"));
	glPointParameterfvPtr = reinterpret_cast<PFNGLPOINTPARAMETERFVPROC>(::wglGetProcAddress("glPointParameterfv"));
	glPointParameteriPtr = reinterpret_cast<PFNGLPOINTPARAMETERIPROC>(::wglGetProcAddress("glPointParameteri"));
	glPointParameterivPtr = reinterpret_cast<PFNGLPOINTPARAMETERIVPROC>(::wglGetProcAddress("glPointParameteriv"));

	return glBlendFuncSeparatePtr != NULL && glMultiDrawArraysPtr != NULL && glMultiDrawElementsPtr != NULL && glPointParameterfPtr != NULL && glPointParameterfvPtr != NULL && 
		glPointParameteriPtr != NULL && glPointParameterivPtr != NULL;
}

inline bool loadGL_version_1_5()
{
	glGenQueriesPtr = reinterpret_cast<PFNGLGENQUERIESPROC>(::wglGetProcAddress("glGenQueries"));
	glDeleteQueriesPtr = reinterpret_cast<PFNGLDELETEQUERIESPROC>(::wglGetProcAddress("glDeleteQueries"));
	glIsQueryPtr = reinterpret_cast<PFNGLISQUERYPROC>(::wglGetProcAddress("glIsQuery"));
	glBeginQueryPtr = reinterpret_cast<PFNGLBEGINQUERYPROC>(::wglGetProcAddress("glBeginQuery"));
	glEndQueryPtr = reinterpret_cast<PFNGLENDQUERYPROC>(::wglGetProcAddress("glEndQuery"));
	glGetQueryivPtr = reinterpret_cast<PFNGLGETQUERYIVPROC>(::wglGetProcAddress("glGetQueryiv"));
	glGetQueryObjectivPtr = reinterpret_cast<PFNGLGETQUERYOBJECTIVPROC>(::wglGetProcAddress("glGetQueryObjectiv"));
	glGetQueryObjectuivPtr = reinterpret_cast<PFNGLGETQUERYOBJECTUIVPROC>(::wglGetProcAddress("glGetQueryObjectuiv"));
	glBindBufferPtr = reinterpret_cast<PFNGLBINDBUFFERPROC>(::wglGetProcAddress("glBindBuffer"));
	glDeleteBuffersPtr = reinterpret_cast<PFNGLDELETEBUFFERSPROC>(::wglGetProcAddress("glDeleteBuffers"));
	glGenBuffersPtr = reinterpret_cast<PFNGLGENBUFFERSPROC>(::wglGetProcAddress("glGenBuffers"));
	glIsBufferPtr = reinterpret_cast<PFNGLISBUFFERPROC>(::wglGetProcAddress("glIsBuffer"));
	glBufferDataPtr = reinterpret_cast<PFNGLBUFFERDATAPROC>(::wglGetProcAddress("glBufferData"));
	glBufferSubDataPtr = reinterpret_cast<PFNGLBUFFERSUBDATAPROC>(::wglGetProcAddress("glBufferSubData"));
	glGetBufferSubDataPtr = reinterpret_cast<PFNGLGETBUFFERSUBDATAPROC>(::wglGetProcAddress("glGetBufferSubData"));
	glMapBufferPtr = reinterpret_cast<PFNGLMAPBUFFERPROC>(::wglGetProcAddress("glMapBuffer"));
	glUnmapBufferPtr = reinterpret_cast<PFNGLUNMAPBUFFERPROC>(::wglGetProcAddress("glUnmapBuffer"));
	glGetBufferParameterivPtr = reinterpret_cast<PFNGLGETBUFFERPARAMETERIVPROC>(::wglGetProcAddress("glGetBufferParameteriv"));
	glGetBufferPointervPtr = reinterpret_cast<PFNGLGETBUFFERPOINTERVPROC>(::wglGetProcAddress("glGetBufferPointerv"));

	return glGenQueriesPtr != NULL && glDeleteQueriesPtr != NULL && glIsQueryPtr != NULL && glBeginQueryPtr != NULL && glEndQueryPtr != NULL && 
		glGetQueryivPtr != NULL && glGetQueryObjectivPtr != NULL && glGetQueryObjectuivPtr != NULL && glBindBufferPtr != NULL && glDeleteBuffersPtr != NULL && 
		glGenBuffersPtr != NULL && glIsBufferPtr != NULL && glBufferDataPtr != NULL && glBufferSubDataPtr != NULL && glGetBufferSubDataPtr != NULL && 
		glMapBufferPtr != NULL && glUnmapBufferPtr != NULL && glGetBufferParameterivPtr != NULL && glGetBufferPointervPtr != NULL;
}

inline bool loadGL_version_2_0()
{
	glBlendEquationSeparatePtr = reinterpret_cast<PFNGLBLENDEQUATIONSEPARATEPROC>(::wglGetProcAddress("glBlendEquationSeparate"));
	glDrawBuffersPtr = reinterpret_cast<PFNGLDRAWBUFFERSPROC>(::wglGetProcAddress("glDrawBuffers"));
	glStencilOpSeparatePtr = reinterpret_cast<PFNGLSTENCILOPSEPARATEPROC>(::wglGetProcAddress("glStencilOpSeparate"));
	glStencilFuncSeparatePtr = reinterpret_cast<PFNGLSTENCILFUNCSEPARATEPROC>(::wglGetProcAddress("glStencilFuncSeparate"));
	glStencilMaskSeparatePtr = reinterpret_cast<PFNGLSTENCILMASKSEPARATEPROC>(::wglGetProcAddress("glStencilMaskSeparate"));
	glAttachShaderPtr = reinterpret_cast<PFNGLATTACHSHADERPROC>(::wglGetProcAddress("glAttachShader"));
	glBindAttribLocationPtr = reinterpret_cast<PFNGLBINDATTRIBLOCATIONPROC>(::wglGetProcAddress("glBindAttribLocation"));
	glCompileShaderPtr = reinterpret_cast<PFNGLCOMPILESHADERPROC>(::wglGetProcAddress("glCompileShader"));
	glCreateProgramPtr = reinterpret_cast<PFNGLCREATEPROGRAMPROC>(::wglGetProcAddress("glCreateProgram"));
	glCreateShaderPtr = reinterpret_cast<PFNGLCREATESHADERPROC>(::wglGetProcAddress("glCreateShader"));
	glDeleteProgramPtr = reinterpret_cast<PFNGLDELETEPROGRAMPROC>(::wglGetProcAddress("glDeleteProgram"));
	glDeleteShaderPtr = reinterpret_cast<PFNGLDELETESHADERPROC>(::wglGetProcAddress("glDeleteShader"));
	glDetachShaderPtr = reinterpret_cast<PFNGLDETACHSHADERPROC>(::wglGetProcAddress("glDetachShader"));
	glDisableVertexAttribArrayPtr = reinterpret_cast<PFNGLDISABLEVERTEXATTRIBARRAYPROC>(::wglGetProcAddress("glDisableVertexAttribArray"));
	glEnableVertexAttribArrayPtr = reinterpret_cast<PFNGLENABLEVERTEXATTRIBARRAYPROC>(::wglGetProcAddress("glEnableVertexAttribArray"));
	glGetActiveAttribPtr = reinterpret_cast<PFNGLGETACTIVEATTRIBPROC>(::wglGetProcAddress("glGetActiveAttrib"));
	glGetActiveUniformPtr = reinterpret_cast<PFNGLGETACTIVEUNIFORMPROC>(::wglGetProcAddress("glGetActiveUniform"));
	glGetAttachedShadersPtr = reinterpret_cast<PFNGLGETATTACHEDSHADERSPROC>(::wglGetProcAddress("glGetAttachedShaders"));
	glGetAttribLocationPtr = reinterpret_cast<PFNGLGETATTRIBLOCATIONPROC>(::wglGetProcAddress("glGetAttribLocation"));
	glGetProgramivPtr = reinterpret_cast<PFNGLGETPROGRAMIVPROC>(::wglGetProcAddress("glGetProgramiv"));
	glGetProgramInfoLogPtr = reinterpret_cast<PFNGLGETPROGRAMINFOLOGPROC>(::wglGetProcAddress("glGetProgramInfoLog"));
	glGetShaderivPtr = reinterpret_cast<PFNGLGETSHADERIVPROC>(::wglGetProcAddress("glGetShaderiv"));
	glGetShaderInfoLogPtr = reinterpret_cast<PFNGLGETSHADERINFOLOGPROC>(::wglGetProcAddress("glGetShaderInfoLog"));
	glGetShaderSourcePtr = reinterpret_cast<PFNGLGETSHADERSOURCEPROC>(::wglGetProcAddress("glGetShaderSource"));
	glGetUniformLocationPtr = reinterpret_cast<PFNGLGETUNIFORMLOCATIONPROC>(::wglGetProcAddress("glGetUniformLocation"));
	glGetUniformfvPtr = reinterpret_cast<PFNGLGETUNIFORMFVPROC>(::wglGetProcAddress("glGetUniformfv"));
	glGetUniformivPtr = reinterpret_cast<PFNGLGETUNIFORMIVPROC>(::wglGetProcAddress("glGetUniformiv"));
	glGetVertexAttribdvPtr = reinterpret_cast<PFNGLGETVERTEXATTRIBDVPROC>(::wglGetProcAddress("glGetVertexAttribdv"));
	glGetVertexAttribfvPtr = reinterpret_cast<PFNGLGETVERTEXATTRIBFVPROC>(::wglGetProcAddress("glGetVertexAttribfv"));
	glGetVertexAttribivPtr = reinterpret_cast<PFNGLGETVERTEXATTRIBIVPROC>(::wglGetProcAddress("glGetVertexAttribiv"));
	glGetVertexAttribPointervPtr = reinterpret_cast<PFNGLGETVERTEXATTRIBPOINTERVPROC>(::wglGetProcAddress("glGetVertexAttribPointerv"));
	glIsProgramPtr = reinterpret_cast<PFNGLISPROGRAMPROC>(::wglGetProcAddress("glIsProgram"));
	glIsShaderPtr = reinterpret_cast<PFNGLISSHADERPROC>(::wglGetProcAddress("glIsShader"));
	glLinkProgramPtr = reinterpret_cast<PFNGLLINKPROGRAMPROC>(::wglGetProcAddress("glLinkProgram"));
	glShaderSourcePtr = reinterpret_cast<PFNGLSHADERSOURCEPROC>(::wglGetProcAddress("glShaderSource"));
	glUseProgramPtr = reinterpret_cast<PFNGLUSEPROGRAMPROC>(::wglGetProcAddress("glUseProgram"));
	glUniform1fPtr = reinterpret_cast<PFNGLUNIFORM1FPROC>(::wglGetProcAddress("glUniform1f"));
	glUniform2fPtr = reinterpret_cast<PFNGLUNIFORM2FPROC>(::wglGetProcAddress("glUniform2f"));
	glUniform3fPtr = reinterpret_cast<PFNGLUNIFORM3FPROC>(::wglGetProcAddress("glUniform3f"));
	glUniform4fPtr = reinterpret_cast<PFNGLUNIFORM4FPROC>(::wglGetProcAddress("glUniform4f"));
	glUniform1iPtr = reinterpret_cast<PFNGLUNIFORM1IPROC>(::wglGetProcAddress("glUniform1i"));
	glUniform2iPtr = reinterpret_cast<PFNGLUNIFORM2IPROC>(::wglGetProcAddress("glUniform2i"));
	glUniform3iPtr = reinterpret_cast<PFNGLUNIFORM3IPROC>(::wglGetProcAddress("glUniform3i"));
	glUniform4iPtr = reinterpret_cast<PFNGLUNIFORM4IPROC>(::wglGetProcAddress("glUniform4i"));
	glUniform1fvPtr = reinterpret_cast<PFNGLUNIFORM1FVPROC>(::wglGetProcAddress("glUniform1fv"));
	glUniform2fvPtr = reinterpret_cast<PFNGLUNIFORM2FVPROC>(::wglGetProcAddress("glUniform2fv"));
	glUniform3fvPtr = reinterpret_cast<PFNGLUNIFORM3FVPROC>(::wglGetProcAddress("glUniform3fv"));
	glUniform4fvPtr = reinterpret_cast<PFNGLUNIFORM4FVPROC>(::wglGetProcAddress("glUniform4fv"));
	glUniform1ivPtr = reinterpret_cast<PFNGLUNIFORM1IVPROC>(::wglGetProcAddress("glUniform1iv"));
	glUniform2ivPtr = reinterpret_cast<PFNGLUNIFORM2IVPROC>(::wglGetProcAddress("glUniform2iv"));
	glUniform3ivPtr = reinterpret_cast<PFNGLUNIFORM3IVPROC>(::wglGetProcAddress("glUniform3iv"));
	glUniform4ivPtr = reinterpret_cast<PFNGLUNIFORM4IVPROC>(::wglGetProcAddress("glUniform4iv"));
	glUniformMatrix2fvPtr = reinterpret_cast<PFNGLUNIFORMMATRIX2FVPROC>(::wglGetProcAddress("glUniformMatrix2fv"));
	glUniformMatrix3fvPtr = reinterpret_cast<PFNGLUNIFORMMATRIX3FVPROC>(::wglGetProcAddress("glUniformMatrix3fv"));
	glUniformMatrix4fvPtr = reinterpret_cast<PFNGLUNIFORMMATRIX4FVPROC>(::wglGetProcAddress("glUniformMatrix4fv"));
	glValidateProgramPtr = reinterpret_cast<PFNGLVALIDATEPROGRAMPROC>(::wglGetProcAddress("glValidateProgram"));
	glVertexAttrib1dPtr = reinterpret_cast<PFNGLVERTEXATTRIB1DPROC>(::wglGetProcAddress("glVertexAttrib1d"));
	glVertexAttrib1dvPtr = reinterpret_cast<PFNGLVERTEXATTRIB1DVPROC>(::wglGetProcAddress("glVertexAttrib1dv"));
	glVertexAttrib1fPtr = reinterpret_cast<PFNGLVERTEXATTRIB1FPROC>(::wglGetProcAddress("glVertexAttrib1f"));
	glVertexAttrib1fvPtr = reinterpret_cast<PFNGLVERTEXATTRIB1FVPROC>(::wglGetProcAddress("glVertexAttrib1fv"));
	glVertexAttrib1sPtr = reinterpret_cast<PFNGLVERTEXATTRIB1SPROC>(::wglGetProcAddress("glVertexAttrib1s"));
	glVertexAttrib1svPtr = reinterpret_cast<PFNGLVERTEXATTRIB1SVPROC>(::wglGetProcAddress("glVertexAttrib1sv"));
	glVertexAttrib2dPtr = reinterpret_cast<PFNGLVERTEXATTRIB2DPROC>(::wglGetProcAddress("glVertexAttrib2d"));
	glVertexAttrib2dvPtr = reinterpret_cast<PFNGLVERTEXATTRIB2DVPROC>(::wglGetProcAddress("glVertexAttrib2dv"));
	glVertexAttrib2fPtr = reinterpret_cast<PFNGLVERTEXATTRIB2FPROC>(::wglGetProcAddress("glVertexAttrib2f"));
	glVertexAttrib2fvPtr = reinterpret_cast<PFNGLVERTEXATTRIB2FVPROC>(::wglGetProcAddress("glVertexAttrib2fv"));
	glVertexAttrib2sPtr = reinterpret_cast<PFNGLVERTEXATTRIB2SPROC>(::wglGetProcAddress("glVertexAttrib2s"));
	glVertexAttrib2svPtr = reinterpret_cast<PFNGLVERTEXATTRIB2SVPROC>(::wglGetProcAddress("glVertexAttrib2sv"));
	glVertexAttrib3dPtr = reinterpret_cast<PFNGLVERTEXATTRIB3DPROC>(::wglGetProcAddress("glVertexAttrib3d"));
	glVertexAttrib3dvPtr = reinterpret_cast<PFNGLVERTEXATTRIB3DVPROC>(::wglGetProcAddress("glVertexAttrib3dv"));
	glVertexAttrib3fPtr = reinterpret_cast<PFNGLVERTEXATTRIB3FPROC>(::wglGetProcAddress("glVertexAttrib3f"));
	glVertexAttrib3fvPtr = reinterpret_cast<PFNGLVERTEXATTRIB3FVPROC>(::wglGetProcAddress("glVertexAttrib3fv"));
	glVertexAttrib3sPtr = reinterpret_cast<PFNGLVERTEXATTRIB3SPROC>(::wglGetProcAddress("glVertexAttrib3s"));
	glVertexAttrib3svPtr = reinterpret_cast<PFNGLVERTEXATTRIB3SVPROC>(::wglGetProcAddress("glVertexAttrib3sv"));
	glVertexAttrib4NbvPtr = reinterpret_cast<PFNGLVERTEXATTRIB4NBVPROC>(::wglGetProcAddress("glVertexAttrib4Nbv"));
	glVertexAttrib4NivPtr = reinterpret_cast<PFNGLVERTEXATTRIB4NIVPROC>(::wglGetProcAddress("glVertexAttrib4Niv"));
	glVertexAttrib4NsvPtr = reinterpret_cast<PFNGLVERTEXATTRIB4NSVPROC>(::wglGetProcAddress("glVertexAttrib4Nsv"));
	glVertexAttrib4NubPtr = reinterpret_cast<PFNGLVERTEXATTRIB4NUBPROC>(::wglGetProcAddress("glVertexAttrib4Nub"));
	glVertexAttrib4NubvPtr = reinterpret_cast<PFNGLVERTEXATTRIB4NUBVPROC>(::wglGetProcAddress("glVertexAttrib4Nubv"));
	glVertexAttrib4NuivPtr = reinterpret_cast<PFNGLVERTEXATTRIB4NUIVPROC>(::wglGetProcAddress("glVertexAttrib4Nuiv"));
	glVertexAttrib4NusvPtr = reinterpret_cast<PFNGLVERTEXATTRIB4NUSVPROC>(::wglGetProcAddress("glVertexAttrib4Nusv"));
	glVertexAttrib4bvPtr = reinterpret_cast<PFNGLVERTEXATTRIB4BVPROC>(::wglGetProcAddress("glVertexAttrib4bv"));
	glVertexAttrib4dPtr = reinterpret_cast<PFNGLVERTEXATTRIB4DPROC>(::wglGetProcAddress("glVertexAttrib4d"));
	glVertexAttrib4dvPtr = reinterpret_cast<PFNGLVERTEXATTRIB4DVPROC>(::wglGetProcAddress("glVertexAttrib4dv"));
	glVertexAttrib4fPtr = reinterpret_cast<PFNGLVERTEXATTRIB4FPROC>(::wglGetProcAddress("glVertexAttrib4f"));
	glVertexAttrib4fvPtr = reinterpret_cast<PFNGLVERTEXATTRIB4FVPROC>(::wglGetProcAddress("glVertexAttrib4fv"));
	glVertexAttrib4ivPtr = reinterpret_cast<PFNGLVERTEXATTRIB4IVPROC>(::wglGetProcAddress("glVertexAttrib4iv"));
	glVertexAttrib4sPtr = reinterpret_cast<PFNGLVERTEXATTRIB4SPROC>(::wglGetProcAddress("glVertexAttrib4s"));
	glVertexAttrib4svPtr = reinterpret_cast<PFNGLVERTEXATTRIB4SVPROC>(::wglGetProcAddress("glVertexAttrib4sv"));
	glVertexAttrib4ubvPtr = reinterpret_cast<PFNGLVERTEXATTRIB4UBVPROC>(::wglGetProcAddress("glVertexAttrib4ubv"));
	glVertexAttrib4uivPtr = reinterpret_cast<PFNGLVERTEXATTRIB4UIVPROC>(::wglGetProcAddress("glVertexAttrib4uiv"));
	glVertexAttrib4usvPtr = reinterpret_cast<PFNGLVERTEXATTRIB4USVPROC>(::wglGetProcAddress("glVertexAttrib4usv"));
	glVertexAttribPointerPtr = reinterpret_cast<PFNGLVERTEXATTRIBPOINTERPROC>(::wglGetProcAddress("glVertexAttribPointer"));

	return glBlendEquationSeparatePtr != NULL && glDrawBuffersPtr != NULL && glStencilOpSeparatePtr != NULL && glStencilFuncSeparatePtr != NULL && glStencilMaskSeparatePtr != NULL && 
		glAttachShaderPtr != NULL && glBindAttribLocationPtr != NULL && glCompileShaderPtr != NULL && glCreateProgramPtr != NULL && glCreateShaderPtr != NULL && 
		glDeleteProgramPtr != NULL && glDeleteShaderPtr != NULL && glDetachShaderPtr != NULL && glDisableVertexAttribArrayPtr != NULL && glEnableVertexAttribArrayPtr != NULL && 
		glGetActiveAttribPtr != NULL && glGetActiveUniformPtr != NULL && glGetAttachedShadersPtr != NULL && glGetAttribLocationPtr != NULL && glGetProgramivPtr != NULL && 
		glGetProgramInfoLogPtr != NULL && glGetShaderivPtr != NULL && glGetShaderInfoLogPtr != NULL && glGetShaderSourcePtr != NULL && glGetUniformLocationPtr != NULL && 
		glGetUniformfvPtr != NULL && glGetUniformivPtr != NULL && glGetVertexAttribdvPtr != NULL && glGetVertexAttribfvPtr != NULL && glGetVertexAttribivPtr != NULL && 
		glGetVertexAttribPointervPtr != NULL && glIsProgramPtr != NULL && glIsShaderPtr != NULL && glLinkProgramPtr != NULL && glShaderSourcePtr != NULL && 
		glUseProgramPtr != NULL && glUniform1fPtr != NULL && glUniform2fPtr != NULL && glUniform3fPtr != NULL && glUniform4fPtr != NULL && 
		glUniform1iPtr != NULL && glUniform2iPtr != NULL && glUniform3iPtr != NULL && glUniform4iPtr != NULL && glUniform1fvPtr != NULL && 
		glUniform2fvPtr != NULL && glUniform3fvPtr != NULL && glUniform4fvPtr != NULL && glUniform1ivPtr != NULL && glUniform2ivPtr != NULL && 
		glUniform3ivPtr != NULL && glUniform4ivPtr != NULL && glUniformMatrix2fvPtr != NULL && glUniformMatrix3fvPtr != NULL && glUniformMatrix4fvPtr != NULL && 
		glValidateProgramPtr != NULL && glVertexAttrib1dPtr != NULL && glVertexAttrib1dvPtr != NULL && glVertexAttrib1fPtr != NULL && glVertexAttrib1fvPtr != NULL && 
		glVertexAttrib1sPtr != NULL && glVertexAttrib1svPtr != NULL && glVertexAttrib2dPtr != NULL && glVertexAttrib2dvPtr != NULL && glVertexAttrib2fPtr != NULL && 
		glVertexAttrib2fvPtr != NULL && glVertexAttrib2sPtr != NULL && glVertexAttrib2svPtr != NULL && glVertexAttrib3dPtr != NULL && glVertexAttrib3dvPtr != NULL && 
		glVertexAttrib3fPtr != NULL && glVertexAttrib3fvPtr != NULL && glVertexAttrib3sPtr != NULL && glVertexAttrib3svPtr != NULL && glVertexAttrib4NbvPtr != NULL && 
		glVertexAttrib4NivPtr != NULL && glVertexAttrib4NsvPtr != NULL && glVertexAttrib4NubPtr != NULL && glVertexAttrib4NubvPtr != NULL && glVertexAttrib4NuivPtr != NULL && 
		glVertexAttrib4NusvPtr != NULL && glVertexAttrib4bvPtr != NULL && glVertexAttrib4dPtr != NULL && glVertexAttrib4dvPtr != NULL && glVertexAttrib4fPtr != NULL && 
		glVertexAttrib4fvPtr != NULL && glVertexAttrib4ivPtr != NULL && glVertexAttrib4sPtr != NULL && glVertexAttrib4svPtr != NULL && glVertexAttrib4ubvPtr != NULL && 
		glVertexAttrib4uivPtr != NULL && glVertexAttrib4usvPtr != NULL && glVertexAttribPointerPtr != NULL;
}

inline bool loadGL_version_2_1()
{
	glUniformMatrix2x3fvPtr = reinterpret_cast<PFNGLUNIFORMMATRIX2X3FVPROC>(::wglGetProcAddress("glUniformMatrix2x3fv"));
	glUniformMatrix3x2fvPtr = reinterpret_cast<PFNGLUNIFORMMATRIX3X2FVPROC>(::wglGetProcAddress("glUniformMatrix3x2fv"));
	glUniformMatrix2x4fvPtr = reinterpret_cast<PFNGLUNIFORMMATRIX2X4FVPROC>(::wglGetProcAddress("glUniformMatrix2x4fv"));
	glUniformMatrix4x2fvPtr = reinterpret_cast<PFNGLUNIFORMMATRIX4X2FVPROC>(::wglGetProcAddress("glUniformMatrix4x2fv"));
	glUniformMatrix3x4fvPtr = reinterpret_cast<PFNGLUNIFORMMATRIX3X4FVPROC>(::wglGetProcAddress("glUniformMatrix3x4fv"));
	glUniformMatrix4x3fvPtr = reinterpret_cast<PFNGLUNIFORMMATRIX4X3FVPROC>(::wglGetProcAddress("glUniformMatrix4x3fv"));

	return glUniformMatrix2x3fvPtr != NULL && glUniformMatrix3x2fvPtr != NULL && glUniformMatrix2x4fvPtr != NULL && glUniformMatrix4x2fvPtr != NULL && glUniformMatrix3x4fvPtr != NULL && 
		glUniformMatrix4x3fvPtr != NULL;
}

inline bool loadGL_version_3_0()
{
	glColorMaskiPtr = reinterpret_cast<PFNGLCOLORMASKIPROC>(::wglGetProcAddress("glColorMaski"));
	glGetBooleani_vPtr = reinterpret_cast<PFNGLGETBOOLEANI_VPROC>(::wglGetProcAddress("glGetBooleani_v"));
	glGetIntegeri_vPtr = reinterpret_cast<PFNGLGETINTEGERI_VPROC>(::wglGetProcAddress("glGetIntegeri_v"));
	glEnableiPtr = reinterpret_cast<PFNGLENABLEIPROC>(::wglGetProcAddress("glEnablei"));
	glDisableiPtr = reinterpret_cast<PFNGLDISABLEIPROC>(::wglGetProcAddress("glDisablei"));
	glIsEnablediPtr = reinterpret_cast<PFNGLISENABLEDIPROC>(::wglGetProcAddress("glIsEnabledi"));
	glBeginTransformFeedbackPtr = reinterpret_cast<PFNGLBEGINTRANSFORMFEEDBACKPROC>(::wglGetProcAddress("glBeginTransformFeedback"));
	glEndTransformFeedbackPtr = reinterpret_cast<PFNGLENDTRANSFORMFEEDBACKPROC>(::wglGetProcAddress("glEndTransformFeedback"));
	glBindBufferRangePtr = reinterpret_cast<PFNGLBINDBUFFERRANGEPROC>(::wglGetProcAddress("glBindBufferRange"));
	glBindBufferBasePtr = reinterpret_cast<PFNGLBINDBUFFERBASEPROC>(::wglGetProcAddress("glBindBufferBase"));
	glTransformFeedbackVaryingsPtr = reinterpret_cast<PFNGLTRANSFORMFEEDBACKVARYINGSPROC>(::wglGetProcAddress("glTransformFeedbackVaryings"));
	glGetTransformFeedbackVaryingPtr = reinterpret_cast<PFNGLGETTRANSFORMFEEDBACKVARYINGPROC>(::wglGetProcAddress("glGetTransformFeedbackVarying"));
	glClampColorPtr = reinterpret_cast<PFNGLCLAMPCOLORPROC>(::wglGetProcAddress("glClampColor"));
	glBeginConditionalRenderPtr = reinterpret_cast<PFNGLBEGINCONDITIONALRENDERPROC>(::wglGetProcAddress("glBeginConditionalRender"));
	glEndConditionalRenderPtr = reinterpret_cast<PFNGLENDCONDITIONALRENDERPROC>(::wglGetProcAddress("glEndConditionalRender"));
	glVertexAttribIPointerPtr = reinterpret_cast<PFNGLVERTEXATTRIBIPOINTERPROC>(::wglGetProcAddress("glVertexAttribIPointer"));
	glGetVertexAttribIivPtr = reinterpret_cast<PFNGLGETVERTEXATTRIBIIVPROC>(::wglGetProcAddress("glGetVertexAttribIiv"));
	glGetVertexAttribIuivPtr = reinterpret_cast<PFNGLGETVERTEXATTRIBIUIVPROC>(::wglGetProcAddress("glGetVertexAttribIuiv"));
	glVertexAttribI1iPtr = reinterpret_cast<PFNGLVERTEXATTRIBI1IPROC>(::wglGetProcAddress("glVertexAttribI1i"));
	glVertexAttribI2iPtr = reinterpret_cast<PFNGLVERTEXATTRIBI2IPROC>(::wglGetProcAddress("glVertexAttribI2i"));
	glVertexAttribI3iPtr = reinterpret_cast<PFNGLVERTEXATTRIBI3IPROC>(::wglGetProcAddress("glVertexAttribI3i"));
	glVertexAttribI4iPtr = reinterpret_cast<PFNGLVERTEXATTRIBI4IPROC>(::wglGetProcAddress("glVertexAttribI4i"));
	glVertexAttribI1uiPtr = reinterpret_cast<PFNGLVERTEXATTRIBI1UIPROC>(::wglGetProcAddress("glVertexAttribI1ui"));
	glVertexAttribI2uiPtr = reinterpret_cast<PFNGLVERTEXATTRIBI2UIPROC>(::wglGetProcAddress("glVertexAttribI2ui"));
	glVertexAttribI3uiPtr = reinterpret_cast<PFNGLVERTEXATTRIBI3UIPROC>(::wglGetProcAddress("glVertexAttribI3ui"));
	glVertexAttribI4uiPtr = reinterpret_cast<PFNGLVERTEXATTRIBI4UIPROC>(::wglGetProcAddress("glVertexAttribI4ui"));
	glVertexAttribI1ivPtr = reinterpret_cast<PFNGLVERTEXATTRIBI1IVPROC>(::wglGetProcAddress("glVertexAttribI1iv"));
	glVertexAttribI2ivPtr = reinterpret_cast<PFNGLVERTEXATTRIBI2IVPROC>(::wglGetProcAddress("glVertexAttribI2iv"));
	glVertexAttribI3ivPtr = reinterpret_cast<PFNGLVERTEXATTRIBI3IVPROC>(::wglGetProcAddress("glVertexAttribI3iv"));
	glVertexAttribI4ivPtr = reinterpret_cast<PFNGLVERTEXATTRIBI4IVPROC>(::wglGetProcAddress("glVertexAttribI4iv"));
	glVertexAttribI1uivPtr = reinterpret_cast<PFNGLVERTEXATTRIBI1UIVPROC>(::wglGetProcAddress("glVertexAttribI1uiv"));
	glVertexAttribI2uivPtr = reinterpret_cast<PFNGLVERTEXATTRIBI2UIVPROC>(::wglGetProcAddress("glVertexAttribI2uiv"));
	glVertexAttribI3uivPtr = reinterpret_cast<PFNGLVERTEXATTRIBI3UIVPROC>(::wglGetProcAddress("glVertexAttribI3uiv"));
	glVertexAttribI4uivPtr = reinterpret_cast<PFNGLVERTEXATTRIBI4UIVPROC>(::wglGetProcAddress("glVertexAttribI4uiv"));
	glVertexAttribI4bvPtr = reinterpret_cast<PFNGLVERTEXATTRIBI4BVPROC>(::wglGetProcAddress("glVertexAttribI4bv"));
	glVertexAttribI4svPtr = reinterpret_cast<PFNGLVERTEXATTRIBI4SVPROC>(::wglGetProcAddress("glVertexAttribI4sv"));
	glVertexAttribI4ubvPtr = reinterpret_cast<PFNGLVERTEXATTRIBI4UBVPROC>(::wglGetProcAddress("glVertexAttribI4ubv"));
	glVertexAttribI4usvPtr = reinterpret_cast<PFNGLVERTEXATTRIBI4USVPROC>(::wglGetProcAddress("glVertexAttribI4usv"));
	glGetUniformuivPtr = reinterpret_cast<PFNGLGETUNIFORMUIVPROC>(::wglGetProcAddress("glGetUniformuiv"));
	glBindFragDataLocationPtr = reinterpret_cast<PFNGLBINDFRAGDATALOCATIONPROC>(::wglGetProcAddress("glBindFragDataLocation"));
	glGetFragDataLocationPtr = reinterpret_cast<PFNGLGETFRAGDATALOCATIONPROC>(::wglGetProcAddress("glGetFragDataLocation"));
	glUniform1uiPtr = reinterpret_cast<PFNGLUNIFORM1UIPROC>(::wglGetProcAddress("glUniform1ui"));
	glUniform2uiPtr = reinterpret_cast<PFNGLUNIFORM2UIPROC>(::wglGetProcAddress("glUniform2ui"));
	glUniform3uiPtr = reinterpret_cast<PFNGLUNIFORM3UIPROC>(::wglGetProcAddress("glUniform3ui"));
	glUniform4uiPtr = reinterpret_cast<PFNGLUNIFORM4UIPROC>(::wglGetProcAddress("glUniform4ui"));
	glUniform1uivPtr = reinterpret_cast<PFNGLUNIFORM1UIVPROC>(::wglGetProcAddress("glUniform1uiv"));
	glUniform2uivPtr = reinterpret_cast<PFNGLUNIFORM2UIVPROC>(::wglGetProcAddress("glUniform2uiv"));
	glUniform3uivPtr = reinterpret_cast<PFNGLUNIFORM3UIVPROC>(::wglGetProcAddress("glUniform3uiv"));
	glUniform4uivPtr = reinterpret_cast<PFNGLUNIFORM4UIVPROC>(::wglGetProcAddress("glUniform4uiv"));
	glTexParameterIivPtr = reinterpret_cast<PFNGLTEXPARAMETERIIVPROC>(::wglGetProcAddress("glTexParameterIiv"));
	glTexParameterIuivPtr = reinterpret_cast<PFNGLTEXPARAMETERIUIVPROC>(::wglGetProcAddress("glTexParameterIuiv"));
	glGetTexParameterIivPtr = reinterpret_cast<PFNGLGETTEXPARAMETERIIVPROC>(::wglGetProcAddress("glGetTexParameterIiv"));
	glGetTexParameterIuivPtr = reinterpret_cast<PFNGLGETTEXPARAMETERIUIVPROC>(::wglGetProcAddress("glGetTexParameterIuiv"));
	glClearBufferivPtr = reinterpret_cast<PFNGLCLEARBUFFERIVPROC>(::wglGetProcAddress("glClearBufferiv"));
	glClearBufferuivPtr = reinterpret_cast<PFNGLCLEARBUFFERUIVPROC>(::wglGetProcAddress("glClearBufferuiv"));
	glClearBufferfvPtr = reinterpret_cast<PFNGLCLEARBUFFERFVPROC>(::wglGetProcAddress("glClearBufferfv"));
	glClearBufferfiPtr = reinterpret_cast<PFNGLCLEARBUFFERFIPROC>(::wglGetProcAddress("glClearBufferfi"));
	glGetStringiPtr = reinterpret_cast<PFNGLGETSTRINGIPROC>(::wglGetProcAddress("glGetStringi"));

	return glColorMaskiPtr != NULL && glGetBooleani_vPtr != NULL && glGetIntegeri_vPtr != NULL && glEnableiPtr != NULL && glDisableiPtr != NULL && 
		glIsEnablediPtr != NULL && glBeginTransformFeedbackPtr != NULL && glEndTransformFeedbackPtr != NULL && glBindBufferRangePtr != NULL && glBindBufferBasePtr != NULL && 
		glTransformFeedbackVaryingsPtr != NULL && glGetTransformFeedbackVaryingPtr != NULL && glClampColorPtr != NULL && glBeginConditionalRenderPtr != NULL && glEndConditionalRenderPtr != NULL && 
		glVertexAttribIPointerPtr != NULL && glGetVertexAttribIivPtr != NULL && glGetVertexAttribIuivPtr != NULL && glVertexAttribI1iPtr != NULL && glVertexAttribI2iPtr != NULL && 
		glVertexAttribI3iPtr != NULL && glVertexAttribI4iPtr != NULL && glVertexAttribI1uiPtr != NULL && glVertexAttribI2uiPtr != NULL && glVertexAttribI3uiPtr != NULL && 
		glVertexAttribI4uiPtr != NULL && glVertexAttribI1ivPtr != NULL && glVertexAttribI2ivPtr != NULL && glVertexAttribI3ivPtr != NULL && glVertexAttribI4ivPtr != NULL && 
		glVertexAttribI1uivPtr != NULL && glVertexAttribI2uivPtr != NULL && glVertexAttribI3uivPtr != NULL && glVertexAttribI4uivPtr != NULL && glVertexAttribI4bvPtr != NULL && 
		glVertexAttribI4svPtr != NULL && glVertexAttribI4ubvPtr != NULL && glVertexAttribI4usvPtr != NULL && glGetUniformuivPtr != NULL && glBindFragDataLocationPtr != NULL && 
		glGetFragDataLocationPtr != NULL && glUniform1uiPtr != NULL && glUniform2uiPtr != NULL && glUniform3uiPtr != NULL && glUniform4uiPtr != NULL && 
		glUniform1uivPtr != NULL && glUniform2uivPtr != NULL && glUniform3uivPtr != NULL && glUniform4uivPtr != NULL && glTexParameterIivPtr != NULL && 
		glTexParameterIuivPtr != NULL && glGetTexParameterIivPtr != NULL && glGetTexParameterIuivPtr != NULL && glClearBufferivPtr != NULL && glClearBufferuivPtr != NULL && 
		glClearBufferfvPtr != NULL && glClearBufferfiPtr != NULL && glGetStringiPtr != NULL;
}

inline bool loadGL_version_3_1()
{
	glDrawArraysInstancedPtr = reinterpret_cast<PFNGLDRAWARRAYSINSTANCEDPROC>(::wglGetProcAddress("glDrawArraysInstanced"));
	glDrawElementsInstancedPtr = reinterpret_cast<PFNGLDRAWELEMENTSINSTANCEDPROC>(::wglGetProcAddress("glDrawElementsInstanced"));
	glTexBufferPtr = reinterpret_cast<PFNGLTEXBUFFERPROC>(::wglGetProcAddress("glTexBuffer"));
	glPrimitiveRestartIndexPtr = reinterpret_cast<PFNGLPRIMITIVERESTARTINDEXPROC>(::wglGetProcAddress("glPrimitiveRestartIndex"));

	return glDrawArraysInstancedPtr != NULL && glDrawElementsInstancedPtr != NULL && glTexBufferPtr != NULL && glPrimitiveRestartIndexPtr != NULL;
}

inline bool loadGL_version_3_2()
{
	glGetInteger64i_vPtr = reinterpret_cast<PFNGLGETINTEGER64I_VPROC>(::wglGetProcAddress("glGetInteger64i_v"));
	glGetBufferParameteri64vPtr = reinterpret_cast<PFNGLGETBUFFERPARAMETERI64VPROC>(::wglGetProcAddress("glGetBufferParameteri64v"));
	glFramebufferTexturePtr = reinterpret_cast<PFNGLFRAMEBUFFERTEXTUREPROC>(::wglGetProcAddress("glFramebufferTexture"));

	return glGetInteger64i_vPtr != NULL && glGetBufferParameteri64vPtr != NULL && glFramebufferTexturePtr != NULL;
}

inline bool loadGL_version_3_3()
{
	glVertexAttribDivisorPtr = reinterpret_cast<PFNGLVERTEXATTRIBDIVISORPROC>(::wglGetProcAddress("glVertexAttribDivisor"));

	return glVertexAttribDivisorPtr != NULL;
}

inline bool loadGL_version_4_0()
{
	glMinSampleShadingPtr = reinterpret_cast<PFNGLMINSAMPLESHADINGPROC>(::wglGetProcAddress("glMinSampleShading"));
	glBlendEquationiPtr = reinterpret_cast<PFNGLBLENDEQUATIONIPROC>(::wglGetProcAddress("glBlendEquationi"));
	glBlendEquationSeparateiPtr = reinterpret_cast<PFNGLBLENDEQUATIONSEPARATEIPROC>(::wglGetProcAddress("glBlendEquationSeparatei"));
	glBlendFunciPtr = reinterpret_cast<PFNGLBLENDFUNCIPROC>(::wglGetProcAddress("glBlendFunci"));
	glBlendFuncSeparateiPtr = reinterpret_cast<PFNGLBLENDFUNCSEPARATEIPROC>(::wglGetProcAddress("glBlendFuncSeparatei"));

	return glMinSampleShadingPtr != NULL && glBlendEquationiPtr != NULL && glBlendEquationSeparateiPtr != NULL && glBlendFunciPtr != NULL && glBlendFuncSeparateiPtr != NULL;
}

inline bool loadGL_ARB_framebuffer_object()
{
	glIsRenderbufferPtr = reinterpret_cast<PFNGLISRENDERBUFFERPROC>(::wglGetProcAddress("glIsRenderbuffer"));
	glBindRenderbufferPtr = reinterpret_cast<PFNGLBINDRENDERBUFFERPROC>(::wglGetProcAddress("glBindRenderbuffer"));
	glDeleteRenderbuffersPtr = reinterpret_cast<PFNGLDELETERENDERBUFFERSPROC>(::wglGetProcAddress("glDeleteRenderbuffers"));
	glGenRenderbuffersPtr = reinterpret_cast<PFNGLGENRENDERBUFFERSPROC>(::wglGetProcAddress("glGenRenderbuffers"));
	glRenderbufferStoragePtr = reinterpret_cast<PFNGLRENDERBUFFERSTORAGEPROC>(::wglGetProcAddress("glRenderbufferStorage"));
	glGetRenderbufferParameterivPtr = reinterpret_cast<PFNGLGETRENDERBUFFERPARAMETERIVPROC>(::wglGetProcAddress("glGetRenderbufferParameteriv"));
	glIsFramebufferPtr = reinterpret_cast<PFNGLISFRAMEBUFFERPROC>(::wglGetProcAddress("glIsFramebuffer"));
	glBindFramebufferPtr = reinterpret_cast<PFNGLBINDFRAMEBUFFERPROC>(::wglGetProcAddress("glBindFramebuffer"));
	glDeleteFramebuffersPtr = reinterpret_cast<PFNGLDELETEFRAMEBUFFERSPROC>(::wglGetProcAddress("glDeleteFramebuffers"));
	glGenFramebuffersPtr = reinterpret_cast<PFNGLGENFRAMEBUFFERSPROC>(::wglGetProcAddress("glGenFramebuffers"));
	glCheckFramebufferStatusPtr = reinterpret_cast<PFNGLCHECKFRAMEBUFFERSTATUSPROC>(::wglGetProcAddress("glCheckFramebufferStatus"));
	glFramebufferTexture1DPtr = reinterpret_cast<PFNGLFRAMEBUFFERTEXTURE1DPROC>(::wglGetProcAddress("glFramebufferTexture1D"));
	glFramebufferTexture2DPtr = reinterpret_cast<PFNGLFRAMEBUFFERTEXTURE2DPROC>(::wglGetProcAddress("glFramebufferTexture2D"));
	glFramebufferTexture3DPtr = reinterpret_cast<PFNGLFRAMEBUFFERTEXTURE3DPROC>(::wglGetProcAddress("glFramebufferTexture3D"));
	glFramebufferRenderbufferPtr = reinterpret_cast<PFNGLFRAMEBUFFERRENDERBUFFERPROC>(::wglGetProcAddress("glFramebufferRenderbuffer"));
	glGetFramebufferAttachmentParameterivPtr = reinterpret_cast<PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVPROC>(::wglGetProcAddress("glGetFramebufferAttachmentParameteriv"));
	glGenerateMipmapPtr = reinterpret_cast<PFNGLGENERATEMIPMAPPROC>(::wglGetProcAddress("glGenerateMipmap"));
	glBlitFramebufferPtr = reinterpret_cast<PFNGLBLITFRAMEBUFFERPROC>(::wglGetProcAddress("glBlitFramebuffer"));
	glRenderbufferStorageMultisamplePtr = reinterpret_cast<PFNGLRENDERBUFFERSTORAGEMULTISAMPLEPROC>(::wglGetProcAddress("glRenderbufferStorageMultisample"));
	glFramebufferTextureLayerPtr = reinterpret_cast<PFNGLFRAMEBUFFERTEXTURELAYERPROC>(::wglGetProcAddress("glFramebufferTextureLayer"));

	return glIsRenderbufferPtr != NULL && glBindRenderbufferPtr != NULL && glDeleteRenderbuffersPtr != NULL && glGenRenderbuffersPtr != NULL && glRenderbufferStoragePtr != NULL && 
		glGetRenderbufferParameterivPtr != NULL && glIsFramebufferPtr != NULL && glBindFramebufferPtr != NULL && glDeleteFramebuffersPtr != NULL && glGenFramebuffersPtr != NULL && 
		glCheckFramebufferStatusPtr != NULL && glFramebufferTexture1DPtr != NULL && glFramebufferTexture2DPtr != NULL && glFramebufferTexture3DPtr != NULL && glFramebufferRenderbufferPtr != NULL && 
		glGetFramebufferAttachmentParameterivPtr != NULL && glGenerateMipmapPtr != NULL && glBlitFramebufferPtr != NULL && glRenderbufferStorageMultisamplePtr != NULL && glFramebufferTextureLayerPtr != NULL;
}

inline bool loadGL_ARB_map_buffer_range()
{
	glMapBufferRangePtr = reinterpret_cast<PFNGLMAPBUFFERRANGEPROC>(::wglGetProcAddress("glMapBufferRange"));
	glFlushMappedBufferRangePtr = reinterpret_cast<PFNGLFLUSHMAPPEDBUFFERRANGEPROC>(::wglGetProcAddress("glFlushMappedBufferRange"));

	return glMapBufferRangePtr != NULL && glFlushMappedBufferRangePtr != NULL;
}

inline bool loadGL_ARB_vertex_array_object()
{
	glBindVertexArrayPtr = reinterpret_cast<PFNGLBINDVERTEXARRAYPROC>(::wglGetProcAddress("glBindVertexArray"));
	glDeleteVertexArraysPtr = reinterpret_cast<PFNGLDELETEVERTEXARRAYSPROC>(::wglGetProcAddress("glDeleteVertexArrays"));
	glGenVertexArraysPtr = reinterpret_cast<PFNGLGENVERTEXARRAYSPROC>(::wglGetProcAddress("glGenVertexArrays"));
	glIsVertexArrayPtr = reinterpret_cast<PFNGLISVERTEXARRAYPROC>(::wglGetProcAddress("glIsVertexArray"));

	return glBindVertexArrayPtr != NULL && glDeleteVertexArraysPtr != NULL && glGenVertexArraysPtr != NULL && glIsVertexArrayPtr != NULL;
}

inline bool loadGL_ARB_uniform_buffer_object()
{
	glGetUniformIndicesPtr = reinterpret_cast<PFNGLGETUNIFORMINDICESPROC>(::wglGetProcAddress("glGetUniformIndices"));
	glGetActiveUniformsivPtr = reinterpret_cast<PFNGLGETACTIVEUNIFORMSIVPROC>(::wglGetProcAddress("glGetActiveUniformsiv"));
	glGetActiveUniformNamePtr = reinterpret_cast<PFNGLGETACTIVEUNIFORMNAMEPROC>(::wglGetProcAddress("glGetActiveUniformName"));
	glGetUniformBlockIndexPtr = reinterpret_cast<PFNGLGETUNIFORMBLOCKINDEXPROC>(::wglGetProcAddress("glGetUniformBlockIndex"));
	glGetActiveUniformBlockivPtr = reinterpret_cast<PFNGLGETACTIVEUNIFORMBLOCKIVPROC>(::wglGetProcAddress("glGetActiveUniformBlockiv"));
	glGetActiveUniformBlockNamePtr = reinterpret_cast<PFNGLGETACTIVEUNIFORMBLOCKNAMEPROC>(::wglGetProcAddress("glGetActiveUniformBlockName"));
	glUniformBlockBindingPtr = reinterpret_cast<PFNGLUNIFORMBLOCKBINDINGPROC>(::wglGetProcAddress("glUniformBlockBinding"));

	return glGetUniformIndicesPtr != NULL && glGetActiveUniformsivPtr != NULL && glGetActiveUniformNamePtr != NULL && glGetUniformBlockIndexPtr != NULL && glGetActiveUniformBlockivPtr != NULL && 
		glGetActiveUniformBlockNamePtr != NULL && glUniformBlockBindingPtr != NULL;
}

inline bool loadGL_ARB_copy_buffer()
{
	glCopyBufferSubDataPtr = reinterpret_cast<PFNGLCOPYBUFFERSUBDATAPROC>(::wglGetProcAddress("glCopyBufferSubData"));

	return glCopyBufferSubDataPtr != NULL;
}

inline bool loadGL_ARB_draw_elements_base_vertex()
{
	glDrawElementsBaseVertexPtr = reinterpret_cast<PFNGLDRAWELEMENTSBASEVERTEXPROC>(::wglGetProcAddress("glDrawElementsBaseVertex"));
	glDrawRangeElementsBaseVertexPtr = reinterpret_cast<PFNGLDRAWRANGEELEMENTSBASEVERTEXPROC>(::wglGetProcAddress("glDrawRangeElementsBaseVertex"));
	glDrawElementsInstancedBaseVertexPtr = reinterpret_cast<PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXPROC>(::wglGetProcAddress("glDrawElementsInstancedBaseVertex"));
	glMultiDrawElementsBaseVertexPtr = reinterpret_cast<PFNGLMULTIDRAWELEMENTSBASEVERTEXPROC>(::wglGetProcAddress("glMultiDrawElementsBaseVertex"));

	return glDrawElementsBaseVertexPtr != NULL && glDrawRangeElementsBaseVertexPtr != NULL && glDrawElementsInstancedBaseVertexPtr != NULL && glMultiDrawElementsBaseVertexPtr != NULL;
}

inline bool loadGL_ARB_provoking_vertex()
{
	glProvokingVertexPtr = reinterpret_cast<PFNGLPROVOKINGVERTEXPROC>(::wglGetProcAddress("glProvokingVertex"));

	return glProvokingVertexPtr != NULL;
}

inline bool loadGL_ARB_sync()
{
	glFenceSyncPtr = reinterpret_cast<PFNGLFENCESYNCPROC>(::wglGetProcAddress("glFenceSync"));
	glIsSyncPtr = reinterpret_cast<PFNGLISSYNCPROC>(::wglGetProcAddress("glIsSync"));
	glDeleteSyncPtr = reinterpret_cast<PFNGLDELETESYNCPROC>(::wglGetProcAddress("glDeleteSync"));
	glClientWaitSyncPtr = reinterpret_cast<PFNGLCLIENTWAITSYNCPROC>(::wglGetProcAddress("glClientWaitSync"));
	glWaitSyncPtr = reinterpret_cast<PFNGLWAITSYNCPROC>(::wglGetProcAddress("glWaitSync"));
	glGetInteger64vPtr = reinterpret_cast<PFNGLGETINTEGER64VPROC>(::wglGetProcAddress("glGetInteger64v"));
	glGetSyncivPtr = reinterpret_cast<PFNGLGETSYNCIVPROC>(::wglGetProcAddress("glGetSynciv"));

	return glFenceSyncPtr != NULL && glIsSyncPtr != NULL && glDeleteSyncPtr != NULL && glClientWaitSyncPtr != NULL && glWaitSyncPtr != NULL && 
		glGetInteger64vPtr != NULL && glGetSyncivPtr != NULL;
}

inline bool loadGL_ARB_texture_multisample()
{
	glTexImage2DMultisamplePtr = reinterpret_cast<PFNGLTEXIMAGE2DMULTISAMPLEPROC>(::wglGetProcAddress("glTexImage2DMultisample"));
	glTexImage3DMultisamplePtr = reinterpret_cast<PFNGLTEXIMAGE3DMULTISAMPLEPROC>(::wglGetProcAddress("glTexImage3DMultisample"));
	glGetMultisamplefvPtr = reinterpret_cast<PFNGLGETMULTISAMPLEFVPROC>(::wglGetProcAddress("glGetMultisamplefv"));
	glSampleMaskiPtr = reinterpret_cast<PFNGLSAMPLEMASKIPROC>(::wglGetProcAddress("glSampleMaski"));

	return glTexImage2DMultisamplePtr != NULL && glTexImage3DMultisamplePtr != NULL && glGetMultisamplefvPtr != NULL && glSampleMaskiPtr != NULL;
}

inline bool loadGL_ARB_draw_buffers_blend()
{
	glBlendEquationiARBPtr = reinterpret_cast<PFNGLBLENDEQUATIONIARBPROC>(::wglGetProcAddress("glBlendEquationiARB"));
	glBlendEquationSeparateiARBPtr = reinterpret_cast<PFNGLBLENDEQUATIONSEPARATEIARBPROC>(::wglGetProcAddress("glBlendEquationSeparateiARB"));
	glBlendFunciARBPtr = reinterpret_cast<PFNGLBLENDFUNCIARBPROC>(::wglGetProcAddress("glBlendFunciARB"));
	glBlendFuncSeparateiARBPtr = reinterpret_cast<PFNGLBLENDFUNCSEPARATEIARBPROC>(::wglGetProcAddress("glBlendFuncSeparateiARB"));

	return glBlendEquationiARBPtr != NULL && glBlendEquationSeparateiARBPtr != NULL && glBlendFunciARBPtr != NULL && glBlendFuncSeparateiARBPtr != NULL;
}

inline bool loadGL_ARB_sample_shading()
{
	glMinSampleShadingARBPtr = reinterpret_cast<PFNGLMINSAMPLESHADINGARBPROC>(::wglGetProcAddress("glMinSampleShadingARB"));

	return glMinSampleShadingARBPtr != NULL;
}

inline bool loadGL_ARB_shading_language_include()
{
	glNamedStringARBPtr = reinterpret_cast<PFNGLNAMEDSTRINGARBPROC>(::wglGetProcAddress("glNamedStringARB"));
	glDeleteNamedStringARBPtr = reinterpret_cast<PFNGLDELETENAMEDSTRINGARBPROC>(::wglGetProcAddress("glDeleteNamedStringARB"));
	glCompileShaderIncludeARBPtr = reinterpret_cast<PFNGLCOMPILESHADERINCLUDEARBPROC>(::wglGetProcAddress("glCompileShaderIncludeARB"));
	glIsNamedStringARBPtr = reinterpret_cast<PFNGLISNAMEDSTRINGARBPROC>(::wglGetProcAddress("glIsNamedStringARB"));
	glGetNamedStringARBPtr = reinterpret_cast<PFNGLGETNAMEDSTRINGARBPROC>(::wglGetProcAddress("glGetNamedStringARB"));
	glGetNamedStringivARBPtr = reinterpret_cast<PFNGLGETNAMEDSTRINGIVARBPROC>(::wglGetProcAddress("glGetNamedStringivARB"));

	return glNamedStringARBPtr != NULL && glDeleteNamedStringARBPtr != NULL && glCompileShaderIncludeARBPtr != NULL && glIsNamedStringARBPtr != NULL && glGetNamedStringARBPtr != NULL && 
		glGetNamedStringivARBPtr != NULL;
}

inline bool loadGL_ARB_blend_func_extended()
{
	glBindFragDataLocationIndexedPtr = reinterpret_cast<PFNGLBINDFRAGDATALOCATIONINDEXEDPROC>(::wglGetProcAddress("glBindFragDataLocationIndexed"));
	glGetFragDataIndexPtr = reinterpret_cast<PFNGLGETFRAGDATAINDEXPROC>(::wglGetProcAddress("glGetFragDataIndex"));

	return glBindFragDataLocationIndexedPtr != NULL && glGetFragDataIndexPtr != NULL;
}

inline bool loadGL_ARB_sampler_objects()
{
	glGenSamplersPtr = reinterpret_cast<PFNGLGENSAMPLERSPROC>(::wglGetProcAddress("glGenSamplers"));
	glDeleteSamplersPtr = reinterpret_cast<PFNGLDELETESAMPLERSPROC>(::wglGetProcAddress("glDeleteSamplers"));
	glIsSamplerPtr = reinterpret_cast<PFNGLISSAMPLERPROC>(::wglGetProcAddress("glIsSampler"));
	glBindSamplerPtr = reinterpret_cast<PFNGLBINDSAMPLERPROC>(::wglGetProcAddress("glBindSampler"));
	glSamplerParameteriPtr = reinterpret_cast<PFNGLSAMPLERPARAMETERIPROC>(::wglGetProcAddress("glSamplerParameteri"));
	glSamplerParameterivPtr = reinterpret_cast<PFNGLSAMPLERPARAMETERIVPROC>(::wglGetProcAddress("glSamplerParameteriv"));
	glSamplerParameterfPtr = reinterpret_cast<PFNGLSAMPLERPARAMETERFPROC>(::wglGetProcAddress("glSamplerParameterf"));
	glSamplerParameterfvPtr = reinterpret_cast<PFNGLSAMPLERPARAMETERFVPROC>(::wglGetProcAddress("glSamplerParameterfv"));
	glSamplerParameterIivPtr = reinterpret_cast<PFNGLSAMPLERPARAMETERIIVPROC>(::wglGetProcAddress("glSamplerParameterIiv"));
	glSamplerParameterIuivPtr = reinterpret_cast<PFNGLSAMPLERPARAMETERIUIVPROC>(::wglGetProcAddress("glSamplerParameterIuiv"));
	glGetSamplerParameterivPtr = reinterpret_cast<PFNGLGETSAMPLERPARAMETERIVPROC>(::wglGetProcAddress("glGetSamplerParameteriv"));
	glGetSamplerParameterIivPtr = reinterpret_cast<PFNGLGETSAMPLERPARAMETERIIVPROC>(::wglGetProcAddress("glGetSamplerParameterIiv"));
	glGetSamplerParameterfvPtr = reinterpret_cast<PFNGLGETSAMPLERPARAMETERFVPROC>(::wglGetProcAddress("glGetSamplerParameterfv"));
	glGetSamplerParameterIuivPtr = reinterpret_cast<PFNGLGETSAMPLERPARAMETERIUIVPROC>(::wglGetProcAddress("glGetSamplerParameterIuiv"));

	return glGenSamplersPtr != NULL && glDeleteSamplersPtr != NULL && glIsSamplerPtr != NULL && glBindSamplerPtr != NULL && glSamplerParameteriPtr != NULL && 
		glSamplerParameterivPtr != NULL && glSamplerParameterfPtr != NULL && glSamplerParameterfvPtr != NULL && glSamplerParameterIivPtr != NULL && glSamplerParameterIuivPtr != NULL && 
		glGetSamplerParameterivPtr != NULL && glGetSamplerParameterIivPtr != NULL && glGetSamplerParameterfvPtr != NULL && glGetSamplerParameterIuivPtr != NULL;
}

inline bool loadGL_ARB_timer_query()
{
	glQueryCounterPtr = reinterpret_cast<PFNGLQUERYCOUNTERPROC>(::wglGetProcAddress("glQueryCounter"));
	glGetQueryObjecti64vPtr = reinterpret_cast<PFNGLGETQUERYOBJECTI64VPROC>(::wglGetProcAddress("glGetQueryObjecti64v"));
	glGetQueryObjectui64vPtr = reinterpret_cast<PFNGLGETQUERYOBJECTUI64VPROC>(::wglGetProcAddress("glGetQueryObjectui64v"));

	return glQueryCounterPtr != NULL && glGetQueryObjecti64vPtr != NULL && glGetQueryObjectui64vPtr != NULL;
}

inline bool loadGL_ARB_vertex_type_2_10_10_10_rev()
{
	glVertexP2uiPtr = reinterpret_cast<PFNGLVERTEXP2UIPROC>(::wglGetProcAddress("glVertexP2ui"));
	glVertexP2uivPtr = reinterpret_cast<PFNGLVERTEXP2UIVPROC>(::wglGetProcAddress("glVertexP2uiv"));
	glVertexP3uiPtr = reinterpret_cast<PFNGLVERTEXP3UIPROC>(::wglGetProcAddress("glVertexP3ui"));
	glVertexP3uivPtr = reinterpret_cast<PFNGLVERTEXP3UIVPROC>(::wglGetProcAddress("glVertexP3uiv"));
	glVertexP4uiPtr = reinterpret_cast<PFNGLVERTEXP4UIPROC>(::wglGetProcAddress("glVertexP4ui"));
	glVertexP4uivPtr = reinterpret_cast<PFNGLVERTEXP4UIVPROC>(::wglGetProcAddress("glVertexP4uiv"));
	glTexCoordP1uiPtr = reinterpret_cast<PFNGLTEXCOORDP1UIPROC>(::wglGetProcAddress("glTexCoordP1ui"));
	glTexCoordP1uivPtr = reinterpret_cast<PFNGLTEXCOORDP1UIVPROC>(::wglGetProcAddress("glTexCoordP1uiv"));
	glTexCoordP2uiPtr = reinterpret_cast<PFNGLTEXCOORDP2UIPROC>(::wglGetProcAddress("glTexCoordP2ui"));
	glTexCoordP2uivPtr = reinterpret_cast<PFNGLTEXCOORDP2UIVPROC>(::wglGetProcAddress("glTexCoordP2uiv"));
	glTexCoordP3uiPtr = reinterpret_cast<PFNGLTEXCOORDP3UIPROC>(::wglGetProcAddress("glTexCoordP3ui"));
	glTexCoordP3uivPtr = reinterpret_cast<PFNGLTEXCOORDP3UIVPROC>(::wglGetProcAddress("glTexCoordP3uiv"));
	glTexCoordP4uiPtr = reinterpret_cast<PFNGLTEXCOORDP4UIPROC>(::wglGetProcAddress("glTexCoordP4ui"));
	glTexCoordP4uivPtr = reinterpret_cast<PFNGLTEXCOORDP4UIVPROC>(::wglGetProcAddress("glTexCoordP4uiv"));
	glMultiTexCoordP1uiPtr = reinterpret_cast<PFNGLMULTITEXCOORDP1UIPROC>(::wglGetProcAddress("glMultiTexCoordP1ui"));
	glMultiTexCoordP1uivPtr = reinterpret_cast<PFNGLMULTITEXCOORDP1UIVPROC>(::wglGetProcAddress("glMultiTexCoordP1uiv"));
	glMultiTexCoordP2uiPtr = reinterpret_cast<PFNGLMULTITEXCOORDP2UIPROC>(::wglGetProcAddress("glMultiTexCoordP2ui"));
	glMultiTexCoordP2uivPtr = reinterpret_cast<PFNGLMULTITEXCOORDP2UIVPROC>(::wglGetProcAddress("glMultiTexCoordP2uiv"));
	glMultiTexCoordP3uiPtr = reinterpret_cast<PFNGLMULTITEXCOORDP3UIPROC>(::wglGetProcAddress("glMultiTexCoordP3ui"));
	glMultiTexCoordP3uivPtr = reinterpret_cast<PFNGLMULTITEXCOORDP3UIVPROC>(::wglGetProcAddress("glMultiTexCoordP3uiv"));
	glMultiTexCoordP4uiPtr = reinterpret_cast<PFNGLMULTITEXCOORDP4UIPROC>(::wglGetProcAddress("glMultiTexCoordP4ui"));
	glMultiTexCoordP4uivPtr = reinterpret_cast<PFNGLMULTITEXCOORDP4UIVPROC>(::wglGetProcAddress("glMultiTexCoordP4uiv"));
	glNormalP3uiPtr = reinterpret_cast<PFNGLNORMALP3UIPROC>(::wglGetProcAddress("glNormalP3ui"));
	glNormalP3uivPtr = reinterpret_cast<PFNGLNORMALP3UIVPROC>(::wglGetProcAddress("glNormalP3uiv"));
	glColorP3uiPtr = reinterpret_cast<PFNGLCOLORP3UIPROC>(::wglGetProcAddress("glColorP3ui"));
	glColorP3uivPtr = reinterpret_cast<PFNGLCOLORP3UIVPROC>(::wglGetProcAddress("glColorP3uiv"));
	glColorP4uiPtr = reinterpret_cast<PFNGLCOLORP4UIPROC>(::wglGetProcAddress("glColorP4ui"));
	glColorP4uivPtr = reinterpret_cast<PFNGLCOLORP4UIVPROC>(::wglGetProcAddress("glColorP4uiv"));
	glSecondaryColorP3uiPtr = reinterpret_cast<PFNGLSECONDARYCOLORP3UIPROC>(::wglGetProcAddress("glSecondaryColorP3ui"));
	glSecondaryColorP3uivPtr = reinterpret_cast<PFNGLSECONDARYCOLORP3UIVPROC>(::wglGetProcAddress("glSecondaryColorP3uiv"));
	glVertexAttribP1uiPtr = reinterpret_cast<PFNGLVERTEXATTRIBP1UIPROC>(::wglGetProcAddress("glVertexAttribP1ui"));
	glVertexAttribP1uivPtr = reinterpret_cast<PFNGLVERTEXATTRIBP1UIVPROC>(::wglGetProcAddress("glVertexAttribP1uiv"));
	glVertexAttribP2uiPtr = reinterpret_cast<PFNGLVERTEXATTRIBP2UIPROC>(::wglGetProcAddress("glVertexAttribP2ui"));
	glVertexAttribP2uivPtr = reinterpret_cast<PFNGLVERTEXATTRIBP2UIVPROC>(::wglGetProcAddress("glVertexAttribP2uiv"));
	glVertexAttribP3uiPtr = reinterpret_cast<PFNGLVERTEXATTRIBP3UIPROC>(::wglGetProcAddress("glVertexAttribP3ui"));
	glVertexAttribP3uivPtr = reinterpret_cast<PFNGLVERTEXATTRIBP3UIVPROC>(::wglGetProcAddress("glVertexAttribP3uiv"));
	glVertexAttribP4uiPtr = reinterpret_cast<PFNGLVERTEXATTRIBP4UIPROC>(::wglGetProcAddress("glVertexAttribP4ui"));
	glVertexAttribP4uivPtr = reinterpret_cast<PFNGLVERTEXATTRIBP4UIVPROC>(::wglGetProcAddress("glVertexAttribP4uiv"));

	return glVertexP2uiPtr != NULL && glVertexP2uivPtr != NULL && glVertexP3uiPtr != NULL && glVertexP3uivPtr != NULL && glVertexP4uiPtr != NULL && 
		glVertexP4uivPtr != NULL && glTexCoordP1uiPtr != NULL && glTexCoordP1uivPtr != NULL && glTexCoordP2uiPtr != NULL && glTexCoordP2uivPtr != NULL && 
		glTexCoordP3uiPtr != NULL && glTexCoordP3uivPtr != NULL && glTexCoordP4uiPtr != NULL && glTexCoordP4uivPtr != NULL && glMultiTexCoordP1uiPtr != NULL && 
		glMultiTexCoordP1uivPtr != NULL && glMultiTexCoordP2uiPtr != NULL && glMultiTexCoordP2uivPtr != NULL && glMultiTexCoordP3uiPtr != NULL && glMultiTexCoordP3uivPtr != NULL && 
		glMultiTexCoordP4uiPtr != NULL && glMultiTexCoordP4uivPtr != NULL && glNormalP3uiPtr != NULL && glNormalP3uivPtr != NULL && glColorP3uiPtr != NULL && 
		glColorP3uivPtr != NULL && glColorP4uiPtr != NULL && glColorP4uivPtr != NULL && glSecondaryColorP3uiPtr != NULL && glSecondaryColorP3uivPtr != NULL && 
		glVertexAttribP1uiPtr != NULL && glVertexAttribP1uivPtr != NULL && glVertexAttribP2uiPtr != NULL && glVertexAttribP2uivPtr != NULL && glVertexAttribP3uiPtr != NULL && 
		glVertexAttribP3uivPtr != NULL && glVertexAttribP4uiPtr != NULL && glVertexAttribP4uivPtr != NULL;
}

inline bool loadGL_ARB_draw_indirect()
{
	glDrawArraysIndirectPtr = reinterpret_cast<PFNGLDRAWARRAYSINDIRECTPROC>(::wglGetProcAddress("glDrawArraysIndirect"));
	glDrawElementsIndirectPtr = reinterpret_cast<PFNGLDRAWELEMENTSINDIRECTPROC>(::wglGetProcAddress("glDrawElementsIndirect"));

	return glDrawArraysIndirectPtr != NULL && glDrawElementsIndirectPtr != NULL;
}

inline bool loadGL_ARB_gpu_shader_fp64()
{
	glUniform1dPtr = reinterpret_cast<PFNGLUNIFORM1DPROC>(::wglGetProcAddress("glUniform1d"));
	glUniform2dPtr = reinterpret_cast<PFNGLUNIFORM2DPROC>(::wglGetProcAddress("glUniform2d"));
	glUniform3dPtr = reinterpret_cast<PFNGLUNIFORM3DPROC>(::wglGetProcAddress("glUniform3d"));
	glUniform4dPtr = reinterpret_cast<PFNGLUNIFORM4DPROC>(::wglGetProcAddress("glUniform4d"));
	glUniform1dvPtr = reinterpret_cast<PFNGLUNIFORM1DVPROC>(::wglGetProcAddress("glUniform1dv"));
	glUniform2dvPtr = reinterpret_cast<PFNGLUNIFORM2DVPROC>(::wglGetProcAddress("glUniform2dv"));
	glUniform3dvPtr = reinterpret_cast<PFNGLUNIFORM3DVPROC>(::wglGetProcAddress("glUniform3dv"));
	glUniform4dvPtr = reinterpret_cast<PFNGLUNIFORM4DVPROC>(::wglGetProcAddress("glUniform4dv"));
	glUniformMatrix2dvPtr = reinterpret_cast<PFNGLUNIFORMMATRIX2DVPROC>(::wglGetProcAddress("glUniformMatrix2dv"));
	glUniformMatrix3dvPtr = reinterpret_cast<PFNGLUNIFORMMATRIX3DVPROC>(::wglGetProcAddress("glUniformMatrix3dv"));
	glUniformMatrix4dvPtr = reinterpret_cast<PFNGLUNIFORMMATRIX4DVPROC>(::wglGetProcAddress("glUniformMatrix4dv"));
	glUniformMatrix2x3dvPtr = reinterpret_cast<PFNGLUNIFORMMATRIX2X3DVPROC>(::wglGetProcAddress("glUniformMatrix2x3dv"));
	glUniformMatrix2x4dvPtr = reinterpret_cast<PFNGLUNIFORMMATRIX2X4DVPROC>(::wglGetProcAddress("glUniformMatrix2x4dv"));
	glUniformMatrix3x2dvPtr = reinterpret_cast<PFNGLUNIFORMMATRIX3X2DVPROC>(::wglGetProcAddress("glUniformMatrix3x2dv"));
	glUniformMatrix3x4dvPtr = reinterpret_cast<PFNGLUNIFORMMATRIX3X4DVPROC>(::wglGetProcAddress("glUniformMatrix3x4dv"));
	glUniformMatrix4x2dvPtr = reinterpret_cast<PFNGLUNIFORMMATRIX4X2DVPROC>(::wglGetProcAddress("glUniformMatrix4x2dv"));
	glUniformMatrix4x3dvPtr = reinterpret_cast<PFNGLUNIFORMMATRIX4X3DVPROC>(::wglGetProcAddress("glUniformMatrix4x3dv"));
	glGetUniformdvPtr = reinterpret_cast<PFNGLGETUNIFORMDVPROC>(::wglGetProcAddress("glGetUniformdv"));

	return glUniform1dPtr != NULL && glUniform2dPtr != NULL && glUniform3dPtr != NULL && glUniform4dPtr != NULL && glUniform1dvPtr != NULL && 
		glUniform2dvPtr != NULL && glUniform3dvPtr != NULL && glUniform4dvPtr != NULL && glUniformMatrix2dvPtr != NULL && glUniformMatrix3dvPtr != NULL && 
		glUniformMatrix4dvPtr != NULL && glUniformMatrix2x3dvPtr != NULL && glUniformMatrix2x4dvPtr != NULL && glUniformMatrix3x2dvPtr != NULL && glUniformMatrix3x4dvPtr != NULL && 
		glUniformMatrix4x2dvPtr != NULL && glUniformMatrix4x3dvPtr != NULL && glGetUniformdvPtr != NULL;
}

inline bool loadGL_ARB_shader_subroutine()
{
	glGetSubroutineUniformLocationPtr = reinterpret_cast<PFNGLGETSUBROUTINEUNIFORMLOCATIONPROC>(::wglGetProcAddress("glGetSubroutineUniformLocation"));
	glGetSubroutineIndexPtr = reinterpret_cast<PFNGLGETSUBROUTINEINDEXPROC>(::wglGetProcAddress("glGetSubroutineIndex"));
	glGetActiveSubroutineUniformivPtr = reinterpret_cast<PFNGLGETACTIVESUBROUTINEUNIFORMIVPROC>(::wglGetProcAddress("glGetActiveSubroutineUniformiv"));
	glGetActiveSubroutineUniformNamePtr = reinterpret_cast<PFNGLGETACTIVESUBROUTINEUNIFORMNAMEPROC>(::wglGetProcAddress("glGetActiveSubroutineUniformName"));
	glGetActiveSubroutineNamePtr = reinterpret_cast<PFNGLGETACTIVESUBROUTINENAMEPROC>(::wglGetProcAddress("glGetActiveSubroutineName"));
	glUniformSubroutinesuivPtr = reinterpret_cast<PFNGLUNIFORMSUBROUTINESUIVPROC>(::wglGetProcAddress("glUniformSubroutinesuiv"));
	glGetUniformSubroutineuivPtr = reinterpret_cast<PFNGLGETUNIFORMSUBROUTINEUIVPROC>(::wglGetProcAddress("glGetUniformSubroutineuiv"));
	glGetProgramStageivPtr = reinterpret_cast<PFNGLGETPROGRAMSTAGEIVPROC>(::wglGetProcAddress("glGetProgramStageiv"));

	return glGetSubroutineUniformLocationPtr != NULL && glGetSubroutineIndexPtr != NULL && glGetActiveSubroutineUniformivPtr != NULL && glGetActiveSubroutineUniformNamePtr != NULL && glGetActiveSubroutineNamePtr != NULL && 
		glUniformSubroutinesuivPtr != NULL && glGetUniformSubroutineuivPtr != NULL && glGetProgramStageivPtr != NULL;
}

inline bool loadGL_ARB_tessellation_shader()
{
	glPatchParameteriPtr = reinterpret_cast<PFNGLPATCHPARAMETERIPROC>(::wglGetProcAddress("glPatchParameteri"));
	glPatchParameterfvPtr = reinterpret_cast<PFNGLPATCHPARAMETERFVPROC>(::wglGetProcAddress("glPatchParameterfv"));

	return glPatchParameteriPtr != NULL && glPatchParameterfvPtr != NULL;
}

inline bool loadGL_ARB_transform_feedback2()
{
	glBindTransformFeedbackPtr = reinterpret_cast<PFNGLBINDTRANSFORMFEEDBACKPROC>(::wglGetProcAddress("glBindTransformFeedback"));
	glDeleteTransformFeedbacksPtr = reinterpret_cast<PFNGLDELETETRANSFORMFEEDBACKSPROC>(::wglGetProcAddress("glDeleteTransformFeedbacks"));
	glGenTransformFeedbacksPtr = reinterpret_cast<PFNGLGENTRANSFORMFEEDBACKSPROC>(::wglGetProcAddress("glGenTransformFeedbacks"));
	glIsTransformFeedbackPtr = reinterpret_cast<PFNGLISTRANSFORMFEEDBACKPROC>(::wglGetProcAddress("glIsTransformFeedback"));
	glPauseTransformFeedbackPtr = reinterpret_cast<PFNGLPAUSETRANSFORMFEEDBACKPROC>(::wglGetProcAddress("glPauseTransformFeedback"));
	glResumeTransformFeedbackPtr = reinterpret_cast<PFNGLRESUMETRANSFORMFEEDBACKPROC>(::wglGetProcAddress("glResumeTransformFeedback"));
	glDrawTransformFeedbackPtr = reinterpret_cast<PFNGLDRAWTRANSFORMFEEDBACKPROC>(::wglGetProcAddress("glDrawTransformFeedback"));

	return glBindTransformFeedbackPtr != NULL && glDeleteTransformFeedbacksPtr != NULL && glGenTransformFeedbacksPtr != NULL && glIsTransformFeedbackPtr != NULL && glPauseTransformFeedbackPtr != NULL && 
		glResumeTransformFeedbackPtr != NULL && glDrawTransformFeedbackPtr != NULL;
}

inline bool loadGL_ARB_transform_feedback3()
{
	glDrawTransformFeedbackStreamPtr = reinterpret_cast<PFNGLDRAWTRANSFORMFEEDBACKSTREAMPROC>(::wglGetProcAddress("glDrawTransformFeedbackStream"));
	glBeginQueryIndexedPtr = reinterpret_cast<PFNGLBEGINQUERYINDEXEDPROC>(::wglGetProcAddress("glBeginQueryIndexed"));
	glEndQueryIndexedPtr = reinterpret_cast<PFNGLENDQUERYINDEXEDPROC>(::wglGetProcAddress("glEndQueryIndexed"));
	glGetQueryIndexedivPtr = reinterpret_cast<PFNGLGETQUERYINDEXEDIVPROC>(::wglGetProcAddress("glGetQueryIndexediv"));

	return glDrawTransformFeedbackStreamPtr != NULL && glBeginQueryIndexedPtr != NULL && glEndQueryIndexedPtr != NULL && glGetQueryIndexedivPtr != NULL;
}

inline bool loadGL_ARB_ES2_compatibility()
{
	glReleaseShaderCompilerPtr = reinterpret_cast<PFNGLRELEASESHADERCOMPILERPROC>(::wglGetProcAddress("glReleaseShaderCompiler"));
	glShaderBinaryPtr = reinterpret_cast<PFNGLSHADERBINARYPROC>(::wglGetProcAddress("glShaderBinary"));
	glGetShaderPrecisionFormatPtr = reinterpret_cast<PFNGLGETSHADERPRECISIONFORMATPROC>(::wglGetProcAddress("glGetShaderPrecisionFormat"));
	glDepthRangefPtr = reinterpret_cast<PFNGLDEPTHRANGEFPROC>(::wglGetProcAddress("glDepthRangef"));
	glClearDepthfPtr = reinterpret_cast<PFNGLCLEARDEPTHFPROC>(::wglGetProcAddress("glClearDepthf"));

	return glReleaseShaderCompilerPtr != NULL && glShaderBinaryPtr != NULL && glGetShaderPrecisionFormatPtr != NULL && glDepthRangefPtr != NULL && glClearDepthfPtr != NULL;
}

inline bool loadGL_ARB_get_program_binary()
{
	glGetProgramBinaryPtr = reinterpret_cast<PFNGLGETPROGRAMBINARYPROC>(::wglGetProcAddress("glGetProgramBinary"));
	glProgramBinaryPtr = reinterpret_cast<PFNGLPROGRAMBINARYPROC>(::wglGetProcAddress("glProgramBinary"));
	glProgramParameteriPtr = reinterpret_cast<PFNGLPROGRAMPARAMETERIPROC>(::wglGetProcAddress("glProgramParameteri"));

	return glGetProgramBinaryPtr != NULL && glProgramBinaryPtr != NULL && glProgramParameteriPtr != NULL;
}

inline bool loadGL_ARB_separate_shader_objects()
{
	glUseProgramStagesPtr = reinterpret_cast<PFNGLUSEPROGRAMSTAGESPROC>(::wglGetProcAddress("glUseProgramStages"));
	glActiveShaderProgramPtr = reinterpret_cast<PFNGLACTIVESHADERPROGRAMPROC>(::wglGetProcAddress("glActiveShaderProgram"));
	glCreateShaderProgramvPtr = reinterpret_cast<PFNGLCREATESHADERPROGRAMVPROC>(::wglGetProcAddress("glCreateShaderProgramv"));
	glBindProgramPipelinePtr = reinterpret_cast<PFNGLBINDPROGRAMPIPELINEPROC>(::wglGetProcAddress("glBindProgramPipeline"));
	glDeleteProgramPipelinesPtr = reinterpret_cast<PFNGLDELETEPROGRAMPIPELINESPROC>(::wglGetProcAddress("glDeleteProgramPipelines"));
	glGenProgramPipelinesPtr = reinterpret_cast<PFNGLGENPROGRAMPIPELINESPROC>(::wglGetProcAddress("glGenProgramPipelines"));
	glIsProgramPipelinePtr = reinterpret_cast<PFNGLISPROGRAMPIPELINEPROC>(::wglGetProcAddress("glIsProgramPipeline"));
	glGetProgramPipelineivPtr = reinterpret_cast<PFNGLGETPROGRAMPIPELINEIVPROC>(::wglGetProcAddress("glGetProgramPipelineiv"));
	glProgramUniform1iPtr = reinterpret_cast<PFNGLPROGRAMUNIFORM1IPROC>(::wglGetProcAddress("glProgramUniform1i"));
	glProgramUniform1ivPtr = reinterpret_cast<PFNGLPROGRAMUNIFORM1IVPROC>(::wglGetProcAddress("glProgramUniform1iv"));
	glProgramUniform1fPtr = reinterpret_cast<PFNGLPROGRAMUNIFORM1FPROC>(::wglGetProcAddress("glProgramUniform1f"));
	glProgramUniform1fvPtr = reinterpret_cast<PFNGLPROGRAMUNIFORM1FVPROC>(::wglGetProcAddress("glProgramUniform1fv"));
	glProgramUniform1dPtr = reinterpret_cast<PFNGLPROGRAMUNIFORM1DPROC>(::wglGetProcAddress("glProgramUniform1d"));
	glProgramUniform1dvPtr = reinterpret_cast<PFNGLPROGRAMUNIFORM1DVPROC>(::wglGetProcAddress("glProgramUniform1dv"));
	glProgramUniform1uiPtr = reinterpret_cast<PFNGLPROGRAMUNIFORM1UIPROC>(::wglGetProcAddress("glProgramUniform1ui"));
	glProgramUniform1uivPtr = reinterpret_cast<PFNGLPROGRAMUNIFORM1UIVPROC>(::wglGetProcAddress("glProgramUniform1uiv"));
	glProgramUniform2iPtr = reinterpret_cast<PFNGLPROGRAMUNIFORM2IPROC>(::wglGetProcAddress("glProgramUniform2i"));
	glProgramUniform2ivPtr = reinterpret_cast<PFNGLPROGRAMUNIFORM2IVPROC>(::wglGetProcAddress("glProgramUniform2iv"));
	glProgramUniform2fPtr = reinterpret_cast<PFNGLPROGRAMUNIFORM2FPROC>(::wglGetProcAddress("glProgramUniform2f"));
	glProgramUniform2fvPtr = reinterpret_cast<PFNGLPROGRAMUNIFORM2FVPROC>(::wglGetProcAddress("glProgramUniform2fv"));
	glProgramUniform2dPtr = reinterpret_cast<PFNGLPROGRAMUNIFORM2DPROC>(::wglGetProcAddress("glProgramUniform2d"));
	glProgramUniform2dvPtr = reinterpret_cast<PFNGLPROGRAMUNIFORM2DVPROC>(::wglGetProcAddress("glProgramUniform2dv"));
	glProgramUniform2uiPtr = reinterpret_cast<PFNGLPROGRAMUNIFORM2UIPROC>(::wglGetProcAddress("glProgramUniform2ui"));
	glProgramUniform2uivPtr = reinterpret_cast<PFNGLPROGRAMUNIFORM2UIVPROC>(::wglGetProcAddress("glProgramUniform2uiv"));
	glProgramUniform3iPtr = reinterpret_cast<PFNGLPROGRAMUNIFORM3IPROC>(::wglGetProcAddress("glProgramUniform3i"));
	glProgramUniform3ivPtr = reinterpret_cast<PFNGLPROGRAMUNIFORM3IVPROC>(::wglGetProcAddress("glProgramUniform3iv"));
	glProgramUniform3fPtr = reinterpret_cast<PFNGLPROGRAMUNIFORM3FPROC>(::wglGetProcAddress("glProgramUniform3f"));
	glProgramUniform3fvPtr = reinterpret_cast<PFNGLPROGRAMUNIFORM3FVPROC>(::wglGetProcAddress("glProgramUniform3fv"));
	glProgramUniform3dPtr = reinterpret_cast<PFNGLPROGRAMUNIFORM3DPROC>(::wglGetProcAddress("glProgramUniform3d"));
	glProgramUniform3dvPtr = reinterpret_cast<PFNGLPROGRAMUNIFORM3DVPROC>(::wglGetProcAddress("glProgramUniform3dv"));
	glProgramUniform3uiPtr = reinterpret_cast<PFNGLPROGRAMUNIFORM3UIPROC>(::wglGetProcAddress("glProgramUniform3ui"));
	glProgramUniform3uivPtr = reinterpret_cast<PFNGLPROGRAMUNIFORM3UIVPROC>(::wglGetProcAddress("glProgramUniform3uiv"));
	glProgramUniform4iPtr = reinterpret_cast<PFNGLPROGRAMUNIFORM4IPROC>(::wglGetProcAddress("glProgramUniform4i"));
	glProgramUniform4ivPtr = reinterpret_cast<PFNGLPROGRAMUNIFORM4IVPROC>(::wglGetProcAddress("glProgramUniform4iv"));
	glProgramUniform4fPtr = reinterpret_cast<PFNGLPROGRAMUNIFORM4FPROC>(::wglGetProcAddress("glProgramUniform4f"));
	glProgramUniform4fvPtr = reinterpret_cast<PFNGLPROGRAMUNIFORM4FVPROC>(::wglGetProcAddress("glProgramUniform4fv"));
	glProgramUniform4dPtr = reinterpret_cast<PFNGLPROGRAMUNIFORM4DPROC>(::wglGetProcAddress("glProgramUniform4d"));
	glProgramUniform4dvPtr = reinterpret_cast<PFNGLPROGRAMUNIFORM4DVPROC>(::wglGetProcAddress("glProgramUniform4dv"));
	glProgramUniform4uiPtr = reinterpret_cast<PFNGLPROGRAMUNIFORM4UIPROC>(::wglGetProcAddress("glProgramUniform4ui"));
	glProgramUniform4uivPtr = reinterpret_cast<PFNGLPROGRAMUNIFORM4UIVPROC>(::wglGetProcAddress("glProgramUniform4uiv"));
	glProgramUniformMatrix2fvPtr = reinterpret_cast<PFNGLPROGRAMUNIFORMMATRIX2FVPROC>(::wglGetProcAddress("glProgramUniformMatrix2fv"));
	glProgramUniformMatrix3fvPtr = reinterpret_cast<PFNGLPROGRAMUNIFORMMATRIX3FVPROC>(::wglGetProcAddress("glProgramUniformMatrix3fv"));
	glProgramUniformMatrix4fvPtr = reinterpret_cast<PFNGLPROGRAMUNIFORMMATRIX4FVPROC>(::wglGetProcAddress("glProgramUniformMatrix4fv"));
	glProgramUniformMatrix2dvPtr = reinterpret_cast<PFNGLPROGRAMUNIFORMMATRIX2DVPROC>(::wglGetProcAddress("glProgramUniformMatrix2dv"));
	glProgramUniformMatrix3dvPtr = reinterpret_cast<PFNGLPROGRAMUNIFORMMATRIX3DVPROC>(::wglGetProcAddress("glProgramUniformMatrix3dv"));
	glProgramUniformMatrix4dvPtr = reinterpret_cast<PFNGLPROGRAMUNIFORMMATRIX4DVPROC>(::wglGetProcAddress("glProgramUniformMatrix4dv"));
	glProgramUniformMatrix2x3fvPtr = reinterpret_cast<PFNGLPROGRAMUNIFORMMATRIX2X3FVPROC>(::wglGetProcAddress("glProgramUniformMatrix2x3fv"));
	glProgramUniformMatrix3x2fvPtr = reinterpret_cast<PFNGLPROGRAMUNIFORMMATRIX3X2FVPROC>(::wglGetProcAddress("glProgramUniformMatrix3x2fv"));
	glProgramUniformMatrix2x4fvPtr = reinterpret_cast<PFNGLPROGRAMUNIFORMMATRIX2X4FVPROC>(::wglGetProcAddress("glProgramUniformMatrix2x4fv"));
	glProgramUniformMatrix4x2fvPtr = reinterpret_cast<PFNGLPROGRAMUNIFORMMATRIX4X2FVPROC>(::wglGetProcAddress("glProgramUniformMatrix4x2fv"));
	glProgramUniformMatrix3x4fvPtr = reinterpret_cast<PFNGLPROGRAMUNIFORMMATRIX3X4FVPROC>(::wglGetProcAddress("glProgramUniformMatrix3x4fv"));
	glProgramUniformMatrix4x3fvPtr = reinterpret_cast<PFNGLPROGRAMUNIFORMMATRIX4X3FVPROC>(::wglGetProcAddress("glProgramUniformMatrix4x3fv"));
	glProgramUniformMatrix2x3dvPtr = reinterpret_cast<PFNGLPROGRAMUNIFORMMATRIX2X3DVPROC>(::wglGetProcAddress("glProgramUniformMatrix2x3dv"));
	glProgramUniformMatrix3x2dvPtr = reinterpret_cast<PFNGLPROGRAMUNIFORMMATRIX3X2DVPROC>(::wglGetProcAddress("glProgramUniformMatrix3x2dv"));
	glProgramUniformMatrix2x4dvPtr = reinterpret_cast<PFNGLPROGRAMUNIFORMMATRIX2X4DVPROC>(::wglGetProcAddress("glProgramUniformMatrix2x4dv"));
	glProgramUniformMatrix4x2dvPtr = reinterpret_cast<PFNGLPROGRAMUNIFORMMATRIX4X2DVPROC>(::wglGetProcAddress("glProgramUniformMatrix4x2dv"));
	glProgramUniformMatrix3x4dvPtr = reinterpret_cast<PFNGLPROGRAMUNIFORMMATRIX3X4DVPROC>(::wglGetProcAddress("glProgramUniformMatrix3x4dv"));
	glProgramUniformMatrix4x3dvPtr = reinterpret_cast<PFNGLPROGRAMUNIFORMMATRIX4X3DVPROC>(::wglGetProcAddress("glProgramUniformMatrix4x3dv"));
	glValidateProgramPipelinePtr = reinterpret_cast<PFNGLVALIDATEPROGRAMPIPELINEPROC>(::wglGetProcAddress("glValidateProgramPipeline"));
	glGetProgramPipelineInfoLogPtr = reinterpret_cast<PFNGLGETPROGRAMPIPELINEINFOLOGPROC>(::wglGetProcAddress("glGetProgramPipelineInfoLog"));

	return glUseProgramStagesPtr != NULL && glActiveShaderProgramPtr != NULL && glCreateShaderProgramvPtr != NULL && glBindProgramPipelinePtr != NULL && glDeleteProgramPipelinesPtr != NULL && 
		glGenProgramPipelinesPtr != NULL && glIsProgramPipelinePtr != NULL && glGetProgramPipelineivPtr != NULL && glProgramUniform1iPtr != NULL && glProgramUniform1ivPtr != NULL && 
		glProgramUniform1fPtr != NULL && glProgramUniform1fvPtr != NULL && glProgramUniform1dPtr != NULL && glProgramUniform1dvPtr != NULL && glProgramUniform1uiPtr != NULL && 
		glProgramUniform1uivPtr != NULL && glProgramUniform2iPtr != NULL && glProgramUniform2ivPtr != NULL && glProgramUniform2fPtr != NULL && glProgramUniform2fvPtr != NULL && 
		glProgramUniform2dPtr != NULL && glProgramUniform2dvPtr != NULL && glProgramUniform2uiPtr != NULL && glProgramUniform2uivPtr != NULL && glProgramUniform3iPtr != NULL && 
		glProgramUniform3ivPtr != NULL && glProgramUniform3fPtr != NULL && glProgramUniform3fvPtr != NULL && glProgramUniform3dPtr != NULL && glProgramUniform3dvPtr != NULL && 
		glProgramUniform3uiPtr != NULL && glProgramUniform3uivPtr != NULL && glProgramUniform4iPtr != NULL && glProgramUniform4ivPtr != NULL && glProgramUniform4fPtr != NULL && 
		glProgramUniform4fvPtr != NULL && glProgramUniform4dPtr != NULL && glProgramUniform4dvPtr != NULL && glProgramUniform4uiPtr != NULL && glProgramUniform4uivPtr != NULL && 
		glProgramUniformMatrix2fvPtr != NULL && glProgramUniformMatrix3fvPtr != NULL && glProgramUniformMatrix4fvPtr != NULL && glProgramUniformMatrix2dvPtr != NULL && glProgramUniformMatrix3dvPtr != NULL && 
		glProgramUniformMatrix4dvPtr != NULL && glProgramUniformMatrix2x3fvPtr != NULL && glProgramUniformMatrix3x2fvPtr != NULL && glProgramUniformMatrix2x4fvPtr != NULL && glProgramUniformMatrix4x2fvPtr != NULL && 
		glProgramUniformMatrix3x4fvPtr != NULL && glProgramUniformMatrix4x3fvPtr != NULL && glProgramUniformMatrix2x3dvPtr != NULL && glProgramUniformMatrix3x2dvPtr != NULL && glProgramUniformMatrix2x4dvPtr != NULL && 
		glProgramUniformMatrix4x2dvPtr != NULL && glProgramUniformMatrix3x4dvPtr != NULL && glProgramUniformMatrix4x3dvPtr != NULL && glValidateProgramPipelinePtr != NULL && glGetProgramPipelineInfoLogPtr != NULL;
}

inline bool loadGL_ARB_vertex_attrib_64bit()
{
	glVertexAttribL1dPtr = reinterpret_cast<PFNGLVERTEXATTRIBL1DPROC>(::wglGetProcAddress("glVertexAttribL1d"));
	glVertexAttribL2dPtr = reinterpret_cast<PFNGLVERTEXATTRIBL2DPROC>(::wglGetProcAddress("glVertexAttribL2d"));
	glVertexAttribL3dPtr = reinterpret_cast<PFNGLVERTEXATTRIBL3DPROC>(::wglGetProcAddress("glVertexAttribL3d"));
	glVertexAttribL4dPtr = reinterpret_cast<PFNGLVERTEXATTRIBL4DPROC>(::wglGetProcAddress("glVertexAttribL4d"));
	glVertexAttribL1dvPtr = reinterpret_cast<PFNGLVERTEXATTRIBL1DVPROC>(::wglGetProcAddress("glVertexAttribL1dv"));
	glVertexAttribL2dvPtr = reinterpret_cast<PFNGLVERTEXATTRIBL2DVPROC>(::wglGetProcAddress("glVertexAttribL2dv"));
	glVertexAttribL3dvPtr = reinterpret_cast<PFNGLVERTEXATTRIBL3DVPROC>(::wglGetProcAddress("glVertexAttribL3dv"));
	glVertexAttribL4dvPtr = reinterpret_cast<PFNGLVERTEXATTRIBL4DVPROC>(::wglGetProcAddress("glVertexAttribL4dv"));
	glVertexAttribLPointerPtr = reinterpret_cast<PFNGLVERTEXATTRIBLPOINTERPROC>(::wglGetProcAddress("glVertexAttribLPointer"));
	glGetVertexAttribLdvPtr = reinterpret_cast<PFNGLGETVERTEXATTRIBLDVPROC>(::wglGetProcAddress("glGetVertexAttribLdv"));

	return glVertexAttribL1dPtr != NULL && glVertexAttribL2dPtr != NULL && glVertexAttribL3dPtr != NULL && glVertexAttribL4dPtr != NULL && glVertexAttribL1dvPtr != NULL && 
		glVertexAttribL2dvPtr != NULL && glVertexAttribL3dvPtr != NULL && glVertexAttribL4dvPtr != NULL && glVertexAttribLPointerPtr != NULL && glGetVertexAttribLdvPtr != NULL;
}

inline bool loadGL_ARB_viewport_array()
{
	glViewportArrayvPtr = reinterpret_cast<PFNGLVIEWPORTARRAYVPROC>(::wglGetProcAddress("glViewportArrayv"));
	glViewportIndexedfPtr = reinterpret_cast<PFNGLVIEWPORTINDEXEDFPROC>(::wglGetProcAddress("glViewportIndexedf"));
	glViewportIndexedfvPtr = reinterpret_cast<PFNGLVIEWPORTINDEXEDFVPROC>(::wglGetProcAddress("glViewportIndexedfv"));
	glScissorArrayvPtr = reinterpret_cast<PFNGLSCISSORARRAYVPROC>(::wglGetProcAddress("glScissorArrayv"));
	glScissorIndexedPtr = reinterpret_cast<PFNGLSCISSORINDEXEDPROC>(::wglGetProcAddress("glScissorIndexed"));
	glScissorIndexedvPtr = reinterpret_cast<PFNGLSCISSORINDEXEDVPROC>(::wglGetProcAddress("glScissorIndexedv"));
	glDepthRangeArrayvPtr = reinterpret_cast<PFNGLDEPTHRANGEARRAYVPROC>(::wglGetProcAddress("glDepthRangeArrayv"));
	glDepthRangeIndexedPtr = reinterpret_cast<PFNGLDEPTHRANGEINDEXEDPROC>(::wglGetProcAddress("glDepthRangeIndexed"));
	glGetFloati_vPtr = reinterpret_cast<PFNGLGETFLOATI_VPROC>(::wglGetProcAddress("glGetFloati_v"));
	glGetDoublei_vPtr = reinterpret_cast<PFNGLGETDOUBLEI_VPROC>(::wglGetProcAddress("glGetDoublei_v"));

	return glViewportArrayvPtr != NULL && glViewportIndexedfPtr != NULL && glViewportIndexedfvPtr != NULL && glScissorArrayvPtr != NULL && glScissorIndexedPtr != NULL && 
		glScissorIndexedvPtr != NULL && glDepthRangeArrayvPtr != NULL && glDepthRangeIndexedPtr != NULL && glGetFloati_vPtr != NULL && glGetDoublei_vPtr != NULL;
}

inline bool loadGL_ARB_cl_event()
{
	glCreateSyncFromCLeventARBPtr = reinterpret_cast<PFNGLCREATESYNCFROMCLEVENTARBPROC>(::wglGetProcAddress("glCreateSyncFromCLeventARB"));

	return glCreateSyncFromCLeventARBPtr != NULL;
}

inline bool loadGL_ARB_debug_output()
{
	glDebugMessageControlARBPtr = reinterpret_cast<PFNGLDEBUGMESSAGECONTROLARBPROC>(::wglGetProcAddress("glDebugMessageControlARB"));
	glDebugMessageInsertARBPtr = reinterpret_cast<PFNGLDEBUGMESSAGEINSERTARBPROC>(::wglGetProcAddress("glDebugMessageInsertARB"));
	glDebugMessageCallbackARBPtr = reinterpret_cast<PFNGLDEBUGMESSAGECALLBACKARBPROC>(::wglGetProcAddress("glDebugMessageCallbackARB"));
	glGetDebugMessageLogARBPtr = reinterpret_cast<PFNGLGETDEBUGMESSAGELOGARBPROC>(::wglGetProcAddress("glGetDebugMessageLogARB"));

	return glDebugMessageControlARBPtr != NULL && glDebugMessageInsertARBPtr != NULL && glDebugMessageCallbackARBPtr != NULL && glGetDebugMessageLogARBPtr != NULL;
}

inline bool loadGL_ARB_robustness()
{
	glGetGraphicsResetStatusARBPtr = reinterpret_cast<PFNGLGETGRAPHICSRESETSTATUSARBPROC>(::wglGetProcAddress("glGetGraphicsResetStatusARB"));
	glGetnTexImageARBPtr = reinterpret_cast<PFNGLGETNTEXIMAGEARBPROC>(::wglGetProcAddress("glGetnTexImageARB"));
	glReadnPixelsARBPtr = reinterpret_cast<PFNGLREADNPIXELSARBPROC>(::wglGetProcAddress("glReadnPixelsARB"));
	glGetnCompressedTexImageARBPtr = reinterpret_cast<PFNGLGETNCOMPRESSEDTEXIMAGEARBPROC>(::wglGetProcAddress("glGetnCompressedTexImageARB"));
	glGetnUniformfvARBPtr = reinterpret_cast<PFNGLGETNUNIFORMFVARBPROC>(::wglGetProcAddress("glGetnUniformfvARB"));
	glGetnUniformivARBPtr = reinterpret_cast<PFNGLGETNUNIFORMIVARBPROC>(::wglGetProcAddress("glGetnUniformivARB"));
	glGetnUniformuivARBPtr = reinterpret_cast<PFNGLGETNUNIFORMUIVARBPROC>(::wglGetProcAddress("glGetnUniformuivARB"));
	glGetnUniformdvARBPtr = reinterpret_cast<PFNGLGETNUNIFORMDVARBPROC>(::wglGetProcAddress("glGetnUniformdvARB"));

	return glGetGraphicsResetStatusARBPtr != NULL && glGetnTexImageARBPtr != NULL && glReadnPixelsARBPtr != NULL && glGetnCompressedTexImageARBPtr != NULL && glGetnUniformfvARBPtr != NULL && 
		glGetnUniformivARBPtr != NULL && glGetnUniformuivARBPtr != NULL && glGetnUniformdvARBPtr != NULL;
}

inline bool loadGL_ARB_base_instance()
{
	glDrawArraysInstancedBaseInstancePtr = reinterpret_cast<PFNGLDRAWARRAYSINSTANCEDBASEINSTANCEPROC>(::wglGetProcAddress("glDrawArraysInstancedBaseInstance"));
	glDrawElementsInstancedBaseInstancePtr = reinterpret_cast<PFNGLDRAWELEMENTSINSTANCEDBASEINSTANCEPROC>(::wglGetProcAddress("glDrawElementsInstancedBaseInstance"));
	glDrawElementsInstancedBaseVertexBaseInstancePtr = reinterpret_cast<PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXBASEINSTANCEPROC>(::wglGetProcAddress("glDrawElementsInstancedBaseVertexBaseInstance"));

	return glDrawArraysInstancedBaseInstancePtr != NULL && glDrawElementsInstancedBaseInstancePtr != NULL && glDrawElementsInstancedBaseVertexBaseInstancePtr != NULL;
}

inline bool loadGL_ARB_transform_feedback_instanced()
{
	glDrawTransformFeedbackInstancedPtr = reinterpret_cast<PFNGLDRAWTRANSFORMFEEDBACKINSTANCEDPROC>(::wglGetProcAddress("glDrawTransformFeedbackInstanced"));
	glDrawTransformFeedbackStreamInstancedPtr = reinterpret_cast<PFNGLDRAWTRANSFORMFEEDBACKSTREAMINSTANCEDPROC>(::wglGetProcAddress("glDrawTransformFeedbackStreamInstanced"));

	return glDrawTransformFeedbackInstancedPtr != NULL && glDrawTransformFeedbackStreamInstancedPtr != NULL;
}

inline bool loadGL_ARB_internalformat_query()
{
	glGetInternalformativPtr = reinterpret_cast<PFNGLGETINTERNALFORMATIVPROC>(::wglGetProcAddress("glGetInternalformativ"));

	return glGetInternalformativPtr != NULL;
}

inline bool loadGL_ARB_shader_atomic_counters()
{
	glGetActiveAtomicCounterBufferivPtr = reinterpret_cast<PFNGLGETACTIVEATOMICCOUNTERBUFFERIVPROC>(::wglGetProcAddress("glGetActiveAtomicCounterBufferiv"));

	return glGetActiveAtomicCounterBufferivPtr != NULL;
}

inline bool loadGL_ARB_shader_image_load_store()
{
	glBindImageTexturePtr = reinterpret_cast<PFNGLBINDIMAGETEXTUREPROC>(::wglGetProcAddress("glBindImageTexture"));
	glMemoryBarrierPtr = reinterpret_cast<PFNGLMEMORYBARRIERPROC>(::wglGetProcAddress("glMemoryBarrier"));

	return glBindImageTexturePtr != NULL && glMemoryBarrierPtr != NULL;
}

inline bool loadGL_ARB_texture_storage()
{
	glTexStorage1DPtr = reinterpret_cast<PFNGLTEXSTORAGE1DPROC>(::wglGetProcAddress("glTexStorage1D"));
	glTexStorage2DPtr = reinterpret_cast<PFNGLTEXSTORAGE2DPROC>(::wglGetProcAddress("glTexStorage2D"));
	glTexStorage3DPtr = reinterpret_cast<PFNGLTEXSTORAGE3DPROC>(::wglGetProcAddress("glTexStorage3D"));
	glTextureStorage1DEXTPtr = reinterpret_cast<PFNGLTEXTURESTORAGE1DEXTPROC>(::wglGetProcAddress("glTextureStorage1DEXT"));
	glTextureStorage2DEXTPtr = reinterpret_cast<PFNGLTEXTURESTORAGE2DEXTPROC>(::wglGetProcAddress("glTextureStorage2DEXT"));
	glTextureStorage3DEXTPtr = reinterpret_cast<PFNGLTEXTURESTORAGE3DEXTPROC>(::wglGetProcAddress("glTextureStorage3DEXT"));

	return glTexStorage1DPtr != NULL && glTexStorage2DPtr != NULL && glTexStorage3DPtr != NULL && glTextureStorage1DEXTPtr != NULL && glTextureStorage2DEXTPtr != NULL && 
		glTextureStorage3DEXTPtr != NULL;
}

inline bool loadGL_KHR_debug()
{
	glDebugMessageControlPtr = reinterpret_cast<PFNGLDEBUGMESSAGECONTROLPROC>(::wglGetProcAddress("glDebugMessageControl"));
	glDebugMessageInsertPtr = reinterpret_cast<PFNGLDEBUGMESSAGEINSERTPROC>(::wglGetProcAddress("glDebugMessageInsert"));
	glDebugMessageCallbackPtr = reinterpret_cast<PFNGLDEBUGMESSAGECALLBACKPROC>(::wglGetProcAddress("glDebugMessageCallback"));
	glGetDebugMessageLogPtr = reinterpret_cast<PFNGLGETDEBUGMESSAGELOGPROC>(::wglGetProcAddress("glGetDebugMessageLog"));
	glPushDebugGroupPtr = reinterpret_cast<PFNGLPUSHDEBUGGROUPPROC>(::wglGetProcAddress("glPushDebugGroup"));
	glPopDebugGroupPtr = reinterpret_cast<PFNGLPOPDEBUGGROUPPROC>(::wglGetProcAddress("glPopDebugGroup"));
	glObjectLabelPtr = reinterpret_cast<PFNGLOBJECTLABELPROC>(::wglGetProcAddress("glObjectLabel"));
	glGetObjectLabelPtr = reinterpret_cast<PFNGLGETOBJECTLABELPROC>(::wglGetProcAddress("glGetObjectLabel"));
	glObjectPtrLabelPtr = reinterpret_cast<PFNGLOBJECTPTRLABELPROC>(::wglGetProcAddress("glObjectPtrLabel"));
	glGetObjectPtrLabelPtr = reinterpret_cast<PFNGLGETOBJECTPTRLABELPROC>(::wglGetProcAddress("glGetObjectPtrLabel"));

	return glDebugMessageControlPtr != NULL && glDebugMessageInsertPtr != NULL && glDebugMessageCallbackPtr != NULL && glGetDebugMessageLogPtr != NULL && glPushDebugGroupPtr != NULL && 
		glPopDebugGroupPtr != NULL && glObjectLabelPtr != NULL && glGetObjectLabelPtr != NULL && glObjectPtrLabelPtr != NULL && glGetObjectPtrLabelPtr != NULL;
}

inline bool loadGL_ARB_clear_buffer_object()
{
	glClearBufferDataPtr = reinterpret_cast<PFNGLCLEARBUFFERDATAPROC>(::wglGetProcAddress("glClearBufferData"));
	glClearBufferSubDataPtr = reinterpret_cast<PFNGLCLEARBUFFERSUBDATAPROC>(::wglGetProcAddress("glClearBufferSubData"));
	glClearNamedBufferDataEXTPtr = reinterpret_cast<PFNGLCLEARNAMEDBUFFERDATAEXTPROC>(::wglGetProcAddress("glClearNamedBufferDataEXT"));
	glClearNamedBufferSubDataEXTPtr = reinterpret_cast<PFNGLCLEARNAMEDBUFFERSUBDATAEXTPROC>(::wglGetProcAddress("glClearNamedBufferSubDataEXT"));

	return glClearBufferDataPtr != NULL && glClearBufferSubDataPtr != NULL && glClearNamedBufferDataEXTPtr != NULL && glClearNamedBufferSubDataEXTPtr != NULL;
}

inline bool loadGL_ARB_compute_shader()
{
	glDispatchComputePtr = reinterpret_cast<PFNGLDISPATCHCOMPUTEPROC>(::wglGetProcAddress("glDispatchCompute"));
	glDispatchComputeIndirectPtr = reinterpret_cast<PFNGLDISPATCHCOMPUTEINDIRECTPROC>(::wglGetProcAddress("glDispatchComputeIndirect"));

	return glDispatchComputePtr != NULL && glDispatchComputeIndirectPtr != NULL;
}

inline bool loadGL_ARB_copy_image()
{
	glCopyImageSubDataPtr = reinterpret_cast<PFNGLCOPYIMAGESUBDATAPROC>(::wglGetProcAddress("glCopyImageSubData"));

	return glCopyImageSubDataPtr != NULL;
}

inline bool loadGL_ARB_texture_view()
{
	glTextureViewPtr = reinterpret_cast<PFNGLTEXTUREVIEWPROC>(::wglGetProcAddress("glTextureView"));

	return glTextureViewPtr != NULL;
}

inline bool loadGL_ARB_vertex_attrib_binding()
{
	glBindVertexBufferPtr = reinterpret_cast<PFNGLBINDVERTEXBUFFERPROC>(::wglGetProcAddress("glBindVertexBuffer"));
	glVertexAttribFormatPtr = reinterpret_cast<PFNGLVERTEXATTRIBFORMATPROC>(::wglGetProcAddress("glVertexAttribFormat"));
	glVertexAttribIFormatPtr = reinterpret_cast<PFNGLVERTEXATTRIBIFORMATPROC>(::wglGetProcAddress("glVertexAttribIFormat"));
	glVertexAttribLFormatPtr = reinterpret_cast<PFNGLVERTEXATTRIBLFORMATPROC>(::wglGetProcAddress("glVertexAttribLFormat"));
	glVertexAttribBindingPtr = reinterpret_cast<PFNGLVERTEXATTRIBBINDINGPROC>(::wglGetProcAddress("glVertexAttribBinding"));
	glVertexBindingDivisorPtr = reinterpret_cast<PFNGLVERTEXBINDINGDIVISORPROC>(::wglGetProcAddress("glVertexBindingDivisor"));
	glVertexArrayBindVertexBufferEXTPtr = reinterpret_cast<PFNGLVERTEXARRAYBINDVERTEXBUFFEREXTPROC>(::wglGetProcAddress("glVertexArrayBindVertexBufferEXT"));
	glVertexArrayVertexAttribFormatEXTPtr = reinterpret_cast<PFNGLVERTEXARRAYVERTEXATTRIBFORMATEXTPROC>(::wglGetProcAddress("glVertexArrayVertexAttribFormatEXT"));
	glVertexArrayVertexAttribIFormatEXTPtr = reinterpret_cast<PFNGLVERTEXARRAYVERTEXATTRIBIFORMATEXTPROC>(::wglGetProcAddress("glVertexArrayVertexAttribIFormatEXT"));
	glVertexArrayVertexAttribLFormatEXTPtr = reinterpret_cast<PFNGLVERTEXARRAYVERTEXATTRIBLFORMATEXTPROC>(::wglGetProcAddress("glVertexArrayVertexAttribLFormatEXT"));
	glVertexArrayVertexAttribBindingEXTPtr = reinterpret_cast<PFNGLVERTEXARRAYVERTEXATTRIBBINDINGEXTPROC>(::wglGetProcAddress("glVertexArrayVertexAttribBindingEXT"));
	glVertexArrayVertexBindingDivisorEXTPtr = reinterpret_cast<PFNGLVERTEXARRAYVERTEXBINDINGDIVISOREXTPROC>(::wglGetProcAddress("glVertexArrayVertexBindingDivisorEXT"));

	return glBindVertexBufferPtr != NULL && glVertexAttribFormatPtr != NULL && glVertexAttribIFormatPtr != NULL && glVertexAttribLFormatPtr != NULL && glVertexAttribBindingPtr != NULL && 
		glVertexBindingDivisorPtr != NULL && glVertexArrayBindVertexBufferEXTPtr != NULL && glVertexArrayVertexAttribFormatEXTPtr != NULL && glVertexArrayVertexAttribIFormatEXTPtr != NULL && glVertexArrayVertexAttribLFormatEXTPtr != NULL && 
		glVertexArrayVertexAttribBindingEXTPtr != NULL && glVertexArrayVertexBindingDivisorEXTPtr != NULL;
}

inline bool loadGL_ARB_framebuffer_no_attachments()
{
	glFramebufferParameteriPtr = reinterpret_cast<PFNGLFRAMEBUFFERPARAMETERIPROC>(::wglGetProcAddress("glFramebufferParameteri"));
	glGetFramebufferParameterivPtr = reinterpret_cast<PFNGLGETFRAMEBUFFERPARAMETERIVPROC>(::wglGetProcAddress("glGetFramebufferParameteriv"));
	glNamedFramebufferParameteriEXTPtr = reinterpret_cast<PFNGLNAMEDFRAMEBUFFERPARAMETERIEXTPROC>(::wglGetProcAddress("glNamedFramebufferParameteriEXT"));
	glGetNamedFramebufferParameterivEXTPtr = reinterpret_cast<PFNGLGETNAMEDFRAMEBUFFERPARAMETERIVEXTPROC>(::wglGetProcAddress("glGetNamedFramebufferParameterivEXT"));

	return glFramebufferParameteriPtr != NULL && glGetFramebufferParameterivPtr != NULL && glNamedFramebufferParameteriEXTPtr != NULL && glGetNamedFramebufferParameterivEXTPtr != NULL;
}

inline bool loadGL_ARB_internalformat_query2()
{
	glGetInternalformati64vPtr = reinterpret_cast<PFNGLGETINTERNALFORMATI64VPROC>(::wglGetProcAddress("glGetInternalformati64v"));

	return glGetInternalformati64vPtr != NULL;
}

inline bool loadGL_ARB_invalidate_subdata()
{
	glInvalidateTexSubImagePtr = reinterpret_cast<PFNGLINVALIDATETEXSUBIMAGEPROC>(::wglGetProcAddress("glInvalidateTexSubImage"));
	glInvalidateTexImagePtr = reinterpret_cast<PFNGLINVALIDATETEXIMAGEPROC>(::wglGetProcAddress("glInvalidateTexImage"));
	glInvalidateBufferSubDataPtr = reinterpret_cast<PFNGLINVALIDATEBUFFERSUBDATAPROC>(::wglGetProcAddress("glInvalidateBufferSubData"));
	glInvalidateBufferDataPtr = reinterpret_cast<PFNGLINVALIDATEBUFFERDATAPROC>(::wglGetProcAddress("glInvalidateBufferData"));
	glInvalidateFramebufferPtr = reinterpret_cast<PFNGLINVALIDATEFRAMEBUFFERPROC>(::wglGetProcAddress("glInvalidateFramebuffer"));
	glInvalidateSubFramebufferPtr = reinterpret_cast<PFNGLINVALIDATESUBFRAMEBUFFERPROC>(::wglGetProcAddress("glInvalidateSubFramebuffer"));

	return glInvalidateTexSubImagePtr != NULL && glInvalidateTexImagePtr != NULL && glInvalidateBufferSubDataPtr != NULL && glInvalidateBufferDataPtr != NULL && glInvalidateFramebufferPtr != NULL && 
		glInvalidateSubFramebufferPtr != NULL;
}

inline bool loadGL_ARB_multi_draw_indirect()
{
	glMultiDrawArraysIndirectPtr = reinterpret_cast<PFNGLMULTIDRAWARRAYSINDIRECTPROC>(::wglGetProcAddress("glMultiDrawArraysIndirect"));
	glMultiDrawElementsIndirectPtr = reinterpret_cast<PFNGLMULTIDRAWELEMENTSINDIRECTPROC>(::wglGetProcAddress("glMultiDrawElementsIndirect"));

	return glMultiDrawArraysIndirectPtr != NULL && glMultiDrawElementsIndirectPtr != NULL;
}

inline bool loadGL_ARB_program_interface_query()
{
	glGetProgramInterfaceivPtr = reinterpret_cast<PFNGLGETPROGRAMINTERFACEIVPROC>(::wglGetProcAddress("glGetProgramInterfaceiv"));
	glGetProgramResourceIndexPtr = reinterpret_cast<PFNGLGETPROGRAMRESOURCEINDEXPROC>(::wglGetProcAddress("glGetProgramResourceIndex"));
	glGetProgramResourceNamePtr = reinterpret_cast<PFNGLGETPROGRAMRESOURCENAMEPROC>(::wglGetProcAddress("glGetProgramResourceName"));
	glGetProgramResourceivPtr = reinterpret_cast<PFNGLGETPROGRAMRESOURCEIVPROC>(::wglGetProcAddress("glGetProgramResourceiv"));
	glGetProgramResourceLocationPtr = reinterpret_cast<PFNGLGETPROGRAMRESOURCELOCATIONPROC>(::wglGetProcAddress("glGetProgramResourceLocation"));
	glGetProgramResourceLocationIndexPtr = reinterpret_cast<PFNGLGETPROGRAMRESOURCELOCATIONINDEXPROC>(::wglGetProcAddress("glGetProgramResourceLocationIndex"));

	return glGetProgramInterfaceivPtr != NULL && glGetProgramResourceIndexPtr != NULL && glGetProgramResourceNamePtr != NULL && glGetProgramResourceivPtr != NULL && glGetProgramResourceLocationPtr != NULL && 
		glGetProgramResourceLocationIndexPtr != NULL;
}

inline bool loadGL_ARB_shader_storage_buffer_object()
{
	glShaderStorageBlockBindingPtr = reinterpret_cast<PFNGLSHADERSTORAGEBLOCKBINDINGPROC>(::wglGetProcAddress("glShaderStorageBlockBinding"));

	return glShaderStorageBlockBindingPtr != NULL;
}

inline bool loadGL_ARB_texture_buffer_range()
{
	glTexBufferRangePtr = reinterpret_cast<PFNGLTEXBUFFERRANGEPROC>(::wglGetProcAddress("glTexBufferRange"));
	glTextureBufferRangeEXTPtr = reinterpret_cast<PFNGLTEXTUREBUFFERRANGEEXTPROC>(::wglGetProcAddress("glTextureBufferRangeEXT"));

	return glTexBufferRangePtr != NULL && glTextureBufferRangeEXTPtr != NULL;
}

inline bool loadGL_ARB_texture_storage_multisample()
{
	glTexStorage2DMultisamplePtr = reinterpret_cast<PFNGLTEXSTORAGE2DMULTISAMPLEPROC>(::wglGetProcAddress("glTexStorage2DMultisample"));
	glTexStorage3DMultisamplePtr = reinterpret_cast<PFNGLTEXSTORAGE3DMULTISAMPLEPROC>(::wglGetProcAddress("glTexStorage3DMultisample"));
	glTextureStorage2DMultisampleEXTPtr = reinterpret_cast<PFNGLTEXTURESTORAGE2DMULTISAMPLEEXTPROC>(::wglGetProcAddress("glTextureStorage2DMultisampleEXT"));
	glTextureStorage3DMultisampleEXTPtr = reinterpret_cast<PFNGLTEXTURESTORAGE3DMULTISAMPLEEXTPROC>(::wglGetProcAddress("glTextureStorage3DMultisampleEXT"));

	return glTexStorage2DMultisamplePtr != NULL && glTexStorage3DMultisamplePtr != NULL && glTextureStorage2DMultisampleEXTPtr != NULL && glTextureStorage3DMultisampleEXTPtr != NULL;
}

std::string getGLExtensions()
{
	std::string extensions = "";

	GLint numberOfExtensions = 0;
	glGetIntegerv(GL_NUM_EXTENSIONS, &numberOfExtensions);

	if ( numberOfExtensions > 0 )
	{
		for (GLint i = 0 ; i < numberOfExtensions ; ++i)
		{
			const char* extension = (const char*)glGetStringi(GL_EXTENSIONS, i);
			extensions.append(extension);
		}
	}

	return extensions;
}

namespace Gx
{
	bool hasGL_version_1_2 = false;
	bool hasGL_version_1_3 = false;
	bool hasGL_version_1_4 = false;
	bool hasGL_version_1_5 = false;
	bool hasGL_version_2_0 = false;
	bool hasGL_version_2_1 = false;
	bool hasGL_version_3_0 = false;
	bool hasGL_version_3_1 = false;
	bool hasGL_version_3_2 = false;
	bool hasGL_version_3_3 = false;
	bool hasGL_version_4_0 = false;
	bool hasGL_version_4_1 = false; // no entry points
	bool hasGL_version_4_2 = false; // no entry points
	bool hasGL_version_4_3 = false; // no entry points
	bool hasGL_ARB_depth_buffer_float = false; // no entry points
	bool hasGL_ARB_framebuffer_object = false;
	bool hasGL_ARB_framebuffer_sRGB = false; // no entry points
	bool hasGL_ARB_half_float_vertex = false; // no entry points
	bool hasGL_ARB_map_buffer_range = false;
	bool hasGL_ARB_texture_compression_rgtc = false; // no entry points
	bool hasGL_ARB_texture_rg = false; // no entry points
	bool hasGL_ARB_vertex_array_object = false;
	bool hasGL_ARB_uniform_buffer_object = false;
	bool hasGL_ARB_copy_buffer = false;
	bool hasGL_ARB_depth_clamp = false; // no entry points
	bool hasGL_ARB_draw_elements_base_vertex = false;
	bool hasGL_ARB_fragment_coord_conventions = false; // no entry points
	bool hasGL_ARB_provoking_vertex = false;
	bool hasGL_ARB_seamless_cube_map = false; // no entry points
	bool hasGL_ARB_sync = false;
	bool hasGL_ARB_texture_multisample = false;
	bool hasGL_ARB_vertex_array_bgra = false; // no entry points
	bool hasGL_ARB_draw_buffers_blend = false;
	bool hasGL_ARB_sample_shading = false;
	bool hasGL_ARB_texture_cube_map_array = false; // no entry points
	bool hasGL_ARB_texture_gather = false; // no entry points
	bool hasGL_ARB_texture_query_lod = false; // no entry points
	bool hasGL_ARB_shading_language_include = false;
	bool hasGL_ARB_texture_compression_bptc = false; // no entry points
	bool hasGL_ARB_blend_func_extended = false;
	bool hasGL_ARB_explicit_attrib_location = false; // no entry points
	bool hasGL_ARB_occlusion_query2 = false; // no entry points
	bool hasGL_ARB_sampler_objects = false;
	bool hasGL_ARB_shader_bit_encoding = false; // no entry points
	bool hasGL_ARB_texture_rgb10_a2ui = false; // no entry points
	bool hasGL_ARB_texture_swizzle = false; // no entry points
	bool hasGL_ARB_timer_query = false;
	bool hasGL_ARB_vertex_type_2_10_10_10_rev = false;
	bool hasGL_ARB_draw_indirect = false;
	bool hasGL_ARB_gpu_shader5 = false; // no entry points
	bool hasGL_ARB_gpu_shader_fp64 = false;
	bool hasGL_ARB_shader_subroutine = false;
	bool hasGL_ARB_tessellation_shader = false;
	bool hasGL_ARB_texture_buffer_object_rgb32 = false; // no entry points
	bool hasGL_ARB_transform_feedback2 = false;
	bool hasGL_ARB_transform_feedback3 = false;
	bool hasGL_ARB_ES2_compatibility = false;
	bool hasGL_ARB_get_program_binary = false;
	bool hasGL_ARB_separate_shader_objects = false;
	bool hasGL_ARB_shader_precision = false;
	bool hasGL_ARB_vertex_attrib_64bit = false;
	bool hasGL_ARB_viewport_array = false;
	bool hasGL_ARB_cl_event = false;
	bool hasGL_ARB_debug_output = false;
	bool hasGL_ARB_robustness = false;
	bool hasGL_ARB_shader_stencil_export = false; // no entry points
	bool hasGL_ARB_base_instance = false;
	bool hasGL_ARB_shading_language_420pack = false; // no entry points
	bool hasGL_ARB_transform_feedback_instanced = false;
	bool hasGL_ARB_compressed_texture_pixel_storage = false; // no entry points
	bool hasGL_ARB_conservative_depth = false; // no entry points
	bool hasGL_ARB_internalformat_query = false;
	bool hasGL_ARB_map_buffer_alignment = false; // no entry points
	bool hasGL_ARB_shader_atomic_counters = false;
	bool hasGL_ARB_shader_image_load_store = false;
	bool hasGL_ARB_shading_language_packing = false; // no entry points
	bool hasGL_ARB_texture_storage = false;
	bool hasGL_KHR_texture_compression_astc_ldr = false; // no entry points
	bool hasGL_KHR_debug = false;
	bool hasGL_ARB_arrays_of_arrays = false; // no entry points
	bool hasGL_ARB_clear_buffer_object = false;
	bool hasGL_ARB_compute_shader = false;
	bool hasGL_ARB_copy_image = false;
	bool hasGL_ARB_texture_view = false;
	bool hasGL_ARB_vertex_attrib_binding = false;
	bool hasGL_ARB_robustness_isolation = false; // no entry points
	bool hasGL_ARB_ES3_compatibility = false; // no entry points
	bool hasGL_ARB_explicit_uniform_location = false; // no entry points
	bool hasGL_ARB_fragment_layer_viewport = false; // no entry points
	bool hasGL_ARB_framebuffer_no_attachments = false;
	bool hasGL_ARB_internalformat_query2 = false;
	bool hasGL_ARB_invalidate_subdata = false;
	bool hasGL_ARB_multi_draw_indirect = false;
	bool hasGL_ARB_program_interface_query = false;
	bool hasGL_ARB_robust_buffer_access_behavior = false; // no entry points
	bool hasGL_ARB_shader_image_size = false; // no entry points
	bool hasGL_ARB_shader_storage_buffer_object = false;
	bool hasGL_ARB_stencil_texturing = false; // no entry points
	bool hasGL_ARB_texture_buffer_range = false;
	bool hasGL_ARB_texture_query_levels = false; // no entry points
	bool hasGL_ARB_texture_storage_multisample = false;
	bool hasGL_EXT_texture_filter_anisotropic = false; // no entry points

	static std::string extensions;

	bool hasGLExtension(const char* extensionName)
	{
		if ( extensions.find(extensionName) != std::string::npos )
		{
			return true;
		}

		return false;
	}

	void loadGLFuntions()
	{
		hasGL_version_1_2 = loadGL_version_1_2();
		hasGL_version_1_3 = loadGL_version_1_3();
		hasGL_version_1_4 = loadGL_version_1_4();
		hasGL_version_1_5 = loadGL_version_1_5();
		hasGL_version_2_0 = loadGL_version_2_0();
		hasGL_version_2_1 = loadGL_version_2_1();

		hasGL_ARB_framebuffer_object = loadGL_ARB_framebuffer_object();
		hasGL_ARB_map_buffer_range = loadGL_ARB_map_buffer_range();
		hasGL_ARB_vertex_array_object = loadGL_ARB_vertex_array_object();
		hasGL_ARB_uniform_buffer_object = loadGL_ARB_uniform_buffer_object();
		hasGL_ARB_copy_buffer = loadGL_ARB_copy_buffer();
		hasGL_ARB_draw_elements_base_vertex = loadGL_ARB_draw_elements_base_vertex();
		hasGL_ARB_provoking_vertex = loadGL_ARB_provoking_vertex();
		hasGL_ARB_sync = loadGL_ARB_sync();
		hasGL_ARB_texture_multisample = loadGL_ARB_texture_multisample();
		hasGL_ARB_draw_buffers_blend = loadGL_ARB_draw_buffers_blend();
		hasGL_ARB_sample_shading = loadGL_ARB_sample_shading();
		hasGL_ARB_shading_language_include = loadGL_ARB_shading_language_include();
		hasGL_ARB_blend_func_extended = loadGL_ARB_blend_func_extended();
		hasGL_ARB_sampler_objects = loadGL_ARB_sampler_objects();
		hasGL_ARB_timer_query = loadGL_ARB_timer_query();
		hasGL_ARB_vertex_type_2_10_10_10_rev = loadGL_ARB_vertex_type_2_10_10_10_rev();
		hasGL_ARB_draw_indirect = loadGL_ARB_draw_indirect();
		hasGL_ARB_gpu_shader_fp64 = loadGL_ARB_gpu_shader_fp64();
		hasGL_ARB_shader_subroutine = loadGL_ARB_shader_subroutine();
		hasGL_ARB_tessellation_shader = loadGL_ARB_tessellation_shader();
		hasGL_ARB_transform_feedback2 = loadGL_ARB_transform_feedback2();
		hasGL_ARB_transform_feedback3 = loadGL_ARB_transform_feedback3();
		hasGL_ARB_ES2_compatibility = loadGL_ARB_ES2_compatibility();
		hasGL_ARB_get_program_binary = loadGL_ARB_get_program_binary();
		hasGL_ARB_separate_shader_objects = loadGL_ARB_separate_shader_objects();
		hasGL_ARB_vertex_attrib_64bit = loadGL_ARB_vertex_attrib_64bit();
		hasGL_ARB_viewport_array = loadGL_ARB_viewport_array();
		hasGL_ARB_cl_event = loadGL_ARB_cl_event();
		hasGL_ARB_debug_output = loadGL_ARB_debug_output();
		hasGL_ARB_robustness = loadGL_ARB_robustness();
		hasGL_ARB_base_instance = loadGL_ARB_base_instance();
		hasGL_ARB_transform_feedback_instanced = loadGL_ARB_transform_feedback_instanced();
		hasGL_ARB_internalformat_query = loadGL_ARB_internalformat_query();
		hasGL_ARB_shader_atomic_counters = loadGL_ARB_shader_atomic_counters();
		hasGL_ARB_shader_image_load_store = loadGL_ARB_shader_image_load_store();
		hasGL_ARB_texture_storage = loadGL_ARB_texture_storage();
		hasGL_KHR_debug = loadGL_KHR_debug();
		hasGL_ARB_clear_buffer_object = loadGL_ARB_clear_buffer_object();
		hasGL_ARB_compute_shader = loadGL_ARB_compute_shader();
		hasGL_ARB_copy_image = loadGL_ARB_copy_image();
		hasGL_ARB_texture_view = loadGL_ARB_texture_view();
		hasGL_ARB_vertex_attrib_binding = loadGL_ARB_vertex_attrib_binding();
		hasGL_ARB_framebuffer_no_attachments = loadGL_ARB_framebuffer_no_attachments();
		hasGL_ARB_internalformat_query2 = loadGL_ARB_internalformat_query2();
		hasGL_ARB_invalidate_subdata = loadGL_ARB_invalidate_subdata();
		hasGL_ARB_multi_draw_indirect = loadGL_ARB_multi_draw_indirect();
		hasGL_ARB_program_interface_query = loadGL_ARB_program_interface_query();
		hasGL_ARB_shader_storage_buffer_object = loadGL_ARB_shader_storage_buffer_object();
		hasGL_ARB_texture_buffer_range = loadGL_ARB_texture_buffer_range();
		hasGL_ARB_texture_storage_multisample = loadGL_ARB_texture_storage_multisample();

		hasGL_version_3_0 = loadGL_version_3_0() && hasGL_ARB_framebuffer_object & hasGL_ARB_map_buffer_range && hasGL_ARB_vertex_array_object;
		hasGL_version_3_1 = loadGL_version_3_1() && hasGL_ARB_copy_buffer && hasGL_ARB_uniform_buffer_object;
		hasGL_version_3_2 = loadGL_version_3_2() && hasGL_ARB_draw_elements_base_vertex && hasGL_ARB_provoking_vertex && hasGL_ARB_sync && hasGL_ARB_texture_multisample;

		extensions = getGLExtensions();
		
		hasGL_ARB_depth_buffer_float = hasGLExtension("GL_ARB_depth_buffer_float");
		hasGL_ARB_framebuffer_sRGB = hasGLExtension("GL_ARB_framebuffer_sRGB");
		hasGL_ARB_half_float_vertex = hasGLExtension("GL_ARB_half_float_vertex");
		hasGL_ARB_texture_compression_rgtc = hasGLExtension("GL_ARB_texture_compression_rgtc");
		hasGL_ARB_texture_rg = hasGLExtension("GL_ARB_texture_rg");
		hasGL_ARB_depth_clamp = hasGLExtension("GL_ARB_depth_clamp");
		hasGL_ARB_fragment_coord_conventions = hasGLExtension("GL_ARB_fragment_coord_conventions");
		hasGL_ARB_seamless_cube_map = hasGLExtension("GL_ARB_seamless_cube_map");
		hasGL_ARB_vertex_array_bgra = hasGLExtension("GL_ARB_vertex_array_bgra");
		hasGL_ARB_texture_cube_map_array = hasGLExtension("GL_ARB_texture_cube_map_array");
		hasGL_ARB_texture_gather = hasGLExtension("GL_ARB_texture_gather");
		hasGL_ARB_texture_query_lod = hasGLExtension("GL_ARB_texture_query_lod");
		hasGL_ARB_texture_compression_bptc = hasGLExtension("GL_ARB_texture_compression_bptc");
		hasGL_ARB_explicit_attrib_location = hasGLExtension("GL_ARB_explicit_attrib_location");
		hasGL_ARB_occlusion_query2 = hasGLExtension("GL_ARB_occlusion_query2");
		hasGL_ARB_shader_bit_encoding = hasGLExtension("GL_ARB_shader_bit_encoding");
		hasGL_ARB_texture_rgb10_a2ui = hasGLExtension("GL_ARB_texture_rgb10_a2ui");
		hasGL_ARB_texture_swizzle = hasGLExtension("GL_ARB_texture_swizzle");
		hasGL_ARB_gpu_shader5 = hasGLExtension("GL_ARB_gpu_shader5");
		hasGL_ARB_texture_buffer_object_rgb32 = hasGLExtension("GL_ARB_texture_buffer_object_rgb32");
		hasGL_ARB_shader_stencil_export = hasGLExtension("GL_ARB_shader_stencil_export");
		hasGL_ARB_shading_language_420pack = hasGLExtension("GL_ARB_shading_language_420pack");
		hasGL_ARB_compressed_texture_pixel_storage = hasGLExtension("GL_ARB_compressed_texture_pixel_storage");
		hasGL_ARB_conservative_depth = hasGLExtension("GL_ARB_conservative_depth");
		hasGL_ARB_map_buffer_alignment = hasGLExtension("GL_ARB_map_buffer_alignment");
		hasGL_ARB_shading_language_packing = hasGLExtension("GL_ARB_shading_language_packing");
		hasGL_KHR_texture_compression_astc_ldr = hasGLExtension("GL_KHR_texture_compression_astc_ldr");
		hasGL_ARB_arrays_of_arrays = hasGLExtension("GL_ARB_arrays_of_arrays");
		hasGL_ARB_robustness_isolation = hasGLExtension("GL_ARB_robustness_isolation");
		hasGL_ARB_ES3_compatibility = hasGLExtension("GL_ARB_ES3_compatibility");
		hasGL_ARB_explicit_uniform_location = hasGLExtension("GL_ARB_explicit_uniform_location");
		hasGL_ARB_fragment_layer_viewport = hasGLExtension("GL_ARB_fragment_layer_viewport");
		hasGL_ARB_robust_buffer_access_behavior = hasGLExtension("GL_ARB_robust_buffer_access_behavior");
		hasGL_ARB_shader_image_size = hasGLExtension("GL_ARB_shader_image_size");
		hasGL_ARB_stencil_texturing = hasGLExtension("GL_ARB_stencil_texturing");
		hasGL_ARB_texture_query_levels = hasGLExtension("GL_ARB_texture_query_levels");
		hasGL_ARB_shader_precision = hasGLExtension("GL_ARB_shader_precision");
		hasGL_EXT_texture_filter_anisotropic = hasGLExtension("GL_EXT_texture_filter_anisotropic");

		hasGL_version_3_3 = loadGL_version_3_3() && hasGL_ARB_blend_func_extended && hasGL_ARB_sampler_objects && hasGL_ARB_explicit_attrib_location
			&& hasGL_ARB_occlusion_query2 && hasGL_ARB_shader_bit_encoding && hasGL_ARB_texture_rgb10_a2ui && hasGL_ARB_texture_swizzle && hasGL_ARB_timer_query
			&& hasGL_ARB_vertex_type_2_10_10_10_rev;

		hasGL_version_4_0 = loadGL_version_4_0() && hasGL_ARB_texture_query_lod && hasGL_ARB_draw_indirect && hasGL_ARB_gpu_shader5 && hasGL_ARB_gpu_shader_fp64
			&& hasGL_ARB_shader_subroutine && hasGL_ARB_tessellation_shader && hasGL_ARB_texture_buffer_object_rgb32 && hasGL_ARB_texture_cube_map_array
			&& hasGL_ARB_texture_gather && hasGL_ARB_transform_feedback2 && hasGL_ARB_transform_feedback3;

		hasGL_version_4_1 = hasGL_ARB_ES2_compatibility && hasGL_ARB_get_program_binary && hasGL_ARB_separate_shader_objects && hasGL_ARB_shader_precision
			&& hasGL_ARB_vertex_attrib_64bit && hasGL_ARB_viewport_array;

		hasGL_version_4_2 = hasGL_ARB_base_instance && hasGL_ARB_shading_language_420pack && hasGL_ARB_transform_feedback_instanced && hasGL_ARB_compressed_texture_pixel_storage
			&& hasGL_ARB_conservative_depth && hasGL_ARB_internalformat_query && hasGL_ARB_map_buffer_alignment && hasGL_ARB_shader_atomic_counters && hasGL_ARB_shader_image_load_store
			&& hasGL_ARB_shading_language_packing && hasGL_ARB_texture_storage;

		hasGL_version_4_3 = hasGL_ARB_arrays_of_arrays && hasGL_ARB_fragment_layer_viewport && hasGL_ARB_shader_image_size && hasGL_ARB_ES3_compatibility && hasGL_ARB_clear_buffer_object
			&& hasGL_ARB_compute_shader && hasGL_ARB_copy_image && hasGL_ARB_debug_output && hasGL_ARB_explicit_uniform_location && hasGL_ARB_framebuffer_no_attachments
			&& hasGL_ARB_internalformat_query2 && hasGL_ARB_invalidate_subdata && hasGL_ARB_multi_draw_indirect && hasGL_ARB_program_interface_query
			&& hasGL_ARB_robust_buffer_access_behavior && hasGL_ARB_shader_storage_buffer_object && hasGL_ARB_stencil_texturing && hasGL_ARB_texture_buffer_range
			&& hasGL_ARB_texture_query_levels && hasGL_ARB_texture_storage_multisample && hasGL_ARB_texture_view && hasGL_ARB_vertex_attrib_binding;
	}

	void getGLVersion(int& major, int& minor)
	{
		int _major = -1, _minor = -1;

		::glGetIntegerv(GL_MAJOR_VERSION, &_major);
		::glGetIntegerv(GL_MINOR_VERSION, &_minor);
	}

	int getGLMajorVersion()
	{
		int major;
		::glGetIntegerv(GL_MAJOR_VERSION, &major);

		return major;
	}

	int getGLMinorVersion()
	{
		int minor;
		::glGetIntegerv(GL_MINOR_VERSION, &minor);

		return minor;
	}

}