#pragma once

#ifndef __gx_foundation_h__
	#define __gx_foundation_h__

//////////////////////////////////////////////////////////////////////////

#ifndef WIN32_LEAN_AND_MEAN
	#define WIN32_LEAN_AND_MEAN
#endif

#ifndef NOMINMAX
	#define NOMINMAX
#endif

#include <windows.h>
#include <memory>
#include <vector>

//////////////////////////////////////////////////////////////////////////

typedef unsigned char		GxU8;
typedef unsigned short		GxU16;
typedef unsigned int		GxU32;
typedef unsigned __int64	GxU64;

typedef signed char			GxI8;
typedef signed short		GxI16;
typedef signed int			GxI32;
typedef signed __int64		GxI64;

typedef float				GxF32;
typedef double				GxF64;

//////////////////////////////////////////////////////////////////////////

// disable: needs to have dll-interface to be used by clients of class
#pragma warning(disable: 4251)

//////////////////////////////////////////////////////////////////////////

#ifdef GX_EXPORTS
	#define GX_API __declspec(dllexport)
#else
	#define GX_API __declspec(dllimport)
#endif

//////////////////////////////////////////////////////////////////////////

// assert
#ifdef _DEBUG
	#define GX_ASSERT(_exp, _msg)							\
		if(!(_exp))											\
		{													\
			::MessageBox(0, _msg, "Assert", MB_ICONERROR);	\
			__debugbreak();									\
		}
#else
	#define GX_ASSERT(_exp, _msg)
#endif

//////////////////////////////////////////////////////////////////////////

// tworzy wektor z tablicy o N elementach - dla kadego typu
template<typename T, size_t N>
std::vector<T> createVector(const T (&data)[N])
{
	return std::vector<T>(data, data+N);
}

//////////////////////////////////////////////////////////////////////////

#endif /* __foundation_h__ */