#pragma once

#ifndef __gx_gamemode_h__
	#define __gx_gamemode_h__

#include "foundation.h"
#include <vector>

namespace Gx
{
	typedef std::vector<class GameMode> GameModeCollection;

	class GX_API GameMode
	{
	public:
		GameMode(GxU32 width, GxU32 height, GxU32 bitsPerPixel)
			: width(width), height(height), bitsPerPixel(bitsPerPixel) { }

		static GameMode getDesktopGameMode();
		static GameModeCollection getFullScreenGameModes();

		GxU32 width;
		GxU32 height;
		GxU32 bitsPerPixel;
	};

	GX_API bool operator ==(const GameMode& left, const GameMode& right);
	GX_API bool operator !=(const GameMode& left, const GameMode& right);
	GX_API bool operator <(const GameMode& left, const GameMode& right);
	GX_API bool operator >(const GameMode& left, const GameMode& right);
	GX_API bool operator <=(const GameMode& left, const GameMode& right);
	GX_API bool operator >=(const GameMode& left, const GameMode& right);
}

#endif /* __gx_gamemode_h__ */