#pragma once

#ifndef __gx_meshhelper_h__
	#define __gx_meshhelper_h__

#include "foundation.h"

namespace Gx
{
	class Mesh;
	class GraphicsDevice;

	class GX_API MeshHelper
	{
	public:
		static Mesh* createBox(GraphicsDevice* graphics);

		static Mesh* createGrid(GraphicsDevice* graphics, GxF32 size, GxU32 count);

		static Mesh* createPlane(GraphicsDevice* graphics, GxF32 size, GxU32 count);

		static Mesh* createSphere(GraphicsDevice* graphics, GxF32 radius, GxU32 stacks, GxU32 slices);

		static Mesh* createCone(GraphicsDevice* graphics, GxF32 radius, GxF32 halfHeight, GxU32 slices);

		static Mesh* createCapsule(GraphicsDevice* graphics, GxF32 radius, GxF32 halfHeight, GxU32 stacks, GxU32 slices);
	};
}

#endif /* __gx_meshhelper_h__ */